/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/quay/container-security-operator/apis/secscan/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeImageManifestVulns implements ImageManifestVulnInterface
type FakeImageManifestVulns struct {
	Fake *FakeSecscanV1alpha1
	ns   string
}

var imagemanifestvulnsResource = schema.GroupVersionResource{Group: "secscan.quay.redhat.com", Version: "v1alpha1", Resource: "imagemanifestvulns"}

var imagemanifestvulnsKind = schema.GroupVersionKind{Group: "secscan.quay.redhat.com", Version: "v1alpha1", Kind: "ImageManifestVuln"}

// Get takes name of the imageManifestVuln, and returns the corresponding imageManifestVuln object, and an error if there is any.
func (c *FakeImageManifestVulns) Get(name string, options v1.GetOptions) (result *v1alpha1.ImageManifestVuln, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(imagemanifestvulnsResource, c.ns, name), &v1alpha1.ImageManifestVuln{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ImageManifestVuln), err
}

// List takes label and field selectors, and returns the list of ImageManifestVulns that match those selectors.
func (c *FakeImageManifestVulns) List(opts v1.ListOptions) (result *v1alpha1.ImageManifestVulnList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(imagemanifestvulnsResource, imagemanifestvulnsKind, c.ns, opts), &v1alpha1.ImageManifestVulnList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.ImageManifestVulnList{ListMeta: obj.(*v1alpha1.ImageManifestVulnList).ListMeta}
	for _, item := range obj.(*v1alpha1.ImageManifestVulnList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested imageManifestVulns.
func (c *FakeImageManifestVulns) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(imagemanifestvulnsResource, c.ns, opts))

}

// Create takes the representation of a imageManifestVuln and creates it.  Returns the server's representation of the imageManifestVuln, and an error, if there is any.
func (c *FakeImageManifestVulns) Create(imageManifestVuln *v1alpha1.ImageManifestVuln) (result *v1alpha1.ImageManifestVuln, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(imagemanifestvulnsResource, c.ns, imageManifestVuln), &v1alpha1.ImageManifestVuln{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ImageManifestVuln), err
}

// Update takes the representation of a imageManifestVuln and updates it. Returns the server's representation of the imageManifestVuln, and an error, if there is any.
func (c *FakeImageManifestVulns) Update(imageManifestVuln *v1alpha1.ImageManifestVuln) (result *v1alpha1.ImageManifestVuln, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(imagemanifestvulnsResource, c.ns, imageManifestVuln), &v1alpha1.ImageManifestVuln{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ImageManifestVuln), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeImageManifestVulns) UpdateStatus(imageManifestVuln *v1alpha1.ImageManifestVuln) (*v1alpha1.ImageManifestVuln, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(imagemanifestvulnsResource, "status", c.ns, imageManifestVuln), &v1alpha1.ImageManifestVuln{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ImageManifestVuln), err
}

// Delete takes name of the imageManifestVuln and deletes it. Returns an error if one occurs.
func (c *FakeImageManifestVulns) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(imagemanifestvulnsResource, c.ns, name), &v1alpha1.ImageManifestVuln{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeImageManifestVulns) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(imagemanifestvulnsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.ImageManifestVulnList{})
	return err
}

// Patch applies the patch and returns the patched imageManifestVuln.
func (c *FakeImageManifestVulns) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ImageManifestVuln, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(imagemanifestvulnsResource, c.ns, name, pt, data, subresources...), &v1alpha1.ImageManifestVuln{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ImageManifestVuln), err
}
