"""Add new metadata columns to Manifest table

Revision ID: 88e64904d000
Revises: 3383aad1e992
Create Date: 2020-04-21 14:00:50.376517

"""

# revision identifiers, used by Alembic.
revision = "88e64904d000"
down_revision = "3383aad1e992"

import sqlalchemy as sa


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("manifest", sa.Column("config_media_type", sa.String(length=255), nullable=True))
    op.add_column("manifest", sa.Column("layers_compressed_size", sa.BigInteger(), nullable=True))
    op.create_index(
        "manifest_repository_id_config_media_type",
        "manifest",
        ["repository_id", "config_media_type"],
        unique=False,
    )
    # ### end Alembic commands ###

    # ### population of test data ### #
    tester.populate_column("manifest", "config_media_type", tester.TestDataType.String)
    tester.populate_column("manifest", "layers_compressed_size", tester.TestDataType.Integer)
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("manifest_repository_id_config_media_type", table_name="manifest")
    op.drop_column("manifest", "layers_compressed_size")
    op.drop_column("manifest", "config_media_type")
    # ### end Alembic commands ###
