"""
Add user prompt support.

Revision ID: 6c7014e84a5e
Revises: c156deb8845d
Create Date: 2016-10-31 16:26:31.447705
"""

# revision identifiers, used by Alembic.
revision = "6c7014e84a5e"
down_revision = "c156deb8845d"

import sqlalchemy as sa


def upgrade(op, tables, tester):
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "userpromptkind",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_userpromptkind")),
    )
    op.create_index("userpromptkind_name", "userpromptkind", ["name"], unique=False)
    op.create_table(
        "userprompt",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=False),
        sa.Column("kind_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["kind_id"], ["userpromptkind.id"], name=op.f("fk_userprompt_kind_id_userpromptkind")
        ),
        sa.ForeignKeyConstraint(["user_id"], ["user.id"], name=op.f("fk_userprompt_user_id_user")),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_userprompt")),
    )
    op.create_index("userprompt_kind_id", "userprompt", ["kind_id"], unique=False)
    op.create_index("userprompt_user_id", "userprompt", ["user_id"], unique=False)
    op.create_index("userprompt_user_id_kind_id", "userprompt", ["user_id", "kind_id"], unique=True)
    ### end Alembic commands ###

    op.bulk_insert(
        tables.userpromptkind,
        [
            {"name": "confirm_username"},
        ],
    )

    # ### population of test data ### #
    tester.populate_table(
        "userprompt",
        [
            ("user_id", tester.TestDataType.Foreign("user")),
            ("kind_id", tester.TestDataType.Foreign("userpromptkind")),
        ],
    )
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("userprompt")
    op.drop_table("userpromptkind")
    ### end Alembic commands ###
