// Copyright 2019 Google Inc. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package bigtableadmin provides access to the Cloud Bigtable Admin API.
//
// See https://cloud.google.com/bigtable/
//
// Usage example:
//
//   import "google.golang.org/api/bigtableadmin/v1"
//   ...
//   bigtableadminService, err := bigtableadmin.New(oauthHttpClient)
package bigtableadmin // import "google.golang.org/api/bigtableadmin/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	gensupport "google.golang.org/api/gensupport"
	googleapi "google.golang.org/api/googleapi"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled

const apiId = "bigtableadmin:v1"
const apiName = "bigtableadmin"
const apiVersion = "v1"
const basePath = "https://bigtableadmin.googleapis.com/"

func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	return rs
}

type ProjectsLocationsService struct {
	s *Service
}

// Cluster: A resizable group of nodes in a particular cloud location,
// capable
// of serving all Tables in the parent
// Instance.
type Cluster struct {
	// DefaultStorageType: (`CreationOnly`)
	// The type of storage used by this cluster to serve its
	// parent instance's tables, unless explicitly overridden.
	//
	// Possible values:
	//   "STORAGE_TYPE_UNSPECIFIED" - The user did not specify a storage
	// type.
	//   "SSD" - Flash (SSD) storage should be used.
	//   "HDD" - Magnetic drive (HDD) storage should be used.
	DefaultStorageType string `json:"defaultStorageType,omitempty"`

	// Location: (`CreationOnly`)
	// The location where this cluster's nodes and storage reside. For
	// best
	// performance, clients should be located as close as possible to
	// this
	// cluster. Currently only zones are supported, so values should be of
	// the
	// form `projects/<project>/locations/<zone>`.
	Location string `json:"location,omitempty"`

	// Name: (`OutputOnly`)
	// The unique name of the cluster. Values are of the
	// form
	// `projects/<project>/instances/<instance>/clusters/a-z*`.
	Name string `json:"name,omitempty"`

	// ServeNodes: The number of nodes allocated to this cluster. More nodes
	// enable higher
	// throughput and more consistent performance.
	ServeNodes int64 `json:"serveNodes,omitempty"`

	// State: (`OutputOnly`)
	// The current state of the cluster.
	//
	// Possible values:
	//   "STATE_NOT_KNOWN" - The state of the cluster could not be
	// determined.
	//   "READY" - The cluster has been successfully created and is ready to
	// serve requests.
	//   "CREATING" - The cluster is currently being created, and may be
	// destroyed
	// if the creation process encounters an error.
	// A cluster may not be able to serve requests while being created.
	//   "RESIZING" - The cluster is currently being resized, and may revert
	// to its previous
	// node count if the process encounters an error.
	// A cluster is still capable of serving requests while being
	// resized,
	// but may exhibit performance as if its number of allocated nodes
	// is
	// between the starting and requested states.
	//   "DISABLED" - The cluster has no backing nodes. The data (tables)
	// still
	// exist, but no operations can be performed on the cluster.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultStorageType")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultStorageType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Cluster) MarshalJSON() ([]byte, error) {
	type NoMethod Cluster
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateClusterMetadata: The metadata for the Operation returned by
// CreateCluster.
type CreateClusterMetadata struct {
	// FinishTime: The time at which the operation failed or was completed
	// successfully.
	FinishTime string `json:"finishTime,omitempty"`

	// OriginalRequest: The request that prompted the initiation of this
	// CreateCluster operation.
	OriginalRequest *CreateClusterRequest `json:"originalRequest,omitempty"`

	// RequestTime: The time at which the original request was received.
	RequestTime string `json:"requestTime,omitempty"`

	// Tables: Keys: the full `name` of each table that existed in the
	// instance when
	// CreateCluster was first called,
	// i.e.
	// `projects/<project>/instances/<instance>/tables/<table>`. Any table
	// added
	// to the instance by a later API call will be created in the new
	// cluster by
	// that API call, not this one.
	//
	// Values: information on how much of a table's data has been copied to
	// the
	// newly-created cluster so far.
	Tables map[string]TableProgress `json:"tables,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinishTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinishTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateClusterMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CreateClusterMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateClusterRequest: Request message for
// BigtableInstanceAdmin.CreateCluster.
type CreateClusterRequest struct {
	// Cluster: The cluster to be created.
	// Fields marked `OutputOnly` must be left blank.
	Cluster *Cluster `json:"cluster,omitempty"`

	// ClusterId: The ID to be used when referring to the new cluster within
	// its instance,
	// e.g., just `mycluster` rather
	// than
	// `projects/myproject/instances/myinstance/clusters/mycluster`.
	ClusterId string `json:"clusterId,omitempty"`

	// Parent: The unique name of the instance in which to create the new
	// cluster.
	// Values are of the form
	// `projects/<project>/instances/<instance>`.
	Parent string `json:"parent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cluster") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cluster") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateClusterRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateInstanceMetadata: The metadata for the Operation returned by
// CreateInstance.
type CreateInstanceMetadata struct {
	// FinishTime: The time at which the operation failed or was completed
	// successfully.
	FinishTime string `json:"finishTime,omitempty"`

	// OriginalRequest: The request that prompted the initiation of this
	// CreateInstance operation.
	OriginalRequest *CreateInstanceRequest `json:"originalRequest,omitempty"`

	// RequestTime: The time at which the original request was received.
	RequestTime string `json:"requestTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinishTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinishTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateInstanceMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CreateInstanceMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateInstanceRequest: Request message for
// BigtableInstanceAdmin.CreateInstance.
type CreateInstanceRequest struct {
	// Clusters: The clusters to be created within the instance, mapped by
	// desired
	// cluster ID, e.g., just `mycluster` rather
	// than
	// `projects/myproject/instances/myinstance/clusters/mycluster`.
	// Fie
	// lds marked `OutputOnly` must be left blank.
	// Currently, at most two clusters can be specified.
	Clusters map[string]Cluster `json:"clusters,omitempty"`

	// Instance: The instance to create.
	// Fields marked `OutputOnly` must be left blank.
	Instance *Instance `json:"instance,omitempty"`

	// InstanceId: The ID to be used when referring to the new instance
	// within its project,
	// e.g., just `myinstance` rather
	// than
	// `projects/myproject/instances/myinstance`.
	InstanceId string `json:"instanceId,omitempty"`

	// Parent: The unique name of the project in which to create the new
	// instance.
	// Values are of the form `projects/<project>`.
	Parent string `json:"parent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Clusters") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Clusters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateInstanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateInstanceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Instance: A collection of Bigtable Tables and
// the resources that serve them.
// All tables in an instance are served from all
// Clusters in the instance.
type Instance struct {
	// DisplayName: The descriptive name for this instance as it appears in
	// UIs.
	// Can be changed at any time, but should be kept globally unique
	// to avoid confusion.
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Labels are a flexible and lightweight mechanism for
	// organizing cloud
	// resources into groups that reflect a customer's organizational needs
	// and
	// deployment strategies. They can be used to filter resources and
	// aggregate
	// metrics.
	//
	// * Label keys must be between 1 and 63 characters long and must
	// conform to
	//   the regular expression: `\p{Ll}\p{Lo}{0,62}`.
	// * Label values must be between 0 and 63 characters long and must
	// conform to
	//   the regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`.
	// * No more than 64 labels can be associated with a given resource.
	// * Keys and values must both be under 128 bytes.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: (`OutputOnly`)
	// The unique name of the instance. Values are of the
	// form
	// `projects/<project>/instances/a-z+[a-z0-9]`.
	Name string `json:"name,omitempty"`

	// State: (`OutputOnly`)
	// The current state of the instance.
	//
	// Possible values:
	//   "STATE_NOT_KNOWN" - The state of the instance could not be
	// determined.
	//   "READY" - The instance has been successfully created and can serve
	// requests
	// to its tables.
	//   "CREATING" - The instance is currently being created, and may be
	// destroyed
	// if the creation process encounters an error.
	State string `json:"state,omitempty"`

	// Type: The type of the instance. Defaults to `PRODUCTION`.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type of the instance is unspecified. If
	// set when creating an
	// instance, a `PRODUCTION` instance will be created. If set when
	// updating
	// an instance, the type will be left unchanged.
	//   "PRODUCTION" - An instance meant for production use. `serve_nodes`
	// must be set
	// on the cluster.
	//   "DEVELOPMENT" - The instance is meant for development and testing
	// purposes only; it has
	// no performance or uptime guarantees and is not covered by SLA.
	// After a development instance is created, it can be upgraded
	// by
	// updating the instance to type `PRODUCTION`. An instance created
	// as a production instance cannot be changed to a development
	// instance.
	// When creating a development instance, `serve_nodes` on the cluster
	// must
	// not be set.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Instance) MarshalJSON() ([]byte, error) {
	type NoMethod Instance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for
// Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in
	// the request.
	Locations []*Location `json:"locations,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents Google Cloud Platform location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby
	// city name.
	// For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Cross-service attributes for the location. For example
	//
	//     {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`

	// LocationId: The canonical id for this location. For example:
	// "us-east1".
	LocationId string `json:"locationId,omitempty"`

	// Metadata: Service-specific metadata. For example the available
	// capacity at the given
	// location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: Resource name for the location, which may vary between
	// implementations.
	// For example: "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PartialUpdateInstanceRequest: Request message for
// BigtableInstanceAdmin.PartialUpdateInstance.
type PartialUpdateInstanceRequest struct {
	// Instance: The Instance which will (partially) replace the current
	// value.
	Instance *Instance `json:"instance,omitempty"`

	// UpdateMask: The subset of Instance fields which should be
	// replaced.
	// Must be explicitly set.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PartialUpdateInstanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PartialUpdateInstanceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TableProgress: Progress info for copying a table's data to the new
// cluster.
type TableProgress struct {
	// EstimatedCopiedBytes: Estimate of the number of bytes copied so far
	// for this table.
	// This will eventually reach 'estimated_size_bytes' unless the table
	// copy
	// is CANCELLED.
	EstimatedCopiedBytes int64 `json:"estimatedCopiedBytes,omitempty,string"`

	// EstimatedSizeBytes: Estimate of the size of the table to be copied.
	EstimatedSizeBytes int64 `json:"estimatedSizeBytes,omitempty,string"`

	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "PENDING" - The table has not yet begun copying to the new cluster.
	//   "COPYING" - The table is actively being copied to the new cluster.
	//   "COMPLETED" - The table has been fully copied to the new cluster.
	//   "CANCELLED" - The table was deleted before it finished copying to
	// the new cluster.
	// Note that tables deleted after completion will stay marked
	// as
	// COMPLETED, not CANCELLED.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EstimatedCopiedBytes") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EstimatedCopiedBytes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *TableProgress) MarshalJSON() ([]byte, error) {
	type NoMethod TableProgress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateAppProfileMetadata: The metadata for the Operation returned by
// UpdateAppProfile.
type UpdateAppProfileMetadata struct {
}

// UpdateClusterMetadata: The metadata for the Operation returned by
// UpdateCluster.
type UpdateClusterMetadata struct {
	// FinishTime: The time at which the operation failed or was completed
	// successfully.
	FinishTime string `json:"finishTime,omitempty"`

	// OriginalRequest: The request that prompted the initiation of this
	// UpdateCluster operation.
	OriginalRequest *Cluster `json:"originalRequest,omitempty"`

	// RequestTime: The time at which the original request was received.
	RequestTime string `json:"requestTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinishTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinishTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UpdateClusterMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateClusterMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateInstanceMetadata: The metadata for the Operation returned by
// UpdateInstance.
type UpdateInstanceMetadata struct {
	// FinishTime: The time at which the operation failed or was completed
	// successfully.
	FinishTime string `json:"finishTime,omitempty"`

	// OriginalRequest: The request that prompted the initiation of this
	// UpdateInstance operation.
	OriginalRequest *PartialUpdateInstanceRequest `json:"originalRequest,omitempty"`

	// RequestTime: The time at which the original request was received.
	RequestTime string `json:"requestTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinishTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinishTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UpdateInstanceMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateInstanceMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "bigtableadmin.projects.locations.get":

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigtableadmin.projects.locations.get" call.
// Exactly one of *Location or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about a location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}",
	//   "httpMethod": "GET",
	//   "id": "bigtableadmin.projects.locations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Resource name for the location.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Location"
	//   }
	// }

}

// method id "bigtableadmin.projects.locations.list":

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this
// service.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigtableadmin.projects.locations.list" call.
// Exactly one of *ListLocationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists information about the supported locations for this service.",
	//   "flatPath": "v1/projects/{projectsId}/locations",
	//   "httpMethod": "GET",
	//   "id": "bigtableadmin.projects.locations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The resource that owns the locations collection, if applicable.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/locations",
	//   "response": {
	//     "$ref": "ListLocationsResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
