// Code generated by gen.go; DO NOT EDIT.

package githubv4

// Input represents one of the Input structs:
//
// AcceptTopicSuggestionInput, AddAssigneesToAssignableInput, AddCommentInput, AddLabelsToLabelableInput, AddProjectCardInput, AddProjectColumnInput, AddPullRequestReviewCommentInput, AddPullRequestReviewInput, AddReactionInput, AddStarInput, ChangeUserStatusInput, ClearLabelsFromLabelableInput, CloneProjectInput, CloneTemplateRepositoryInput, CloseIssueInput, ClosePullRequestInput, CommitAuthor, CommitContributionOrder, ContributionOrder, ConvertProjectCardNoteToIssueInput, CreateBranchProtectionRuleInput, CreateContentAttachmentInput, CreateIssueInput, CreateProjectInput, CreatePullRequestInput, CreateRefInput, CreateRepositoryInput, DeclineTopicSuggestionInput, DeleteBranchProtectionRuleInput, DeleteIssueCommentInput, DeleteIssueInput, DeleteProjectCardInput, DeleteProjectColumnInput, DeleteProjectInput, DeletePullRequestReviewCommentInput, DeletePullRequestReviewInput, DeleteRefInput, DeploymentOrder, DismissPullRequestReviewInput, DraftPullRequestReviewComment, GistOrder, ImportProjectInput, IssueFilters, IssueOrder, LanguageOrder, LockLockableInput, MergeBranchInput, MergePullRequestInput, MilestoneOrder, MinimizeCommentInput, MoveProjectCardInput, MoveProjectColumnInput, PinIssueInput, ProjectCardImport, ProjectColumnImport, ProjectOrder, PullRequestOrder, ReactionOrder, RefOrder, ReleaseOrder, RemoveAssigneesFromAssignableInput, RemoveLabelsFromLabelableInput, RemoveOutsideCollaboratorInput, RemoveReactionInput, RemoveStarInput, ReopenIssueInput, ReopenPullRequestInput, RepositoryOrder, RequestReviewsInput, ResolveReviewThreadInput, SecurityAdvisoryIdentifierFilter, SecurityAdvisoryOrder, SecurityVulnerabilityOrder, StarOrder, SubmitPullRequestReviewInput, TeamMemberOrder, TeamOrder, TeamRepositoryOrder, UnlockLockableInput, UnmarkIssueAsDuplicateInput, UnminimizeCommentInput, UnpinIssueInput, UnresolveReviewThreadInput, UpdateBranchProtectionRuleInput, UpdateIssueCommentInput, UpdateIssueInput, UpdateProjectCardInput, UpdateProjectColumnInput, UpdateProjectInput, UpdatePullRequestInput, UpdatePullRequestReviewCommentInput, UpdatePullRequestReviewInput, UpdateRefInput, UpdateRepositoryInput, UpdateSubscriptionInput, UpdateTopicsInput, UserStatusOrder.
type Input interface{}

// AcceptTopicSuggestionInput is an autogenerated input type of AcceptTopicSuggestion.
type AcceptTopicSuggestionInput struct {
	// The Node ID of the repository. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// The name of the suggested topic. (Required.)
	Name String `json:"name"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddAssigneesToAssignableInput is an autogenerated input type of AddAssigneesToAssignable.
type AddAssigneesToAssignableInput struct {
	// The id of the assignable object to add assignees to. (Required.)
	AssignableID ID `json:"assignableId"`
	// The id of users to add as assignees. (Required.)
	AssigneeIDs []ID `json:"assigneeIds"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddCommentInput is an autogenerated input type of AddComment.
type AddCommentInput struct {
	// The Node ID of the subject to modify. (Required.)
	SubjectID ID `json:"subjectId"`
	// The contents of the comment. (Required.)
	Body String `json:"body"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddLabelsToLabelableInput is an autogenerated input type of AddLabelsToLabelable.
type AddLabelsToLabelableInput struct {
	// The id of the labelable object to add labels to. (Required.)
	LabelableID ID `json:"labelableId"`
	// The ids of the labels to add. (Required.)
	LabelIDs []ID `json:"labelIds"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddProjectCardInput is an autogenerated input type of AddProjectCard.
type AddProjectCardInput struct {
	// The Node ID of the ProjectColumn. (Required.)
	ProjectColumnID ID `json:"projectColumnId"`

	// The content of the card. Must be a member of the ProjectCardItem union. (Optional.)
	ContentID *ID `json:"contentId,omitempty"`
	// The note on the card. (Optional.)
	Note *String `json:"note,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddProjectColumnInput is an autogenerated input type of AddProjectColumn.
type AddProjectColumnInput struct {
	// The Node ID of the project. (Required.)
	ProjectID ID `json:"projectId"`
	// The name of the column. (Required.)
	Name String `json:"name"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddPullRequestReviewCommentInput is an autogenerated input type of AddPullRequestReviewComment.
type AddPullRequestReviewCommentInput struct {
	// The Node ID of the review to modify. (Required.)
	PullRequestReviewID ID `json:"pullRequestReviewId"`
	// The text of the comment. (Required.)
	Body String `json:"body"`

	// The SHA of the commit to comment on. (Optional.)
	CommitOID *GitObjectID `json:"commitOID,omitempty"`
	// The relative path of the file to comment on. (Optional.)
	Path *String `json:"path,omitempty"`
	// The line index in the diff to comment on. (Optional.)
	Position *Int `json:"position,omitempty"`
	// The comment id to reply to. (Optional.)
	InReplyTo *ID `json:"inReplyTo,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddPullRequestReviewInput is an autogenerated input type of AddPullRequestReview.
type AddPullRequestReviewInput struct {
	// The Node ID of the pull request to modify. (Required.)
	PullRequestID ID `json:"pullRequestId"`

	// The commit OID the review pertains to. (Optional.)
	CommitOID *GitObjectID `json:"commitOID,omitempty"`
	// The contents of the review body comment. (Optional.)
	Body *String `json:"body,omitempty"`
	// The event to perform on the pull request review. (Optional.)
	Event *PullRequestReviewEvent `json:"event,omitempty"`
	// The review line comments. (Optional.)
	Comments *[]*DraftPullRequestReviewComment `json:"comments,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddReactionInput is an autogenerated input type of AddReaction.
type AddReactionInput struct {
	// The Node ID of the subject to modify. (Required.)
	SubjectID ID `json:"subjectId"`
	// The name of the emoji to react with. (Required.)
	Content ReactionContent `json:"content"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// AddStarInput is an autogenerated input type of AddStar.
type AddStarInput struct {
	// The Starrable ID to star. (Required.)
	StarrableID ID `json:"starrableId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// ChangeUserStatusInput is an autogenerated input type of ChangeUserStatus.
type ChangeUserStatusInput struct {

	// The emoji to represent your status. Can either be a native Unicode emoji or an emoji name with colons, e.g., :grinning:. (Optional.)
	Emoji *String `json:"emoji,omitempty"`
	// A short description of your current status. (Optional.)
	Message *String `json:"message,omitempty"`
	// The ID of the organization whose members will be allowed to see the status. If omitted, the status will be publicly visible. (Optional.)
	OrganizationID *ID `json:"organizationId,omitempty"`
	// Whether this status should indicate you are not fully available on GitHub, e.g., you are away. (Optional.)
	LimitedAvailability *Boolean `json:"limitedAvailability,omitempty"`
	// If set, the user status will not be shown after this date. (Optional.)
	ExpiresAt *DateTime `json:"expiresAt,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// ClearLabelsFromLabelableInput is an autogenerated input type of ClearLabelsFromLabelable.
type ClearLabelsFromLabelableInput struct {
	// The id of the labelable object to clear the labels from. (Required.)
	LabelableID ID `json:"labelableId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CloneProjectInput is an autogenerated input type of CloneProject.
type CloneProjectInput struct {
	// The owner ID to create the project under. (Required.)
	TargetOwnerID ID `json:"targetOwnerId"`
	// The source project to clone. (Required.)
	SourceID ID `json:"sourceId"`
	// Whether or not to clone the source project's workflows. (Required.)
	IncludeWorkflows Boolean `json:"includeWorkflows"`
	// The name of the project. (Required.)
	Name String `json:"name"`

	// The description of the project. (Optional.)
	Body *String `json:"body,omitempty"`
	// The visibility of the project, defaults to false (private). (Optional.)
	Public *Boolean `json:"public,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CloneTemplateRepositoryInput is an autogenerated input type of CloneTemplateRepository.
type CloneTemplateRepositoryInput struct {
	// The Node ID of the template repository. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// The name of the new repository. (Required.)
	Name String `json:"name"`
	// The ID of the owner for the new repository. (Required.)
	OwnerID ID `json:"ownerId"`
	// Indicates the repository's visibility level. (Required.)
	Visibility RepositoryVisibility `json:"visibility"`

	// A short description of the new repository. (Optional.)
	Description *String `json:"description,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CloseIssueInput is an autogenerated input type of CloseIssue.
type CloseIssueInput struct {
	// ID of the issue to be closed. (Required.)
	IssueID ID `json:"issueId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// ClosePullRequestInput is an autogenerated input type of ClosePullRequest.
type ClosePullRequestInput struct {
	// ID of the pull request to be closed. (Required.)
	PullRequestID ID `json:"pullRequestId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CommitAuthor specifies an author for filtering Git commits.
type CommitAuthor struct {

	// ID of a User to filter by. If non-null, only commits authored by this user will be returned. This field takes precedence over emails. (Optional.)
	ID *ID `json:"id,omitempty"`
	// Email addresses to filter by. Commits authored by any of the specified email addresses will be returned. (Optional.)
	Emails *[]String `json:"emails,omitempty"`
}

// CommitContributionOrder represents ordering options for commit contribution connections.
type CommitContributionOrder struct {
	// The field by which to order commit contributions. (Required.)
	Field CommitContributionOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// ContributionOrder represents ordering options for contribution connections.
type ContributionOrder struct {
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`

	// The field by which to order contributions. **Upcoming Change on 2019-10-01 UTC** **Description:** `field` will be removed. Only one order field is supported. **Reason:** `field` will be removed. (Optional.)
	Field *ContributionOrderField `json:"field,omitempty"`
}

// ConvertProjectCardNoteToIssueInput is an autogenerated input type of ConvertProjectCardNoteToIssue.
type ConvertProjectCardNoteToIssueInput struct {
	// The ProjectCard ID to convert. (Required.)
	ProjectCardID ID `json:"projectCardId"`
	// The ID of the repository to create the issue in. (Required.)
	RepositoryID ID `json:"repositoryId"`

	// The title of the newly created issue. Defaults to the card's note text. (Optional.)
	Title *String `json:"title,omitempty"`
	// The body of the newly created issue. (Optional.)
	Body *String `json:"body,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CreateBranchProtectionRuleInput is an autogenerated input type of CreateBranchProtectionRule.
type CreateBranchProtectionRuleInput struct {
	// The global relay id of the repository in which a new branch protection rule should be created in. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// The glob-like pattern used to determine matching branches. (Required.)
	Pattern String `json:"pattern"`

	// Are approving reviews required to update matching branches. (Optional.)
	RequiresApprovingReviews *Boolean `json:"requiresApprovingReviews,omitempty"`
	// Number of approving reviews required to update matching branches. (Optional.)
	RequiredApprovingReviewCount *Int `json:"requiredApprovingReviewCount,omitempty"`
	// Are commits required to be signed. (Optional.)
	RequiresCommitSignatures *Boolean `json:"requiresCommitSignatures,omitempty"`
	// Can admins overwrite branch protection. (Optional.)
	IsAdminEnforced *Boolean `json:"isAdminEnforced,omitempty"`
	// Are status checks required to update matching branches. (Optional.)
	RequiresStatusChecks *Boolean `json:"requiresStatusChecks,omitempty"`
	// Are branches required to be up to date before merging. (Optional.)
	RequiresStrictStatusChecks *Boolean `json:"requiresStrictStatusChecks,omitempty"`
	// Are reviews from code owners required to update matching branches. (Optional.)
	RequiresCodeOwnerReviews *Boolean `json:"requiresCodeOwnerReviews,omitempty"`
	// Will new commits pushed to matching branches dismiss pull request review approvals. (Optional.)
	DismissesStaleReviews *Boolean `json:"dismissesStaleReviews,omitempty"`
	// Is dismissal of pull request reviews restricted. (Optional.)
	RestrictsReviewDismissals *Boolean `json:"restrictsReviewDismissals,omitempty"`
	// A list of User or Team IDs allowed to dismiss reviews on pull requests targeting matching branches. (Optional.)
	ReviewDismissalActorIDs *[]ID `json:"reviewDismissalActorIds,omitempty"`
	// Is pushing to matching branches restricted. (Optional.)
	RestrictsPushes *Boolean `json:"restrictsPushes,omitempty"`
	// A list of User or Team IDs allowed to push to matching branches. (Optional.)
	PushActorIDs *[]ID `json:"pushActorIds,omitempty"`
	// List of required status check contexts that must pass for commits to be accepted to matching branches. (Optional.)
	RequiredStatusCheckContexts *[]String `json:"requiredStatusCheckContexts,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CreateContentAttachmentInput is an autogenerated input type of CreateContentAttachment.
type CreateContentAttachmentInput struct {
	// The node ID of the content_reference. (Required.)
	ContentReferenceID ID `json:"contentReferenceId"`
	// The title of the content attachment. (Required.)
	Title String `json:"title"`
	// The body of the content attachment, which may contain markdown. (Required.)
	Body String `json:"body"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CreateIssueInput is an autogenerated input type of CreateIssue.
type CreateIssueInput struct {
	// The Node ID of the repository. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// The title for the issue. (Required.)
	Title String `json:"title"`

	// The body for the issue description. (Optional.)
	Body *String `json:"body,omitempty"`
	// The Node ID for the user assignee for this issue. (Optional.)
	AssigneeIDs *[]ID `json:"assigneeIds,omitempty"`
	// The Node ID of the milestone for this issue. (Optional.)
	MilestoneID *ID `json:"milestoneId,omitempty"`
	// An array of Node IDs of labels for this issue. (Optional.)
	LabelIDs *[]ID `json:"labelIds,omitempty"`
	// An array of Node IDs for projects associated with this issue. (Optional.)
	ProjectIDs *[]ID `json:"projectIds,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CreateProjectInput is an autogenerated input type of CreateProject.
type CreateProjectInput struct {
	// The owner ID to create the project under. (Required.)
	OwnerID ID `json:"ownerId"`
	// The name of project. (Required.)
	Name String `json:"name"`

	// The description of project. (Optional.)
	Body *String `json:"body,omitempty"`
	// The name of the GitHub-provided template. (Optional.)
	Template *ProjectTemplate `json:"template,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CreatePullRequestInput is an autogenerated input type of CreatePullRequest.
type CreatePullRequestInput struct {
	// The Node ID of the repository. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository. (Required.)
	BaseRefName String `json:"baseRefName"`
	// The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head_ref_name` with a user like this: `username:branch`. (Required.)
	HeadRefName String `json:"headRefName"`
	// The title of the pull request. (Required.)
	Title String `json:"title"`

	// The contents of the pull request. (Optional.)
	Body *String `json:"body,omitempty"`
	// Indicates whether maintainers can modify the pull request. (Optional.)
	MaintainerCanModify *Boolean `json:"maintainerCanModify,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CreateRefInput is an autogenerated input type of CreateRef.
type CreateRefInput struct {
	// The Node ID of the Repository to create the Ref in. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// The fully qualified name of the new Ref (ie: `refs/heads/my_new_branch`). (Required.)
	Name String `json:"name"`
	// The GitObjectID that the new Ref shall target. Must point to a commit. (Required.)
	Oid GitObjectID `json:"oid"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// CreateRepositoryInput is an autogenerated input type of CreateRepository.
type CreateRepositoryInput struct {
	// The name of the new repository. (Required.)
	Name String `json:"name"`
	// Indicates the repository's visibility level. (Required.)
	Visibility RepositoryVisibility `json:"visibility"`

	// The ID of the owner for the new repository. (Optional.)
	OwnerID *ID `json:"ownerId,omitempty"`
	// A short description of the new repository. (Optional.)
	Description *String `json:"description,omitempty"`
	// Whether this repository should be marked as a template such that anyone who can access it can create new repositories with the same files and directory structure. (Optional.)
	Template *Boolean `json:"template,omitempty"`
	// The URL for a web page about this repository. (Optional.)
	HomepageURL *URI `json:"homepageUrl,omitempty"`
	// Indicates if the repository should have the wiki feature enabled. (Optional.)
	HasWikiEnabled *Boolean `json:"hasWikiEnabled,omitempty"`
	// Indicates if the repository should have the issues feature enabled. (Optional.)
	HasIssuesEnabled *Boolean `json:"hasIssuesEnabled,omitempty"`
	// When an organization is specified as the owner, this ID identifies the team that should be granted access to the new repository. (Optional.)
	TeamID *ID `json:"teamId,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeclineTopicSuggestionInput is an autogenerated input type of DeclineTopicSuggestion.
type DeclineTopicSuggestionInput struct {
	// The Node ID of the repository. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// The name of the suggested topic. (Required.)
	Name String `json:"name"`
	// The reason why the suggested topic is declined. (Required.)
	Reason TopicSuggestionDeclineReason `json:"reason"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeleteBranchProtectionRuleInput is an autogenerated input type of DeleteBranchProtectionRule.
type DeleteBranchProtectionRuleInput struct {
	// The global relay id of the branch protection rule to be deleted. (Required.)
	BranchProtectionRuleID ID `json:"branchProtectionRuleId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeleteIssueCommentInput is an autogenerated input type of DeleteIssueComment.
type DeleteIssueCommentInput struct {
	// The ID of the comment to delete. (Required.)
	ID ID `json:"id"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeleteIssueInput is an autogenerated input type of DeleteIssue.
type DeleteIssueInput struct {
	// The ID of the issue to delete. (Required.)
	IssueID ID `json:"issueId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeleteProjectCardInput is an autogenerated input type of DeleteProjectCard.
type DeleteProjectCardInput struct {
	// The id of the card to delete. (Required.)
	CardID ID `json:"cardId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeleteProjectColumnInput is an autogenerated input type of DeleteProjectColumn.
type DeleteProjectColumnInput struct {
	// The id of the column to delete. (Required.)
	ColumnID ID `json:"columnId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeleteProjectInput is an autogenerated input type of DeleteProject.
type DeleteProjectInput struct {
	// The Project ID to update. (Required.)
	ProjectID ID `json:"projectId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeletePullRequestReviewCommentInput is an autogenerated input type of DeletePullRequestReviewComment.
type DeletePullRequestReviewCommentInput struct {
	// The ID of the comment to delete. (Required.)
	ID ID `json:"id"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeletePullRequestReviewInput is an autogenerated input type of DeletePullRequestReview.
type DeletePullRequestReviewInput struct {
	// The Node ID of the pull request review to delete. (Required.)
	PullRequestReviewID ID `json:"pullRequestReviewId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeleteRefInput is an autogenerated input type of DeleteRef.
type DeleteRefInput struct {
	// The Node ID of the Ref to be deleted. (Required.)
	RefID ID `json:"refId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DeploymentOrder represents ordering options for deployment connections.
type DeploymentOrder struct {
	// The field to order deployments by. (Required.)
	Field DeploymentOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// DismissPullRequestReviewInput is an autogenerated input type of DismissPullRequestReview.
type DismissPullRequestReviewInput struct {
	// The Node ID of the pull request review to modify. (Required.)
	PullRequestReviewID ID `json:"pullRequestReviewId"`
	// The contents of the pull request review dismissal message. (Required.)
	Message String `json:"message"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// DraftPullRequestReviewComment specifies a review comment to be left with a Pull Request Review.
type DraftPullRequestReviewComment struct {
	// Path to the file being commented on. (Required.)
	Path String `json:"path"`
	// Position in the file to leave a comment on. (Required.)
	Position Int `json:"position"`
	// Body of the comment to leave. (Required.)
	Body String `json:"body"`
}

// GistOrder represents ordering options for gist connections.
type GistOrder struct {
	// The field to order repositories by. (Required.)
	Field GistOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// ImportProjectInput is an autogenerated input type of ImportProject.
type ImportProjectInput struct {
	// The name of the Organization or User to create the Project under. (Required.)
	OwnerName String `json:"ownerName"`
	// The name of Project. (Required.)
	Name String `json:"name"`
	// A list of columns containing issues and pull requests. (Required.)
	ColumnImports []ProjectColumnImport `json:"columnImports"`

	// The description of Project. (Optional.)
	Body *String `json:"body,omitempty"`
	// Whether the Project is public or not. (Optional.)
	Public *Boolean `json:"public,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// IssueFilters represents ways in which to filter lists of issues.
type IssueFilters struct {

	// List issues assigned to given name. Pass in `null` for issues with no assigned user, and `*` for issues assigned to any user. (Optional.)
	Assignee *String `json:"assignee,omitempty"`
	// List issues created by given name. (Optional.)
	CreatedBy *String `json:"createdBy,omitempty"`
	// List issues where the list of label names exist on the issue. (Optional.)
	Labels *[]String `json:"labels,omitempty"`
	// List issues where the given name is mentioned in the issue. (Optional.)
	Mentioned *String `json:"mentioned,omitempty"`
	// List issues by given milestone argument. If an string representation of an integer is passed, it should refer to a milestone by its number field. Pass in `null` for issues with no milestone, and `*` for issues that are assigned to any milestone. (Optional.)
	Milestone *String `json:"milestone,omitempty"`
	// List issues that have been updated at or after the given date. (Optional.)
	Since *DateTime `json:"since,omitempty"`
	// List issues filtered by the list of states given. (Optional.)
	States *[]IssueState `json:"states,omitempty"`
	// List issues subscribed to by viewer. (Optional.)
	ViewerSubscribed *Boolean `json:"viewerSubscribed,omitempty"`
}

// IssueOrder represents ways in which lists of issues can be ordered upon return.
type IssueOrder struct {
	// The field in which to order issues by. (Required.)
	Field IssueOrderField `json:"field"`
	// The direction in which to order issues by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// LanguageOrder represents ordering options for language connections.
type LanguageOrder struct {
	// The field to order languages by. (Required.)
	Field LanguageOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// LockLockableInput is an autogenerated input type of LockLockable.
type LockLockableInput struct {
	// ID of the issue or pull request to be locked. (Required.)
	LockableID ID `json:"lockableId"`

	// A reason for why the issue or pull request will be locked. (Optional.)
	LockReason *LockReason `json:"lockReason,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// MergeBranchInput is an autogenerated input type of MergeBranch.
type MergeBranchInput struct {
	// The Node ID of the Repository containing the base branch that will be modified. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// The name of the base branch that the provided head will be merged into. (Required.)
	Base String `json:"base"`
	// The head to merge into the base branch. This can be a branch name or a commit GitObjectID. (Required.)
	Head String `json:"head"`

	// Message to use for the merge commit. If omitted, a default will be used. (Optional.)
	CommitMessage *String `json:"commitMessage,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// MergePullRequestInput is an autogenerated input type of MergePullRequest.
type MergePullRequestInput struct {
	// ID of the pull request to be merged. (Required.)
	PullRequestID ID `json:"pullRequestId"`

	// Commit headline to use for the merge commit; if omitted, a default message will be used. (Optional.)
	CommitHeadline *String `json:"commitHeadline,omitempty"`
	// Commit body to use for the merge commit; if omitted, a default message will be used. (Optional.)
	CommitBody *String `json:"commitBody,omitempty"`
	// OID that the pull request head ref must match to allow merge; if omitted, no check is performed. (Optional.)
	ExpectedHeadOid *GitObjectID `json:"expectedHeadOid,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// MilestoneOrder represents ordering options for milestone connections.
type MilestoneOrder struct {
	// The field to order milestones by. (Required.)
	Field MilestoneOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// MinimizeCommentInput is an autogenerated input type of MinimizeComment.
type MinimizeCommentInput struct {
	// The Node ID of the subject to modify. (Required.)
	SubjectID ID `json:"subjectId"`
	// The classification of comment. (Required.)
	Classifier ReportedContentClassifiers `json:"classifier"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// MoveProjectCardInput is an autogenerated input type of MoveProjectCard.
type MoveProjectCardInput struct {
	// The id of the card to move. (Required.)
	CardID ID `json:"cardId"`
	// The id of the column to move it into. (Required.)
	ColumnID ID `json:"columnId"`

	// Place the new card after the card with this id. Pass null to place it at the top. (Optional.)
	AfterCardID *ID `json:"afterCardId,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// MoveProjectColumnInput is an autogenerated input type of MoveProjectColumn.
type MoveProjectColumnInput struct {
	// The id of the column to move. (Required.)
	ColumnID ID `json:"columnId"`

	// Place the new column after the column with this id. Pass null to place it at the front. (Optional.)
	AfterColumnID *ID `json:"afterColumnId,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// PinIssueInput is an autogenerated input type of PinIssue.
type PinIssueInput struct {
	// The ID of the issue to be pinned. (Required.)
	IssueID ID `json:"issueId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// ProjectCardImport represents an issue or PR and its owning repository to be used in a project card.
type ProjectCardImport struct {
	// Repository name with owner (owner/repository). (Required.)
	Repository String `json:"repository"`
	// The issue or pull request number. (Required.)
	Number Int `json:"number"`
}

// ProjectColumnImport represents a project column and a list of its issues and PRs.
type ProjectColumnImport struct {
	// The name of the column. (Required.)
	ColumnName String `json:"columnName"`
	// The position of the column, starting from 0. (Required.)
	Position Int `json:"position"`

	// A list of issues and pull requests in the column. (Optional.)
	Issues *[]ProjectCardImport `json:"issues,omitempty"`
}

// ProjectOrder represents ways in which lists of projects can be ordered upon return.
type ProjectOrder struct {
	// The field in which to order projects by. (Required.)
	Field ProjectOrderField `json:"field"`
	// The direction in which to order projects by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// PullRequestOrder represents ways in which lists of issues can be ordered upon return.
type PullRequestOrder struct {
	// The field in which to order pull requests by. (Required.)
	Field PullRequestOrderField `json:"field"`
	// The direction in which to order pull requests by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// ReactionOrder represents ways in which lists of reactions can be ordered upon return.
type ReactionOrder struct {
	// The field in which to order reactions by. (Required.)
	Field ReactionOrderField `json:"field"`
	// The direction in which to order reactions by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// RefOrder represents ways in which lists of git refs can be ordered upon return.
type RefOrder struct {
	// The field in which to order refs by. (Required.)
	Field RefOrderField `json:"field"`
	// The direction in which to order refs by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// ReleaseOrder represents ways in which lists of releases can be ordered upon return.
type ReleaseOrder struct {
	// The field in which to order releases by. (Required.)
	Field ReleaseOrderField `json:"field"`
	// The direction in which to order releases by the specified field. (Required.)
	Direction OrderDirection `json:"direction"`
}

// RemoveAssigneesFromAssignableInput is an autogenerated input type of RemoveAssigneesFromAssignable.
type RemoveAssigneesFromAssignableInput struct {
	// The id of the assignable object to remove assignees from. (Required.)
	AssignableID ID `json:"assignableId"`
	// The id of users to remove as assignees. (Required.)
	AssigneeIDs []ID `json:"assigneeIds"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// RemoveLabelsFromLabelableInput is an autogenerated input type of RemoveLabelsFromLabelable.
type RemoveLabelsFromLabelableInput struct {
	// The id of the Labelable to remove labels from. (Required.)
	LabelableID ID `json:"labelableId"`
	// The ids of labels to remove. (Required.)
	LabelIDs []ID `json:"labelIds"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// RemoveOutsideCollaboratorInput is an autogenerated input type of RemoveOutsideCollaborator.
type RemoveOutsideCollaboratorInput struct {
	// The ID of the outside collaborator to remove. (Required.)
	UserID ID `json:"userId"`
	// The ID of the organization to remove the outside collaborator from. (Required.)
	OrganizationID ID `json:"organizationId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// RemoveReactionInput is an autogenerated input type of RemoveReaction.
type RemoveReactionInput struct {
	// The Node ID of the subject to modify. (Required.)
	SubjectID ID `json:"subjectId"`
	// The name of the emoji reaction to remove. (Required.)
	Content ReactionContent `json:"content"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// RemoveStarInput is an autogenerated input type of RemoveStar.
type RemoveStarInput struct {
	// The Starrable ID to unstar. (Required.)
	StarrableID ID `json:"starrableId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// ReopenIssueInput is an autogenerated input type of ReopenIssue.
type ReopenIssueInput struct {
	// ID of the issue to be opened. (Required.)
	IssueID ID `json:"issueId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// ReopenPullRequestInput is an autogenerated input type of ReopenPullRequest.
type ReopenPullRequestInput struct {
	// ID of the pull request to be reopened. (Required.)
	PullRequestID ID `json:"pullRequestId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// RepositoryOrder represents ordering options for repository connections.
type RepositoryOrder struct {
	// The field to order repositories by. (Required.)
	Field RepositoryOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// RequestReviewsInput is an autogenerated input type of RequestReviews.
type RequestReviewsInput struct {
	// The Node ID of the pull request to modify. (Required.)
	PullRequestID ID `json:"pullRequestId"`

	// The Node IDs of the user to request. (Optional.)
	UserIDs *[]ID `json:"userIds,omitempty"`
	// The Node IDs of the team to request. (Optional.)
	TeamIDs *[]ID `json:"teamIds,omitempty"`
	// Add users to the set rather than replace. (Optional.)
	Union *Boolean `json:"union,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// ResolveReviewThreadInput is an autogenerated input type of ResolveReviewThread.
type ResolveReviewThreadInput struct {
	// The ID of the thread to resolve. (Required.)
	ThreadID ID `json:"threadId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// SecurityAdvisoryIdentifierFilter represents an advisory identifier to filter results on.
type SecurityAdvisoryIdentifierFilter struct {
	// The identifier type. (Required.)
	Type SecurityAdvisoryIdentifierType `json:"type"`
	// The identifier string. Supports exact or partial matching. (Required.)
	Value String `json:"value"`
}

// SecurityAdvisoryOrder represents ordering options for security advisory connections.
type SecurityAdvisoryOrder struct {
	// The field to order security advisories by. (Required.)
	Field SecurityAdvisoryOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// SecurityVulnerabilityOrder represents ordering options for security vulnerability connections.
type SecurityVulnerabilityOrder struct {
	// The field to order security vulnerabilities by. (Required.)
	Field SecurityVulnerabilityOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// StarOrder represents ways in which star connections can be ordered.
type StarOrder struct {
	// The field in which to order nodes by. (Required.)
	Field StarOrderField `json:"field"`
	// The direction in which to order nodes. (Required.)
	Direction OrderDirection `json:"direction"`
}

// SubmitPullRequestReviewInput is an autogenerated input type of SubmitPullRequestReview.
type SubmitPullRequestReviewInput struct {
	// The Pull Request Review ID to submit. (Required.)
	PullRequestReviewID ID `json:"pullRequestReviewId"`
	// The event to send to the Pull Request Review. (Required.)
	Event PullRequestReviewEvent `json:"event"`

	// The text field to set on the Pull Request Review. (Optional.)
	Body *String `json:"body,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// TeamMemberOrder represents ordering options for team member connections.
type TeamMemberOrder struct {
	// The field to order team members by. (Required.)
	Field TeamMemberOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// TeamOrder represents ways in which team connections can be ordered.
type TeamOrder struct {
	// The field in which to order nodes by. (Required.)
	Field TeamOrderField `json:"field"`
	// The direction in which to order nodes. (Required.)
	Direction OrderDirection `json:"direction"`
}

// TeamRepositoryOrder represents ordering options for team repository connections.
type TeamRepositoryOrder struct {
	// The field to order repositories by. (Required.)
	Field TeamRepositoryOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}

// UnlockLockableInput is an autogenerated input type of UnlockLockable.
type UnlockLockableInput struct {
	// ID of the issue or pull request to be unlocked. (Required.)
	LockableID ID `json:"lockableId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UnmarkIssueAsDuplicateInput is an autogenerated input type of UnmarkIssueAsDuplicate.
type UnmarkIssueAsDuplicateInput struct {
	// ID of the issue or pull request currently marked as a duplicate. (Required.)
	DuplicateID ID `json:"duplicateId"`
	// ID of the issue or pull request currently considered canonical/authoritative/original. (Required.)
	CanonicalID ID `json:"canonicalId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UnminimizeCommentInput is an autogenerated input type of UnminimizeComment.
type UnminimizeCommentInput struct {
	// The Node ID of the subject to modify. (Required.)
	SubjectID ID `json:"subjectId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UnpinIssueInput is an autogenerated input type of UnpinIssue.
type UnpinIssueInput struct {
	// The ID of the issue to be unpinned. (Required.)
	IssueID ID `json:"issueId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UnresolveReviewThreadInput is an autogenerated input type of UnresolveReviewThread.
type UnresolveReviewThreadInput struct {
	// The ID of the thread to unresolve. (Required.)
	ThreadID ID `json:"threadId"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateBranchProtectionRuleInput is an autogenerated input type of UpdateBranchProtectionRule.
type UpdateBranchProtectionRuleInput struct {
	// The global relay id of the branch protection rule to be updated. (Required.)
	BranchProtectionRuleID ID `json:"branchProtectionRuleId"`

	// The glob-like pattern used to determine matching branches. (Optional.)
	Pattern *String `json:"pattern,omitempty"`
	// Are approving reviews required to update matching branches. (Optional.)
	RequiresApprovingReviews *Boolean `json:"requiresApprovingReviews,omitempty"`
	// Number of approving reviews required to update matching branches. (Optional.)
	RequiredApprovingReviewCount *Int `json:"requiredApprovingReviewCount,omitempty"`
	// Are commits required to be signed. (Optional.)
	RequiresCommitSignatures *Boolean `json:"requiresCommitSignatures,omitempty"`
	// Can admins overwrite branch protection. (Optional.)
	IsAdminEnforced *Boolean `json:"isAdminEnforced,omitempty"`
	// Are status checks required to update matching branches. (Optional.)
	RequiresStatusChecks *Boolean `json:"requiresStatusChecks,omitempty"`
	// Are branches required to be up to date before merging. (Optional.)
	RequiresStrictStatusChecks *Boolean `json:"requiresStrictStatusChecks,omitempty"`
	// Are reviews from code owners required to update matching branches. (Optional.)
	RequiresCodeOwnerReviews *Boolean `json:"requiresCodeOwnerReviews,omitempty"`
	// Will new commits pushed to matching branches dismiss pull request review approvals. (Optional.)
	DismissesStaleReviews *Boolean `json:"dismissesStaleReviews,omitempty"`
	// Is dismissal of pull request reviews restricted. (Optional.)
	RestrictsReviewDismissals *Boolean `json:"restrictsReviewDismissals,omitempty"`
	// A list of User or Team IDs allowed to dismiss reviews on pull requests targeting matching branches. (Optional.)
	ReviewDismissalActorIDs *[]ID `json:"reviewDismissalActorIds,omitempty"`
	// Is pushing to matching branches restricted. (Optional.)
	RestrictsPushes *Boolean `json:"restrictsPushes,omitempty"`
	// A list of User or Team IDs allowed to push to matching branches. (Optional.)
	PushActorIDs *[]ID `json:"pushActorIds,omitempty"`
	// List of required status check contexts that must pass for commits to be accepted to matching branches. (Optional.)
	RequiredStatusCheckContexts *[]String `json:"requiredStatusCheckContexts,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateIssueCommentInput is an autogenerated input type of UpdateIssueComment.
type UpdateIssueCommentInput struct {
	// The ID of the IssueComment to modify. (Required.)
	ID ID `json:"id"`
	// The updated text of the comment. (Required.)
	Body String `json:"body"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateIssueInput is an autogenerated input type of UpdateIssue.
type UpdateIssueInput struct {
	// The ID of the Issue to modify. (Required.)
	ID ID `json:"id"`

	// The title for the issue. (Optional.)
	Title *String `json:"title,omitempty"`
	// The body for the issue description. (Optional.)
	Body *String `json:"body,omitempty"`
	// An array of Node IDs of users for this issue. (Optional.)
	AssigneeIDs *[]ID `json:"assigneeIds,omitempty"`
	// The Node ID of the milestone for this issue. (Optional.)
	MilestoneID *ID `json:"milestoneId,omitempty"`
	// An array of Node IDs of labels for this issue. (Optional.)
	LabelIDs *[]ID `json:"labelIds,omitempty"`
	// The desired issue state. (Optional.)
	State *IssueState `json:"state,omitempty"`
	// An array of Node IDs for projects associated with this issue. (Optional.)
	ProjectIDs *[]ID `json:"projectIds,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateProjectCardInput is an autogenerated input type of UpdateProjectCard.
type UpdateProjectCardInput struct {
	// The ProjectCard ID to update. (Required.)
	ProjectCardID ID `json:"projectCardId"`

	// Whether or not the ProjectCard should be archived. (Optional.)
	IsArchived *Boolean `json:"isArchived,omitempty"`
	// The note of ProjectCard. (Optional.)
	Note *String `json:"note,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateProjectColumnInput is an autogenerated input type of UpdateProjectColumn.
type UpdateProjectColumnInput struct {
	// The ProjectColumn ID to update. (Required.)
	ProjectColumnID ID `json:"projectColumnId"`
	// The name of project column. (Required.)
	Name String `json:"name"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateProjectInput is an autogenerated input type of UpdateProject.
type UpdateProjectInput struct {
	// The Project ID to update. (Required.)
	ProjectID ID `json:"projectId"`

	// The name of project. (Optional.)
	Name *String `json:"name,omitempty"`
	// The description of project. (Optional.)
	Body *String `json:"body,omitempty"`
	// Whether the project is open or closed. (Optional.)
	State *ProjectState `json:"state,omitempty"`
	// Whether the project is public or not. (Optional.)
	Public *Boolean `json:"public,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdatePullRequestInput is an autogenerated input type of UpdatePullRequest.
type UpdatePullRequestInput struct {
	// The Node ID of the pull request. (Required.)
	PullRequestID ID `json:"pullRequestId"`

	// The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. (Optional.)
	BaseRefName *String `json:"baseRefName,omitempty"`
	// The title of the pull request. (Optional.)
	Title *String `json:"title,omitempty"`
	// The contents of the pull request. (Optional.)
	Body *String `json:"body,omitempty"`
	// Indicates whether maintainers can modify the pull request. (Optional.)
	MaintainerCanModify *Boolean `json:"maintainerCanModify,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdatePullRequestReviewCommentInput is an autogenerated input type of UpdatePullRequestReviewComment.
type UpdatePullRequestReviewCommentInput struct {
	// The Node ID of the comment to modify. (Required.)
	PullRequestReviewCommentID ID `json:"pullRequestReviewCommentId"`
	// The text of the comment. (Required.)
	Body String `json:"body"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdatePullRequestReviewInput is an autogenerated input type of UpdatePullRequestReview.
type UpdatePullRequestReviewInput struct {
	// The Node ID of the pull request review to modify. (Required.)
	PullRequestReviewID ID `json:"pullRequestReviewId"`
	// The contents of the pull request review body. (Required.)
	Body String `json:"body"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateRefInput is an autogenerated input type of UpdateRef.
type UpdateRefInput struct {
	// The Node ID of the Ref to be updated. (Required.)
	RefID ID `json:"refId"`
	// The GitObjectID that the Ref shall be updated to target. (Required.)
	Oid GitObjectID `json:"oid"`

	// Permit updates of branch Refs that are not fast-forwards?. (Optional.)
	Force *Boolean `json:"force,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateRepositoryInput is an autogenerated input type of UpdateRepository.
type UpdateRepositoryInput struct {
	// The ID of the repository to update. (Required.)
	RepositoryID ID `json:"repositoryId"`

	// The new name of the repository. (Optional.)
	Name *String `json:"name,omitempty"`
	// A new description for the repository. Pass an empty string to erase the existing description. (Optional.)
	Description *String `json:"description,omitempty"`
	// Whether this repository should be marked as a template such that anyone who can access it can create new repositories with the same files and directory structure. (Optional.)
	Template *Boolean `json:"template,omitempty"`
	// The URL for a web page about this repository. Pass an empty string to erase the existing URL. (Optional.)
	HomepageURL *URI `json:"homepageUrl,omitempty"`
	// Indicates if the repository should have the wiki feature enabled. (Optional.)
	HasWikiEnabled *Boolean `json:"hasWikiEnabled,omitempty"`
	// Indicates if the repository should have the issues feature enabled. (Optional.)
	HasIssuesEnabled *Boolean `json:"hasIssuesEnabled,omitempty"`
	// Indicates if the repository should have the project boards feature enabled. (Optional.)
	HasProjectsEnabled *Boolean `json:"hasProjectsEnabled,omitempty"`
	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateSubscriptionInput is an autogenerated input type of UpdateSubscription.
type UpdateSubscriptionInput struct {
	// The Node ID of the subscribable object to modify. (Required.)
	SubscribableID ID `json:"subscribableId"`
	// The new state of the subscription. (Required.)
	State SubscriptionState `json:"state"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UpdateTopicsInput is an autogenerated input type of UpdateTopics.
type UpdateTopicsInput struct {
	// The Node ID of the repository. (Required.)
	RepositoryID ID `json:"repositoryId"`
	// An array of topic names. (Required.)
	TopicNames []String `json:"topicNames"`

	// A unique identifier for the client performing the mutation. (Optional.)
	ClientMutationID *String `json:"clientMutationId,omitempty"`
}

// UserStatusOrder represents ordering options for user status connections.
type UserStatusOrder struct {
	// The field to order user statuses by. (Required.)
	Field UserStatusOrderField `json:"field"`
	// The ordering direction. (Required.)
	Direction OrderDirection `json:"direction"`
}
