/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated for package cloudinit by go-bindata DO NOT EDIT. (@generated)
// sources:
// bootstrap/kubeadm/internal/cloudinit/kubeadm-bootstrap-script.sh
package cloudinit

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

// Name return file name
func (fi bindataFileInfo) Name() string {
	return fi.name
}

// Size return file size
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}

// Mode return file mode
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}

// Mode return file modify time
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}

// IsDir return file whether a directory
func (fi bindataFileInfo) IsDir() bool {
	return fi.mode&os.ModeDir != 0
}

// Sys return file is sys mode
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _bootstrapKubeadmInternalCloudinitKubeadmBootstrapScriptSh = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x57\x61\x6f\xdb\xb0\x11\xfd\xae\x5f\xf1\x62\x1b\x6b\xd2\x44\xb6\xe3\xa2\x43\x91\xc0\xdb\xbc\xb4\xc5\x8c\x76\x49\x11\xa7\x2d\x8a\xa2\x08\x68\xe9\x24\x71\xa6\x48\x95\xa4\xe2\x18\x6e\xfe\xfb\x40\x4a\x76\xec\xd8\x4e\xda\x6c\xf9\x12\x81\xbc\x7b\x77\xf7\xee\xf1\x48\x37\xf7\x3a\x63\x2e\x3b\x63\x66\xb2\xa0\x89\x33\x55\xcc\x34\x4f\x33\x8b\x5e\xb7\xd7\xc5\x55\x46\xf8\x50\x8e\x49\x4b\xb2\x64\x30\x28\x6d\xa6\xb4\x69\x07\xcd\xa0\x89\x8f\x3c\x22\x69\x28\x46\x29\x63\xd2\xb0\x19\x61\x50\xb0\x28\xa3\xc5\xce\x11\xbe\x90\x36\x5c\x49\xf4\xda\x5d\xec\x3b\x83\x46\xbd\xd5\x38\x38\x0d\x9a\x98\xa9\x12\x39\x9b\x41\x2a\x8b\xd2\x10\x6c\xc6\x0d\x12\x2e\x08\x74\x1b\x51\x61\xc1\x25\x22\x95\x17\x82\x33\x19\x11\xa6\xdc\x66\x3e\x4c\x0d\xd2\x0e\x9a\xf8\x56\x43\xa8\xb1\x65\x5c\x82\x21\x52\xc5\x0c\x2a\x59\xb5\x03\xb3\x3e\x61\xf7\x97\x59\x5b\x9c\x74\x3a\xd3\xe9\xb4\xcd\x7c\xb2\x6d\xa5\xd3\x8e\xa8\x0c\x4d\xe7\xe3\xf0\xec\xdd\xf9\xe8\x5d\xd8\x6b\x77\xbd\xcb\x67\x29\xc8\x18\x68\xfa\x59\x72\x4d\x31\xc6\x33\xb0\xa2\x10\x3c\x62\x63\x41\x10\x6c\x0a\xa5\xc1\x52\x4d\x14\xc3\x2a\x97\xef\x54\x73\xcb\x65\x7a\x04\xa3\x12\x3b\x65\x9a\x82\x26\x62\x6e\xac\xe6\xe3\xd2\xae\x91\xb5\xc8\x8e\x9b\x35\x03\x25\xc1\x24\x1a\x83\x11\x86\xa3\x06\xfe\x39\x18\x0d\x47\x47\x41\x13\x5f\x87\x57\xff\xba\xf8\x7c\x85\xaf\x83\xcb\xcb\xc1\xf9\xd5\xf0\xdd\x08\x17\x97\x38\xbb\x38\x7f\x3b\xbc\x1a\x5e\x9c\x8f\x70\xf1\x1e\x83\xf3\x6f\xf8\x30\x3c\x7f\x7b\x04\xe2\x36\x23\x0d\xba\x2d\xb4\xcb\x5f\x69\x70\x47\x23\xc5\x8e\xb3\x11\xd1\x5a\x02\x89\xaa\x12\x32\x05\x45\x3c\xe1\x11\x04\x93\x69\xc9\x52\x42\xaa\x6e\x48\x4b\x2e\x53\x14\xa4\x73\x6e\x5c\x33\x0d\x98\x8c\x83\x26\x04\xcf\xb9\x65\xd6\xaf\x6c\x14\xd5\x0e\x9c\x40\x54\xea\x4a\x21\xad\x1d\x49\x32\x06\xdd\x72\xeb\x12\x18\xe8\xd4\x9c\xf8\x86\xb4\x8e\xf1\x6f\x32\xc6\xc5\xb2\x0a\x42\xa5\xf7\x4d\xf6\x6e\x95\x51\xcf\xeb\xb0\xc2\x89\x54\xec\x6d\x35\xd9\x52\xcb\x40\xa8\xf4\xe4\xc4\xef\x5c\x3b\xf4\xfd\x03\xcc\x03\x40\xa8\x88\x09\xe4\x15\x72\xbf\xd1\x9a\x1f\xdf\x35\x96\xcb\x0e\xc1\xad\xf5\xee\x1a\x81\x5f\x5c\x20\xa0\xd1\x9a\xd7\x3e\xde\xbc\x89\xf9\x1c\x3c\x41\xfb\x4c\x49\xab\x95\xf8\x24\x98\x24\xdc\xdd\x2d\x9c\xb8\x4c\x14\x1a\x97\x94\xab\x1b\x47\x51\x4e\xf9\x98\x34\x12\xad\x72\x44\xa2\x34\x96\x34\x8c\x65\xb6\x34\x0e\x6c\x52\x8e\x89\xc5\x39\x34\x19\xb2\x08\x13\x94\x45\xcc\x2c\x85\xb5\x65\x58\x59\xe2\xd7\x2f\x58\x5d\xd2\x8e\x10\x64\xa3\xb8\x8e\xb3\x15\x53\x3b\x43\x0a\x9d\x59\x58\xa7\x73\x0f\xe8\xcb\x21\x19\x6f\xa9\xc0\x90\x75\xa2\x5d\x00\x6e\xc5\x7e\x90\x59\xcd\x58\x9d\x7e\xfb\x36\x9c\xbc\x31\x6d\xae\x96\x7e\x63\xa5\xac\xb1\x9a\x15\x30\x91\xe6\x85\x45\xab\xeb\xfb\xef\xc2\xf8\x1e\xd7\x05\xb7\xe6\xae\x1f\x9e\x6f\xb7\xed\x7a\x50\x2f\xdc\x05\x55\x77\x4d\x19\x45\x64\xcc\x7a\x7f\x97\xc9\xff\x51\x02\x09\x97\xdc\x64\x14\x2f\xa3\x75\x5d\x94\x07\x4a\x1d\x97\x16\x13\xa2\x02\xa9\xe2\x32\x6d\xaf\x48\xec\x71\x75\x59\x9e\x93\xb1\x2c\x2f\xfa\xad\x7d\xd7\x5a\x84\x21\x37\x2a\x7c\xf3\xd7\xee\x71\xdf\x50\xa4\x64\x6c\x0e\x5c\xdc\x28\x53\x68\xec\xed\xed\xe1\x7b\x6b\xbe\xf4\xb9\xfb\x01\x8f\x83\xbf\xfd\xa5\x17\x00\x26\xe3\x89\x0d\xe0\x8f\x66\x1d\xe8\x14\xb1\x0a\xdc\x08\xab\x00\xdc\xd7\x8a\x5c\x6b\xbf\x58\x49\xaa\x4a\xfa\xa4\xb9\xb4\x60\x0b\x9a\x05\x97\xd4\x06\xde\x2b\x9d\x33\x6b\xab\x69\x65\x32\x35\x45\x59\xc0\xcf\x4d\x63\x35\xb1\xdc\x4d\x4e\x55\xda\xa2\xb4\x75\xdd\x8e\xe4\xba\xec\x3f\xaa\xef\xf0\xf0\x70\x6b\x7d\xcf\xa9\x6d\xa5\xae\x28\xa3\x68\x72\x5d\xb7\xf8\x3a\x52\x79\xce\x64\xbc\xd6\x96\x7a\xed\xb1\x43\x0f\x44\xcc\xd0\x42\x79\xe0\x32\x00\x1a\xdd\xc6\x81\xcf\x60\x45\x5a\xf7\x47\xa0\x50\xda\x71\x56\x2b\x31\x29\x05\xe8\x96\xa2\xd2\x0d\x3f\x5f\x86\x83\xf2\x61\x3d\x3a\x70\x7a\xea\x20\x8f\x57\x21\xeb\xf3\xb2\x81\x99\x30\x2e\x28\x06\x8b\x1c\xd8\xbe\x39\x78\x04\xaf\xf7\x3b\x78\x85\xa6\x44\xf8\x0b\xdc\x73\x55\x6b\x3a\x2e\xb5\x3b\x78\xdb\x71\x5f\x6d\xe0\x5e\x57\x47\x71\x03\xfc\x86\x09\x1e\xfb\x99\x5f\xe3\xee\x4c\xf6\xe5\x6f\xa4\x5a\xca\x89\x54\xd3\x05\xd4\xa2\x1d\x3b\x21\xc9\xb0\xc8\x69\x20\x29\xa5\x27\xcb\x5d\x01\x7a\x16\xae\x8b\x40\xf6\xbb\xcb\x9e\x2f\x64\x52\x5f\x15\x40\x29\x2d\x17\xf8\x8e\x96\x44\x98\x12\x5e\xe3\xc7\x52\x78\x2b\x6d\xd7\xa5\xf4\x57\xde\x8b\xd6\xcb\x17\x55\xf8\x26\x4c\x46\x42\x54\x84\xc6\xdc\xb8\xcb\xbf\x3f\x3a\x3b\xee\xbe\x79\xe5\xf7\x1b\xad\x7f\x34\x10\x86\x91\x92\x09\x4f\xfb\x1d\x5d\xca\x4e\x1d\x7b\xf1\x3f\xfc\x8f\xe2\xb2\x36\x68\xcf\x58\x2e\x30\x9f\xb7\x3f\x54\x7b\x5f\x48\x8f\x95\xe1\x76\xe6\xe7\x32\x1e\xa4\xdd\x6f\xfd\xdd\xaf\x6e\x55\x3e\x1a\x3e\x49\x37\x34\xd7\xbd\x6a\xde\x78\xe2\xaa\x7d\xb8\x87\x90\x7e\xa2\xeb\x8a\xb7\x19\x49\x6f\x08\x8c\x35\xb1\x89\xff\x4e\x78\x5d\xf4\x57\x02\x13\x42\x4d\x57\x34\xe5\x5b\x65\xdc\xf0\x28\x98\x31\x4f\xc5\xe8\x3d\x15\x43\xf6\x5b\xfb\xfb\x12\x87\x38\x3e\xa8\xf4\x62\x84\x1b\xbc\xc7\xaf\x17\x47\x7e\x37\xbc\xa4\x07\x25\x6c\xa8\xd7\x2a\x85\x9c\xc9\x59\x9d\xf4\xd1\xe2\xfa\x71\xd4\x24\xbc\x9a\x92\x3b\x2e\xf8\xa5\xc4\x9c\xc0\x94\x0e\x63\x4e\xe1\xb6\x61\xb3\xa1\xb0\x47\x64\xf4\xb8\x88\xfe\x9f\x12\xda\x26\xa0\x67\xc8\xe7\xf9\xcc\x27\xcc\x32\x51\xd1\xbe\xc9\xfa\xea\x33\x24\x58\x3b\xc2\xcb\xab\xdb\x55\x8a\x22\x73\x43\xfa\x5e\x7a\x61\xc8\x53\xa9\x34\x85\xcb\xa5\xb0\x6a\x6c\xff\x2d\xd7\x83\x1b\xc6\x85\x63\x34\x74\x8f\x9f\x70\xb2\xfc\xc9\x12\xe6\x4c\xf2\x84\x8c\x35\xbb\xbb\xfd\x64\x12\x51\xe5\x10\x16\xce\xc3\xc5\x2f\x98\x26\xc4\x6a\x2a\x85\x62\x71\x18\x91\xb6\xe6\xb9\x28\xff\x93\xb3\x33\xac\x14\xf1\xec\xf0\xab\xab\x6b\xbd\x79\x12\xd0\x2d\x09\xb2\xee\xe5\xaa\xed\x6e\x76\x37\x8f\xd0\xd3\xd9\xf9\x0d\xf7\x8a\xfd\xd3\xb2\xfc\x46\xfd\xb2\xae\x5e\x3e\xcf\x42\xc8\x99\x9e\x84\xbb\xa9\xd9\x7c\x97\x06\xff\x0d\x00\x00\xff\xff\x86\x85\x6b\x16\x46\x0f\x00\x00")

func bootstrapKubeadmInternalCloudinitKubeadmBootstrapScriptShBytes() ([]byte, error) {
	return bindataRead(
		_bootstrapKubeadmInternalCloudinitKubeadmBootstrapScriptSh,
		"bootstrap/kubeadm/internal/cloudinit/kubeadm-bootstrap-script.sh",
	)
}

func bootstrapKubeadmInternalCloudinitKubeadmBootstrapScriptSh() (*asset, error) {
	bytes, err := bootstrapKubeadmInternalCloudinitKubeadmBootstrapScriptShBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "bootstrap/kubeadm/internal/cloudinit/kubeadm-bootstrap-script.sh", size: 3910, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"bootstrap/kubeadm/internal/cloudinit/kubeadm-bootstrap-script.sh": bootstrapKubeadmInternalCloudinitKubeadmBootstrapScriptSh,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"bootstrap": &bintree{nil, map[string]*bintree{
		"kubeadm": &bintree{nil, map[string]*bintree{
			"internal": &bintree{nil, map[string]*bintree{
				"cloudinit": &bintree{nil, map[string]*bintree{
					"kubeadm-bootstrap-script.sh": &bintree{bootstrapKubeadmInternalCloudinitKubeadmBootstrapScriptSh, map[string]*bintree{}},
				}},
			}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
