// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package paymentsresellersubscription provides access to the Payments Reseller Subscription API.
//
// For product documentation, see: https://developers.google.com/payments/reseller/subscription/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/paymentsresellersubscription/v1"
//   ...
//   ctx := context.Background()
//   paymentsresellersubscriptionService, err := paymentsresellersubscription.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   paymentsresellersubscriptionService, err := paymentsresellersubscription.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   paymentsresellersubscriptionService, err := paymentsresellersubscription.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package paymentsresellersubscription // import "google.golang.org/api/paymentsresellersubscription/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "paymentsresellersubscription:v1"
const apiName = "paymentsresellersubscription"
const apiVersion = "v1"
const basePath = "https://paymentsresellersubscription.googleapis.com/"
const mtlsBasePath = "https://paymentsresellersubscription.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Partners = NewPartnersService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Partners *PartnersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewPartnersService(s *Service) *PartnersService {
	rs := &PartnersService{s: s}
	rs.Products = NewPartnersProductsService(s)
	rs.Promotions = NewPartnersPromotionsService(s)
	rs.Subscriptions = NewPartnersSubscriptionsService(s)
	return rs
}

type PartnersService struct {
	s *Service

	Products *PartnersProductsService

	Promotions *PartnersPromotionsService

	Subscriptions *PartnersSubscriptionsService
}

func NewPartnersProductsService(s *Service) *PartnersProductsService {
	rs := &PartnersProductsService{s: s}
	return rs
}

type PartnersProductsService struct {
	s *Service
}

func NewPartnersPromotionsService(s *Service) *PartnersPromotionsService {
	rs := &PartnersPromotionsService{s: s}
	return rs
}

type PartnersPromotionsService struct {
	s *Service
}

func NewPartnersSubscriptionsService(s *Service) *PartnersSubscriptionsService {
	rs := &PartnersSubscriptionsService{s: s}
	return rs
}

type PartnersSubscriptionsService struct {
	s *Service
}

type GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionRequest struct {
	// CancelImmediately: Optional. If true, the subscription will be
	// cancelled immediately. Otherwise, the subscription will be cancelled
	// at the end of the current cycle, and therefore no prorated refund
	// will be issued for the rest of the cycle.
	CancelImmediately bool `json:"cancelImmediately,omitempty"`

	// CancellationReason: Specifies the reason for the cancellation.
	//
	// Possible values:
	//   "CANCELLATION_REASON_UNSPECIFIED" - Reason is unspecified.
	//   "CANCELLATION_REASON_FRAUD" - Fraudualant transaction.
	//   "CANCELLATION_REASON_REMORSE" - Buyer's remorse.
	//   "CANCELLATION_REASON_ACCIDENTAL_PURCHASE" - Accidential purchase.
	//   "CANCELLATION_REASON_PAST_DUE" - Payment is past due.
	//   "CANCELLATION_REASON_ACCOUNT_CLOSED" - User account closed.
	//   "CANCELLATION_REASON_UPGRADE_DOWNGRADE" - Used for notification
	// only, do not use in Cancel API. Cancallation due to upgrade or
	// downgrade.
	//   "CANCELLATION_REASON_OTHER" - Other reason.
	CancellationReason string `json:"cancellationReason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CancelImmediately")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CancelImmediately") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionResponse struct {
	// Subscription: The cancelled subscription resource.
	Subscription *GoogleCloudPaymentsResellerSubscriptionV1Subscription `json:"subscription,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Subscription") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Subscription") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1Duration: Describes the
// length of a period of a time.
type GoogleCloudPaymentsResellerSubscriptionV1Duration struct {
	// Count: number of duration units to be included.
	Count int64 `json:"count,omitempty"`

	// Unit: The unit used for the duration
	//
	// Possible values:
	//   "UNIT_UNSPECIFIED" - Default value.
	//   "MONTH" - Unit of a calendar month.
	//   "DAY" - Unit of a day.
	Unit string `json:"unit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1Duration) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1Duration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionRequest:
// Partner request for entitling the previously provisioned subscription
// to an end user. The end user identity is inferred from the request
// OAuth context.
type GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionRequest struct {
}

type GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionResponse struct {
	// Subscription: The subscription that has user linked to it.
	Subscription *GoogleCloudPaymentsResellerSubscriptionV1Subscription `json:"subscription,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Subscription") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Subscription") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionRequest:
// Request message for extending a Subscription resource. A new
// recurrence will be made based on the subscription schedule defined by
// the original product.
type GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionRequest struct {
	// Extension: Required. Specifies details of the extension. Currently,
	// the duration of the extension must be exactly one billing cycle of
	// the original subscription.
	Extension *GoogleCloudPaymentsResellerSubscriptionV1Extension `json:"extension,omitempty"`

	// RequestId: Required. Restricted to 36 ASCII characters. A random UUID
	// is recommended. The idempotency key for the request. The ID
	// generation logic is controlled by the partner. request_id should be
	// the same as on retries of the same request. A different request_id
	// must be used for a extension of a different cycle. A random UUID is
	// recommended.
	RequestId string `json:"requestId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Extension") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Extension") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionResponse struct {
	// CycleEndTime: The time at which the subscription is expected to be
	// extended, in ISO 8061 format. UTC timezone. Example,
	// "cycleEndTime":"2019-08-31T17:28:54.564Z"
	CycleEndTime string `json:"cycleEndTime,omitempty"`

	// FreeTrialEndTime: End of the free trial period, in ISO 8061 format.
	// UTC timezone. Example, "freeTrialEndTime":"2019-08-31T17:28:54.564Z"
	// This time will be set the same as initial subscription creation time
	// if no free trial period is offered to the partner.
	FreeTrialEndTime string `json:"freeTrialEndTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CycleEndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CycleEndTime") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1Extension: Describes the
// details of an extension request.
type GoogleCloudPaymentsResellerSubscriptionV1Extension struct {
	// Duration: Specifies the period of access the subscription should
	// grant.
	Duration *GoogleCloudPaymentsResellerSubscriptionV1Duration `json:"duration,omitempty"`

	// PartnerUserToken: Required. Identifier of the end-user in partner’s
	// system.
	PartnerUserToken string `json:"partnerUserToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Duration") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1Extension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1Extension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudPaymentsResellerSubscriptionV1ListProductsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is empty, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Products: The products for the specified partner.
	Products []*GoogleCloudPaymentsResellerSubscriptionV1Product `json:"products,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1ListProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1ListProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudPaymentsResellerSubscriptionV1ListPromotionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is empty, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Promotions: The promotions for the specified partner.
	Promotions []*GoogleCloudPaymentsResellerSubscriptionV1Promotion `json:"promotions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1ListPromotionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1ListPromotionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1Location: Describes a
// location of an end user.
type GoogleCloudPaymentsResellerSubscriptionV1Location struct {
	// PostalCode: The postal code this location refers to. Ex. "94043"
	PostalCode string `json:"postalCode,omitempty"`

	// RegionCode: 2-letter ISO region code for current content region. Ex.
	// “US” Please refers to: https://en.wikipedia.org/wiki/ISO_3166-1
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PostalCode") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PostalCode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1Location) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1Location
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1Product: A Product resource
// that defines a subscription service that can be resold.
type GoogleCloudPaymentsResellerSubscriptionV1Product struct {
	// Name: Output only. Response only. Resource name of the subscription.
	// It will have the format of
	// "partners/{partner_id}/products/{product_id}"
	Name string `json:"name,omitempty"`

	// RegionCodes: Output only. 2-letter ISO region code where the product
	// is available in. Ex. "US" Please refers to:
	// https://en.wikipedia.org/wiki/ISO_3166-1
	RegionCodes []string `json:"regionCodes,omitempty"`

	// SubscriptionBillingCycleDuration: Output only. Specifies the length
	// of the billing cycle of the subscription.
	SubscriptionBillingCycleDuration *GoogleCloudPaymentsResellerSubscriptionV1Duration `json:"subscriptionBillingCycleDuration,omitempty"`

	// Titles: Output only. Localized human readable name of the product.
	Titles []*GoogleTypeLocalizedText `json:"titles,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1Product) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1Product
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1Promotion: A Promotion
// resource that defines a promotion for a subscription that can be
// resold.
type GoogleCloudPaymentsResellerSubscriptionV1Promotion struct {
	// ApplicableProducts: Output only. The product ids this promotion can
	// be applied to.
	ApplicableProducts []string `json:"applicableProducts,omitempty"`

	// EndTime: Optional. Specifies the end time (exclusive) of the period
	// that the promotion is available in. If unset, the promotion is
	// available indefinitely.
	EndTime string `json:"endTime,omitempty"`

	// FreeTrialDuration: Output only. Specifies the duration of the free
	// trial of the subscription.
	FreeTrialDuration *GoogleCloudPaymentsResellerSubscriptionV1Duration `json:"freeTrialDuration,omitempty"`

	// Name: Output only. Response only. Resource name of the subscription
	// promotion. It will have the format of
	// "partners/{partner_id}/promotion/{promotion_id}"
	Name string `json:"name,omitempty"`

	// RegionCodes: Output only. 2-letter ISO region code where the
	// promotion is available in. Ex. "US" Please refers to:
	// https://en.wikipedia.org/wiki/ISO_3166-1
	RegionCodes []string `json:"regionCodes,omitempty"`

	// StartTime: Optional. Specifies the start time (inclusive) of the
	// period that the promotion is available in.
	StartTime string `json:"startTime,omitempty"`

	// Titles: Output only. Localized human readable name of the promotion.
	Titles []*GoogleTypeLocalizedText `json:"titles,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApplicableProducts")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApplicableProducts") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1Promotion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1Promotion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1Subscription: A Subscription
// resource managed by 3P Partners.
type GoogleCloudPaymentsResellerSubscriptionV1Subscription struct {
	// CancellationDetails: Output only. Describes the details of a
	// cancelled subscription. Only applicable to subscription of state
	// `STATE_CANCELLED`.
	CancellationDetails *GoogleCloudPaymentsResellerSubscriptionV1SubscriptionCancellationDetails `json:"cancellationDetails,omitempty"`

	// CreateTime: Output only. System generated timestamp when the
	// subscription is created. UTC timezone.
	CreateTime string `json:"createTime,omitempty"`

	// CycleEndTime: Output only. The time at which the subscription is
	// expected to be extended, in ISO 8061 format. UTC timezone. For
	// example: "2019-08-31T17:28:54.564Z"
	CycleEndTime string `json:"cycleEndTime,omitempty"`

	// EndUserEntitled: Output only. Indicates if the subscription is
	// entitled to the end user.
	EndUserEntitled bool `json:"endUserEntitled,omitempty"`

	// FreeTrialEndTime: Output only. End of the free trial period, in ISO
	// 8061 format. For example, "2019-08-31T17:28:54.564Z". It will be set
	// the same as createTime if no free trial promotion is specified.
	FreeTrialEndTime string `json:"freeTrialEndTime,omitempty"`

	// Name: Output only. Response only. Resource name of the subscription.
	// It will have the format of
	// "partners/{partner_id}/subscriptions/{subscription_id}"
	Name string `json:"name,omitempty"`

	// PartnerUserToken: Required. Identifier of the end-user in partner’s
	// system. The value is restricted to 63 ASCII characters at the
	// maximum.
	PartnerUserToken string `json:"partnerUserToken,omitempty"`

	// ProcessingState: Output only. Describes the processing state of the
	// subscription. See more details at the lifecycle of a subscription
	// (/payments/reseller/subscription/reference/index/Receive.Notifications
	// #payments-subscription-lifecycle).
	//
	// Possible values:
	//   "PROCESSING_STATE_UNSPECIFIED" - The processing state is
	// unspecified.
	//   "PROCESSING_STATE_CANCELLING" - The subscription is being
	// cancelled.
	//   "PROCESSING_STATE_RECURRING" - The subscription is recurring.
	ProcessingState string `json:"processingState,omitempty"`

	// Products: Required. Resource name that identifies one or more
	// subscription products. The format will be
	// 'partners/{partner_id}/products/{product_id}'.
	Products []string `json:"products,omitempty"`

	// Promotions: Optional. Resource name that identifies one or more
	// promotions that can be applied on the product. A typical promotion
	// for a subscription is Free trial. The format will be
	// 'partners/{partner_id}/promotions/{promotion_id}'.
	Promotions []string `json:"promotions,omitempty"`

	// RedirectUri: Output only. The place where partners should redirect
	// the end-user to after creation. This field might also be populated
	// when creation failed. However, Partners should always prepare a
	// default URL to redirect the user in case this field is empty.
	RedirectUri string `json:"redirectUri,omitempty"`

	// ServiceLocation: Required. The location that the service is provided
	// as indicated by the partner.
	ServiceLocation *GoogleCloudPaymentsResellerSubscriptionV1Location `json:"serviceLocation,omitempty"`

	// State: Output only. Describes the state of the subscription. See more
	// details at the lifecycle of a subscription
	// (/payments/reseller/subscription/reference/index/Receive.Notifications
	// #payments-subscription-lifecycle).
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state is unspecified.
	//   "STATE_CREATED" - The subscription is created, a state before it is
	// moved to STATE_ACTIVE.
	//   "STATE_ACTIVE" - The subscription is active.
	//   "STATE_CANCELLED" - The subscription is cancelled.
	//   "STATE_IN_GRACE_PERIOD" - The subscription has not been extended by
	// the partner after the end of current cycle.
	//   "STATE_CANCEL_AT_END_OF_CYCLE" - The subscription is waiting to be
	// cancelled by the next recurrence cycle.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. System generated timestamp when the
	// subscription is most recently updated. UTC timezone.
	UpdateTime string `json:"updateTime,omitempty"`

	// UpgradeDowngradeDetails: Optional. Details about the previous
	// subscription that this new subscription upgrades/downgrades from.
	// Only populated if this subscription is an upgrade/downgrade from
	// another subscription.
	UpgradeDowngradeDetails *GoogleCloudPaymentsResellerSubscriptionV1SubscriptionUpgradeDowngradeDetails `json:"upgradeDowngradeDetails,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CancellationDetails")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CancellationDetails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1Subscription) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1Subscription
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1SubscriptionCancellationDetai
// ls: Describes the details of a cancelled or cancelling subscription.
type GoogleCloudPaymentsResellerSubscriptionV1SubscriptionCancellationDetails struct {
	// Reason: The reason of the cancellation.
	//
	// Possible values:
	//   "CANCELLATION_REASON_UNSPECIFIED" - Reason is unspecified.
	//   "CANCELLATION_REASON_FRAUD" - Fraudualant transaction.
	//   "CANCELLATION_REASON_REMORSE" - Buyer's remorse.
	//   "CANCELLATION_REASON_ACCIDENTAL_PURCHASE" - Accidential purchase.
	//   "CANCELLATION_REASON_PAST_DUE" - Payment is past due.
	//   "CANCELLATION_REASON_ACCOUNT_CLOSED" - User account closed.
	//   "CANCELLATION_REASON_UPGRADE_DOWNGRADE" - Used for notification
	// only, do not use in Cancel API. Cancallation due to upgrade or
	// downgrade.
	//   "CANCELLATION_REASON_OTHER" - Other reason.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Reason") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Reason") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1SubscriptionCancellationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1SubscriptionCancellationDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1SubscriptionUpgradeDowngradeD
// etails: Details about the previous subscription that this new
// subscription upgrades/downgrades from.
type GoogleCloudPaymentsResellerSubscriptionV1SubscriptionUpgradeDowngradeDetails struct {
	// BillingCycleSpec: Required. Specifies the billing cycle spec for the
	// new upgraded/downgraded subscription.
	//
	// Possible values:
	//   "BILLING_CYCLE_SPEC_UNSPECIFIED" - Billing cycle spec is not
	// specified.
	//   "BILLING_CYCLE_SPEC_ALIGN_WITH_PREVIOUS_SUBSCRIPTION" - The billing
	// cycle of the new subscription aligns with the previous subscription
	// it upgrades or downgrades from.
	//   "BILLING_CYCLE_SPEC_START_IMMEDIATELY" - The billing cycle of the
	// new subscription starts immediately.
	BillingCycleSpec string `json:"billingCycleSpec,omitempty"`

	// PreviousSubscriptionId: Required. The previous subscription id to be
	// replaced. This is not the full resource name, use the subscription_id
	// segment only.
	PreviousSubscriptionId string `json:"previousSubscriptionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BillingCycleSpec") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BillingCycleSpec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1SubscriptionUpgradeDowngradeDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1SubscriptionUpgradeDowngradeDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionRequest
// : Request to revoke a cancellation request.
type GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionRequest struct {
}

// GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionRespons
// e: Response that contains the updated subscription resource.
type GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionResponse struct {
	// Subscription: The updated subscription resource.
	Subscription *GoogleCloudPaymentsResellerSubscriptionV1Subscription `json:"subscription,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Subscription") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Subscription") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeLocalizedText: Localized variant of a text in a particular
// language.
type GoogleTypeLocalizedText struct {
	// LanguageCode: The text's BCP-47 language code, such as "en-US" or
	// "sr-Latn". For more information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `json:"languageCode,omitempty"`

	// Text: Localized string in the language corresponding to
	// `language_code' below.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeLocalizedText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeLocalizedText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "paymentsresellersubscription.partners.products.list":

type PartnersProductsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Used by partners to list products that can be resold to their
// customers. It should be called directly by the partner using service
// accounts.
//
// - parent: The parent, the partner that can resell. Format:
//   partners/{partner}.
func (r *PartnersProductsService) List(parent string) *PartnersProductsListCall {
	c := &PartnersProductsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of products to return. The service may return fewer than this value.
// If unspecified, at most 50 products will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *PartnersProductsListCall) PageSize(pageSize int64) *PartnersProductsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListProducts` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListProducts` must match the call that provided the page
// token.
func (c *PartnersProductsListCall) PageToken(pageToken string) *PartnersProductsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PartnersProductsListCall) Fields(s ...googleapi.Field) *PartnersProductsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PartnersProductsListCall) IfNoneMatch(entityTag string) *PartnersProductsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PartnersProductsListCall) Context(ctx context.Context) *PartnersProductsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PartnersProductsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PartnersProductsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210728")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/products")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "paymentsresellersubscription.partners.products.list" call.
// Exactly one of
// *GoogleCloudPaymentsResellerSubscriptionV1ListProductsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudPaymentsResellerSubscriptionV1ListProductsResponse.ServerR
// esponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PartnersProductsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPaymentsResellerSubscriptionV1ListProductsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudPaymentsResellerSubscriptionV1ListProductsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Used by partners to list products that can be resold to their customers. It should be called directly by the partner using service accounts.",
	//   "flatPath": "v1/partners/{partnersId}/products",
	//   "httpMethod": "GET",
	//   "id": "paymentsresellersubscription.partners.products.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Optional. The maximum number of products to return. The service may return fewer than this value. If unspecified, at most 50 products will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. A page token, received from a previous `ListProducts` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListProducts` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent, the partner that can resell. Format: partners/{partner}",
	//       "location": "path",
	//       "pattern": "^partners/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/products",
	//   "response": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1ListProductsResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PartnersProductsListCall) Pages(ctx context.Context, f func(*GoogleCloudPaymentsResellerSubscriptionV1ListProductsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "paymentsresellersubscription.partners.promotions.list":

type PartnersPromotionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Used by partners to list promotions, such as free trial, that
// can be applied on subscriptions. It should be called directly by the
// partner using service accounts.
//
// - parent: The parent, the partner that can resell. Format:
//   partners/{partner}.
func (r *PartnersPromotionsService) List(parent string) *PartnersPromotionsListCall {
	c := &PartnersPromotionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Specifies the filters
// for the promotion results. The syntax defined in the EBNF grammar:
// https://google.aip.dev/assets/misc/ebnf-filtering.txt. Examples: -
// applicable_products: "sku1" - region_codes: "US" -
// applicable_products: "sku1" AND region_codes: "US"
func (c *PartnersPromotionsListCall) Filter(filter string) *PartnersPromotionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of promotions to return. The service may return fewer than this
// value. If unspecified, at most 50 products will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *PartnersPromotionsListCall) PageSize(pageSize int64) *PartnersPromotionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListPromotions` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListPromotions` must match the call that provided the
// page token.
func (c *PartnersPromotionsListCall) PageToken(pageToken string) *PartnersPromotionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PartnersPromotionsListCall) Fields(s ...googleapi.Field) *PartnersPromotionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PartnersPromotionsListCall) IfNoneMatch(entityTag string) *PartnersPromotionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PartnersPromotionsListCall) Context(ctx context.Context) *PartnersPromotionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PartnersPromotionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PartnersPromotionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210728")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/promotions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "paymentsresellersubscription.partners.promotions.list" call.
// Exactly one of
// *GoogleCloudPaymentsResellerSubscriptionV1ListPromotionsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudPaymentsResellerSubscriptionV1ListPromotionsResponse.Serve
// rResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PartnersPromotionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPaymentsResellerSubscriptionV1ListPromotionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudPaymentsResellerSubscriptionV1ListPromotionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Used by partners to list promotions, such as free trial, that can be applied on subscriptions. It should be called directly by the partner using service accounts.",
	//   "flatPath": "v1/partners/{partnersId}/promotions",
	//   "httpMethod": "GET",
	//   "id": "paymentsresellersubscription.partners.promotions.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Specifies the filters for the promotion results. The syntax defined in the EBNF grammar: https://google.aip.dev/assets/misc/ebnf-filtering.txt. Examples: - applicable_products: \"sku1\" - region_codes: \"US\" - applicable_products: \"sku1\" AND region_codes: \"US\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of promotions to return. The service may return fewer than this value. If unspecified, at most 50 products will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. A page token, received from a previous `ListPromotions` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListPromotions` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent, the partner that can resell. Format: partners/{partner}",
	//       "location": "path",
	//       "pattern": "^partners/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/promotions",
	//   "response": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1ListPromotionsResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PartnersPromotionsListCall) Pages(ctx context.Context, f func(*GoogleCloudPaymentsResellerSubscriptionV1ListPromotionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "paymentsresellersubscription.partners.subscriptions.cancel":

type PartnersSubscriptionsCancelCall struct {
	s                                                                  *Service
	name                                                               string
	googlecloudpaymentsresellersubscriptionv1cancelsubscriptionrequest *GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionRequest
	urlParams_                                                         gensupport.URLParams
	ctx_                                                               context.Context
	header_                                                            http.Header
}

// Cancel: Used by partners to cancel a subscription service either
// immediately or by the end of the current billing cycle for their
// customers. It should be called directly by the partner using service
// accounts.
//
// - name: The name of the subscription resource to be cancelled. It
//   will have the format of
//   "partners/{partner_id}/subscriptions/{subscription_id}".
func (r *PartnersSubscriptionsService) Cancel(name string, googlecloudpaymentsresellersubscriptionv1cancelsubscriptionrequest *GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionRequest) *PartnersSubscriptionsCancelCall {
	c := &PartnersSubscriptionsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudpaymentsresellersubscriptionv1cancelsubscriptionrequest = googlecloudpaymentsresellersubscriptionv1cancelsubscriptionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PartnersSubscriptionsCancelCall) Fields(s ...googleapi.Field) *PartnersSubscriptionsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PartnersSubscriptionsCancelCall) Context(ctx context.Context) *PartnersSubscriptionsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PartnersSubscriptionsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PartnersSubscriptionsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210728")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudpaymentsresellersubscriptionv1cancelsubscriptionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "paymentsresellersubscription.partners.subscriptions.cancel" call.
// Exactly one of
// *GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionResponse.S
// erverResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PartnersSubscriptionsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Used by partners to cancel a subscription service either immediately or by the end of the current billing cycle for their customers. It should be called directly by the partner using service accounts.",
	//   "flatPath": "v1/partners/{partnersId}/subscriptions/{subscriptionsId}:cancel",
	//   "httpMethod": "POST",
	//   "id": "paymentsresellersubscription.partners.subscriptions.cancel",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the subscription resource to be cancelled. It will have the format of \"partners/{partner_id}/subscriptions/{subscription_id}\"",
	//       "location": "path",
	//       "pattern": "^partners/[^/]+/subscriptions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:cancel",
	//   "request": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1CancelSubscriptionResponse"
	//   }
	// }

}

// method id "paymentsresellersubscription.partners.subscriptions.create":

type PartnersSubscriptionsCreateCall struct {
	s                                                     *Service
	parentid                                              string
	googlecloudpaymentsresellersubscriptionv1subscription *GoogleCloudPaymentsResellerSubscriptionV1Subscription
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// Create: Used by partners to create a subscription for their
// customers. The created subscription is associated with the end user
// inferred from the end user credentials. This API must be authorized
// by the end user using OAuth.
//
// - parent: The parent resource name, which is the identifier of the
//   partner. It will have the format of "partners/{partner_id}".
func (r *PartnersSubscriptionsService) Create(parentid string, googlecloudpaymentsresellersubscriptionv1subscription *GoogleCloudPaymentsResellerSubscriptionV1Subscription) *PartnersSubscriptionsCreateCall {
	c := &PartnersSubscriptionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googlecloudpaymentsresellersubscriptionv1subscription = googlecloudpaymentsresellersubscriptionv1subscription
	return c
}

// SubscriptionId sets the optional parameter "subscriptionId":
// Required. Identifies the subscription resource on the Partner side.
// The value is restricted to 63 ASCII characters at the maximum. If a
// subscription was previously created with the same subscription_id, we
// will directly return that one.
func (c *PartnersSubscriptionsCreateCall) SubscriptionId(subscriptionId string) *PartnersSubscriptionsCreateCall {
	c.urlParams_.Set("subscriptionId", subscriptionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PartnersSubscriptionsCreateCall) Fields(s ...googleapi.Field) *PartnersSubscriptionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PartnersSubscriptionsCreateCall) Context(ctx context.Context) *PartnersSubscriptionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PartnersSubscriptionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PartnersSubscriptionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210728")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudpaymentsresellersubscriptionv1subscription)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/subscriptions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "paymentsresellersubscription.partners.subscriptions.create" call.
// Exactly one of *GoogleCloudPaymentsResellerSubscriptionV1Subscription
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudPaymentsResellerSubscriptionV1Subscription.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PartnersSubscriptionsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPaymentsResellerSubscriptionV1Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudPaymentsResellerSubscriptionV1Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Used by partners to create a subscription for their customers. The created subscription is associated with the end user inferred from the end user credentials. This API must be authorized by the end user using OAuth.",
	//   "flatPath": "v1/partners/{partnersId}/subscriptions",
	//   "httpMethod": "POST",
	//   "id": "paymentsresellersubscription.partners.subscriptions.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource name, which is the identifier of the partner. It will have the format of \"partners/{partner_id}\".",
	//       "location": "path",
	//       "pattern": "^partners/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "subscriptionId": {
	//       "description": "Required. Identifies the subscription resource on the Partner side. The value is restricted to 63 ASCII characters at the maximum. If a subscription was previously created with the same subscription_id, we will directly return that one.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/subscriptions",
	//   "request": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1Subscription"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1Subscription"
	//   }
	// }

}

// method id "paymentsresellersubscription.partners.subscriptions.entitle":

type PartnersSubscriptionsEntitleCall struct {
	s                                                                   *Service
	name                                                                string
	googlecloudpaymentsresellersubscriptionv1entitlesubscriptionrequest *GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionRequest
	urlParams_                                                          gensupport.URLParams
	ctx_                                                                context.Context
	header_                                                             http.Header
}

// Entitle: Used by partners to entitle a previously provisioned
// subscription to the current end user. The end user identity is
// inferred from the authorized credential of the request. This API must
// be authorized by the end user using OAuth.
//
// - name: The name of the subscription resource that is entitled to the
//   current end user. It will have the format of
//   "partners/{partner_id}/subscriptions/{subscription_id}".
func (r *PartnersSubscriptionsService) Entitle(name string, googlecloudpaymentsresellersubscriptionv1entitlesubscriptionrequest *GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionRequest) *PartnersSubscriptionsEntitleCall {
	c := &PartnersSubscriptionsEntitleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudpaymentsresellersubscriptionv1entitlesubscriptionrequest = googlecloudpaymentsresellersubscriptionv1entitlesubscriptionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PartnersSubscriptionsEntitleCall) Fields(s ...googleapi.Field) *PartnersSubscriptionsEntitleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PartnersSubscriptionsEntitleCall) Context(ctx context.Context) *PartnersSubscriptionsEntitleCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PartnersSubscriptionsEntitleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PartnersSubscriptionsEntitleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210728")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudpaymentsresellersubscriptionv1entitlesubscriptionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:entitle")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "paymentsresellersubscription.partners.subscriptions.entitle" call.
// Exactly one of
// *GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionResponse.
// ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PartnersSubscriptionsEntitleCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Used by partners to entitle a previously provisioned subscription to the current end user. The end user identity is inferred from the authorized credential of the request. This API must be authorized by the end user using OAuth.",
	//   "flatPath": "v1/partners/{partnersId}/subscriptions/{subscriptionsId}:entitle",
	//   "httpMethod": "POST",
	//   "id": "paymentsresellersubscription.partners.subscriptions.entitle",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the subscription resource that is entitled to the current end user. It will have the format of \"partners/{partner_id}/subscriptions/{subscription_id}\"",
	//       "location": "path",
	//       "pattern": "^partners/[^/]+/subscriptions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:entitle",
	//   "request": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1EntitleSubscriptionResponse"
	//   }
	// }

}

// method id "paymentsresellersubscription.partners.subscriptions.extend":

type PartnersSubscriptionsExtendCall struct {
	s                                                                  *Service
	name                                                               string
	googlecloudpaymentsresellersubscriptionv1extendsubscriptionrequest *GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionRequest
	urlParams_                                                         gensupport.URLParams
	ctx_                                                               context.Context
	header_                                                            http.Header
}

// Extend: Used by partners to extend a subscription service for their
// customers. It should be called directly by the partner using service
// accounts.
//
// - name: The name of the subscription resource to be extended. It will
//   have the format of
//   "partners/{partner_id}/subscriptions/{subscription_id}".
func (r *PartnersSubscriptionsService) Extend(name string, googlecloudpaymentsresellersubscriptionv1extendsubscriptionrequest *GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionRequest) *PartnersSubscriptionsExtendCall {
	c := &PartnersSubscriptionsExtendCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudpaymentsresellersubscriptionv1extendsubscriptionrequest = googlecloudpaymentsresellersubscriptionv1extendsubscriptionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PartnersSubscriptionsExtendCall) Fields(s ...googleapi.Field) *PartnersSubscriptionsExtendCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PartnersSubscriptionsExtendCall) Context(ctx context.Context) *PartnersSubscriptionsExtendCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PartnersSubscriptionsExtendCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PartnersSubscriptionsExtendCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210728")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudpaymentsresellersubscriptionv1extendsubscriptionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:extend")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "paymentsresellersubscription.partners.subscriptions.extend" call.
// Exactly one of
// *GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionResponse.S
// erverResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PartnersSubscriptionsExtendCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Used by partners to extend a subscription service for their customers. It should be called directly by the partner using service accounts.",
	//   "flatPath": "v1/partners/{partnersId}/subscriptions/{subscriptionsId}:extend",
	//   "httpMethod": "POST",
	//   "id": "paymentsresellersubscription.partners.subscriptions.extend",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the subscription resource to be extended. It will have the format of \"partners/{partner_id}/subscriptions/{subscription_id}\".",
	//       "location": "path",
	//       "pattern": "^partners/[^/]+/subscriptions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:extend",
	//   "request": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1ExtendSubscriptionResponse"
	//   }
	// }

}

// method id "paymentsresellersubscription.partners.subscriptions.get":

type PartnersSubscriptionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Used by partners to get a subscription by id. It should be
// called directly by the partner using service accounts.
//
// - name: The name of the subscription resource to retrieve. It will
//   have the format of
//   "partners/{partner_id}/subscriptions/{subscription_id}".
func (r *PartnersSubscriptionsService) Get(name string) *PartnersSubscriptionsGetCall {
	c := &PartnersSubscriptionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PartnersSubscriptionsGetCall) Fields(s ...googleapi.Field) *PartnersSubscriptionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PartnersSubscriptionsGetCall) IfNoneMatch(entityTag string) *PartnersSubscriptionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PartnersSubscriptionsGetCall) Context(ctx context.Context) *PartnersSubscriptionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PartnersSubscriptionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PartnersSubscriptionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210728")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "paymentsresellersubscription.partners.subscriptions.get" call.
// Exactly one of *GoogleCloudPaymentsResellerSubscriptionV1Subscription
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudPaymentsResellerSubscriptionV1Subscription.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PartnersSubscriptionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPaymentsResellerSubscriptionV1Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudPaymentsResellerSubscriptionV1Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Used by partners to get a subscription by id. It should be called directly by the partner using service accounts.",
	//   "flatPath": "v1/partners/{partnersId}/subscriptions/{subscriptionsId}",
	//   "httpMethod": "GET",
	//   "id": "paymentsresellersubscription.partners.subscriptions.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the subscription resource to retrieve. It will have the format of \"partners/{partner_id}/subscriptions/{subscription_id}\"",
	//       "location": "path",
	//       "pattern": "^partners/[^/]+/subscriptions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1Subscription"
	//   }
	// }

}

// method id "paymentsresellersubscription.partners.subscriptions.provision":

type PartnersSubscriptionsProvisionCall struct {
	s                                                     *Service
	parentid                                              string
	googlecloudpaymentsresellersubscriptionv1subscription *GoogleCloudPaymentsResellerSubscriptionV1Subscription
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// Provision: Used by partners to provision a subscription for their
// customers. This creates a subscription without associating it with
// the end user account. EntitleSubscription must be called separately
// using OAuth in order for the end user account to be associated with
// the subscription. It should be called directly by the partner using
// service accounts.
//
// - parent: The parent resource name, which is the identifier of the
//   partner. It will have the format of "partners/{partner_id}".
func (r *PartnersSubscriptionsService) Provision(parentid string, googlecloudpaymentsresellersubscriptionv1subscription *GoogleCloudPaymentsResellerSubscriptionV1Subscription) *PartnersSubscriptionsProvisionCall {
	c := &PartnersSubscriptionsProvisionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googlecloudpaymentsresellersubscriptionv1subscription = googlecloudpaymentsresellersubscriptionv1subscription
	return c
}

// SubscriptionId sets the optional parameter "subscriptionId":
// Required. Identifies the subscription resource on the Partner side.
// The value is restricted to 63 ASCII characters at the maximum. If a
// subscription was previously created with the same subscription_id, we
// will directly return that one.
func (c *PartnersSubscriptionsProvisionCall) SubscriptionId(subscriptionId string) *PartnersSubscriptionsProvisionCall {
	c.urlParams_.Set("subscriptionId", subscriptionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PartnersSubscriptionsProvisionCall) Fields(s ...googleapi.Field) *PartnersSubscriptionsProvisionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PartnersSubscriptionsProvisionCall) Context(ctx context.Context) *PartnersSubscriptionsProvisionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PartnersSubscriptionsProvisionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PartnersSubscriptionsProvisionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210728")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudpaymentsresellersubscriptionv1subscription)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/subscriptions:provision")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "paymentsresellersubscription.partners.subscriptions.provision" call.
// Exactly one of *GoogleCloudPaymentsResellerSubscriptionV1Subscription
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudPaymentsResellerSubscriptionV1Subscription.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PartnersSubscriptionsProvisionCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPaymentsResellerSubscriptionV1Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudPaymentsResellerSubscriptionV1Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Used by partners to provision a subscription for their customers. This creates a subscription without associating it with the end user account. EntitleSubscription must be called separately using OAuth in order for the end user account to be associated with the subscription. It should be called directly by the partner using service accounts.",
	//   "flatPath": "v1/partners/{partnersId}/subscriptions:provision",
	//   "httpMethod": "POST",
	//   "id": "paymentsresellersubscription.partners.subscriptions.provision",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource name, which is the identifier of the partner. It will have the format of \"partners/{partner_id}\".",
	//       "location": "path",
	//       "pattern": "^partners/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "subscriptionId": {
	//       "description": "Required. Identifies the subscription resource on the Partner side. The value is restricted to 63 ASCII characters at the maximum. If a subscription was previously created with the same subscription_id, we will directly return that one.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/subscriptions:provision",
	//   "request": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1Subscription"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1Subscription"
	//   }
	// }

}

// method id "paymentsresellersubscription.partners.subscriptions.undoCancel":

type PartnersSubscriptionsUndoCancelCall struct {
	s                                                                      *Service
	name                                                                   string
	googlecloudpaymentsresellersubscriptionv1undocancelsubscriptionrequest *GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionRequest
	urlParams_                                                             gensupport.URLParams
	ctx_                                                                   context.Context
	header_                                                                http.Header
}

// UndoCancel: Used by partners to revoke the pending cancellation of a
// subscription, which is currently in `STATE_CANCEL_AT_END_OF_CYCLE`
// state. If the subscription is already cancelled, the request will
// fail. It should be called directly by the partner using service
// accounts.
//
// - name: The name of the subscription resource whose pending
//   cancellation needs to be undone. It will have the format of
//   "partners/{partner_id}/subscriptions/{subscription_id}".
func (r *PartnersSubscriptionsService) UndoCancel(name string, googlecloudpaymentsresellersubscriptionv1undocancelsubscriptionrequest *GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionRequest) *PartnersSubscriptionsUndoCancelCall {
	c := &PartnersSubscriptionsUndoCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudpaymentsresellersubscriptionv1undocancelsubscriptionrequest = googlecloudpaymentsresellersubscriptionv1undocancelsubscriptionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PartnersSubscriptionsUndoCancelCall) Fields(s ...googleapi.Field) *PartnersSubscriptionsUndoCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PartnersSubscriptionsUndoCancelCall) Context(ctx context.Context) *PartnersSubscriptionsUndoCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PartnersSubscriptionsUndoCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PartnersSubscriptionsUndoCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210728")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudpaymentsresellersubscriptionv1undocancelsubscriptionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:undoCancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "paymentsresellersubscription.partners.subscriptions.undoCancel" call.
// Exactly one of
// *GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionRespon
// se or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionRespon
// se.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PartnersSubscriptionsUndoCancelCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Used by partners to revoke the pending cancellation of a subscription, which is currently in `STATE_CANCEL_AT_END_OF_CYCLE` state. If the subscription is already cancelled, the request will fail. It should be called directly by the partner using service accounts.",
	//   "flatPath": "v1/partners/{partnersId}/subscriptions/{subscriptionsId}:undoCancel",
	//   "httpMethod": "POST",
	//   "id": "paymentsresellersubscription.partners.subscriptions.undoCancel",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the subscription resource whose pending cancellation needs to be undone. It will have the format of \"partners/{partner_id}/subscriptions/{subscription_id}\"",
	//       "location": "path",
	//       "pattern": "^partners/[^/]+/subscriptions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:undoCancel",
	//   "request": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudPaymentsResellerSubscriptionV1UndoCancelSubscriptionResponse"
	//   }
	// }

}
