/**
 * Copyright 2015-2016 Red Hat, Inc, and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wildfly.swarm.teiid.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

import org.wildfly.swarm.config.infinispan.cache_container.EvictionComponent;
import org.wildfly.swarm.config.infinispan.cache_container.LockingComponent;
import org.wildfly.swarm.config.infinispan.cache_container.TransactionComponent;
import org.wildfly.swarm.infinispan.InfinispanFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;
import org.wildfly.swarm.teiid.TeiidFraction;

/**
 * Teiid query engine depend on 3 local cache be installed
 *   resultset-repl
 *   resultset
 *   preparedplan
 * @author kylin
 *
 */
@Pre
@ApplicationScoped
public class CacheCustomizer implements Customizer {

    @Inject
    private Instance<InfinispanFraction> infinispan;

    @Inject
    TeiidFraction fraction;

    @Override
    public void customize() throws Exception {

        this.infinispan.get().cacheContainer("teiid-cache",
                cc -> cc.defaultCache("resultset")
                .localCache("resultset-repl",
                        c -> c.lockingComponent(l -> l.isolation(LockingComponent.Isolation.READ_COMMITTED))
                        .transactionComponent(t -> t.mode(TransactionComponent.Mode.NON_XA))
                        .evictionComponent(e -> e.strategy(EvictionComponent.Strategy.LIRS).maxEntries(1024L))
                        .expirationComponent(e -> e.maxIdle(7200000L)))
                .localCache("resultset",
                        c -> c.lockingComponent(l -> l.isolation(LockingComponent.Isolation.READ_COMMITTED))
                        .transactionComponent(t -> t.mode(TransactionComponent.Mode.NON_XA))
                        .evictionComponent(e -> e.strategy(EvictionComponent.Strategy.LIRS).maxEntries(1024L))
                        .expirationComponent(e -> e.maxIdle(7200000L)))
                .localCache("preparedplan",
                        c -> c.lockingComponent(l -> l.isolation(LockingComponent.Isolation.READ_COMMITTED))
                        .evictionComponent(e -> e.strategy(EvictionComponent.Strategy.LIRS).maxEntries(512L))
                        .expirationComponent(e -> e.maxIdle(28800L))
                        ));

        if (this.fraction.preparedplanCacheInfinispanContainer() == null) {
            this.fraction.preparedplanCacheInfinispanContainer("teiid-cache");
        }
        if (this.fraction.preparedplanCacheName() == null) {
            this.fraction.preparedplanCacheName("preparedplan");
        }
        if (this.fraction.resultsetCacheInfinispanContainer() == null) {
            this.fraction.resultsetCacheInfinispanContainer("teiid-cache");
        }
        if (this.fraction.resultsetCacheName() == null) {
            this.fraction.resultsetCacheName("resultset");
        }
    }

}
