/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.expr.compare;

import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.NodeSetExpression;
import jd.xml.xpath.expr.compare.EqualsBooleans;
import jd.xml.xpath.expr.compare.EqualsNumbers;
import jd.xml.xpath.expr.compare.EqualsObjectNumber;
import jd.xml.xpath.expr.compare.EqualsObjectString;
import jd.xml.xpath.expr.compare.EqualsObjects;
import jd.xml.xpath.expr.compare.EqualsSetSimple;
import jd.xml.xpath.expr.compare.EqualsStrings;
import jd.xml.xpath.expr.compare.RelateNumbers;
import jd.xml.xpath.expr.compare.RelateObjectNumber;
import jd.xml.xpath.expr.compare.RelateObjects;
import jd.xml.xpath.expr.function.BooleanFunction;
import jd.xml.xpath.expr.function.Count;
import jd.xml.xpath.expr.function.Function;
import jd.xml.xpath.expr.function.Not;
import jd.xml.xpath.expr.function.ToBoolean;
import jd.xml.xpath.object.Equality;
import jd.xml.xpath.object.Relation;

public abstract class CompareFactory {
    public static Expression createRelate(Expression expression, Relation relation, Expression expression2) {
        if (Count.TYPE.isFunctionInstance(expression) && expression2.getResultType() <= 2 && expression2.getContextDependencies() == 0 && expression2.toNumberValue(null) == 0.0 && relation == Relation.GREATER) {
            return CompareFactory.createIsEmptyExpr(expression, false);
        }
        int n = expression.getResultType();
        int n2 = expression2.getResultType();
        if (n2 <= 2) {
            if (n <= 2 || n == 3 && CompareFactory.compareSetAsSimple(expression, expression2)) {
                return new RelateNumbers(expression, relation, expression2);
            }
            return new RelateObjectNumber(expression, relation, expression2);
        }
        if (n <= 2) {
            return CompareFactory.createRelate(expression2, relation.getReverse(), expression);
        }
        return new RelateObjects(expression, relation, expression2);
    }

    public static Expression createEquals(Expression expression, Equality equality, Expression expression2) {
        if (Count.TYPE.isFunctionInstance(expression) && expression2.getResultType() == 1 && expression2.getContextDependencies() == 0 && expression2.toNumberValue(null) == 0.0) {
            return CompareFactory.createIsEmptyExpr(expression, equality == Equality.EQUAL);
        }
        int n = expression.getResultType();
        int n2 = expression2.getResultType();
        switch (n) {
            case 0: {
                return new EqualsBooleans(expression, equality, expression2);
            }
            case 1: {
                if (n2 != 1 && n2 != 2) break;
                return new EqualsNumbers(expression, equality, expression2);
            }
            case 2: {
                if (n2 != 2) break;
                return new EqualsStrings(expression, equality, expression2);
            }
            case 3: {
                if (n2 == 1 || n2 == 2) {
                    if (!CompareFactory.compareSetAsSimple(expression, expression2)) {
                        return new EqualsSetSimple(expression, equality, expression2);
                    }
                    if (n2 == 1) {
                        return new EqualsNumbers(expression2, equality, expression);
                    }
                    return new EqualsStrings(expression2, equality, expression);
                }
                if (n2 != 3) break;
                return new EqualsObjects(expression, equality, expression2);
            }
            default: {
                if (n2 >= 3) {
                    return new EqualsObjects(expression, equality, expression2);
                }
                if (n2 == 1) {
                    return new EqualsObjectNumber(expression, equality, expression2);
                }
                if (n2 != 2) break;
                return new EqualsObjectString(expression, equality, expression2);
            }
        }
        return CompareFactory.createEquals(expression2, equality, expression);
    }

    private static boolean compareSetAsSimple(Expression expression, Expression expression2) {
        NodeSetExpression nodeSetExpression;
        boolean bl = false;
        if (expression instanceof NodeSetExpression && (nodeSetExpression = (NodeSetExpression)expression).getMaxResultSize() == 1) {
            if (nodeSetExpression.getMinResultSize() == 1) {
                bl = true;
            } else if (expression2.getResultType() == 2 && expression2.getContextDependencies() == 0 && expression2.toStringValue(null).length() > 0) {
                bl = true;
            }
        }
        return bl;
    }

    private static Expression createIsEmptyExpr(Expression expression, boolean bl) {
        Expression expression2 = ((Function)expression).getArgument(0);
        BooleanFunction booleanFunction = bl ? new Not() : new ToBoolean();
        booleanFunction.setArguments(new Expression[]{expression2});
        return booleanFunction;
    }
}

