/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.Serializable;
import java.util.Arrays;
import net.sourceforge.cobertura.coveragedata.BranchCoverageData;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;

public class SwitchData
implements BranchCoverageData,
Comparable,
Serializable,
HasBeenInstrumented {
    private static final long serialVersionUID = 9L;
    private int switchNumber;
    private long defaultHits;
    private long[] hits;
    private int[] keys;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$SwitchData;

    public SwitchData(int switchNumber, int[] keys) {
        this.switchNumber = switchNumber;
        this.defaultHits = 0L;
        this.hits = new long[keys.length];
        Arrays.fill(this.hits, 0L);
        this.keys = new int[keys.length];
        System.arraycopy(keys, 0, this.keys, 0, keys.length);
    }

    public SwitchData(int switchNumber, int min, int max) {
        this.switchNumber = switchNumber;
        this.defaultHits = 0L;
        this.hits = new long[max - min + 1];
        Arrays.fill(this.hits, 0L);
        this.keys = new int[max - min + 1];
        int i = 0;
        while (min <= max) {
            this.keys[i++] = min++;
        }
    }

    public SwitchData(int switchNumber) {
        this(switchNumber, new int[0]);
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(class$net$sourceforge$cobertura$coveragedata$SwitchData == null ? (class$net$sourceforge$cobertura$coveragedata$SwitchData = SwitchData.class$("net.sourceforge.cobertura.coveragedata.SwitchData")) : class$net$sourceforge$cobertura$coveragedata$SwitchData)) {
            return Integer.MAX_VALUE;
        }
        return this.switchNumber - ((SwitchData)o).switchNumber;
    }

    void touchBranch(int branch) {
        if (branch == -1) {
            ++this.defaultHits;
        } else {
            if (this.hits.length <= branch) {
                long[] old = this.hits;
                this.hits = new long[branch + 1];
                System.arraycopy(old, 0, this.hits, 0, old.length);
                Arrays.fill(this.hits, old.length, this.hits.length - 1, 0L);
            }
            int n = branch;
            this.hits[n] = this.hits[n] + 1L;
        }
    }

    public int getSwitchNumber() {
        return this.switchNumber;
    }

    public long getHits(int branch) {
        if (this.hits.length > branch) {
            return this.hits[branch];
        }
        return -1L;
    }

    public long getDefaultHits() {
        return this.defaultHits;
    }

    public double getBranchCoverageRate() {
        int branches = this.hits.length + 1;
        int hit = this.defaultHits > 0L ? 1 : 0;
        int i = this.hits.length - 1;
        while (i >= 0) {
            hit += this.hits[i--] > 0L ? 1 : 0;
        }
        return (double)hit / (double)branches;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SwitchData switchData = (SwitchData)obj;
        return this.defaultHits == switchData.defaultHits && Arrays.equals(this.hits, switchData.hits) && this.switchNumber == switchData.switchNumber;
    }

    public int hashCode() {
        return this.switchNumber;
    }

    public int getNumberOfCoveredBranches() {
        int ret = this.defaultHits > 0L ? 1 : 0;
        int i = this.hits.length - 1;
        while (i >= 0) {
            if (this.hits[i] > 0L) {
                ++ret;
            }
            --i;
        }
        return ret;
    }

    public int getNumberOfValidBranches() {
        return this.hits.length + 1;
    }

    public void merge(BranchCoverageData coverageData) {
        SwitchData switchData = (SwitchData)coverageData;
        this.defaultHits += switchData.defaultHits;
        int i = Math.min(this.hits.length, switchData.hits.length) - 1;
        while (i >= 0) {
            int n = i;
            this.hits[n] = this.hits[n] + switchData.hits[i];
            --i;
        }
        if (switchData.hits.length > this.hits.length) {
            long[] old = this.hits;
            this.hits = new long[switchData.hits.length];
            System.arraycopy(old, 0, this.hits, 0, old.length);
            System.arraycopy(switchData.hits, old.length, this.hits, old.length, this.hits.length - old.length);
        }
        if (this.keys.length == 0 && switchData.keys.length > 0) {
            this.keys = switchData.keys;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

