/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect.instruction;

import alt.jiapi.file.ConstantPool;
import alt.jiapi.reflect.instruction.CPInstruction;
import alt.jiapi.reflect.instruction.Opcodes;

public class ReferencingInstruction
extends CPInstruction {
    public ReferencingInstruction(byte[] bytes, ConstantPool cp) {
        super(bytes, cp);
    }

    public String getReferencedTypeName() {
        return this.getClassName();
    }

    public String getClassName() {
        return this.getInternalName().replace('/', '.');
    }

    public String getInternalName() {
        ConstantPool.Entry entry = this.cp.get(this.getIndex());
        if (entry instanceof ConstantPool.MethodRefInfo) {
            ConstantPool.MethodRefInfo mri = (ConstantPool.MethodRefInfo)entry;
            return mri.getClassInfo().getName();
        }
        if (entry instanceof ConstantPool.FieldRefInfo) {
            ConstantPool.FieldRefInfo fri = (ConstantPool.FieldRefInfo)entry;
            return fri.getClassInfo().getName();
        }
        if (entry instanceof ConstantPool.InterfaceMethodRefInfo) {
            ConstantPool.InterfaceMethodRefInfo fri = (ConstantPool.InterfaceMethodRefInfo)entry;
            return fri.getClassInfo().getName();
        }
        System.out.println("Don't know what to do with " + entry);
        return null;
    }

    public String getName() {
        ConstantPool.Entry entry = this.cp.get(this.getIndex());
        ConstantPool.NameAndTypeInfo nti = null;
        if (entry instanceof ConstantPool.MethodRefInfo) {
            ConstantPool.MethodRefInfo mri = (ConstantPool.MethodRefInfo)entry;
            nti = mri.getNameAndTypeInfo();
        } else if (entry instanceof ConstantPool.FieldRefInfo) {
            ConstantPool.FieldRefInfo fri = (ConstantPool.FieldRefInfo)entry;
            nti = fri.getNameAndTypeInfo();
        } else if (entry instanceof ConstantPool.InterfaceMethodRefInfo) {
            ConstantPool.InterfaceMethodRefInfo fri = (ConstantPool.InterfaceMethodRefInfo)entry;
            nti = fri.getNameAndTypeInfo();
        } else {
            System.out.println("Don't know what to do with " + entry);
        }
        return nti.getName();
    }

    public String getDescriptor() {
        ConstantPool.Entry entry = this.cp.get(this.getIndex());
        ConstantPool.NameAndTypeInfo nti = null;
        if (entry instanceof ConstantPool.MethodRefInfo) {
            ConstantPool.MethodRefInfo mri = (ConstantPool.MethodRefInfo)entry;
            nti = mri.getNameAndTypeInfo();
        } else if (entry instanceof ConstantPool.FieldRefInfo) {
            ConstantPool.FieldRefInfo fri = (ConstantPool.FieldRefInfo)entry;
            nti = fri.getNameAndTypeInfo();
        } else if (entry instanceof ConstantPool.InterfaceMethodRefInfo) {
            ConstantPool.InterfaceMethodRefInfo fri = (ConstantPool.InterfaceMethodRefInfo)entry;
            nti = fri.getNameAndTypeInfo();
        } else {
            System.out.println(this.cp);
            System.out.println("Failed to get (interface)Method/Field ref-info from index " + this.getIndex() + ": " + entry);
            System.out.println("Instruction: " + Opcodes.opcodeStrings[this.getOpcode() & 0xFF]);
        }
        return nti.getDescriptor();
    }
}

