/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.instrumentor.AbstractStrategy;
import alt.jiapi.instrumentor.HotSpot;
import alt.jiapi.instrumentor.Instrumentation;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.instruction.Invocation;
import alt.jiapi.reflect.instruction.OpcodeGroups;
import java.util.ArrayList;
import java.util.List;

public class MethodCallStrategy
extends AbstractStrategy {
    public MethodCallStrategy() {
        this("*");
    }

    public MethodCallStrategy(String matcher) {
        super(matcher);
    }

    public MethodCallStrategy(String[] matchers, boolean reverse) {
        super(matchers, reverse);
    }

    public List findHotSpots(InstructionList il) {
        ArrayList<HotSpot> hotSpots = new ArrayList<HotSpot>();
        int index = 0;
        while ((index = il.indexOf(OpcodeGroups.INVOKE_INSTRUCTIONS, index)) != -1) {
            Invocation ins = (Invocation)il.get(index);
            String targetName = ins.getClassName() + "." + ins.getMethodName();
            if (this.match(targetName)) {
                Instrumentation i = this.getInstrumentation();
                i.setTargetName(targetName);
                HotSpot h = new HotSpot(index, index + 1);
                hotSpots.add(h);
            }
            ++index;
        }
        return hotSpots;
    }
}

