/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.tree.AttributeCollection;

public class XSLOutputCharacter
extends StyleElement {
    private int codepoint = -1;
    private String replacementString = null;

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "character") {
                String string2 = attributeCollection.getValue(n);
                switch (string2.length()) {
                    case 0: {
                        this.compileError("character attribute must not be zero-length");
                        this.codepoint = 256;
                        break;
                    }
                    case 1: {
                        this.codepoint = string2.charAt(0);
                        break;
                    }
                    case 2: {
                        if (XMLChar.isHighSurrogate(string2.charAt(0)) && XMLChar.isLowSurrogate(string2.charAt(1))) {
                            this.codepoint = XMLChar.supplemental(string2.charAt(0), string2.charAt(1));
                            break;
                        }
                        this.compileError("character attribute must be a single XML character");
                        this.codepoint = 256;
                        break;
                    }
                    default: {
                        this.compileError("character attribute must be a single XML character");
                        this.codepoint = 256;
                        break;
                    }
                }
            } else if (string == "string") {
                this.replacementString = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.codepoint == -1) {
            this.reportAbsence("character");
            return;
        }
        if (this.replacementString == null) {
            this.reportAbsence("string");
            return;
        }
    }

    public void validate() throws TransformerConfigurationException {
        if (!(this.getParent() instanceof XSLCharacterMap)) {
            this.compileError("xsl:output-character may appear only as a child of xsl:character-map");
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        return null;
    }

    public int getCodePoint() {
        return this.codepoint;
    }

    public String getReplacementString() {
        return this.replacementString;
    }
}

