/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Loader;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;

public class SaxonCollation
extends StyleElement {
    private String collationName;
    private Comparator collator;
    private boolean isDefault = false;

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string8 = this.getNamePool().getClarkName(n2);
            if (string8 == "name") {
                string = attributeCollection.getValue(n).trim();
            } else if (string8 == "class") {
                string2 = attributeCollection.getValue(n).trim();
            } else if (string8 == "strength") {
                string3 = attributeCollection.getValue(n).trim();
            } else if (string8 == "decomposition") {
                string4 = attributeCollection.getValue(n).trim();
            } else if (string8 == "lang") {
                string5 = attributeCollection.getValue(n).trim();
            } else if (string8 == "rules") {
                string6 = attributeCollection.getValue(n).trim();
            } else if (string8 == "default") {
                string7 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            this.collationName = string.trim();
        }
        if (string2 != null) {
            if (string6 != null || string5 != null || string3 != null || string4 != null) {
                this.compileError("The class attribute cannot be combined with rules, lang, strength, or decomposition");
            }
            try {
                this.collator = SaxonCollation.makeCollator(string2);
                return;
            }
            catch (TransformerException transformerException) {
                this.collator = Collator.getInstance();
                throw new TransformerConfigurationException(transformerException);
            }
        }
        if (string6 != null) {
            if (string5 != null || string3 != null || string4 != null) {
                this.compileError("The rules attribute cannot be combined with lang, strength, or decomposition");
            }
            try {
                this.collator = new RuleBasedCollator(string6);
            }
            catch (ParseException parseException) {
                this.collator = Collator.getInstance();
                this.compileError("Invalid collation rules: " + parseException.getMessage());
            }
        }
        if (string5 != null) {
            this.collator = Collator.getInstance(Configuration.getLocale(string5));
        } else if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        if (string3 != null && this.collator instanceof Collator) {
            if (string3.equals("primary")) {
                ((Collator)this.collator).setStrength(0);
            } else if (string3.equals("secondary")) {
                ((Collator)this.collator).setStrength(1);
            } else if (string3.equals("tertiary")) {
                ((Collator)this.collator).setStrength(2);
            } else if (string3.equals("identical")) {
                ((Collator)this.collator).setStrength(3);
            } else {
                this.compileError("strength must be primary, secondary, tertiary, or identical");
            }
        }
        if (string4 != null && this.collator instanceof Collator) {
            if (string4.equals("none")) {
                ((Collator)this.collator).setDecomposition(0);
            } else if (string4.equals("standard")) {
                ((Collator)this.collator).setDecomposition(1);
            } else if (string4.equals("full")) {
                ((Collator)this.collator).setDecomposition(2);
            } else {
                this.compileError("decomposition must be none, standard, or full");
            }
        }
        if (string7 != null) {
            if (string7.equals("yes")) {
                this.isDefault = true;
            } else if (!string7.equals("no")) {
                this.compileError("default attribute must be yes or no");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        this.checkEmpty();
    }

    public Instruction compile() throws TransformerConfigurationException {
        this.getPrincipalStyleSheet().setCollation(this.collationName, this.collator, this.isDefault);
        return null;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public boolean isDefaultCollation() {
        return this.isDefault;
    }

    public Comparator getCollator() {
        return this.collator;
    }

    public static Comparator makeCollator(String string) throws TransformerException {
        Object object = Loader.getInstance(string);
        if (object instanceof Comparator) {
            return (Comparator)object;
        }
        throw new TransformerException("Failed to load collation class " + string + ": it is not an instance of java.util.Comparator");
    }

    public static void main(String[] stringArray) {
        System.err.println("The following locales have collations available:");
        Locale[] localeArray = Collator.getAvailableLocales();
        int n = 0;
        while (n < localeArray.length) {
            Locale locale = localeArray[n];
            System.err.println("Locale:" + ("".equals(locale.getCountry()) ? "" : " country='" + locale.getCountry() + "' (" + locale.getDisplayCountry() + ")") + ("".equals(locale.getLanguage()) ? "" : " language='" + locale.getLanguage() + "' (" + locale.getDisplayLanguage() + ")") + ("".equals(locale.getVariant()) ? "" : " variant='" + locale.getVariant() + "' (" + locale.getDisplayVariant() + ")"));
            ++n;
        }
    }
}

