/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Key
extends SystemFunction
implements MappingFunction,
XSLTFunction {
    private NamespaceResolver nsContext = null;
    private int keyFingerprint = -1;

    public Expression simplify() throws XPathException {
        Key key = (Key)super.simplify();
        key.addContextDocumentArgument(2, "key+");
        return key;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        this.argument[1] = ExpressionTool.unsorted(this.argument[1], false);
        if (this.argument[0] instanceof StringValue) {
            this.keyFingerprint = ((ExpressionContext)staticContext).getFingerprint(((StringValue)this.argument[0]).getStringValue(), false);
            if (this.keyFingerprint == -1) {
                this.dynamicError("Key " + ((StringValue)this.argument[0]).getStringValue() + " is not defined");
            }
        } else {
            this.nsContext = ((ExpressionContext)staticContext).getNamespaceContext();
        }
    }

    public int computeSpecialProperties() {
        return 196608;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Object object;
        Controller controller = xPathContext.getController();
        Item item = this.argument[2].evaluateItem(xPathContext);
        if (!(item instanceof DocumentInfo)) {
            this.dynamicError("In the key() function, the context node must be in a tree whose root is a document node");
            return null;
        }
        DocumentInfo documentInfo = (DocumentInfo)item;
        int n = this.keyFingerprint;
        if (n == -1 && (n = this.nsContext.getFingerprint((String)(object = this.argument[0].evaluateItem(xPathContext).getStringValue()), false, xPathContext.getController().getNamePool())) == -1) {
            this.dynamicError("Key '" + (String)object + "' has not been defined");
            return null;
        }
        object = this.argument[1];
        if (!Cardinality.allowsMany(object.getCardinality())) {
            AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
            if (atomicValue == null) {
                return EmptyIterator.getInstance();
            }
            KeyManager keyManager = controller.getKeyManager();
            return keyManager.selectByKey(n, documentInfo, atomicValue, controller);
        }
        KeyContextInfo keyContextInfo = new KeyContextInfo();
        keyContextInfo.document = documentInfo;
        keyContextInfo.controller = controller;
        keyContextInfo.keyFingerprint = n;
        SequenceIterator sequenceIterator = this.argument[1].iterate(xPathContext);
        MappingIterator mappingIterator = new MappingIterator(sequenceIterator, this, null, keyContextInfo);
        return new DocumentOrderIterator(mappingIterator, LocalOrderComparer.getInstance());
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        KeyContextInfo keyContextInfo = (KeyContextInfo)object;
        KeyManager keyManager = keyContextInfo.controller.getKeyManager();
        AtomicValue atomicValue = item instanceof AtomicValue ? (AtomicValue)item : new StringValue(item.getStringValue());
        return keyManager.selectByKey(keyContextInfo.keyFingerprint, keyContextInfo.document, atomicValue, keyContextInfo.controller);
    }

    private class KeyContextInfo {
        public DocumentInfo document;
        public Controller controller;
        public int keyFingerprint;

        private KeyContextInfo() {
        }
    }
}

