/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.classfile.ConstantCP;
import org.aspectj.apache.bcel.classfile.ConstantNameAndType;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.generic.CPInstruction;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.LoadClass;
import org.aspectj.apache.bcel.generic.ObjectType;

public abstract class FieldOrMethod
extends CPInstruction
implements LoadClass {
    private boolean dontKnowSignature = true;
    private String signature;
    private boolean dontKnowName = true;
    private String name;
    private boolean dontKnowClassname = true;
    private String classname;

    FieldOrMethod() {
    }

    protected FieldOrMethod(short opcode, int index) {
        super(opcode, index);
    }

    public String getSignature(ConstantPoolGen cpg) {
        if (this.dontKnowSignature) {
            ConstantPool cp = cpg.getConstantPool();
            ConstantCP cmr = (ConstantCP)cp.getConstant(this.index);
            ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
            this.signature = ((ConstantUtf8)cp.getConstant(cnat.getSignatureIndex())).getBytes();
            this.dontKnowSignature = false;
        }
        return this.signature;
    }

    public String getName(ConstantPoolGen cpg) {
        if (this.dontKnowName) {
            ConstantPool cp = cpg.getConstantPool();
            ConstantCP cmr = (ConstantCP)cp.getConstant(this.index);
            ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
            this.name = ((ConstantUtf8)cp.getConstant(cnat.getNameIndex())).getBytes();
            this.dontKnowName = false;
        }
        return this.name;
    }

    public String getClassName(ConstantPoolGen cpg) {
        if (this.dontKnowClassname) {
            ConstantCP cmr;
            ConstantPool cp = cpg.getConstantPool();
            String str = cp.getConstantString((cmr = (ConstantCP)cp.getConstant(this.index)).getClassIndex(), (byte)7);
            this.classname = str.charAt(0) == '[' ? str : str.replace('/', '.');
            this.dontKnowClassname = false;
        }
        return this.classname;
    }

    public ObjectType getClassType(ConstantPoolGen cpg) {
        return new ObjectType(this.getClassName(cpg));
    }

    public ObjectType getLoadClassType(ConstantPoolGen cpg) {
        return this.getClassType(cpg);
    }
}

