/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.ConstantPushInstruction;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.generic.TypedInstruction;
import org.aspectj.apache.bcel.generic.Visitor;

public class DCONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private double value;

    DCONST() {
    }

    public DCONST(double f) {
        super((short)14, (short)1);
        if (f == 0.0) {
            this.opcode = (short)14;
        } else if (f == 1.0) {
            this.opcode = (short)15;
        } else {
            throw new ClassGenException("DCONST can be used only for 0.0 and 1.0: " + f);
        }
        this.value = f;
    }

    public Number getValue() {
        return new Double(this.value);
    }

    public Type getType(ConstantPoolGen cp) {
        return Type.DOUBLE;
    }

    public void accept(Visitor v) {
        v.visitPushInstruction(this);
        v.visitStackProducer(this);
        v.visitTypedInstruction(this);
        v.visitConstantPushInstruction(this);
        v.visitDCONST(this);
    }
}

