# wildfly-swarm-repository

A project to generate an offline repository of Wildfly Swarm.


`mvn clean install` on the project creates a zip file in the target directory


## How it works
Maven is used to download the Swarm's bom file.
For a non-prod build `bom-all` is used.

Then a maven project with all the fractions from the downloaded bom is created.
The generated project is built using maven with a dedicated local repository.
Then the contents of the local repository are gathered into a zip file.

## What differs for the prod build
For the prod build, `bom` is used instead of `bom-all`.
Additionally, the generated repository includes only the artifacts that were build internally.

Moreover, the prod build includes a check for non-internally built runtime dependencies.
The check is based on the contents of m2repo of the fat jar generated for the project.

To invoke a prod build use:
```bash
mvn clean install -Dswarm.product.build
```


## Development notes

### Using local maven repo
To speed up working locally, or to use the locally built artifacts, 
one can use local maven repository.
To do it set `debug-utils/settingsForLocalM2.xml` as the maven settings to use:
```bash
mvn clean install -Dswarm.product.build -s debug-utils/settingsForLocalM2.xml -Dscript.arguments="--maven-settings <project directory>/debug-utils/settingsForLocalM2.xml"
```

### debugging upload
Start jfrog, e.g. using docker:
```bash
docker run --name artifactory -d -p 8081:8081 docker.bintray.io/jfrog/artifactory-oss:latest
```

Add `local-repo` server to settings.xml:
```xml
  <servers>
   <server>
      <id>local-repo</id>
      <username>admin</username>
      <password>password</password>
    </server>
    </servers>
```

Run with `-Plocal-repo`, e.g.:
```bash
mvn clean deploy -Dswarm.product.build -Plocal-repo
```


## TODO
1. enable strict checking of m2repo by removing --non-strict from the appropriate profile
