/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.reflect.AnnotationFinder;
import org.aspectj.weaver.reflect.IReflectionWorld;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegateFactory;

public class ReflectionWorld
extends World
implements IReflectionWorld {
    private ClassLoader classLoader;
    private AnnotationFinder annotationFinder;
    static /* synthetic */ Class class$org$aspectj$weaver$reflect$ReflectionWorld;

    private ReflectionWorld() {
        this.setMessageHandler(new ExceptionBasedMessageHandler());
        this.setBehaveInJava5Way(LangUtil.is15VMOrGreater());
        this.classLoader = (class$org$aspectj$weaver$reflect$ReflectionWorld == null ? (class$org$aspectj$weaver$reflect$ReflectionWorld = ReflectionWorld.class$("org.aspectj.weaver.reflect.ReflectionWorld")) : class$org$aspectj$weaver$reflect$ReflectionWorld).getClassLoader();
        this.annotationFinder = ReflectionWorld.makeAnnotationFinderIfAny(this.classLoader, this);
    }

    public ReflectionWorld(ClassLoader aClassLoader) {
        this.setMessageHandler(new ExceptionBasedMessageHandler());
        this.setBehaveInJava5Way(LangUtil.is15VMOrGreater());
        this.classLoader = aClassLoader;
        this.annotationFinder = ReflectionWorld.makeAnnotationFinderIfAny(this.classLoader, this);
    }

    public static AnnotationFinder makeAnnotationFinderIfAny(ClassLoader loader, World world) {
        AnnotationFinder annotationFinder = null;
        try {
            if (LangUtil.is15VMOrGreater()) {
                Class<?> java15AnnotationFinder = Class.forName("org.aspectj.weaver.reflect.Java15AnnotationFinder");
                annotationFinder = (AnnotationFinder)java15AnnotationFinder.newInstance();
                annotationFinder.setClassLoader(loader);
                annotationFinder.setWorld(world);
            }
        }
        catch (ClassNotFoundException ex) {
        }
        catch (IllegalAccessException ex) {
            throw new BCException("AspectJ internal error", ex);
        }
        catch (InstantiationException ex) {
            throw new BCException("AspectJ internal error", ex);
        }
        return annotationFinder;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public AnnotationFinder getAnnotationFinder() {
        return this.annotationFinder;
    }

    public ResolvedType resolve(Class aClass) {
        return ReflectionWorld.resolve(this, aClass);
    }

    public static ResolvedType resolve(World world, Class aClass) {
        String className = aClass.getName();
        if (aClass.isArray()) {
            return world.resolve(UnresolvedType.forSignature(className.replace('.', '/')));
        }
        return world.resolve(className);
    }

    protected ReferenceTypeDelegate resolveDelegate(ReferenceType ty) {
        return ReflectionBasedReferenceTypeDelegateFactory.createDelegate(ty, this, this.classLoader);
    }

    public Advice createAdviceMunger(AjAttribute.AdviceAttribute attribute, Pointcut pointcut, Member signature) {
        throw new UnsupportedOperationException("Cannot create advice munger in ReflectionWorld");
    }

    public ConcreteTypeMunger makeCflowStackFieldAdder(ResolvedMember cflowField) {
        throw new UnsupportedOperationException("Cannot create cflow stack in ReflectionWorld");
    }

    public ConcreteTypeMunger makeCflowCounterFieldAdder(ResolvedMember cflowField) {
        throw new UnsupportedOperationException("Cannot create cflow counter in ReflectionWorld");
    }

    public ConcreteTypeMunger makePerClauseAspect(ResolvedType aspect, PerClause.Kind kind) {
        throw new UnsupportedOperationException("Cannot create per clause in ReflectionWorld");
    }

    public ConcreteTypeMunger concreteTypeMunger(ResolvedTypeMunger munger, ResolvedType aspectType) {
        throw new UnsupportedOperationException("Cannot create type munger in ReflectionWorld");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ExceptionBasedMessageHandler
    implements IMessageHandler {
        private ExceptionBasedMessageHandler() {
        }

        public boolean handleMessage(IMessage message) throws AbortException {
            throw new ReflectionWorldException(message.toString());
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return kind == IMessage.INFO;
        }

        public void dontIgnore(IMessage.Kind kind) {
        }

        public void ignore(IMessage.Kind kind) {
        }
    }

    public static class ReflectionWorldException
    extends RuntimeException {
        private static final long serialVersionUID = -3432261918302793005L;

        public ReflectionWorldException(String message) {
            super(message);
        }
    }
}

