/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.util;

import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.instruction.FieldAccess;
import alt.jiapi.reflect.instruction.Invocation;

public class HotSpot {
    private Instruction startIns;
    private Instruction endIns;
    private InstructionList il;

    public HotSpot(InstructionList il, Instruction ins) {
        this(il, ins, ins);
    }

    public HotSpot(InstructionList il, Instruction start, Instruction end) {
        this.il = il;
        this.startIns = start;
        this.endIns = end;
    }

    public InstructionList getInstructionList() {
        int i1 = this.il.indexOf(this.startIns);
        int i2 = this.il.indexOf(this.endIns);
        return this.il.createView(i1, i2 + 1);
    }

    public InstructionList getArgumentList() {
        int i1 = this.il.indexOf(this.startIns);
        int i2 = this.il.indexOf(this.endIns);
        return this.il.createView(i1, i2);
    }

    public Instruction getHotSpotInstruction() {
        return this.endIns;
    }

    public String getName() {
        if (this.endIns instanceof Invocation) {
            Invocation inv = (Invocation)this.endIns;
            StringBuffer sb = new StringBuffer();
            if (!"<init>".equals(inv.getMethodName())) {
                sb.append(inv.getReturnType());
                sb.append(' ');
            }
            sb.append(inv.getClassName());
            sb.append('.');
            sb.append(inv.getMethodName());
            sb.append('(');
            String[] params = inv.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                sb.append(params[i]);
                if (i >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        if (this.endIns instanceof FieldAccess) {
            FieldAccess fa = (FieldAccess)this.endIns;
            return fa.getClassName() + "." + fa.getFieldName();
        }
        return "";
    }
}

