/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.event;

import alt.jiapi.event.EventInstrumentor;
import alt.jiapi.event.MethodEventProducer;
import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiField;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.instruction.FieldAccess;
import alt.jiapi.reflect.instruction.OpcodeGroups;
import java.lang.reflect.Modifier;

class MethodEventInstrumentor
extends EventInstrumentor {
    MethodEventInstrumentor(MethodEventProducer mep) {
        super(mep);
    }

    public void instrument(JiapiMethod jm) {
        InstructionList il = jm.getInstructionList();
        InstructionFactory factory = il.getInstructionFactory();
        JiapiClass mep = this.getEventProducer();
        JiapiMethod methodEntered = null;
        JiapiMethod methodExited = null;
        JiapiField jiapiField = this.getEventProducerField();
        boolean isStatic = Modifier.isStatic(il.getDeclaringMethod().getModifiers());
        try {
            methodEntered = mep.getDeclaredMethod("methodEntered", new String[]{"java.lang.Object", "java.lang.String"});
            methodExited = mep.getDeclaredMethod("methodExited", new String[]{"java.lang.Object", "java.lang.String"});
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e);
        }
        InstructionList entryList = il.createEmptyList();
        entryList.add(factory.getField(jiapiField));
        if (isStatic) {
            entryList.add(factory.pushConstant(il.getDeclaringMethod().getDeclaringClass().getName()));
        } else {
            entryList.add(factory.pushThis());
        }
        entryList.add(factory.pushConstant(il.getDeclaringMethod().getName()));
        entryList.add(factory.invoke(methodEntered));
        int superIdx = il.indexOf((byte)-73);
        if (!"<clinit>".equals(il.getDeclaringMethod().getName())) {
            il.insert(superIdx + 1, entryList);
        } else {
            int idx = this.findFieldInitIndex(il, jiapiField);
            if (idx != -1) {
                il.insert(idx + 1, entryList);
            }
        }
        InstructionList exitList = il.createEmptyList();
        exitList.add(factory.getField(jiapiField));
        if (isStatic) {
            exitList.add(factory.pushConstant(il.getDeclaringMethod().getDeclaringClass().getName()));
        } else {
            exitList.add(factory.pushThis());
        }
        exitList.add(factory.pushConstant(il.getDeclaringMethod().getName()));
        exitList.add(factory.invoke(methodExited));
        int idx = il.indexOf(OpcodeGroups.RETURN_INSTRUCTIONS, 0);
        while (idx != -1) {
            Instruction ins = il.get(idx);
            il.insert(idx, exitList);
            idx = il.indexOf(OpcodeGroups.RETURN_INSTRUCTIONS, idx + exitList.size() + 1);
        }
    }

    private int findFieldInitIndex(InstructionList il, JiapiField jiapiField) {
        FieldAccess fa;
        int idx = -1;
        while ((idx = il.indexOf((byte)-77, idx + 1)) != -1 && !(fa = (FieldAccess)il.get(idx)).getFieldName().equals(jiapiField.getName())) {
        }
        return idx;
    }
}

