/*
 * Decompiled with CFR 0.152.
 */
package jbet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jbet.Block;
import jbet.BranchTarget;
import jbet.ClassFileException;
import jbet.ConstantPool;
import jbet.CpClass;
import jbet.CpDouble;
import jbet.CpEntry;
import jbet.CpFieldRef;
import jbet.CpFloat;
import jbet.CpInteger;
import jbet.CpLong;
import jbet.CpMethodRef;
import jbet.CpString;
import jbet.DataFlow;
import jbet.DataFlowException;
import jbet.Descriptor;
import jbet.GlobalException;
import jbet.Type;
import jbet.Util;

public final class Instruction
implements Cloneable {
    private int _opCode;
    private int _realOpCode;
    private int _pc;
    private int _index;
    private int _cpItemIndex;
    private int _lvtIndex;
    private long _immediate;
    private double _immediate_f;
    private String _immediate_s;
    private BranchTarget[] _switchArray;
    private Object _ref;
    private String _elemname;
    private Object _lvname;
    private Object _type;
    public Instruction next = null;
    public Instruction prev = null;
    Object _procState = null;
    Object _lvrec = null;
    public static final int NAT_BOOLEAN = 4;
    public static final int NAT_CHAR = 5;
    public static final int NAT_FLOAT = 6;
    public static final int NAT_DOUBLE = 7;
    public static final int NAT_BYTE = 8;
    public static final int NAT_SHORT = 9;
    public static final int NAT_INT = 10;
    public static final int NAT_LONG = 11;
    public static final int OP_NOP = 0;
    public static final int OP_MONITORENTER = 194;
    public static final int OP_MONITOREXIT = 195;
    public static final int OP_WIDE = 196;
    public static final int OP_NEW = 187;
    public static final int OP_NEWARRAY = 188;
    public static final int OP_ANEWARRAY = 189;
    public static final int OP_MULTIANEWARRAY = 197;
    public static final int OP_RET = 169;
    public static final int OP_IRETURN = 172;
    public static final int OP_LRETURN = 173;
    public static final int OP_FRETURN = 174;
    public static final int OP_DRETURN = 175;
    public static final int OP_ARETURN = 176;
    public static final int OP_RETURN = 177;
    public static final int OP_CHECKCAST = 192;
    public static final int OP_INSTANCEOF = 193;
    public static final int OP_INVOKEVIRTUAL = 182;
    public static final int OP_INVOKESPECIAL = 183;
    public static final int OP_INVOKESTATIC = 184;
    public static final int OP_INVOKEINTERFACE = 185;
    public static final int OP_IFEQ = 153;
    public static final int OP_IFNE = 154;
    public static final int OP_IFLT = 155;
    public static final int OP_IFGE = 156;
    public static final int OP_IFGT = 157;
    public static final int OP_IFLE = 158;
    public static final int OP_IF_ICMPEQ = 159;
    public static final int OP_IF_ICMPNE = 160;
    public static final int OP_IF_ICMPLT = 161;
    public static final int OP_IF_ICMPGE = 162;
    public static final int OP_IF_ICMPGT = 163;
    public static final int OP_IF_ICMPLE = 164;
    public static final int OP_IF_ACMPEQ = 165;
    public static final int OP_IF_ACMPNE = 166;
    public static final int OP_GOTO = 167;
    public static final int OP_GOTO_W = 200;
    public static final int OP_JSR = 168;
    public static final int OP_TABLESWITCH = 170;
    public static final int OP_LOOKUPSWITCH = 171;
    public static final int OP_IFNULL = 198;
    public static final int OP_IFNONNULL = 199;
    public static final int OP_JSR_W = 201;
    public static final int OP_ATHROW = 191;
    public static final int OP_ACONST_NULL = 1;
    public static final int OP_ICONST_M1 = 2;
    public static final int OP_ICONST_0 = 3;
    public static final int OP_ICONST_1 = 4;
    public static final int OP_ICONST_2 = 5;
    public static final int OP_ICONST_3 = 6;
    public static final int OP_ICONST_4 = 7;
    public static final int OP_ICONST_5 = 8;
    public static final int OP_LCONST_0 = 9;
    public static final int OP_LCONST_1 = 10;
    public static final int OP_FCONST_0 = 11;
    public static final int OP_FCONST_1 = 12;
    public static final int OP_FCONST_2 = 13;
    public static final int OP_DCONST_0 = 14;
    public static final int OP_DCONST_1 = 15;
    public static final int OP_LDC = 18;
    public static final int OP_LDC_W = 19;
    public static final int OP_LDC2_W = 20;
    public static final int OP_BIPUSH = 16;
    public static final int OP_SIPUSH = 17;
    public static final int OP_POP = 87;
    public static final int OP_POP2 = 88;
    public static final int OP_ILOAD = 21;
    public static final int OP_ILOAD_0 = 26;
    public static final int OP_ILOAD_1 = 27;
    public static final int OP_ILOAD_2 = 28;
    public static final int OP_ILOAD_3 = 29;
    public static final int OP_FLOAD = 23;
    public static final int OP_FLOAD_0 = 34;
    public static final int OP_FLOAD_1 = 35;
    public static final int OP_FLOAD_2 = 36;
    public static final int OP_FLOAD_3 = 37;
    public static final int OP_LLOAD = 22;
    public static final int OP_LLOAD_0 = 30;
    public static final int OP_LLOAD_1 = 31;
    public static final int OP_LLOAD_2 = 32;
    public static final int OP_LLOAD_3 = 33;
    public static final int OP_DLOAD = 24;
    public static final int OP_DLOAD_0 = 38;
    public static final int OP_DLOAD_1 = 39;
    public static final int OP_DLOAD_2 = 40;
    public static final int OP_DLOAD_3 = 41;
    public static final int OP_ALOAD = 25;
    public static final int OP_ALOAD_0 = 42;
    public static final int OP_ALOAD_1 = 43;
    public static final int OP_ALOAD_2 = 44;
    public static final int OP_ALOAD_3 = 45;
    public static final int OP_ISTORE = 54;
    public static final int OP_ISTORE_0 = 59;
    public static final int OP_ISTORE_1 = 60;
    public static final int OP_ISTORE_2 = 61;
    public static final int OP_ISTORE_3 = 62;
    public static final int OP_FSTORE = 56;
    public static final int OP_FSTORE_0 = 67;
    public static final int OP_FSTORE_1 = 68;
    public static final int OP_FSTORE_2 = 69;
    public static final int OP_FSTORE_3 = 70;
    public static final int OP_LSTORE = 55;
    public static final int OP_LSTORE_0 = 63;
    public static final int OP_LSTORE_1 = 64;
    public static final int OP_LSTORE_2 = 65;
    public static final int OP_LSTORE_3 = 66;
    public static final int OP_DSTORE = 57;
    public static final int OP_DSTORE_0 = 71;
    public static final int OP_DSTORE_1 = 72;
    public static final int OP_DSTORE_2 = 73;
    public static final int OP_DSTORE_3 = 74;
    public static final int OP_ASTORE = 58;
    public static final int OP_ASTORE_0 = 75;
    public static final int OP_ASTORE_1 = 76;
    public static final int OP_ASTORE_2 = 77;
    public static final int OP_ASTORE_3 = 78;
    public static final int OP_GETSTATIC = 178;
    public static final int OP_PUTSTATIC = 179;
    public static final int OP_GETFIELD = 180;
    public static final int OP_PUTFIELD = 181;
    public static final int OP_DUP = 89;
    public static final int OP_DUP_X1 = 90;
    public static final int OP_DUP_X2 = 91;
    public static final int OP_DUP2 = 92;
    public static final int OP_DUP2_X1 = 93;
    public static final int OP_DUP2_X2 = 94;
    public static final int OP_SWAP = 95;
    public static final int OP_IADD = 96;
    public static final int OP_LADD = 97;
    public static final int OP_FADD = 98;
    public static final int OP_DADD = 99;
    public static final int OP_ISUB = 100;
    public static final int OP_LSUB = 101;
    public static final int OP_FSUB = 102;
    public static final int OP_DSUB = 103;
    public static final int OP_IMUL = 104;
    public static final int OP_LMUL = 105;
    public static final int OP_FMUL = 106;
    public static final int OP_DMUL = 107;
    public static final int OP_IDIV = 108;
    public static final int OP_LDIV = 109;
    public static final int OP_FDIV = 110;
    public static final int OP_DDIV = 111;
    public static final int OP_IREM = 112;
    public static final int OP_LREM = 113;
    public static final int OP_FREM = 114;
    public static final int OP_DREM = 115;
    public static final int OP_INEG = 116;
    public static final int OP_LNEG = 117;
    public static final int OP_FNEG = 118;
    public static final int OP_DNEG = 119;
    public static final int OP_ISHL = 120;
    public static final int OP_LSHL = 121;
    public static final int OP_ISHR = 122;
    public static final int OP_LSHR = 123;
    public static final int OP_IUSHR = 124;
    public static final int OP_LUSHR = 125;
    public static final int OP_IAND = 126;
    public static final int OP_LAND = 127;
    public static final int OP_IOR = 128;
    public static final int OP_LOR = 129;
    public static final int OP_IXOR = 130;
    public static final int OP_LXOR = 131;
    public static final int OP_IINC = 132;
    public static final int OP_LCMP = 148;
    public static final int OP_FCMPG = 149;
    public static final int OP_FCMPL = 150;
    public static final int OP_DCMPG = 151;
    public static final int OP_DCMPL = 152;
    public static final int OP_I2B = 145;
    public static final int OP_I2C = 146;
    public static final int OP_I2S = 147;
    public static final int OP_I2L = 133;
    public static final int OP_I2F = 134;
    public static final int OP_I2D = 135;
    public static final int OP_L2I = 136;
    public static final int OP_L2F = 137;
    public static final int OP_L2D = 138;
    public static final int OP_F2I = 139;
    public static final int OP_F2L = 140;
    public static final int OP_F2D = 141;
    public static final int OP_D2I = 142;
    public static final int OP_D2L = 143;
    public static final int OP_D2F = 144;
    public static final int OP_IALOAD = 46;
    public static final int OP_LALOAD = 47;
    public static final int OP_FALOAD = 48;
    public static final int OP_DALOAD = 49;
    public static final int OP_AALOAD = 50;
    public static final int OP_BALOAD = 51;
    public static final int OP_CALOAD = 52;
    public static final int OP_SALOAD = 53;
    public static final int OP_IASTORE = 79;
    public static final int OP_LASTORE = 80;
    public static final int OP_FASTORE = 81;
    public static final int OP_DASTORE = 82;
    public static final int OP_AASTORE = 83;
    public static final int OP_BASTORE = 84;
    public static final int OP_CASTORE = 85;
    public static final int OP_SASTORE = 86;
    public static final int OP_ARRAYLENGTH = 190;
    public static final int AOP_IPUSH = 256;
    public static final int AOP_FPUSH = 257;
    public static final int AOP_LPUSH = 258;
    public static final int AOP_DPUSH = 259;
    public static final int AOP_SPUSH = 260;
    public static final int AOP_NONE = 512;
    public static final int AOP_EXCMARKER = 513;
    public static final int AOP_COMMENT = 514;
    public static final int AOP_GOTOBLK = 515;
    public static final int AOP_LABEL = 516;
    public static final int AOP_INVOKEINIT = 517;
    public static final int AOP_GOTOTEMP = 518;
    public static final int AOP_FREE = 768;
    static final String[] mnemonics;

    public void copy(Instruction instruction) {
        int n;
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        BranchTarget[] branchTargetArray;
        String string2;
        double d;
        long l;
        int n2;
        int n3;
        int n4;
        int n5;
        Instruction instruction2;
        Instruction instruction3 = this;
        Instruction instruction4 = instruction2 = instruction;
        int n6 = instruction4._opCode;
        Instruction instruction5 = instruction3;
        instruction3._opCode = n6;
        instruction5._realOpCode = n5 = instruction4._realOpCode;
        instruction5._pc = n4 = instruction4._pc;
        instruction5._cpItemIndex = n3 = instruction4._cpItemIndex;
        instruction5._lvtIndex = n2 = instruction4._lvtIndex;
        instruction5._immediate = l = instruction4._immediate;
        instruction5._immediate_f = d = instruction4._immediate_f;
        instruction5._immediate_s = string2 = instruction4._immediate_s;
        instruction5._switchArray = branchTargetArray = instruction4._switchArray;
        instruction5._ref = object4 = instruction4._ref;
        instruction5._type = object3 = instruction4._type;
        instruction5._elemname = string = instruction4._elemname;
        instruction5._procState = object2 = instruction4._procState;
        instruction5._lvname = object = instruction4._lvname;
        instruction5._index = n = instruction4._index;
    }

    void initialize() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction._realOpCode = -1;
        instruction2._cpItemIndex = -1;
        instruction2._ref = null;
        instruction2._switchArray = null;
        instruction2._type = null;
        instruction2._elemname = null;
    }

    public int opCode() {
        Instruction instruction = this;
        return instruction._opCode;
    }

    public int setOpCode(int n) {
        int n2;
        int n3;
        Instruction instruction = this;
        instruction._opCode = n3 = (n2 = n);
        return n3;
    }

    public int realOpCode() {
        Instruction instruction = this;
        return instruction._realOpCode;
    }

    public int setRealOpCode(int n) {
        int n2;
        int n3;
        Instruction instruction = this;
        instruction._realOpCode = n3 = (n2 = n);
        return n3;
    }

    int cpItemIndex() {
        Instruction instruction = this;
        return instruction._cpItemIndex;
    }

    int setCpItemIndex(int n) {
        int n2;
        int n3;
        Instruction instruction = this;
        instruction._cpItemIndex = n3 = (n2 = n);
        return n3;
    }

    int blockNumber() {
        Instruction instruction = this;
        return instruction._cpItemIndex;
    }

    int setBlockNumber(int n) {
        int n2;
        int n3;
        Instruction instruction = this;
        instruction._cpItemIndex = n3 = (n2 = n);
        return n3;
    }

    public int lvtIndex() {
        Instruction instruction = this;
        return instruction._lvtIndex;
    }

    public int setLvtIndex(int n) {
        int n2;
        int n3;
        Instruction instruction = this;
        instruction._lvtIndex = n3 = (n2 = n);
        return n3;
    }

    public int immediate() {
        Instruction instruction = this;
        return (int)instruction._immediate;
    }

    public int setImmediate(int n) {
        long l;
        Instruction instruction = this;
        int n2 = n;
        instruction._immediate = l = (long)n2;
        return (int)l;
    }

    public long immediate_l() {
        Instruction instruction = this;
        return instruction._immediate;
    }

    public long setImmediate_l(long l) {
        long l2;
        long l3;
        Instruction instruction = this;
        instruction._immediate = l3 = (l2 = l);
        return l3;
    }

    public double immediate_f() {
        Instruction instruction = this;
        return instruction._immediate_f;
    }

    public double setImmediate_f(double d) {
        double d2;
        double d3;
        Instruction instruction = this;
        instruction._immediate_f = d3 = (d2 = d);
        return d3;
    }

    public String immediate_s() {
        Instruction instruction = this;
        return instruction._immediate_s;
    }

    public String setImmediate_s(String string) {
        String string2;
        String string3;
        Instruction instruction = this;
        instruction._immediate_s = string3 = (string2 = string);
        return string3;
    }

    public String lvname() {
        Instruction instruction = this;
        return (String)instruction._lvrec;
    }

    public String setLvname(String string) {
        String string2;
        Instruction instruction = this;
        String string3 = string2 = string;
        instruction._lvrec = string3;
        return string3;
    }

    public BranchTarget branchTarget() {
        Instruction instruction = this;
        return (BranchTarget)instruction._ref;
    }

    public BranchTarget setBranchTarget(BranchTarget branchTarget) {
        BranchTarget branchTarget2;
        Instruction instruction = this;
        BranchTarget branchTarget3 = branchTarget2 = branchTarget;
        instruction._ref = branchTarget3;
        return branchTarget3;
    }

    public BranchTarget[] switchArray() {
        Instruction instruction = this;
        return instruction._switchArray;
    }

    public BranchTarget[] setSwitchArray(BranchTarget[] branchTargetArray) {
        BranchTarget[] branchTargetArray2;
        Instruction instruction = this;
        BranchTarget[] branchTargetArray3 = branchTargetArray2 = branchTargetArray;
        instruction._switchArray = branchTargetArray3;
        return branchTargetArray2;
    }

    public String classRef() {
        Instruction instruction = this;
        return (String)instruction._ref;
    }

    public String setClassRef(String string) {
        String string2;
        Instruction instruction = this;
        String string3 = string2 = string;
        instruction._ref = string3;
        return string3;
    }

    public String elemName() {
        Instruction instruction = this;
        return instruction._elemname;
    }

    public String setElemName(String string) {
        String string2;
        String string3;
        Instruction instruction = this;
        instruction._elemname = string3 = (string2 = string);
        return string3;
    }

    public Type type() {
        Instruction instruction = this;
        return (Type)instruction._type;
    }

    public Type setType(Type type) {
        Type type2;
        Instruction instruction = this;
        Type type3 = type2 = type;
        instruction._type = type3;
        return type3;
    }

    Object rawType() {
        Instruction instruction = this;
        return instruction._type;
    }

    public Descriptor descriptor() {
        Instruction instruction = this;
        return (Descriptor)instruction._type;
    }

    public Descriptor setDescriptor(Descriptor descriptor) {
        Descriptor descriptor2;
        Instruction instruction = this;
        Descriptor descriptor3 = descriptor2 = descriptor;
        instruction._type = descriptor3;
        return descriptor3;
    }

    public int pc() {
        Instruction instruction = this;
        return instruction._pc;
    }

    public int setPc(int n) {
        int n2;
        int n3;
        Instruction instruction = this;
        instruction._pc = n3 = (n2 = n);
        return n3;
    }

    public DataFlow.ProcState procState() {
        Instruction instruction = this;
        return (DataFlow.ProcState)instruction._procState;
    }

    DataFlow.ProcState setProcState(DataFlow.ProcState procState) {
        DataFlow.ProcState procState2;
        Instruction instruction = this;
        DataFlow.ProcState procState3 = procState2 = procState;
        instruction._procState = procState3;
        return procState3;
    }

    void model() throws ClassFileException, DataFlowException {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        DataFlow.ProcState procState = instruction2.procState();
        procState.model(instruction2);
    }

    int index() {
        Instruction instruction = this;
        return instruction._index;
    }

    int setIndex(int n) {
        int n2;
        int n3;
        Instruction instruction = this;
        instruction._index = n3 = (n2 = n);
        return n3;
    }

    public void setBranchTarget(Instruction instruction) {
        Instruction instruction2;
        Instruction instruction3 = instruction2 = this;
        Instruction instruction4 = instruction2;
        Instruction instruction5 = instruction;
        if (instruction3.branchTarget() == null) {
            BranchTarget branchTarget = new BranchTarget();
            instruction2.setBranchTarget(branchTarget);
        }
        BranchTarget branchTarget = instruction4.branchTarget();
        branchTarget.instr = instruction5;
    }

    public void setBranchTarget(Block block) {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Block block2 = block;
        if (instruction2.branchTarget() == null) {
            BranchTarget branchTarget = new BranchTarget();
            instruction.setBranchTarget(branchTarget);
        }
        BranchTarget branchTarget = instruction3.branchTarget();
        branchTarget.block = block2;
    }

    public Instruction dup() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        try {
            Instruction instruction7;
            Instruction instruction8 = instruction2;
            Instruction instruction9 = instruction7 = (Instruction)instruction8.clone();
            Instruction instruction10 = instruction7;
            Instruction instruction11 = instruction7;
            Instruction instruction12 = instruction7;
            if (instruction8.usesBranch()) {
                BranchTarget branchTarget = instruction5.branchTarget();
                BranchTarget branchTarget2 = branchTarget.dup();
                instruction12.setBranchTarget(branchTarget2);
            }
            if (instruction6.isSwitch()) {
                BranchTarget[] branchTargetArray;
                BranchTarget[] branchTargetArray2;
                BranchTarget[] branchTargetArray3 = branchTargetArray2 = instruction.switchArray();
                BranchTarget[] branchTargetArray4 = branchTargetArray = new BranchTarget[branchTargetArray2.length];
                int n = 0;
                int n2 = 0;
                while (n2 < branchTargetArray3.length) {
                    BranchTarget branchTarget;
                    int n3 = n;
                    BranchTarget branchTarget3 = branchTargetArray2[n3];
                    branchTargetArray4[n3] = branchTarget = branchTarget3.dup();
                    n2 = n = n3 + 1;
                }
                instruction10.setSwitchArray(branchTargetArray);
            }
            if (instruction3.procState() != null) {
                DataFlow.ProcState procState = instruction4.procState();
                DataFlow.ProcState procState2 = procState.dup();
                instruction11.setProcState(procState2);
            }
            return instruction9;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Instruction setNop() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(0);
        return instruction2;
    }

    public Instruction setComment(String string) {
        Instruction instruction = this;
        String string2 = string;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(514);
        instruction2.setImmediate_s(string2);
        return instruction2;
    }

    public Instruction setIfNull() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(198);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        return instruction2;
    }

    public Instruction setIfNull(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.initialize();
        instruction4.setOpCode(198);
        BranchTarget branchTarget = new BranchTarget(instruction3);
        instruction4.setBranchTarget(branchTarget);
        return instruction4;
    }

    public Instruction setIfNoNull() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(199);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        return instruction2;
    }

    public Instruction setIfNoNull(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.initialize();
        instruction4.setOpCode(199);
        BranchTarget branchTarget = new BranchTarget(instruction3);
        instruction4.setBranchTarget(branchTarget);
        return instruction4;
    }

    public Instruction setNew(String string) {
        Instruction instruction = this;
        String string2 = string;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(187);
        instruction2.setClassRef(string2);
        return instruction2;
    }

    public Instruction setNewArray(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(188);
        instruction2.setImmediate(n2);
        return instruction2;
    }

    public Instruction setANewArray(String string) {
        Instruction instruction = this;
        String string2 = string;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(189);
        instruction2.setClassRef(string2);
        return instruction2;
    }

    public Instruction setMultiaNewArray(String string, int n) {
        Instruction instruction = this;
        String string2 = string;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(197);
        instruction2.setClassRef(string2);
        instruction2.setImmediate(n2);
        return instruction2;
    }

    public Instruction setInstanceof(String string) {
        Instruction instruction = this;
        String string2 = string;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(193);
        instruction2.setClassRef(string2);
        return instruction2;
    }

    public Instruction setInstanceof(Type type) {
        Instruction instruction = this;
        Type type2 = type;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(193);
        String string = type2.toClassRef();
        instruction2.setClassRef(string);
        return instruction2;
    }

    public Instruction setCheckcast(String string) {
        Instruction instruction = this;
        String string2 = string;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(192);
        instruction2.setClassRef(string2);
        return instruction2;
    }

    public Instruction setCheckcast(Type type) {
        Instruction instruction = this;
        Type type2 = type;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(192);
        String string = type2.toClassRef();
        instruction2.setClassRef(string);
        return instruction2;
    }

    public Instruction setInvokeStatic(String string, String string2, Descriptor descriptor) {
        Instruction instruction = this;
        String string3 = string;
        String string4 = string2;
        Descriptor descriptor2 = descriptor;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(184);
        instruction2.setClassRef(string3);
        instruction2.setElemName(string4);
        instruction2.setDescriptor(descriptor2);
        return instruction2;
    }

    public Instruction setInvokeVirtual(String string, String string2, Descriptor descriptor) {
        Instruction instruction = this;
        String string3 = string;
        String string4 = string2;
        Descriptor descriptor2 = descriptor;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(182);
        instruction2.setClassRef(string3);
        instruction2.setElemName(string4);
        instruction2.setDescriptor(descriptor2);
        return instruction2;
    }

    public Instruction setInvokeSpecial(String string, String string2, Descriptor descriptor) {
        Instruction instruction = this;
        String string3 = string;
        String string4 = string2;
        Descriptor descriptor2 = descriptor;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(183);
        instruction2.setClassRef(string3);
        instruction2.setElemName(string4);
        instruction2.setDescriptor(descriptor2);
        return instruction2;
    }

    public Instruction setInvoke(String string, String string2, Descriptor descriptor, int n) {
        Instruction instruction = this;
        String string3 = string;
        String string4 = string2;
        Descriptor descriptor2 = descriptor;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(n2);
        instruction2.setClassRef(string3);
        instruction2.setElemName(string4);
        instruction2.setDescriptor(descriptor2);
        return instruction2;
    }

    public Instruction setInvoke(String string, String string2, Descriptor descriptor, boolean bl) {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        String string3 = string;
        String string4 = string2;
        Descriptor descriptor2 = descriptor;
        boolean bl2 = bl;
        instruction2.initialize();
        int n = bl2 ? 184 : 182;
        Instruction instruction4 = instruction;
        instruction3.setOpCode(n);
        instruction4.setClassRef(string3);
        instruction4.setElemName(string4);
        instruction4.setDescriptor(descriptor2);
        return instruction4;
    }

    public Instruction setGetfield(String string, String string2, Type type) {
        Instruction instruction = this;
        String string3 = string;
        String string4 = string2;
        Type type2 = type;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(180);
        instruction2.setClassRef(string3);
        instruction2.setElemName(string4);
        instruction2.setType(type2);
        return instruction2;
    }

    public boolean isGet() {
        Instruction instruction = this;
        Instruction instruction2 = instruction;
        boolean bl = instruction2.opCode() == 180 || instruction.opCode() == 178;
        return bl;
    }

    public boolean isPut() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        boolean bl = instruction.opCode() == 181 || instruction2.opCode() == 179;
        return bl;
    }

    public Instruction setGetstatic(String string, String string2, Type type) {
        Instruction instruction = this;
        String string3 = string;
        String string4 = string2;
        Type type2 = type;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(178);
        instruction2.setClassRef(string3);
        instruction2.setElemName(string4);
        instruction2.setType(type2);
        return instruction2;
    }

    public Instruction setPutfield(String string, String string2, Type type) {
        Instruction instruction = this;
        String string3 = string;
        String string4 = string2;
        Type type2 = type;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(181);
        instruction2.setClassRef(string3);
        instruction2.setElemName(string4);
        instruction2.setType(type2);
        return instruction2;
    }

    public Instruction setPutstatic(String string, String string2, Type type) {
        Instruction instruction = this;
        String string3 = string;
        String string4 = string2;
        Type type2 = type;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(179);
        instruction2.setClassRef(string3);
        instruction2.setElemName(string4);
        instruction2.setType(type2);
        return instruction2;
    }

    public Instruction setDup() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(89);
        return instruction2;
    }

    public Instruction setDup2() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(92);
        return instruction2;
    }

    public Instruction setDup(Type type) {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Type type2 = type;
        instruction3.initialize();
        int n = type2.category() == 1 ? 89 : 92;
        instruction.setOpCode(n);
        return instruction2;
    }

    public Instruction setDup_x(Type type, Type type2) {
        Type type3;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Type type4 = type;
        Type type5 = type3 = type2;
        instruction6.initialize();
        if (type4.category() == 1) {
            if (type5.category() == 1) {
                instruction3.setOpCode(90);
            } else {
                instruction.setOpCode(91);
            }
        } else if (type3.category() == 1) {
            instruction2.setOpCode(93);
        } else {
            instruction5.setOpCode(94);
        }
        return instruction4;
    }

    public Instruction setAconst_Null() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(1);
        return instruction2;
    }

    public Instruction setAthrow() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(191);
        return instruction2;
    }

    public Instruction setAreturn() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(176);
        return instruction2;
    }

    public Instruction setIreturn() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(172);
        return instruction2;
    }

    public Instruction setDreturn() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(175);
        return instruction2;
    }

    public Instruction setFreturn() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(174);
        return instruction2;
    }

    public Instruction setLreturn() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(173);
        return instruction2;
    }

    public Instruction setReturn() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(177);
        return instruction2;
    }

    public Instruction setPop() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(87);
        return instruction2;
    }

    public Instruction setPop2() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(88);
        return instruction2;
    }

    public Instruction setPop(Type type) {
        Type type2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Type type3 = type2 = type;
        instruction.initialize();
        if (type2.category() == 0) {
            instruction4.setNop();
        } else {
            int n = type3.category() == 1 ? 87 : 88;
            instruction5.setOpCode(n);
        }
        return instruction2;
    }

    public Instruction setDup_x1() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(90);
        return instruction2;
    }

    public Instruction setDup_x2() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(91);
        return instruction2;
    }

    public Instruction setDup2_x1() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(93);
        return instruction2;
    }

    public Instruction setDup2_x2() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(94);
        return instruction2;
    }

    public Instruction setIpush(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(256);
        instruction2.setImmediate(n2);
        return instruction2;
    }

    public Instruction setDpush(double d) {
        Instruction instruction = this;
        double d2 = d;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(259);
        instruction2.setImmediate_f(d2);
        return instruction2;
    }

    public Instruction setFpush(double d) {
        Instruction instruction = this;
        double d2 = d;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(257);
        instruction2.setImmediate_f(d2);
        return instruction2;
    }

    public Instruction setLpush(long l) {
        Instruction instruction = this;
        long l2 = l;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(258);
        instruction2.setImmediate_l(l2);
        return instruction2;
    }

    public Instruction setSpush(String string) {
        Instruction instruction = this;
        String string2 = string;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(260);
        instruction2.setImmediate_s(string2);
        return instruction2;
    }

    public Instruction setLoad(Type type, int n) {
        Type type2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Type type3 = type2 = type;
        int n2 = n;
        Instruction instruction9 = instruction3;
        instruction9.initialize();
        instruction9.setLvtIndex(n2);
        if (type2.arraydepth > 0) {
            Instruction instruction10 = instruction8;
            instruction10.setOpCode(25);
            return instruction10;
        }
        switch (type3.base) {
            case 'L': 
            case 'N': 
            case 'R': 
            case 'l': {
                instruction7.setOpCode(25);
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                instruction5.setOpCode(21);
                break;
            }
            case 'J': {
                instruction4.setOpCode(22);
                break;
            }
            case 'D': {
                instruction.setOpCode(24);
                break;
            }
            case 'F': {
                instruction2.setOpCode(23);
                break;
            }
            default: {
                throw new IllegalStateException("invalid type for setload");
            }
        }
        return instruction6;
    }

    public Instruction setNewArray(Type type) {
        Type type2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Instruction instruction9 = instruction;
        Instruction instruction10 = instruction;
        Instruction instruction11 = instruction;
        Type type3 = type2 = type;
        Type type4 = type2;
        instruction3.initialize();
        switch (type3.base) {
            case 'L': {
                Instruction instruction12 = instruction7;
                instruction12.setOpCode(189);
                String string = type4.cname;
                instruction12.setClassRef(string);
                break;
            }
            case 'S': {
                Instruction instruction13 = instruction5;
                instruction13.setOpCode(188);
                instruction13.setImmediate(9);
                break;
            }
            case 'I': {
                Instruction instruction14 = instruction;
                instruction14.setOpCode(188);
                instruction14.setImmediate(10);
                break;
            }
            case 'D': {
                Instruction instruction15 = instruction11;
                instruction15.setOpCode(188);
                instruction15.setImmediate(7);
                break;
            }
            case 'F': {
                Instruction instruction16 = instruction4;
                instruction16.setOpCode(188);
                instruction16.setImmediate(6);
                break;
            }
            case 'J': {
                Instruction instruction17 = instruction6;
                instruction17.setOpCode(188);
                instruction17.setImmediate(11);
                break;
            }
            case 'Z': {
                Instruction instruction18 = instruction10;
                instruction18.setOpCode(188);
                instruction18.setImmediate(4);
                break;
            }
            case 'B': {
                Instruction instruction19 = instruction8;
                instruction19.setOpCode(188);
                instruction19.setImmediate(8);
                break;
            }
            case 'C': {
                Instruction instruction20 = instruction2;
                instruction20.setOpCode(188);
                instruction20.setImmediate(5);
                break;
            }
            default: {
                StringBuffer stringBuffer = new StringBuffer();
                char c = type2.base;
                StringBuffer stringBuffer2 = stringBuffer.append(c);
                StringBuffer stringBuffer3 = stringBuffer2.append(": invalid type for setnewarray");
                String string = stringBuffer3.toString();
                throw new IllegalStateException(string);
            }
        }
        return instruction9;
    }

    public Instruction setArrayLoad(Type type) {
        Type type2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Instruction instruction9 = instruction;
        Instruction instruction10 = instruction;
        Instruction instruction11 = instruction;
        Type type3 = type2 = type;
        instruction6.initialize();
        if (type3.arraydepth > 1) {
            Instruction instruction12 = instruction3;
            instruction12.setOpCode(50);
            return instruction12;
        }
        switch (type2.base) {
            case 'L': {
                instruction9.setOpCode(50);
                break;
            }
            case 'I': {
                instruction7.setOpCode(46);
                break;
            }
            case 'J': {
                instruction5.setOpCode(47);
                break;
            }
            case 'D': {
                instruction2.setOpCode(49);
                break;
            }
            case 'F': {
                instruction11.setOpCode(48);
                break;
            }
            case 'C': {
                instruction4.setOpCode(52);
                break;
            }
            case 'S': {
                instruction8.setOpCode(53);
                break;
            }
            case 'B': 
            case 'Z': {
                instruction10.setOpCode(51);
                break;
            }
            default: {
                throw new IllegalStateException("invalid type for setarrayload");
            }
        }
        return instruction;
    }

    public Instruction setArrayStore(Type type) {
        Type type2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Instruction instruction9 = instruction;
        Instruction instruction10 = instruction;
        Instruction instruction11 = instruction;
        Type type3 = type2 = type;
        instruction6.initialize();
        if (type2.arraydepth > 1) {
            Instruction instruction12 = instruction5;
            instruction12.setOpCode(83);
            return instruction12;
        }
        switch (type3.base) {
            case 'L': {
                instruction10.setOpCode(83);
                break;
            }
            case 'I': {
                instruction2.setOpCode(79);
                break;
            }
            case 'J': {
                instruction.setOpCode(80);
                break;
            }
            case 'D': {
                instruction4.setOpCode(82);
                break;
            }
            case 'F': {
                instruction3.setOpCode(81);
                break;
            }
            case 'C': {
                instruction11.setOpCode(85);
                break;
            }
            case 'S': {
                instruction9.setOpCode(86);
                break;
            }
            case 'B': 
            case 'Z': {
                instruction8.setOpCode(84);
                break;
            }
            default: {
                throw new IllegalStateException("invalid type for setarraystore");
            }
        }
        return instruction7;
    }

    public Instruction setReturn(Type type) {
        Type type2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Instruction instruction9 = instruction;
        Type type3 = type2 = type;
        Type type4 = type2;
        instruction3.initialize();
        if (type4 == null) {
            Instruction instruction10 = instruction;
            instruction10.setOpCode(177);
            return instruction10;
        }
        if (type2.arraydepth != 0) {
            Instruction instruction11 = instruction8;
            instruction11.setOpCode(176);
            return instruction11;
        }
        switch (type3.base) {
            case 'L': {
                Instruction instruction12 = instruction7;
                instruction12.setOpCode(176);
                return instruction12;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                Instruction instruction13 = instruction9;
                instruction13.setOpCode(172);
                return instruction13;
            }
            case 'J': {
                Instruction instruction14 = instruction5;
                instruction14.setOpCode(173);
                return instruction14;
            }
            case 'F': {
                Instruction instruction15 = instruction4;
                instruction15.setOpCode(174);
                return instruction15;
            }
            case 'D': {
                Instruction instruction16 = instruction2;
                instruction16.setOpCode(175);
                return instruction16;
            }
            case 'V': {
                Instruction instruction17 = instruction6;
                instruction17.setOpCode(177);
                return instruction17;
            }
        }
        return null;
    }

    public Instruction setAload(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.setOpCode(25);
        instruction2.setLvtIndex(n2);
        instruction2.initialize();
        return instruction2;
    }

    public Instruction setRet(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.setOpCode(169);
        instruction2.setLvtIndex(n2);
        instruction2.initialize();
        return instruction2;
    }

    public Instruction setIload(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(21);
        instruction2.setLvtIndex(n2);
        return instruction2;
    }

    public Instruction setDload(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(24);
        instruction2.setLvtIndex(n2);
        return instruction2;
    }

    public Instruction setFload(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(23);
        instruction2.setLvtIndex(n2);
        return instruction2;
    }

    public Instruction setLload(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(22);
        instruction2.setLvtIndex(n2);
        return instruction2;
    }

    public Instruction setIstore(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(54);
        instruction2.setLvtIndex(n2);
        return instruction2;
    }

    public Instruction setIastore() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(79);
        return instruction2;
    }

    public Instruction setIaload() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(46);
        return instruction2;
    }

    public Instruction setAastore() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(83);
        return instruction2;
    }

    public Instruction setAaload() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(50);
        return instruction2;
    }

    public Instruction setArrayLength() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(190);
        return instruction2;
    }

    public Instruction setIsub() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(100);
        return instruction2;
    }

    public Instruction setIinc(int n, int n2) {
        Instruction instruction = this;
        int n3 = n;
        int n4 = n2;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(132);
        instruction2.setLvtIndex(n3);
        instruction2.setImmediate(n4);
        return instruction2;
    }

    public Instruction setLstore(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(55);
        instruction2.setLvtIndex(n2);
        return instruction2;
    }

    public Instruction setFstore(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(56);
        instruction2.setLvtIndex(n2);
        return instruction2;
    }

    public Instruction setDstore(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(57);
        instruction2.setLvtIndex(n2);
        return instruction2;
    }

    public Instruction setAstore(int n) {
        Instruction instruction = this;
        int n2 = n;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(58);
        instruction2.setLvtIndex(n2);
        return instruction2;
    }

    public Instruction setStore(Type type, int n) {
        Type type2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Type type3 = type2 = type;
        int n2 = n;
        Instruction instruction9 = instruction2;
        instruction9.initialize();
        instruction9.setLvtIndex(n2);
        if (type3.arraydepth > 0) {
            Instruction instruction10 = instruction6;
            instruction10.setOpCode(58);
            return instruction10;
        }
        switch (type2.base) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                instruction8.setOpCode(54);
                break;
            }
            case 'J': {
                instruction5.setOpCode(55);
                break;
            }
            case 'F': {
                instruction7.setOpCode(56);
                break;
            }
            case 'D': {
                instruction.setOpCode(57);
                break;
            }
            default: {
                instruction4.setOpCode(58);
            }
        }
        return instruction3;
    }

    public Instruction setSwap() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(95);
        return instruction2;
    }

    public Instruction setIfeq(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.setOpCode(153);
        BranchTarget branchTarget = new BranchTarget();
        instruction4.setBranchTarget(branchTarget);
        BranchTarget branchTarget2 = instruction4.branchTarget();
        branchTarget2.instr = instruction3;
        return instruction4;
    }

    public Instruction setIfne(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.setOpCode(154);
        BranchTarget branchTarget = new BranchTarget();
        instruction4.setBranchTarget(branchTarget);
        BranchTarget branchTarget2 = instruction4.branchTarget();
        branchTarget2.instr = instruction3;
        return instruction4;
    }

    public Instruction setIfeq() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.setOpCode(153);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        return instruction2;
    }

    public Instruction setIfne() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.setOpCode(154);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        return instruction2;
    }

    public Instruction setIflt(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.setOpCode(155);
        BranchTarget branchTarget = new BranchTarget();
        instruction4.setBranchTarget(branchTarget);
        BranchTarget branchTarget2 = instruction4.branchTarget();
        branchTarget2.instr = instruction3;
        return instruction4;
    }

    public Instruction setIfIcmple(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.setOpCode(164);
        BranchTarget branchTarget = new BranchTarget();
        instruction4.setBranchTarget(branchTarget);
        BranchTarget branchTarget2 = instruction4.branchTarget();
        branchTarget2.instr = instruction3;
        return instruction4;
    }

    public Instruction setIfIcmple() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.setOpCode(164);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        return instruction2;
    }

    public Instruction setIfIcmpne(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.setOpCode(160);
        BranchTarget branchTarget = new BranchTarget();
        instruction4.setBranchTarget(branchTarget);
        BranchTarget branchTarget2 = instruction4.branchTarget();
        branchTarget2.instr = instruction3;
        return instruction4;
    }

    public Instruction setIfIcmpne() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.setOpCode(160);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        return instruction2;
    }

    public Instruction setIfIcmpeq(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.setOpCode(159);
        BranchTarget branchTarget = new BranchTarget();
        instruction4.setBranchTarget(branchTarget);
        BranchTarget branchTarget2 = instruction4.branchTarget();
        branchTarget2.instr = instruction3;
        return instruction4;
    }

    public Instruction setIfIcmpeq() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.setOpCode(159);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        return instruction2;
    }

    public Instruction setIfIcmpge(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.setOpCode(162);
        BranchTarget branchTarget = new BranchTarget();
        instruction4.setBranchTarget(branchTarget);
        BranchTarget branchTarget2 = instruction4.branchTarget();
        branchTarget2.instr = instruction3;
        return instruction4;
    }

    public Instruction setIfIcmpgt(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.setOpCode(163);
        BranchTarget branchTarget = new BranchTarget();
        instruction4.setBranchTarget(branchTarget);
        BranchTarget branchTarget2 = instruction4.branchTarget();
        branchTarget2.instr = instruction3;
        return instruction4;
    }

    public Instruction setIfIcmpgt() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.setOpCode(163);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        return instruction2;
    }

    public Instruction setGoto(Instruction instruction) {
        Instruction instruction2 = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction2;
        instruction4.initialize();
        instruction4.setOpCode(167);
        BranchTarget branchTarget = new BranchTarget();
        instruction4.setBranchTarget(branchTarget);
        BranchTarget branchTarget2 = instruction4.branchTarget();
        branchTarget2.instr = instruction3;
        return instruction4;
    }

    public Instruction setGoto(Block block) {
        Instruction instruction = this;
        Block block2 = block;
        Instruction instruction2 = instruction;
        instruction2.initialize();
        instruction2.setOpCode(167);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        BranchTarget branchTarget2 = instruction2.branchTarget();
        branchTarget2.block = block2;
        return instruction2;
    }

    public Instruction setTableSwitch() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(170);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        return instruction2;
    }

    public Instruction setLookupSwitch() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        instruction2.initialize();
        instruction2.setOpCode(171);
        BranchTarget branchTarget = new BranchTarget();
        instruction2.setBranchTarget(branchTarget);
        return instruction2;
    }

    void setVarAccess(int n) {
        int n2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Instruction instruction9 = instruction;
        Instruction instruction10 = instruction;
        int n3 = n2 = n;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n2;
        int n9 = n2;
        int n10 = n2;
        int n11 = n2;
        int n12 = n2;
        switch (n3) {
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                Instruction instruction11 = instruction;
                instruction11.setOpCode(21);
                instruction11.setLvtIndex(n5 - 26);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                Instruction instruction12 = instruction5;
                instruction12.setOpCode(23);
                instruction12.setLvtIndex(n2 - 34);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                Instruction instruction13 = instruction2;
                instruction13.setOpCode(22);
                instruction13.setLvtIndex(n12 - 30);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                Instruction instruction14 = instruction7;
                instruction14.setOpCode(24);
                instruction14.setLvtIndex(n8 - 38);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                Instruction instruction15 = instruction3;
                instruction15.setOpCode(25);
                instruction15.setLvtIndex(n11 - 42);
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                Instruction instruction16 = instruction4;
                instruction16.setOpCode(54);
                instruction16.setLvtIndex(n4 - 59);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                Instruction instruction17 = instruction10;
                instruction17.setOpCode(56);
                instruction17.setLvtIndex(n7 - 67);
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                Instruction instruction18 = instruction6;
                instruction18.setOpCode(55);
                instruction18.setLvtIndex(n10 - 63);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                Instruction instruction19 = instruction9;
                instruction19.setOpCode(57);
                instruction19.setLvtIndex(n6 - 71);
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                Instruction instruction20 = instruction8;
                instruction20.setOpCode(58);
                instruction20.setLvtIndex(n9 - 75);
            }
        }
    }

    public int readFile(DataInputStream dataInputStream, int n, ConstantPool constantPool) throws ClassFileException, IOException {
        int n2;
        int n3;
        int n4;
        ConstantPool constantPool2;
        int n5;
        DataInputStream dataInputStream2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Instruction instruction9 = instruction;
        Instruction instruction10 = instruction;
        Instruction instruction11 = instruction;
        Instruction instruction12 = instruction;
        Instruction instruction13 = instruction;
        Instruction instruction14 = instruction;
        Instruction instruction15 = instruction;
        Instruction instruction16 = instruction;
        Instruction instruction17 = instruction;
        Instruction instruction18 = instruction;
        Instruction instruction19 = instruction;
        Instruction instruction20 = instruction;
        Instruction instruction21 = instruction;
        Instruction instruction22 = instruction;
        Instruction instruction23 = instruction;
        Instruction instruction24 = instruction;
        Instruction instruction25 = instruction;
        Instruction instruction26 = instruction;
        Instruction instruction27 = instruction;
        Instruction instruction28 = instruction;
        Instruction instruction29 = instruction;
        Instruction instruction30 = instruction;
        Instruction instruction31 = instruction;
        Instruction instruction32 = instruction;
        Instruction instruction33 = instruction;
        Instruction instruction34 = instruction;
        Instruction instruction35 = instruction;
        Instruction instruction36 = instruction;
        Instruction instruction37 = instruction;
        Instruction instruction38 = instruction;
        Instruction instruction39 = instruction;
        Instruction instruction40 = instruction;
        Instruction instruction41 = instruction;
        Instruction instruction42 = instruction;
        Instruction instruction43 = instruction;
        Instruction instruction44 = instruction;
        Instruction instruction45 = instruction;
        Instruction instruction46 = instruction;
        DataInputStream dataInputStream3 = dataInputStream2 = dataInputStream;
        DataInputStream dataInputStream4 = dataInputStream2;
        DataInputStream dataInputStream5 = dataInputStream2;
        DataInputStream dataInputStream6 = dataInputStream2;
        DataInputStream dataInputStream7 = dataInputStream2;
        DataInputStream dataInputStream8 = dataInputStream2;
        DataInputStream dataInputStream9 = dataInputStream2;
        DataInputStream dataInputStream10 = dataInputStream2;
        DataInputStream dataInputStream11 = dataInputStream2;
        DataInputStream dataInputStream12 = dataInputStream2;
        DataInputStream dataInputStream13 = dataInputStream2;
        DataInputStream dataInputStream14 = dataInputStream2;
        DataInputStream dataInputStream15 = dataInputStream2;
        DataInputStream dataInputStream16 = dataInputStream2;
        DataInputStream dataInputStream17 = dataInputStream2;
        DataInputStream dataInputStream18 = dataInputStream2;
        DataInputStream dataInputStream19 = dataInputStream2;
        DataInputStream dataInputStream20 = dataInputStream2;
        DataInputStream dataInputStream21 = dataInputStream2;
        DataInputStream dataInputStream22 = dataInputStream2;
        DataInputStream dataInputStream23 = dataInputStream2;
        DataInputStream dataInputStream24 = dataInputStream2;
        DataInputStream dataInputStream25 = dataInputStream2;
        DataInputStream dataInputStream26 = dataInputStream2;
        DataInputStream dataInputStream27 = dataInputStream2;
        DataInputStream dataInputStream28 = dataInputStream2;
        DataInputStream dataInputStream29 = dataInputStream2;
        int n6 = n5 = n;
        ConstantPool constantPool3 = constantPool2 = constantPool;
        ConstantPool constantPool4 = constantPool2;
        ConstantPool constantPool5 = constantPool2;
        ConstantPool constantPool6 = constantPool2;
        ConstantPool constantPool7 = constantPool2;
        ConstantPool constantPool8 = constantPool2;
        ConstantPool constantPool9 = constantPool2;
        ConstantPool constantPool10 = constantPool2;
        ConstantPool constantPool11 = constantPool2;
        Instruction instruction47 = instruction46;
        instruction47.initialize();
        int n7 = n4 = dataInputStream18.readUnsignedByte();
        int n8 = n4;
        int n9 = n4;
        int n10 = n4;
        int n11 = n4;
        int n12 = n4;
        int n13 = n4;
        int n14 = n4;
        int n15 = n4;
        int n16 = n4;
        int n17 = n4;
        int n18 = n4;
        int n19 = n4;
        int n20 = n4;
        int n21 = n4;
        int n22 = n4;
        int n23 = n4;
        int n24 = n4;
        int n25 = n4;
        int n26 = n4;
        instruction47.setRealOpCode(n26);
        block0 : switch (n4) {
            case 0: 
            case 1: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                instruction40.setOpCode(n21);
                n3 = 1;
                n2 = 1;
                break;
            }
            case 196: {
                DataInputStream dataInputStream30 = dataInputStream4;
                int n27 = dataInputStream30.readUnsignedByte();
                Instruction instruction48 = instruction19;
                instruction48.setOpCode(n27);
                int n28 = dataInputStream30.readUnsignedShort();
                instruction48.setLvtIndex(n28);
                n3 = 4;
                n2 = 4;
                switch (instruction48.opCode()) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        break block0;
                    }
                    case 132: {
                        int n29 = dataInputStream2.readUnsignedShort();
                        instruction39.setImmediate(n29);
                        n3 = 6;
                        n2 = 6;
                        break block0;
                    }
                }
                throw new ClassFileException("wide instruction specifies bad opcode");
            }
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                Instruction instruction49 = instruction24;
                instruction49.setOpCode(n15);
                int n30 = dataInputStream27.readUnsignedShort();
                instruction49.setCpItemIndex(n30);
                CpClass cpClass = constantPool11.cpClassAt(n30);
                String string = cpClass.string();
                instruction49.setClassRef(string);
                n3 = 3;
                n2 = 3;
                break;
            }
            case 188: {
                Instruction instruction50 = instruction16;
                instruction50.setOpCode(n19);
                int n31 = dataInputStream20.readUnsignedByte();
                instruction50.setImmediate(n31);
                n3 = 2;
                n2 = 2;
                break;
            }
            case 197: {
                Instruction instruction51 = instruction22;
                instruction51.setOpCode(n11);
                DataInputStream dataInputStream31 = dataInputStream23;
                int n32 = dataInputStream31.readUnsignedShort();
                CpClass cpClass = constantPool10.cpClassAt(n32);
                String string = cpClass.string();
                instruction51.setClassRef(string);
                instruction51.setCpItemIndex(n32);
                int n33 = dataInputStream31.readUnsignedByte();
                instruction51.setImmediate(n33);
                n3 = 4;
                n2 = 4;
                break;
            }
            case 169: {
                n3 = 2;
                n2 = 2;
                Instruction instruction52 = instruction9;
                instruction52.setOpCode(n23);
                int n34 = dataInputStream11.readUnsignedByte();
                instruction52.setLvtIndex(n34);
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                Instruction instruction53 = instruction30;
                instruction53.setOpCode(n4);
                int n35 = dataInputStream16.readUnsignedShort();
                CpMethodRef cpMethodRef = constantPool4.cpMethodRefAt(n35);
                String string = cpMethodRef.classname();
                instruction53.setClassRef(string);
                String string2 = cpMethodRef.name();
                instruction53.setElemName(string2);
                n3 = 3;
                n2 = 3;
                Descriptor descriptor = cpMethodRef.descriptor();
                instruction53.setDescriptor(descriptor);
                break;
            }
            case 185: {
                CpMethodRef cpMethodRef;
                Instruction instruction54 = instruction21;
                instruction54.setOpCode(n25);
                DataInputStream dataInputStream32 = dataInputStream8;
                int n36 = dataInputStream32.readUnsignedShort();
                CpMethodRef cpMethodRef2 = cpMethodRef = constantPool3.cpMethodRefAt(n36);
                String string = cpMethodRef2.classname();
                instruction54.setClassRef(string);
                String string3 = cpMethodRef2.name();
                instruction54.setElemName(string3);
                Descriptor descriptor = cpMethodRef2.descriptor();
                instruction54.setDescriptor(descriptor);
                int n37 = dataInputStream32.readUnsignedByte();
                Descriptor descriptor2 = instruction54.descriptor();
                if (n37 != descriptor2.count()) {
                    StringBuffer stringBuffer = new StringBuffer("argCount is wrong in interface: ");
                    stringBuffer.append(n37);
                    stringBuffer.append(", ");
                    Descriptor descriptor3 = instruction12.descriptor();
                    int n38 = descriptor3.count();
                    stringBuffer.append(n38);
                    stringBuffer.append(", ");
                    String string4 = cpMethodRef.toString();
                    stringBuffer.append(string4);
                    String string5 = stringBuffer.toString();
                    throw new ClassFileException(string5);
                }
                dataInputStream28.readUnsignedByte();
                n3 = 5;
                n2 = 5;
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                Instruction instruction55 = instruction29;
                instruction55.setOpCode(n10);
                BranchTarget branchTarget = new BranchTarget();
                instruction55.setBranchTarget(branchTarget);
                BranchTarget branchTarget2 = instruction55.branchTarget();
                short s = dataInputStream24.readShort();
                branchTarget2.offset = s;
                n3 = 3;
                n2 = 3;
                break;
            }
            case 200: {
                int n39;
                Instruction instruction56 = instruction2;
                instruction56.setOpCode(167);
                BranchTarget branchTarget = new BranchTarget();
                instruction56.setBranchTarget(branchTarget);
                BranchTarget branchTarget3 = instruction56.branchTarget();
                branchTarget3.offset = n39 = dataInputStream15.readInt();
                n3 = 5;
                n2 = 5;
                break;
            }
            case 201: {
                int n40;
                Instruction instruction57 = instruction28;
                instruction57.setOpCode(168);
                BranchTarget branchTarget = new BranchTarget();
                instruction57.setBranchTarget(branchTarget);
                BranchTarget branchTarget4 = instruction57.branchTarget();
                branchTarget4.offset = n40 = dataInputStream21.readInt();
                n3 = 5;
                n2 = 5;
                break;
            }
            case 170: {
                int n41;
                int n42;
                int n43;
                int n44;
                instruction11.setOpCode(n12);
                int n45 = 1;
                int n46 = 1;
                int n47 = n44 = n6 + 1;
                while (n44 % 4 != 0) {
                    int n48 = n47;
                    n47 = n44 = n48 + 1;
                    int n49 = n46;
                    n46 = n45 = n49 + 1;
                    dataInputStream6.readUnsignedByte();
                }
                BranchTarget branchTarget = new BranchTarget();
                Instruction instruction58 = instruction23;
                instruction58.setBranchTarget(branchTarget);
                BranchTarget branchTarget5 = instruction58.branchTarget();
                DataInputStream dataInputStream33 = dataInputStream17;
                branchTarget5.offset = n43 = dataInputStream33.readInt();
                n3 = n42 = n45 + 12;
                n2 = n42;
                int n50 = n41 = dataInputStream33.readInt();
                int n51 = dataInputStream33.readInt() - n50;
                instruction58.setSwitchArray(new BranchTarget[n51 + 1]);
                int n52 = 0;
                int n53 = 0;
                while (n53 < instruction42.switchArray().length) {
                    int n54;
                    Instruction instruction59 = instruction7;
                    BranchTarget[] branchTargetArray = instruction59.switchArray();
                    BranchTarget branchTarget6 = new BranchTarget();
                    int n55 = n52;
                    branchTargetArray[n55] = branchTarget6;
                    int n56 = n42;
                    n3 = n42 = n56 + 4;
                    n2 = n42;
                    BranchTarget[] branchTargetArray2 = instruction59.switchArray();
                    BranchTarget branchTarget7 = branchTargetArray2[n55];
                    branchTarget7.offset = n54 = dataInputStream3.readInt();
                    n53 = n52 = n55 + 1;
                }
                instruction34.setImmediate(n41);
                break;
            }
            case 171: {
                int n57;
                int n58;
                int n59;
                int n60 = 1;
                int n61 = 1;
                int n62 = n59 = n5 + 1;
                instruction33.setOpCode(n17);
                while (n59 % 4 != 0) {
                    dataInputStream10.readUnsignedByte();
                    int n63 = n62;
                    n62 = n59 = n63 + 1;
                    int n64 = n61;
                    n61 = n60 = n64 + 1;
                }
                BranchTarget branchTarget = new BranchTarget();
                Instruction instruction60 = instruction41;
                instruction60.setBranchTarget(branchTarget);
                BranchTarget branchTarget8 = instruction60.branchTarget();
                DataInputStream dataInputStream34 = dataInputStream19;
                branchTarget8.offset = n58 = dataInputStream34.readInt();
                BranchTarget[] branchTargetArray = new BranchTarget[dataInputStream34.readInt()];
                instruction60.setSwitchArray(branchTargetArray);
                n3 = n57 = n60 + 8;
                n2 = n57;
                int n65 = 0;
                int n66 = 0;
                while (n66 < instruction31.switchArray().length) {
                    int n67;
                    int n68;
                    Instruction instruction61 = instruction17;
                    BranchTarget[] branchTargetArray3 = instruction61.switchArray();
                    BranchTarget branchTarget9 = new BranchTarget();
                    int n69 = n65;
                    branchTargetArray3[n69] = branchTarget9;
                    BranchTarget[] branchTargetArray4 = instruction61.switchArray();
                    BranchTarget branchTarget10 = branchTargetArray4[n69];
                    DataInputStream dataInputStream35 = dataInputStream29;
                    branchTarget10.key = n68 = dataInputStream35.readInt();
                    BranchTarget[] branchTargetArray5 = instruction61.switchArray();
                    BranchTarget branchTarget11 = branchTargetArray5[n69];
                    branchTarget11.offset = n67 = dataInputStream35.readInt();
                    int n70 = n57;
                    n3 = n57 = n70 + 8;
                    n2 = n57;
                    n66 = n65 = n69 + 1;
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Instruction instruction62 = instruction26;
                instruction62.setOpCode(256);
                instruction62.setImmediate(n13 - 3);
                n3 = 1;
                n2 = 1;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                Instruction instruction63 = instruction15;
                instruction63.setOpCode(257);
                instruction63.setImmediate_f(n8 - 11);
                n3 = 1;
                n2 = 1;
                break;
            }
            case 9: 
            case 10: {
                Instruction instruction64 = instruction36;
                instruction64.setOpCode(258);
                instruction64.setImmediate(n14 - 9);
                n3 = 1;
                n2 = 1;
                break;
            }
            case 14: 
            case 15: {
                Instruction instruction65 = instruction43;
                instruction65.setOpCode(259);
                instruction65.setImmediate_f(n18 - 14);
                n3 = 1;
                n2 = 1;
                break;
            }
            case 18: {
                CpEntry cpEntry;
                int n71;
                int n72 = n71 = dataInputStream7.readUnsignedByte();
                instruction14.setCpItemIndex(n72);
                CpEntry cpEntry2 = cpEntry = constantPool5.elementAt(n72);
                CpEntry cpEntry3 = cpEntry;
                CpEntry cpEntry4 = cpEntry;
                if (cpEntry instanceof CpInteger) {
                    Instruction instruction66 = instruction13;
                    instruction66.setOpCode(256);
                    int n73 = ((CpInteger)cpEntry).value;
                    instruction66.setImmediate(n73);
                } else if (cpEntry2 instanceof CpFloat) {
                    Instruction instruction67 = instruction25;
                    instruction67.setOpCode(257);
                    double d = ((CpFloat)cpEntry4).value;
                    instruction67.setImmediate_f(d);
                } else if (cpEntry3 instanceof CpString) {
                    Instruction instruction68 = instruction18;
                    instruction68.setOpCode(260);
                    String string = constantPool2.stringAt(n71);
                    instruction68.setImmediate_s(string);
                } else {
                    throw new ClassFileException("attempt to ldc something that is not a Float, Int, or String");
                }
                n3 = 2;
                n2 = 2;
                break;
            }
            case 19: {
                CpEntry cpEntry;
                int n74;
                int n75 = n74 = dataInputStream14.readUnsignedShort();
                instruction10.setCpItemIndex(n75);
                CpEntry cpEntry5 = cpEntry = constantPool8.elementAt(n75);
                CpEntry cpEntry6 = cpEntry;
                CpEntry cpEntry7 = cpEntry;
                if (cpEntry instanceof CpInteger) {
                    Instruction instruction69 = instruction45;
                    instruction69.setOpCode(256);
                    int n76 = ((CpInteger)cpEntry7).value;
                    instruction69.setImmediate(n76);
                } else if (cpEntry6 instanceof CpFloat) {
                    Instruction instruction70 = instruction8;
                    instruction70.setOpCode(257);
                    double d = ((CpFloat)cpEntry5).value;
                    instruction70.setImmediate_f(d);
                } else if (cpEntry instanceof CpString) {
                    Instruction instruction71 = instruction6;
                    instruction71.setOpCode(260);
                    String string = constantPool7.stringAt(n74);
                    instruction71.setImmediate_s(string);
                } else {
                    throw new ClassFileException("attempt to ldc_w something that is not a Float, Int, or String");
                }
                n3 = 3;
                n2 = 3;
                break;
            }
            case 20: {
                CpEntry cpEntry;
                int n77 = dataInputStream26.readUnsignedShort();
                instruction32.setCpItemIndex(n77);
                CpEntry cpEntry8 = cpEntry = constantPool9.elementAt(n77);
                CpEntry cpEntry9 = cpEntry;
                if (cpEntry instanceof CpLong) {
                    Instruction instruction72 = instruction37;
                    instruction72.setOpCode(258);
                    long l = ((CpLong)cpEntry9).value;
                    instruction72.setImmediate_l(l);
                } else if (cpEntry8 instanceof CpDouble) {
                    Instruction instruction73 = instruction44;
                    instruction73.setOpCode(259);
                    double d = ((CpDouble)cpEntry).value;
                    instruction73.setImmediate_f(d);
                } else {
                    throw new ClassFileException("attempt to ldc_2w something that is not a long or double\n");
                }
                n3 = 3;
                n2 = 3;
                break;
            }
            case 16: {
                n3 = 2;
                n2 = 2;
                Instruction instruction74 = instruction20;
                instruction74.setOpCode(256);
                byte by = dataInputStream12.readByte();
                instruction74.setImmediate(by);
                break;
            }
            case 17: {
                Instruction instruction75 = instruction4;
                instruction75.setOpCode(256);
                short s = dataInputStream5.readShort();
                instruction75.setImmediate(s);
                n3 = 3;
                n2 = 3;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                Instruction instruction76 = instruction;
                instruction76.setOpCode(n20);
                int n78 = dataInputStream9.readUnsignedByte();
                instruction76.setLvtIndex(n78);
                n3 = 2;
                n2 = 2;
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                Instruction instruction77 = instruction5;
                instruction77.setOpCode(n7);
                int n79 = dataInputStream25.readUnsignedByte();
                instruction77.setLvtIndex(n79);
                n3 = 2;
                n2 = 2;
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                instruction35.setVarAccess(n24);
                n3 = 1;
                n2 = 1;
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                Instruction instruction78 = instruction38;
                instruction78.setOpCode(n22);
                int n80 = dataInputStream13.readUnsignedShort();
                CpFieldRef cpFieldRef = constantPool6.cpFieldRefAt(n80);
                String string = cpFieldRef.classname();
                instruction78.setClassRef(string);
                String string6 = cpFieldRef.name();
                instruction78.setElemName(string6);
                Type type = cpFieldRef.type();
                instruction78.setType(type);
                n3 = 3;
                n2 = 3;
                break;
            }
            case 132: {
                Instruction instruction79 = instruction3;
                instruction79.setOpCode(n9);
                DataInputStream dataInputStream36 = dataInputStream22;
                int n81 = dataInputStream36.readUnsignedByte();
                instruction79.setLvtIndex(n81);
                byte by = dataInputStream36.readByte();
                instruction79.setImmediate(by);
                n3 = 3;
                n2 = 3;
                break;
            }
            default: {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = stringBuffer.append("non-existent opcode: ");
                String string = Integer.toString(n16);
                StringBuffer stringBuffer3 = stringBuffer2.append(string);
                String string7 = stringBuffer3.toString();
                throw new ClassFileException(string7);
            }
        }
        if (n3 == -1) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer4 = stringBuffer.append("size was not set, opcode: ");
            int n82 = instruction27.opCode();
            StringBuffer stringBuffer5 = stringBuffer4.append(n82);
            String string = stringBuffer5.toString();
            throw new ClassFileException(string);
        }
        return n2;
    }

    int generate_loadstore(DataOutputStream dataOutputStream, int n) throws IOException {
        DataOutputStream dataOutputStream2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        DataOutputStream dataOutputStream3 = dataOutputStream2 = dataOutputStream;
        DataOutputStream dataOutputStream4 = dataOutputStream2;
        int n2 = n;
        if (instruction3.lvtIndex() <= 3) {
            int n3 = n2 + instruction2.lvtIndex();
            dataOutputStream2.writeByte(n3);
            return 1;
        }
        if (instruction.lvtIndex() <= 255) {
            Instruction instruction6 = instruction5;
            int n4 = instruction6.opCode();
            DataOutputStream dataOutputStream5 = dataOutputStream3;
            dataOutputStream5.writeByte(n4);
            int n5 = instruction6.lvtIndex();
            dataOutputStream5.writeByte(n5);
            return 2;
        }
        DataOutputStream dataOutputStream6 = dataOutputStream4;
        dataOutputStream6.writeByte(196);
        Instruction instruction7 = instruction4;
        int n6 = instruction7.opCode();
        dataOutputStream6.writeByte(n6);
        int n7 = instruction7.lvtIndex();
        dataOutputStream6.writeShort(n7);
        return 4;
    }

    void resolveConstants(ConstantPool constantPool) {
        ConstantPool constantPool2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Instruction instruction9 = instruction;
        Instruction instruction10 = instruction;
        Instruction instruction11 = instruction;
        Instruction instruction12 = instruction;
        Instruction instruction13 = instruction;
        Instruction instruction14 = instruction;
        Instruction instruction15 = instruction;
        Instruction instruction16 = instruction;
        Instruction instruction17 = instruction;
        Instruction instruction18 = instruction;
        Instruction instruction19 = instruction;
        Instruction instruction20 = instruction;
        Instruction instruction21 = instruction;
        Instruction instruction22 = instruction;
        Instruction instruction23 = instruction;
        Instruction instruction24 = instruction;
        Instruction instruction25 = instruction;
        Instruction instruction26 = instruction;
        Instruction instruction27 = instruction;
        Instruction instruction28 = instruction;
        Instruction instruction29 = instruction;
        Instruction instruction30 = instruction;
        Instruction instruction31 = instruction;
        Instruction instruction32 = instruction;
        Instruction instruction33 = instruction;
        Instruction instruction34 = instruction;
        Instruction instruction35 = instruction;
        Instruction instruction36 = instruction;
        Instruction instruction37 = instruction;
        Instruction instruction38 = instruction;
        Instruction instruction39 = instruction;
        Instruction instruction40 = instruction;
        Instruction instruction41 = instruction;
        Instruction instruction42 = instruction;
        ConstantPool constantPool3 = constantPool2 = constantPool;
        ConstantPool constantPool4 = constantPool2;
        ConstantPool constantPool5 = constantPool2;
        ConstantPool constantPool6 = constantPool2;
        ConstantPool constantPool7 = constantPool2;
        ConstantPool constantPool8 = constantPool2;
        ConstantPool constantPool9 = constantPool2;
        ConstantPool constantPool10 = constantPool2;
        Instruction instruction43 = instruction27;
        instruction43.setCpItemIndex(-1);
        switch (instruction43.opCode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (instruction18.realOpCode() != -1) break;
                Instruction instruction44 = instruction2;
                int n = instruction44.opCode();
                instruction44.setRealOpCode(n);
                break;
            }
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                Instruction instruction45 = instruction22;
                String string = instruction45.classRef();
                int n = constantPool10.internClass(string);
                instruction45.setCpItemIndex(n);
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                Instruction instruction46 = instruction35;
                String string = instruction46.classRef();
                String string2 = instruction46.elemName();
                Descriptor descriptor = instruction46.descriptor();
                int n = constantPool8.internMethodRef(string, string2, descriptor);
                instruction46.setCpItemIndex(n);
                break;
            }
            case 185: {
                Instruction instruction47 = instruction34;
                String string = instruction47.classRef();
                String string3 = instruction47.elemName();
                Descriptor descriptor = instruction47.descriptor();
                int n = constantPool7.internInterfaceMethodRef(string, string3, descriptor);
                instruction47.setCpItemIndex(n);
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                Instruction instruction48 = instruction9;
                instruction48.cpItemIndex();
                String string = instruction48.classRef();
                String string4 = instruction48.elemName();
                Type type = instruction48.type();
                int n = constantPool6.internFieldRef(string, string4, type);
                instruction48.setCpItemIndex(n);
                break;
            }
            case 256: {
                boolean bl;
                int n;
                int n2 = n = instruction26.realOpCode();
                boolean bl2 = n == -1;
                boolean bl3 = bl = bl2;
                boolean bl4 = bl;
                if (bl && -1 <= instruction19.immediate() && instruction23.immediate() <= 5) {
                    Instruction instruction49 = instruction32;
                    int n3 = 3 + instruction49.immediate();
                    instruction49.setRealOpCode(n3);
                    break;
                }
                if (bl4 && -128 <= instruction13.immediate() && instruction38.immediate() <= 127) {
                    instruction16.setRealOpCode(16);
                    break;
                }
                if (bl && Short.MIN_VALUE <= instruction31.immediate() && instruction40.immediate() <= Short.MAX_VALUE) {
                    instruction30.setRealOpCode(17);
                    break;
                }
                if (!bl3 && n != 18 && n2 != 19) break;
                Instruction instruction50 = instruction7;
                int n4 = instruction50.immediate();
                int n5 = constantPool5.internInteger(n4);
                instruction50.setCpItemIndex(n5);
                if (n5 <= 255) {
                    instruction41.setRealOpCode(18);
                    break;
                }
                instruction39.setRealOpCode(19);
                break;
            }
            case 257: {
                int n;
                int n6 = n = instruction6.realOpCode();
                boolean bl = n == -1;
                boolean bl5 = bl;
                if (bl5 && (instruction3.immediate_f() == 0.0 || instruction14.immediate_f() == 1.0 || instruction17.immediate_f() == 2.0)) {
                    Instruction instruction51 = instruction10;
                    int n7 = (int)instruction51.immediate_f();
                    instruction51.setRealOpCode(11 + n7);
                    break;
                }
                if (!bl5 && n != 18 && n6 != 19) break;
                Instruction instruction52 = instruction33;
                float f = (float)instruction52.immediate_f();
                int n8 = constantPool3.internFloat(f);
                instruction52.setCpItemIndex(n8);
                if (n8 <= 255) {
                    instruction15.setRealOpCode(18);
                    break;
                }
                instruction21.setRealOpCode(19);
                break;
            }
            case 260: {
                Instruction instruction53 = instruction8;
                String string = instruction53.immediate_s();
                int n = constantPool9.internString(string);
                instruction53.setCpItemIndex(n);
                if (n <= 255) {
                    instruction25.setRealOpCode(18);
                    break;
                }
                instruction5.setRealOpCode(19);
                break;
            }
            case 259: {
                int n = instruction24.realOpCode();
                boolean bl = n == -1;
                boolean bl6 = bl;
                if (bl6 && (instruction.immediate_f() == 0.0 || instruction42.immediate_f() == 1.0)) {
                    Instruction instruction54 = instruction36;
                    int n9 = (int)instruction54.immediate_f();
                    instruction54.setRealOpCode(14 + n9);
                    break;
                }
                if (!bl6 && n != 20) break;
                Instruction instruction55 = instruction37;
                double d = instruction55.immediate_f();
                int n10 = constantPool2.internDouble(d);
                instruction55.setCpItemIndex(n10);
                instruction55.setRealOpCode(20);
                break;
            }
            case 258: {
                int n = instruction29.realOpCode();
                boolean bl = n == -1;
                boolean bl7 = bl;
                if (bl7 && (instruction28.immediate_l() == 0L || instruction4.immediate_l() == 1L)) {
                    Instruction instruction56 = instruction12;
                    int n11 = (int)instruction56.immediate_l();
                    instruction56.setRealOpCode(9 + n11);
                    break;
                }
                if (!bl7 && n != 20) break;
                Instruction instruction57 = instruction20;
                long l = instruction57.immediate_l();
                int n12 = constantPool4.internLong(l);
                instruction57.setCpItemIndex(n12);
                instruction57.setRealOpCode(20);
                break;
            }
            default: {
                Instruction instruction58 = instruction11;
                int n = instruction58.opCode();
                instruction58.setRealOpCode(n);
            }
        }
    }

    public int writeFile(DataOutputStream dataOutputStream, int n) throws RuntimeException, IOException {
        int n2;
        int n3;
        int n4;
        DataOutputStream dataOutputStream2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Instruction instruction9 = instruction;
        Instruction instruction10 = instruction;
        Instruction instruction11 = instruction;
        Instruction instruction12 = instruction;
        Instruction instruction13 = instruction;
        Instruction instruction14 = instruction;
        Instruction instruction15 = instruction;
        Instruction instruction16 = instruction;
        Instruction instruction17 = instruction;
        Instruction instruction18 = instruction;
        Instruction instruction19 = instruction;
        Instruction instruction20 = instruction;
        Instruction instruction21 = instruction;
        Instruction instruction22 = instruction;
        Instruction instruction23 = instruction;
        Instruction instruction24 = instruction;
        Instruction instruction25 = instruction;
        Instruction instruction26 = instruction;
        Instruction instruction27 = instruction;
        Instruction instruction28 = instruction;
        Instruction instruction29 = instruction;
        Instruction instruction30 = instruction;
        Instruction instruction31 = instruction;
        Instruction instruction32 = instruction;
        Instruction instruction33 = instruction;
        Instruction instruction34 = instruction;
        Instruction instruction35 = instruction;
        Instruction instruction36 = instruction;
        Instruction instruction37 = instruction;
        Instruction instruction38 = instruction;
        Instruction instruction39 = instruction;
        Instruction instruction40 = instruction;
        Instruction instruction41 = instruction;
        Instruction instruction42 = instruction;
        Instruction instruction43 = instruction;
        Instruction instruction44 = instruction;
        Instruction instruction45 = instruction;
        Instruction instruction46 = instruction;
        Instruction instruction47 = instruction;
        Instruction instruction48 = instruction;
        Instruction instruction49 = instruction;
        Instruction instruction50 = instruction;
        Instruction instruction51 = instruction;
        Instruction instruction52 = instruction;
        Instruction instruction53 = instruction;
        Instruction instruction54 = instruction;
        Instruction instruction55 = instruction;
        Instruction instruction56 = instruction;
        Instruction instruction57 = instruction;
        Instruction instruction58 = instruction;
        Instruction instruction59 = instruction;
        Instruction instruction60 = instruction;
        DataOutputStream dataOutputStream3 = dataOutputStream2 = dataOutputStream;
        DataOutputStream dataOutputStream4 = dataOutputStream2;
        DataOutputStream dataOutputStream5 = dataOutputStream2;
        DataOutputStream dataOutputStream6 = dataOutputStream2;
        DataOutputStream dataOutputStream7 = dataOutputStream2;
        DataOutputStream dataOutputStream8 = dataOutputStream2;
        DataOutputStream dataOutputStream9 = dataOutputStream2;
        DataOutputStream dataOutputStream10 = dataOutputStream2;
        DataOutputStream dataOutputStream11 = dataOutputStream2;
        DataOutputStream dataOutputStream12 = dataOutputStream2;
        DataOutputStream dataOutputStream13 = dataOutputStream2;
        DataOutputStream dataOutputStream14 = dataOutputStream2;
        DataOutputStream dataOutputStream15 = dataOutputStream2;
        DataOutputStream dataOutputStream16 = dataOutputStream2;
        DataOutputStream dataOutputStream17 = dataOutputStream2;
        DataOutputStream dataOutputStream18 = dataOutputStream2;
        DataOutputStream dataOutputStream19 = dataOutputStream2;
        DataOutputStream dataOutputStream20 = dataOutputStream2;
        DataOutputStream dataOutputStream21 = dataOutputStream2;
        DataOutputStream dataOutputStream22 = dataOutputStream2;
        DataOutputStream dataOutputStream23 = dataOutputStream2;
        DataOutputStream dataOutputStream24 = dataOutputStream2;
        DataOutputStream dataOutputStream25 = dataOutputStream2;
        DataOutputStream dataOutputStream26 = dataOutputStream2;
        DataOutputStream dataOutputStream27 = dataOutputStream2;
        DataOutputStream dataOutputStream28 = dataOutputStream2;
        DataOutputStream dataOutputStream29 = dataOutputStream2;
        DataOutputStream dataOutputStream30 = dataOutputStream2;
        DataOutputStream dataOutputStream31 = dataOutputStream2;
        DataOutputStream dataOutputStream32 = dataOutputStream2;
        DataOutputStream dataOutputStream33 = dataOutputStream2;
        DataOutputStream dataOutputStream34 = dataOutputStream2;
        DataOutputStream dataOutputStream35 = dataOutputStream2;
        DataOutputStream dataOutputStream36 = dataOutputStream2;
        DataOutputStream dataOutputStream37 = dataOutputStream2;
        DataOutputStream dataOutputStream38 = dataOutputStream2;
        DataOutputStream dataOutputStream39 = dataOutputStream2;
        DataOutputStream dataOutputStream40 = dataOutputStream2;
        DataOutputStream dataOutputStream41 = dataOutputStream2;
        DataOutputStream dataOutputStream42 = dataOutputStream2;
        DataOutputStream dataOutputStream43 = dataOutputStream2;
        DataOutputStream dataOutputStream44 = dataOutputStream2;
        DataOutputStream dataOutputStream45 = dataOutputStream2;
        DataOutputStream dataOutputStream46 = dataOutputStream2;
        DataOutputStream dataOutputStream47 = dataOutputStream2;
        DataOutputStream dataOutputStream48 = dataOutputStream2;
        DataOutputStream dataOutputStream49 = dataOutputStream2;
        int n5 = n4 = n;
        block0 : switch (instruction60.opCode()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                int n6 = instruction37.opCode();
                dataOutputStream10.writeByte(n6);
                n3 = 1;
                n2 = 1;
                break;
            }
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                Instruction instruction61 = instruction7;
                int n7 = instruction61.opCode();
                DataOutputStream dataOutputStream50 = dataOutputStream44;
                dataOutputStream50.writeByte(n7);
                int n8 = instruction61.cpItemIndex();
                dataOutputStream50.writeShort(n8);
                n3 = 3;
                n2 = 3;
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                Instruction instruction62 = instruction39;
                int n9 = instruction62.opCode();
                DataOutputStream dataOutputStream51 = dataOutputStream48;
                dataOutputStream51.writeByte(n9);
                int n10 = instruction62.cpItemIndex();
                dataOutputStream51.writeShort(n10);
                n3 = 3;
                n2 = 3;
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                Instruction instruction63 = instruction56;
                int n11 = instruction63.opCode();
                DataOutputStream dataOutputStream52 = dataOutputStream13;
                dataOutputStream52.writeByte(n11);
                int n12 = instruction63.cpItemIndex();
                dataOutputStream52.writeShort(n12);
                n3 = 3;
                n2 = 3;
                break;
            }
            case 188: {
                n3 = 2;
                n2 = 2;
                Instruction instruction64 = instruction19;
                int n13 = instruction64.opCode();
                DataOutputStream dataOutputStream53 = dataOutputStream14;
                dataOutputStream53.writeByte(n13);
                int n14 = instruction64.immediate();
                dataOutputStream53.writeByte(n14);
                break;
            }
            case 197: {
                n3 = 4;
                n2 = 4;
                Instruction instruction65 = instruction35;
                int n15 = instruction65.opCode();
                DataOutputStream dataOutputStream54 = dataOutputStream28;
                dataOutputStream54.writeByte(n15);
                int n16 = instruction65.cpItemIndex();
                dataOutputStream54.writeShort(n16);
                int n17 = instruction65.immediate();
                dataOutputStream54.writeByte(n17);
                break;
            }
            case 169: {
                n3 = 2;
                n2 = 2;
                Instruction instruction66 = instruction30;
                int n18 = instruction66.opCode();
                DataOutputStream dataOutputStream55 = dataOutputStream12;
                dataOutputStream55.writeByte(n18);
                int n19 = instruction66.lvtIndex();
                dataOutputStream55.writeByte(n19);
                break;
            }
            case 185: {
                Instruction instruction67 = instruction41;
                int n20 = instruction67.opCode();
                DataOutputStream dataOutputStream56 = dataOutputStream24;
                dataOutputStream56.writeByte(n20);
                int n21 = instruction67.cpItemIndex();
                dataOutputStream56.writeShort(n21);
                Descriptor descriptor = instruction67.descriptor();
                int n22 = descriptor.count();
                dataOutputStream56.writeByte(n22);
                dataOutputStream56.writeByte(0);
                n3 = 5;
                n2 = 5;
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                Instruction instruction68 = instruction47;
                int n23 = instruction68.opCode();
                DataOutputStream dataOutputStream57 = dataOutputStream19;
                dataOutputStream57.writeByte(n23);
                BranchTarget branchTarget = instruction68.branchTarget();
                int n24 = branchTarget.offset;
                dataOutputStream57.writeShort(n24);
                n3 = 3;
                n2 = 3;
                break;
            }
            case 168: {
                if (instruction26.realOpCode() == 168) {
                    DataOutputStream dataOutputStream58 = dataOutputStream9;
                    dataOutputStream58.writeByte(168);
                    BranchTarget branchTarget = instruction43.branchTarget();
                    int n25 = branchTarget.offset;
                    dataOutputStream58.writeShort(n25);
                    n3 = 3;
                    n2 = 3;
                    break;
                }
                DataOutputStream dataOutputStream59 = dataOutputStream5;
                dataOutputStream59.writeByte(201);
                BranchTarget branchTarget = instruction50.branchTarget();
                int n26 = branchTarget.offset;
                dataOutputStream59.writeInt(n26);
                n3 = 5;
                n2 = 5;
                break;
            }
            case 167: {
                if (instruction27.realOpCode() == 167) {
                    DataOutputStream dataOutputStream60 = dataOutputStream47;
                    dataOutputStream60.writeByte(167);
                    BranchTarget branchTarget = instruction34.branchTarget();
                    int n27 = branchTarget.offset;
                    dataOutputStream60.writeShort(n27);
                    n3 = 3;
                    n2 = 3;
                    break;
                }
                DataOutputStream dataOutputStream61 = dataOutputStream8;
                dataOutputStream61.writeByte(200);
                BranchTarget branchTarget = instruction20.branchTarget();
                int n28 = branchTarget.offset;
                dataOutputStream61.writeInt(n28);
                n3 = 5;
                n2 = 5;
                break;
            }
            case 170: {
                int n29;
                int n30 = instruction36.opCode();
                dataOutputStream20.writeByte(n30);
                int n31 = 1;
                int n32 = 1;
                int n33 = n29 = n5 + 1;
                while (n33 % 4 != 0) {
                    int n34 = n31;
                    n32 = n31 = n34 + 1;
                    dataOutputStream17.writeByte(0);
                    int n35 = n29;
                    n33 = n29 = n35 + 1;
                }
                Instruction instruction69 = instruction58;
                BranchTarget branchTarget = instruction69.branchTarget();
                int n36 = branchTarget.offset;
                DataOutputStream dataOutputStream62 = dataOutputStream29;
                dataOutputStream62.writeInt(n36);
                int n37 = instruction69.immediate();
                dataOutputStream62.writeInt(n37);
                int n38 = instruction69.immediate();
                int n39 = instruction69.switchArray().length;
                dataOutputStream62.writeInt(n38 + n39 - 1);
                int n40 = 0;
                int n41 = 0;
                while (n40 < instruction51.switchArray().length) {
                    BranchTarget[] branchTargetArray = instruction42.switchArray();
                    int n42 = n41;
                    BranchTarget branchTarget2 = branchTargetArray[n42];
                    int n43 = branchTarget2.offset;
                    dataOutputStream26.writeInt(n43);
                    n41 = n40 = n42 + 1;
                }
                n2 = n3 = n32 + (12 + instruction16.switchArray().length * 4);
                break;
            }
            case 171: {
                int n44;
                int n45 = instruction12.opCode();
                dataOutputStream33.writeByte(n45);
                int n46 = 1;
                int n47 = 1;
                int n48 = n44 = n4 + 1;
                while (n44 % 4 != 0) {
                    dataOutputStream22.writeByte(0);
                    int n49 = n47;
                    n47 = n46 = n49 + 1;
                    int n50 = n48;
                    n48 = n44 = n50 + 1;
                }
                Instruction instruction70 = instruction;
                BranchTarget branchTarget = instruction70.branchTarget();
                int n51 = branchTarget.offset;
                DataOutputStream dataOutputStream63 = dataOutputStream23;
                dataOutputStream63.writeInt(n51);
                int n52 = instruction70.switchArray().length;
                dataOutputStream63.writeInt(n52);
                int n53 = 0;
                int n54 = 0;
                while (n54 < instruction4.switchArray().length) {
                    Instruction instruction71 = instruction40;
                    BranchTarget[] branchTargetArray = instruction71.switchArray();
                    int n55 = n53;
                    BranchTarget branchTarget3 = branchTargetArray[n55];
                    int n56 = branchTarget3.key;
                    DataOutputStream dataOutputStream64 = dataOutputStream46;
                    dataOutputStream64.writeInt(n56);
                    BranchTarget[] branchTargetArray2 = instruction71.switchArray();
                    BranchTarget branchTarget4 = branchTargetArray2[n55];
                    n54 = n53 = n55 + 1;
                    int n57 = branchTarget4.offset;
                    dataOutputStream64.writeInt(n57);
                }
                n2 = n3 = n46 + (8 + instruction31.switchArray().length * 8);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                int n58 = instruction22.opCode();
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = stringBuffer.append("bad opcode for writing ");
                StringBuffer stringBuffer3 = stringBuffer2.append(n58);
                String string = stringBuffer3.toString();
                throw new RuntimeException(string);
            }
            case 21: {
                n2 = n3 = instruction59.generate_loadstore(dataOutputStream15, 26);
                break;
            }
            case 23: {
                n2 = n3 = instruction32.generate_loadstore(dataOutputStream18, 34);
                break;
            }
            case 22: {
                n2 = n3 = instruction5.generate_loadstore(dataOutputStream42, 30);
                break;
            }
            case 24: {
                n2 = n3 = instruction28.generate_loadstore(dataOutputStream37, 38);
                break;
            }
            case 25: {
                n2 = n3 = instruction3.generate_loadstore(dataOutputStream25, 42);
                break;
            }
            case 54: {
                n2 = n3 = instruction17.generate_loadstore(dataOutputStream41, 59);
                break;
            }
            case 56: {
                n2 = n3 = instruction48.generate_loadstore(dataOutputStream6, 67);
                break;
            }
            case 55: {
                n2 = n3 = instruction10.generate_loadstore(dataOutputStream11, 63);
                break;
            }
            case 57: {
                n2 = n3 = instruction14.generate_loadstore(dataOutputStream43, 71);
                break;
            }
            case 58: {
                n2 = n3 = instruction11.generate_loadstore(dataOutputStream27, 75);
                break;
            }
            case 132: {
                if (instruction18.lvtIndex() <= 255 && -128 <= instruction38.immediate() && instruction21.immediate() <= 127) {
                    Instruction instruction72 = instruction44;
                    int n59 = instruction72.opCode();
                    DataOutputStream dataOutputStream65 = dataOutputStream31;
                    dataOutputStream65.writeByte(n59);
                    int n60 = instruction72.lvtIndex();
                    dataOutputStream65.writeByte(n60);
                    int n61 = instruction72.immediate();
                    dataOutputStream65.writeByte(n61);
                    n3 = 3;
                    n2 = 3;
                    break;
                }
                DataOutputStream dataOutputStream66 = dataOutputStream21;
                dataOutputStream66.writeByte(196);
                Instruction instruction73 = instruction2;
                int n62 = instruction73.opCode();
                dataOutputStream66.writeByte(n62);
                int n63 = instruction73.lvtIndex();
                dataOutputStream66.writeShort(n63);
                int n64 = instruction73.immediate();
                dataOutputStream66.writeShort(n64);
                n3 = 6;
                n2 = 6;
                break;
            }
            case 256: {
                Instruction instruction74 = instruction49;
                int n65 = instruction74.realOpCode();
                dataOutputStream2.writeByte(n65);
                switch (instruction74.realOpCode()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        n3 = 1;
                        n2 = 1;
                        break block0;
                    }
                    case 16: {
                        int n66 = instruction46.immediate();
                        dataOutputStream38.writeByte(n66);
                        n3 = 2;
                        n2 = 2;
                        break block0;
                    }
                    case 17: {
                        int n67 = instruction13.immediate();
                        dataOutputStream36.writeShort(n67);
                        n3 = 3;
                        n2 = 3;
                        break block0;
                    }
                    case 18: {
                        n3 = 2;
                        n2 = 2;
                        int n68 = instruction52.cpItemIndex();
                        dataOutputStream49.writeByte(n68);
                        break block0;
                    }
                    case 19: {
                        int n69 = instruction6.cpItemIndex();
                        dataOutputStream35.writeShort(n69);
                        n3 = 3;
                        n2 = 3;
                        break block0;
                    }
                }
                int n70 = instruction8.realOpCode();
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer4 = stringBuffer.append("no hint for AOP_IPUSH ");
                StringBuffer stringBuffer5 = stringBuffer4.append(n70);
                String string = stringBuffer5.toString();
                throw new RuntimeException(string);
            }
            case 257: {
                Instruction instruction75 = instruction55;
                int n71 = instruction75.realOpCode();
                dataOutputStream39.writeByte(n71);
                switch (instruction75.realOpCode()) {
                    case 11: 
                    case 12: 
                    case 13: {
                        n3 = 1;
                        n2 = 1;
                        break block0;
                    }
                    case 18: {
                        int n72 = instruction23.cpItemIndex();
                        dataOutputStream40.writeByte(n72);
                        n3 = 2;
                        n2 = 2;
                        break block0;
                    }
                    case 19: {
                        int n73 = instruction33.cpItemIndex();
                        dataOutputStream3.writeShort(n73);
                        n3 = 3;
                        n2 = 3;
                        break block0;
                    }
                }
                throw new RuntimeException("no hint for AOP_FPUSH");
            }
            case 259: {
                Instruction instruction76 = instruction53;
                int n74 = instruction76.realOpCode();
                dataOutputStream45.writeByte(n74);
                switch (instruction76.realOpCode()) {
                    case 14: 
                    case 15: {
                        n3 = 1;
                        n2 = 1;
                        break block0;
                    }
                    case 20: {
                        int n75 = instruction29.cpItemIndex();
                        dataOutputStream4.writeShort(n75);
                        n3 = 3;
                        n2 = 3;
                        break block0;
                    }
                }
                throw new RuntimeException("no hint for AOP_DPUSH");
            }
            case 258: {
                Instruction instruction77 = instruction15;
                int n76 = instruction77.realOpCode();
                dataOutputStream16.writeByte(n76);
                switch (instruction77.realOpCode()) {
                    case 9: 
                    case 10: {
                        n3 = 1;
                        n2 = 1;
                        break block0;
                    }
                    case 20: {
                        int n77 = instruction57.cpItemIndex();
                        dataOutputStream30.writeShort(n77);
                        n3 = 3;
                        n2 = 3;
                        break block0;
                    }
                }
                throw new RuntimeException("no hint for AOP_LPUSH");
            }
            case 260: {
                Instruction instruction78 = instruction25;
                int n78 = instruction78.realOpCode();
                dataOutputStream34.writeByte(n78);
                switch (instruction78.realOpCode()) {
                    case 18: {
                        int n79 = instruction9.cpItemIndex();
                        dataOutputStream32.writeByte(n79);
                        n3 = 2;
                        n2 = 2;
                        break block0;
                    }
                    case 19: {
                        int n80 = instruction45.cpItemIndex();
                        dataOutputStream7.writeShort(n80);
                        n3 = 3;
                        n2 = 3;
                        break block0;
                    }
                }
                throw new RuntimeException("no hint for AOP_SPUSH");
            }
            case 513: 
            case 514: {
                return 0;
            }
            default: {
                int n81 = instruction54.opCode();
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer6 = stringBuffer.append("bad opcode ");
                StringBuffer stringBuffer7 = stringBuffer6.append(n81);
                String string = stringBuffer7.toString();
                throw new RuntimeException(string);
            }
        }
        if (n2 == 0) {
            int n82 = instruction24.opCode();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer8 = stringBuffer.append("size not set ");
            StringBuffer stringBuffer9 = stringBuffer8.append(n82);
            String string = stringBuffer9.toString();
            throw new RuntimeException(string);
        }
        return n3;
    }

    public static long unextend32(long l) {
        long l2;
        long l3 = l2 = l;
        long l4 = l2;
        if (l4 < 0L) {
            l3 = l2 + 0x100000000L;
        }
        return l3;
    }

    public static int unextend16(int n) {
        int n2;
        int n3 = n2 = n;
        int n4 = n2;
        if (n2 < 0) {
            n3 = n4 + 65536;
        }
        return n3;
    }

    public static int unextend8(int n) {
        int n2;
        int n3 = n2 = n;
        int n4 = n2;
        if (n4 < 0) {
            n2 = n3 + 256;
        }
        return n2;
    }

    public static int extend8(int n) {
        int n2;
        int n3 = n2 = n;
        int n4 = n2;
        if (n4 > 127) {
            n2 = n3 - 256;
        }
        return n2;
    }

    public static int extend16(int n) {
        int n2;
        int n3 = n2 = n;
        int n4 = n2;
        if (n3 > Short.MAX_VALUE) {
            n4 = n2 - 65536;
        }
        return n4;
    }

    public boolean usesLocals() {
        Instruction instruction = this;
        switch (instruction.opCode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 132: 
            case 169: {
                return true;
            }
        }
        return false;
    }

    public Type localType() {
        Instruction instruction = this;
        switch (instruction.opCode()) {
            case 169: {
                return Type.RETADDR;
            }
            case 23: 
            case 56: {
                return Type.FLOAT;
            }
            case 25: 
            case 58: {
                return Type.OBJECT;
            }
            case 22: 
            case 55: {
                return Type.LONG;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE;
            }
            case 21: 
            case 54: 
            case 132: {
                return Type.INT;
            }
        }
        return null;
    }

    public boolean isStore() {
        Instruction instruction = this;
        switch (instruction.opCode()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 132: {
                return true;
            }
        }
        return false;
    }

    public boolean isLoad() {
        Instruction instruction = this;
        switch (instruction.opCode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 132: 
            case 169: {
                return true;
            }
        }
        return false;
    }

    public boolean usesMethod() {
        Instruction instruction = this;
        switch (instruction.opCode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                return true;
            }
        }
        return false;
    }

    public boolean usesField() {
        Instruction instruction = this;
        switch (instruction.opCode()) {
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                return true;
            }
        }
        return false;
    }

    public boolean usesClass() {
        Instruction instruction = this;
        switch (instruction.opCode()) {
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                return true;
            }
        }
        return false;
    }

    boolean isLongjump() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        boolean bl = instruction.realOpCode() == 200 || instruction2.realOpCode() == 201;
        return bl;
    }

    void setLongjump(boolean bl) {
        boolean bl2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        boolean bl3 = bl2 = bl;
        boolean bl4 = bl2;
        switch (instruction2.opCode()) {
            case 167: {
                int n = bl3 ? 200 : 167;
                instruction.setRealOpCode(n);
                break;
            }
            case 168: {
                int n = bl2 ? 201 : 168;
                instruction4.setRealOpCode(n);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 170: 
            case 171: 
            case 198: 
            case 199: {
                if (bl4) {
                    throw new GlobalException("attempt to call setLongJump on a branch type that does not support it");
                }
            }
            default: {
                throw new GlobalException("attempt to call setLongJump on a opcode that does not support it");
            }
        }
    }

    public int countArgs() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        switch (instruction.opCode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: 
            case 180: 
            case 188: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 198: 
            case 199: 
            case 515: {
                return 1;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return 2;
            }
            case 167: 
            case 168: 
            case 177: 
            case 178: 
            case 187: 
            case 256: {
                return 0;
            }
            case 182: 
            case 183: 
            case 185: {
                Descriptor descriptor = instruction3.descriptor();
                return descriptor.count();
            }
            case 184: {
                Descriptor descriptor = instruction2.descriptor();
                return descriptor.count() - 1;
            }
            case 516: {
                throw new IllegalStateException("countArgs called for label");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("unimplemented: ");
        String string = instruction4.recString();
        StringBuffer stringBuffer3 = stringBuffer2.append(string);
        String string2 = stringBuffer3.toString();
        throw new RuntimeException(string2);
    }

    public int countRets() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        switch (instruction2.opCode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 179: 
            case 181: 
            case 191: 
            case 192: 
            case 198: 
            case 199: 
            case 515: {
                return 0;
            }
            case 1: 
            case 168: 
            case 187: 
            case 188: 
            case 189: 
            case 193: 
            case 197: 
            case 256: {
                return 1;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                Descriptor descriptor = instruction4.descriptor();
                Type type = descriptor.ret;
                return type.category();
            }
            case 178: 
            case 180: {
                Type type = instruction.type();
                return type.category();
            }
            case 516: {
                throw new IllegalStateException("countRets called for label");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("unimplemented: ");
        String string = instruction3.recString();
        StringBuffer stringBuffer3 = stringBuffer2.append(string);
        String string2 = stringBuffer3.toString();
        throw new RuntimeException(string2);
    }

    public int stackUse() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        return instruction2.countArgs() - instruction2.countRets();
    }

    public boolean usesBranch() {
        Instruction instruction = this;
        switch (instruction.opCode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 198: 
            case 199: {
                return true;
            }
        }
        return false;
    }

    public boolean isReturn() {
        int n;
        Instruction instruction = this;
        int n2 = n = instruction.opCode();
        int n3 = n;
        int n4 = n;
        int n5 = n;
        return n == 177 || n2 == 172 || n == 173 || n5 == 176 || n3 == 174 || n4 == 175;
    }

    public boolean isSwitch() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        boolean bl = instruction.opCode() == 170 || instruction2.opCode() == 171;
        return bl;
    }

    public static int invCondition(int n) {
        int n2;
        int n3 = n2 = n;
        switch (n2) {
            case 198: {
                return 199;
            }
            case 199: {
                return 198;
            }
            case 153: {
                return 154;
            }
            case 154: {
                return 153;
            }
            case 158: {
                return 157;
            }
            case 155: {
                return 156;
            }
            case 157: {
                return 158;
            }
            case 156: {
                return 155;
            }
            case 165: {
                return 166;
            }
            case 166: {
                return 165;
            }
            case 159: {
                return 160;
            }
            case 160: {
                return 159;
            }
            case 164: {
                return 163;
            }
            case 161: {
                return 162;
            }
            case 163: {
                return 164;
            }
            case 162: {
                return 161;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("Not a conditional jump: ");
        StringBuffer stringBuffer3 = stringBuffer2.append(n3);
        String string = stringBuffer3.toString();
        throw new IllegalStateException(string);
    }

    Instruction advanceLocals(int n) {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        int n2 = n;
        if (instruction3.usesLocals()) {
            Instruction instruction4 = instruction2;
            int n3 = instruction4.lvtIndex() + n2;
            instruction4.setLvtIndex(n3);
        }
        return instruction;
    }

    int preferablyRealOpCode() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        int n = instruction.realOpCode() == -1 ? instruction3.opCode() : instruction2.realOpCode();
        return n;
    }

    public String recString() {
        Instruction instruction = this;
        return instruction.recString(true);
    }

    String recString(boolean bl) {
        int n;
        boolean bl2;
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Instruction instruction9 = instruction;
        Instruction instruction10 = instruction;
        Instruction instruction11 = instruction;
        Instruction instruction12 = instruction;
        Instruction instruction13 = instruction;
        Instruction instruction14 = instruction;
        Instruction instruction15 = instruction;
        Instruction instruction16 = instruction;
        Instruction instruction17 = instruction;
        Instruction instruction18 = instruction;
        Instruction instruction19 = instruction;
        Instruction instruction20 = instruction;
        Instruction instruction21 = instruction;
        Instruction instruction22 = instruction;
        Instruction instruction23 = instruction;
        Instruction instruction24 = instruction;
        Instruction instruction25 = instruction;
        Instruction instruction26 = instruction;
        Instruction instruction27 = instruction;
        Instruction instruction28 = instruction;
        Instruction instruction29 = instruction;
        Instruction instruction30 = instruction;
        Instruction instruction31 = instruction;
        Instruction instruction32 = instruction;
        Instruction instruction33 = instruction;
        Instruction instruction34 = instruction;
        Instruction instruction35 = instruction;
        Instruction instruction36 = instruction;
        Instruction instruction37 = instruction;
        Instruction instruction38 = instruction;
        Instruction instruction39 = instruction;
        Instruction instruction40 = instruction;
        Instruction instruction41 = instruction;
        boolean bl3 = bl2 = bl;
        int n2 = n = instruction19.preferablyRealOpCode();
        if (n == 196) {
            n2 = n = instruction15.opCode();
        }
        switch (n2) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                if (!bl2 || instruction29.branchTarget() == null) {
                    String[] stringArray = mnemonics;
                    int n3 = instruction28.preferablyRealOpCode();
                    return stringArray[n3];
                }
                BranchTarget branchTarget = instruction5.branchTarget();
                if (branchTarget.instr != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    String[] stringArray = mnemonics;
                    Instruction instruction42 = instruction41;
                    int n4 = instruction42.preferablyRealOpCode();
                    String string = stringArray[n4];
                    StringBuffer stringBuffer2 = stringBuffer.append(string);
                    StringBuffer stringBuffer3 = stringBuffer2.append(" ");
                    BranchTarget branchTarget2 = instruction42.branchTarget();
                    Instruction instruction43 = branchTarget2.instr;
                    int n5 = instruction43.pc();
                    StringBuffer stringBuffer4 = stringBuffer3.append(n5);
                    return stringBuffer4.toString();
                }
                BranchTarget branchTarget3 = instruction26.branchTarget();
                if (branchTarget3.block != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    String[] stringArray = mnemonics;
                    Instruction instruction44 = instruction31;
                    int n6 = instruction44.preferablyRealOpCode();
                    String string = stringArray[n6];
                    StringBuffer stringBuffer5 = stringBuffer.append(string);
                    StringBuffer stringBuffer6 = stringBuffer5.append(" #B");
                    BranchTarget branchTarget4 = instruction44.branchTarget();
                    Block block = branchTarget4.block;
                    int n7 = block.swval;
                    StringBuffer stringBuffer7 = stringBuffer6.append(n7);
                    return stringBuffer7.toString();
                }
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = mnemonics;
                int n8 = instruction25.preferablyRealOpCode();
                String string = stringArray[n8];
                StringBuffer stringBuffer8 = stringBuffer.append(string);
                StringBuffer stringBuffer9 = stringBuffer8.append(" _");
                return stringBuffer9.toString();
            }
            case 170: 
            case 171: {
                BranchTarget[] branchTargetArray;
                StringBuffer stringBuffer;
                if (!bl3 || instruction36.branchTarget() == null) {
                    String[] stringArray = mnemonics;
                    int n9 = instruction9.preferablyRealOpCode();
                    return stringArray[n9];
                }
                StringBuffer stringBuffer10 = stringBuffer = new StringBuffer();
                StringBuffer stringBuffer11 = stringBuffer;
                StringBuffer stringBuffer12 = stringBuffer;
                StringBuffer stringBuffer13 = stringBuffer;
                StringBuffer stringBuffer14 = stringBuffer;
                StringBuffer stringBuffer15 = stringBuffer;
                StringBuffer stringBuffer16 = stringBuffer;
                StringBuffer stringBuffer17 = stringBuffer;
                Instruction instruction45 = instruction18;
                BranchTarget[] branchTargetArray2 = branchTargetArray = instruction45.switchArray();
                BranchTarget[] branchTargetArray3 = branchTargetArray;
                BranchTarget[] branchTargetArray4 = branchTargetArray;
                BranchTarget[] branchTargetArray5 = branchTargetArray;
                BranchTarget[] branchTargetArray6 = branchTargetArray;
                BranchTarget branchTarget = instruction45.branchTarget();
                if (branchTarget.instr != null) {
                    StringBuffer stringBuffer18 = new StringBuffer();
                    String[] stringArray = mnemonics;
                    Instruction instruction46 = instruction34;
                    int n10 = instruction46.preferablyRealOpCode();
                    String string = stringArray[n10];
                    StringBuffer stringBuffer19 = stringBuffer18.append(string);
                    StringBuffer stringBuffer20 = stringBuffer19.append(" ");
                    BranchTarget branchTarget5 = instruction46.branchTarget();
                    Instruction instruction47 = branchTarget5.instr;
                    int n11 = instruction47.pc();
                    StringBuffer stringBuffer21 = stringBuffer20.append(n11);
                    String string2 = stringBuffer21.toString();
                    stringBuffer14.append(string2);
                } else {
                    BranchTarget branchTarget6 = instruction27.branchTarget();
                    if (branchTarget6.block != null) {
                        StringBuffer stringBuffer22 = new StringBuffer();
                        String[] stringArray = mnemonics;
                        Instruction instruction48 = instruction38;
                        int n12 = instruction48.preferablyRealOpCode();
                        String string = stringArray[n12];
                        StringBuffer stringBuffer23 = stringBuffer22.append(string);
                        StringBuffer stringBuffer24 = stringBuffer23.append(" #B");
                        BranchTarget branchTarget7 = instruction48.branchTarget();
                        Block block = branchTarget7.block;
                        int n13 = block.swval;
                        StringBuffer stringBuffer25 = stringBuffer24.append(n13);
                        String string3 = stringBuffer25.toString();
                        stringBuffer.append(string3);
                    } else {
                        StringBuffer stringBuffer26 = new StringBuffer();
                        String[] stringArray = mnemonics;
                        int n14 = instruction32.preferablyRealOpCode();
                        String string = stringArray[n14];
                        StringBuffer stringBuffer27 = stringBuffer26.append(string);
                        StringBuffer stringBuffer28 = stringBuffer27.append(" _");
                        String string4 = stringBuffer28.toString();
                        stringBuffer12.append(string4);
                    }
                }
                if (branchTargetArray6 == null) {
                    return stringBuffer11.toString();
                }
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                int n20 = 0;
                while (n17 < branchTargetArray3.length) {
                    StringBuffer stringBuffer29 = stringBuffer13;
                    stringBuffer29.append(" ");
                    int n21 = n20;
                    int n22 = instruction23.immediate() + n21;
                    stringBuffer29.append(n22);
                    stringBuffer29.append(":");
                    BranchTarget branchTarget8 = branchTargetArray5[n21];
                    if (branchTarget8.instr != null) {
                        BranchTarget branchTarget9 = branchTargetArray[n19];
                        Instruction instruction49 = branchTarget9.instr;
                        int n23 = instruction49.pc();
                        stringBuffer10.append(n23);
                    } else {
                        BranchTarget branchTarget10 = branchTargetArray2[n18];
                        if (branchTarget10.block != null) {
                            StringBuffer stringBuffer30 = new StringBuffer();
                            StringBuffer stringBuffer31 = stringBuffer30.append("#B");
                            BranchTarget branchTarget11 = branchTargetArray4[n16];
                            Block block = branchTarget11.block;
                            int n24 = block.swval;
                            StringBuffer stringBuffer32 = stringBuffer31.append(n24);
                            String string = stringBuffer32.toString();
                            stringBuffer16.append(string);
                        } else {
                            stringBuffer15.append("_");
                        }
                    }
                    int n25 = n15;
                    n16 = n15 = n25 + 1;
                    n17 = n15;
                    n18 = n15;
                    n19 = n15;
                    n20 = n15;
                }
                return stringBuffer17.toString();
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = mnemonics;
                Instruction instruction50 = instruction39;
                int n26 = instruction50.opCode();
                String string = stringArray[n26];
                StringBuffer stringBuffer33 = stringBuffer.append(string);
                StringBuffer stringBuffer34 = stringBuffer33.append(" ");
                int n27 = instruction50.lvtIndex();
                StringBuffer stringBuffer35 = stringBuffer34.append(n27);
                return stringBuffer35.toString();
            }
            case 132: {
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = mnemonics;
                Instruction instruction51 = instruction;
                int n28 = instruction51.opCode();
                String string = stringArray[n28];
                StringBuffer stringBuffer36 = stringBuffer.append(string);
                StringBuffer stringBuffer37 = stringBuffer36.append(" ");
                int n29 = instruction51.immediate();
                StringBuffer stringBuffer38 = stringBuffer37.append(n29);
                StringBuffer stringBuffer39 = stringBuffer38.append(" ");
                int n30 = instruction51.lvtIndex();
                StringBuffer stringBuffer40 = stringBuffer39.append(n30);
                return stringBuffer40.toString();
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = mnemonics;
                Instruction instruction52 = instruction16;
                int n31 = instruction52.preferablyRealOpCode();
                String string = stringArray[n31];
                StringBuffer stringBuffer41 = stringBuffer.append(string);
                StringBuffer stringBuffer42 = stringBuffer41.append(" ");
                String string5 = instruction52.classRef();
                StringBuffer stringBuffer43 = stringBuffer42.append(string5);
                StringBuffer stringBuffer44 = stringBuffer43.append(" . ");
                String string6 = instruction52.elemName();
                StringBuffer stringBuffer45 = stringBuffer44.append(string6);
                StringBuffer stringBuffer46 = stringBuffer45.append(" : ");
                Type type = instruction52.type();
                StringBuffer stringBuffer47 = stringBuffer46.append(type);
                return stringBuffer47.toString();
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = mnemonics;
                Instruction instruction53 = instruction14;
                int n32 = instruction53.preferablyRealOpCode();
                String string = stringArray[n32];
                StringBuffer stringBuffer48 = stringBuffer.append(string);
                StringBuffer stringBuffer49 = stringBuffer48.append(" ");
                String string7 = instruction53.classRef();
                StringBuffer stringBuffer50 = stringBuffer49.append(string7);
                StringBuffer stringBuffer51 = stringBuffer50.append(" . ");
                String string8 = instruction53.elemName();
                StringBuffer stringBuffer52 = stringBuffer51.append(string8);
                StringBuffer stringBuffer53 = stringBuffer52.append(" : ");
                Descriptor descriptor = instruction53.descriptor();
                StringBuffer stringBuffer54 = stringBuffer53.append(descriptor);
                return stringBuffer54.toString();
            }
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = mnemonics;
                Instruction instruction54 = instruction30;
                int n33 = instruction54.preferablyRealOpCode();
                String string = stringArray[n33];
                StringBuffer stringBuffer55 = stringBuffer.append(string);
                StringBuffer stringBuffer56 = stringBuffer55.append(" ");
                String string9 = instruction54.classRef();
                StringBuffer stringBuffer57 = stringBuffer56.append(string9);
                return stringBuffer57.toString();
            }
            case 197: {
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = mnemonics;
                Instruction instruction55 = instruction20;
                int n34 = instruction55.preferablyRealOpCode();
                String string = stringArray[n34];
                StringBuffer stringBuffer58 = stringBuffer.append(string);
                StringBuffer stringBuffer59 = stringBuffer58.append(" ");
                String string10 = instruction55.classRef();
                StringBuffer stringBuffer60 = stringBuffer59.append(string10);
                StringBuffer stringBuffer61 = stringBuffer60.append(" ");
                int n35 = instruction55.immediate();
                StringBuffer stringBuffer62 = stringBuffer61.append(n35);
                return stringBuffer62.toString();
            }
            case 16: 
            case 17: {
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = mnemonics;
                Instruction instruction56 = instruction12;
                int n36 = instruction56.preferablyRealOpCode();
                String string = stringArray[n36];
                StringBuffer stringBuffer63 = stringBuffer.append(string);
                StringBuffer stringBuffer64 = stringBuffer63.append(" ");
                int n37 = instruction56.immediate();
                StringBuffer stringBuffer65 = stringBuffer64.append(n37);
                return stringBuffer65.toString();
            }
            case 18: 
            case 19: {
                switch (instruction7.opCode()) {
                    case 256: {
                        StringBuffer stringBuffer = new StringBuffer();
                        String[] stringArray = mnemonics;
                        Instruction instruction57 = instruction35;
                        int n38 = instruction57.preferablyRealOpCode();
                        String string = stringArray[n38];
                        StringBuffer stringBuffer66 = stringBuffer.append(string);
                        StringBuffer stringBuffer67 = stringBuffer66.append(" ");
                        int n39 = instruction57.immediate();
                        StringBuffer stringBuffer68 = stringBuffer67.append(n39);
                        return stringBuffer68.toString();
                    }
                    case 257: {
                        StringBuffer stringBuffer = new StringBuffer();
                        String[] stringArray = mnemonics;
                        Instruction instruction58 = instruction37;
                        int n40 = instruction58.preferablyRealOpCode();
                        String string = stringArray[n40];
                        StringBuffer stringBuffer69 = stringBuffer.append(string);
                        StringBuffer stringBuffer70 = stringBuffer69.append(" ");
                        double d = instruction58.immediate_f();
                        StringBuffer stringBuffer71 = stringBuffer70.append(d);
                        return stringBuffer71.toString();
                    }
                    case 260: {
                        StringBuffer stringBuffer = new StringBuffer();
                        String[] stringArray = mnemonics;
                        Instruction instruction59 = instruction21;
                        int n41 = instruction59.preferablyRealOpCode();
                        String string = stringArray[n41];
                        StringBuffer stringBuffer72 = stringBuffer.append(string);
                        StringBuffer stringBuffer73 = stringBuffer72.append(" \"");
                        String string11 = instruction59.immediate_s();
                        String string12 = Util.quoteString(string11);
                        StringBuffer stringBuffer74 = stringBuffer73.append(string12);
                        StringBuffer stringBuffer75 = stringBuffer74.append("\"");
                        return stringBuffer75.toString();
                    }
                }
                throw new RuntimeException("unknown type of ldc");
            }
            case 20: {
                switch (instruction10.opCode()) {
                    case 258: {
                        StringBuffer stringBuffer = new StringBuffer();
                        String[] stringArray = mnemonics;
                        Instruction instruction60 = instruction6;
                        int n42 = instruction60.preferablyRealOpCode();
                        String string = stringArray[n42];
                        StringBuffer stringBuffer76 = stringBuffer.append(string);
                        StringBuffer stringBuffer77 = stringBuffer76.append(" ");
                        long l = instruction60.immediate_l();
                        StringBuffer stringBuffer78 = stringBuffer77.append(l);
                        return stringBuffer78.toString();
                    }
                    case 259: {
                        StringBuffer stringBuffer = new StringBuffer();
                        String[] stringArray = mnemonics;
                        Instruction instruction61 = instruction22;
                        int n43 = instruction61.preferablyRealOpCode();
                        String string = stringArray[n43];
                        StringBuffer stringBuffer79 = stringBuffer.append(string);
                        StringBuffer stringBuffer80 = stringBuffer79.append(" ");
                        double d = instruction61.immediate_f();
                        StringBuffer stringBuffer81 = stringBuffer80.append(d);
                        return stringBuffer81.toString();
                    }
                }
                throw new RuntimeException("unknown type of ldc2");
            }
            case 188: {
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = mnemonics;
                Instruction instruction62 = instruction33;
                int n44 = instruction62.preferablyRealOpCode();
                String string = stringArray[n44];
                StringBuffer stringBuffer82 = stringBuffer.append(string);
                StringBuffer stringBuffer83 = stringBuffer82.append(" ");
                int n45 = instruction62.immediate();
                StringBuffer stringBuffer84 = stringBuffer83.append(n45);
                return stringBuffer84.toString();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                String[] stringArray = mnemonics;
                int n46 = instruction40.preferablyRealOpCode();
                return stringArray[n46];
            }
            case 256: {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer85 = stringBuffer.append("IPUSH ");
                int n47 = instruction17.immediate();
                StringBuffer stringBuffer86 = stringBuffer85.append(n47);
                return stringBuffer86.toString();
            }
            case 257: {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer87 = stringBuffer.append("FPUSH ");
                double d = instruction4.immediate_f();
                StringBuffer stringBuffer88 = stringBuffer87.append(d);
                return stringBuffer88.toString();
            }
            case 259: {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer89 = stringBuffer.append("DPUSH ");
                double d = instruction11.immediate_f();
                StringBuffer stringBuffer90 = stringBuffer89.append(d);
                return stringBuffer90.toString();
            }
            case 258: {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer91 = stringBuffer.append("LPUSH ");
                long l = instruction13.immediate_l();
                StringBuffer stringBuffer92 = stringBuffer91.append(l);
                return stringBuffer92.toString();
            }
            case 260: {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer93 = stringBuffer.append("SPUSH \"");
                String string = instruction8.immediate_s();
                StringBuffer stringBuffer94 = stringBuffer93.append(string);
                StringBuffer stringBuffer95 = stringBuffer94.append("\"");
                return stringBuffer95.toString();
            }
            case 513: {
                switch (instruction24.lvtIndex()) {
                    case 0: {
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer96 = stringBuffer.append("ExcEnter (");
                        Instruction instruction63 = instruction3;
                        int n48 = instruction63.immediate();
                        StringBuffer stringBuffer97 = stringBuffer96.append(n48);
                        StringBuffer stringBuffer98 = stringBuffer97.append(": ");
                        String string = instruction63.elemName();
                        StringBuffer stringBuffer99 = stringBuffer98.append(string);
                        StringBuffer stringBuffer100 = stringBuffer99.append(") ");
                        BranchTarget branchTarget = instruction63.branchTarget();
                        String string13 = branchTarget.recString();
                        StringBuffer stringBuffer101 = stringBuffer100.append(string13);
                        return stringBuffer101.toString();
                    }
                    case 1: {
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer102 = stringBuffer.append("ExcLeave (");
                        Instruction instruction64 = instruction2;
                        int n49 = instruction64.immediate();
                        StringBuffer stringBuffer103 = stringBuffer102.append(n49);
                        StringBuffer stringBuffer104 = stringBuffer103.append(": ");
                        String string = instruction64.elemName();
                        StringBuffer stringBuffer105 = stringBuffer104.append(string);
                        StringBuffer stringBuffer106 = stringBuffer105.append(")");
                        return stringBuffer106.toString();
                    }
                    case 2: {
                        return "ExcReset";
                    }
                }
            }
            case 515: {
                return "gotoblk";
            }
            case 516: {
                return "label";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer107 = stringBuffer.append("unknown opcode ");
        StringBuffer stringBuffer108 = stringBuffer107.append(n);
        String string = stringBuffer108.toString();
        throw new RuntimeException(string);
    }

    static int mnemonic2opcode(String string) throws RuntimeException {
        String string2;
        String string3 = string2 = string;
        String string4 = string2;
        String string5 = string2;
        String string6 = string2;
        String string7 = string2;
        String string8 = string2;
        if (string2.equalsIgnoreCase("ipush")) {
            return 256;
        }
        if (string4.equalsIgnoreCase("fpush")) {
            return 257;
        }
        if (string6.equalsIgnoreCase("dpush")) {
            return 259;
        }
        if (string3.equalsIgnoreCase("lpush")) {
            return 258;
        }
        if (string5.equalsIgnoreCase("spush")) {
            return 260;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < mnemonics.length) {
            String[] stringArray = mnemonics;
            String string9 = stringArray[n];
            if (string7.equalsIgnoreCase(string9)) {
                return n4;
            }
            int n5 = n3;
            n2 = n = n5 + 1;
            n3 = n;
            n4 = n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("bad mnemonic: ");
        StringBuffer stringBuffer3 = stringBuffer2.append(string8);
        String string10 = stringBuffer3.toString();
        throw new RuntimeException(string10);
    }

    public int hashCode() {
        Instruction instruction = this;
        return super.hashCode();
    }

    public boolean equals(Object object) {
        Instruction instruction = this;
        Object object2 = object;
        boolean bl = instruction == object2;
        return bl;
    }

    public int maxsize() {
        Instruction instruction;
        Instruction instruction2 = instruction = this;
        Instruction instruction3 = instruction;
        Instruction instruction4 = instruction;
        Instruction instruction5 = instruction;
        Instruction instruction6 = instruction;
        Instruction instruction7 = instruction;
        Instruction instruction8 = instruction;
        Instruction instruction9 = instruction;
        Instruction instruction10 = instruction;
        Instruction instruction11 = instruction;
        Instruction instruction12 = instruction;
        Instruction instruction13 = instruction;
        Instruction instruction14 = instruction;
        Instruction instruction15 = instruction;
        Instruction instruction16 = instruction;
        Instruction instruction17 = instruction;
        switch (instruction2.preferablyRealOpCode()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                return 1;
            }
            case 16: 
            case 18: 
            case 169: 
            case 188: {
                return 2;
            }
            case 17: 
            case 19: 
            case 20: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 198: 
            case 199: 
            case 260: {
                return 3;
            }
            case 197: {
                return 4;
            }
            case 167: 
            case 168: 
            case 185: 
            case 200: 
            case 201: {
                return 5;
            }
            case 170: {
                return 16 + instruction12.switchArray().length * 4;
            }
            case 171: {
                return 12 + instruction7.switchArray().length * 8;
            }
            case 132: {
                if (instruction5.lvtIndex() <= 255 && -128 <= instruction14.immediate() && instruction13.immediate() <= 127) {
                    return 3;
                }
                return 6;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (instruction17.lvtIndex() <= 3) {
                    return 1;
                }
                if (instruction3.lvtIndex() <= 255) {
                    return 2;
                }
                return 4;
            }
            case 256: {
                if (instruction15.immediate() >= -1 && instruction8.immediate() <= 5) {
                    return 1;
                }
                if (-128 <= instruction9.immediate() && instruction4.immediate() <= 127) {
                    return 2;
                }
                return 3;
            }
            case 257: {
                if (instruction.immediate_f() == 2.0) {
                    return 1;
                }
            }
            case 259: {
                if (instruction16.immediate_f() == 0.0 || instruction10.immediate_f() == 1.0) {
                    return 1;
                }
                return 3;
            }
            case 258: {
                if (instruction11.immediate_l() == 0L || instruction6.immediate_l() == 1L) {
                    return 1;
                }
                return 3;
            }
        }
        throw new IllegalStateException("bad opcode for maxsize");
    }

    static {
        String[] stringArray = new String[203];
        String[] stringArray2 = stringArray;
        stringArray[0] = "nop";
        stringArray2[1] = "aconst_null";
        stringArray2[2] = "iconst_m1";
        stringArray2[3] = "iconst_0";
        stringArray2[4] = "iconst_1";
        stringArray2[5] = "iconst_2";
        stringArray2[6] = "iconst_3";
        stringArray2[7] = "iconst_4";
        stringArray2[8] = "iconst_5";
        stringArray2[9] = "lconst_0";
        stringArray2[10] = "lconst_1";
        stringArray2[11] = "fconst_0";
        stringArray2[12] = "fconst_1";
        stringArray2[13] = "fconst_2";
        stringArray2[14] = "dconst_0";
        stringArray2[15] = "dconst_1";
        stringArray2[16] = "bipush";
        stringArray2[17] = "sipush";
        stringArray2[18] = "ldc";
        stringArray2[19] = "ldc_w";
        stringArray2[20] = "ldc2_w";
        stringArray2[21] = "iload";
        stringArray2[22] = "lload";
        stringArray2[23] = "fload";
        stringArray2[24] = "dload";
        stringArray2[25] = "aload";
        stringArray2[26] = "iload_0";
        stringArray2[27] = "iload_1";
        stringArray2[28] = "iload_2";
        stringArray2[29] = "iload_3";
        stringArray2[30] = "lload_0";
        stringArray2[31] = "lload_1";
        stringArray2[32] = "lload_2";
        stringArray2[33] = "lload_3";
        stringArray2[34] = "fload_0";
        stringArray2[35] = "fload_1";
        stringArray2[36] = "fload_2";
        stringArray2[37] = "fload_3";
        stringArray2[38] = "dload_0";
        stringArray2[39] = "dload_1";
        stringArray2[40] = "dload_2";
        stringArray2[41] = "dload_3";
        stringArray2[42] = "aload_0";
        stringArray2[43] = "aload_1";
        stringArray2[44] = "aload_2";
        stringArray2[45] = "aload_3";
        stringArray2[46] = "iaload";
        stringArray2[47] = "laload";
        stringArray2[48] = "faload";
        stringArray2[49] = "daload";
        stringArray2[50] = "aaload";
        stringArray2[51] = "baload";
        stringArray2[52] = "caload";
        stringArray2[53] = "saload";
        stringArray2[54] = "istore";
        stringArray2[55] = "lstore";
        stringArray2[56] = "fstore";
        stringArray2[57] = "dstore";
        stringArray2[58] = "astore";
        stringArray2[59] = "istore_0";
        stringArray2[60] = "istore_1";
        stringArray2[61] = "istore_2";
        stringArray2[62] = "istore_3";
        stringArray2[63] = "lstore_0";
        stringArray2[64] = "lstore_1";
        stringArray2[65] = "lstore_2";
        stringArray2[66] = "lstore_3";
        stringArray2[67] = "fstore_0";
        stringArray2[68] = "fstore_1";
        stringArray2[69] = "fstore_2";
        stringArray2[70] = "fstore_3";
        stringArray2[71] = "dstore_0";
        stringArray2[72] = "dstore_1";
        stringArray2[73] = "dstore_2";
        stringArray2[74] = "dstore_3";
        stringArray2[75] = "astore_0";
        stringArray2[76] = "astore_1";
        stringArray2[77] = "astore_2";
        stringArray2[78] = "astore_3";
        stringArray2[79] = "iastore";
        stringArray2[80] = "lastore";
        stringArray2[81] = "fastore";
        stringArray2[82] = "dastore";
        stringArray2[83] = "aastore";
        stringArray2[84] = "bastore";
        stringArray2[85] = "castore";
        stringArray2[86] = "sastore";
        stringArray2[87] = "pop";
        stringArray2[88] = "pop2";
        stringArray2[89] = "dup";
        stringArray2[90] = "dup_x1";
        stringArray2[91] = "dup_x2";
        stringArray2[92] = "dup2";
        stringArray2[93] = "dup2_x1";
        stringArray2[94] = "dup2_x2";
        stringArray2[95] = "swap";
        stringArray2[96] = "iadd";
        stringArray2[97] = "ladd";
        stringArray2[98] = "fadd";
        stringArray2[99] = "dadd";
        stringArray2[100] = "isub";
        stringArray2[101] = "lsub";
        stringArray2[102] = "fsub";
        stringArray2[103] = "dsub";
        stringArray2[104] = "imul";
        stringArray2[105] = "lmul";
        stringArray2[106] = "fmul";
        stringArray2[107] = "dmul";
        stringArray2[108] = "idiv";
        stringArray2[109] = "ldiv";
        stringArray2[110] = "fdiv";
        stringArray2[111] = "ddiv";
        stringArray2[112] = "irem";
        stringArray2[113] = "lrem";
        stringArray2[114] = "frem";
        stringArray2[115] = "drem";
        stringArray2[116] = "ineg";
        stringArray2[117] = "lneg";
        stringArray2[118] = "fneg";
        stringArray2[119] = "dneg";
        stringArray2[120] = "ishl";
        stringArray2[121] = "lshl";
        stringArray2[122] = "ishr";
        stringArray2[123] = "lshr";
        stringArray2[124] = "iushr";
        stringArray2[125] = "lushr";
        stringArray2[126] = "iand";
        stringArray2[127] = "land";
        stringArray2[128] = "ior";
        stringArray2[129] = "lor";
        stringArray2[130] = "ixor";
        stringArray2[131] = "lxor";
        stringArray2[132] = "iinc";
        stringArray2[133] = "i2l";
        stringArray2[134] = "i2f";
        stringArray2[135] = "i2d";
        stringArray2[136] = "l2i";
        stringArray2[137] = "l2f";
        stringArray2[138] = "l2d";
        stringArray2[139] = "f2i";
        stringArray2[140] = "f2l";
        stringArray2[141] = "f2d";
        stringArray2[142] = "d2i";
        stringArray2[143] = "d2l";
        stringArray2[144] = "d2f";
        stringArray2[145] = "i2b";
        stringArray2[146] = "i2c";
        stringArray2[147] = "i2s";
        stringArray2[148] = "lcmp";
        stringArray2[149] = "fcmpl";
        stringArray2[150] = "fcmpg";
        stringArray2[151] = "dcmpl";
        stringArray2[152] = "dcmpg";
        stringArray2[153] = "ifeq";
        stringArray2[154] = "ifne";
        stringArray2[155] = "iflt";
        stringArray2[156] = "ifge";
        stringArray2[157] = "ifgt";
        stringArray2[158] = "ifle";
        stringArray2[159] = "if_icmpeq";
        stringArray2[160] = "if_icmpne";
        stringArray2[161] = "if_icmplt";
        stringArray2[162] = "if_icmpge";
        stringArray2[163] = "if_icmpgt";
        stringArray2[164] = "if_icmple";
        stringArray2[165] = "if_acmpeq";
        stringArray2[166] = "if_acmpne";
        stringArray2[167] = "goto";
        stringArray2[168] = "jsr";
        stringArray2[169] = "ret";
        stringArray2[170] = "tableswitch";
        stringArray2[171] = "lookupswitch";
        stringArray2[172] = "ireturn";
        stringArray2[173] = "lreturn";
        stringArray2[174] = "freturn";
        stringArray2[175] = "dreturn";
        stringArray2[176] = "areturn";
        stringArray2[177] = "return";
        stringArray2[178] = "getstatic";
        stringArray2[179] = "putstatic";
        stringArray2[180] = "getfield";
        stringArray2[181] = "putfield";
        stringArray2[182] = "invokevirtual";
        stringArray2[183] = "invokespecial";
        stringArray2[184] = "invokestatic";
        stringArray2[185] = "invokeinterface";
        stringArray2[186] = "xxxunusedxxx1";
        stringArray2[187] = "new";
        stringArray2[188] = "newarray";
        stringArray2[189] = "anewarray";
        stringArray2[190] = "arraylength";
        stringArray2[191] = "athrow";
        stringArray2[192] = "checkcast";
        stringArray2[193] = "instanceof";
        stringArray2[194] = "monitorenter";
        stringArray2[195] = "monitorexit";
        stringArray2[196] = "wide";
        stringArray2[197] = "multianewarray";
        stringArray2[198] = "ifnull";
        stringArray2[199] = "ifnonnull";
        stringArray2[200] = "goto_w";
        stringArray2[201] = "jsr_w";
        stringArray2[202] = "breakpoint";
        mnemonics = stringArray2;
    }
}

