/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.regex.Pattern;
import net.sf.saxon.type.Facet;
import net.sf.saxon.type.RegexTranslator;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class PatternFacet
extends Facet {
    StringValue requiredValue;
    Pattern regex;

    public String getName() {
        return "pattern";
    }

    public String getValue() {
        return this.requiredValue.getStringValue();
    }

    public void setValue(String value) throws SchemaException {
        this.requiredValue = new StringValue(value);
        try {
            this.regex = Pattern.compile(RegexTranslator.translate(value, false));
        }
        catch (RegexTranslator.RegexSyntaxException e) {
            throw new SchemaException(e.getMessage());
        }
    }

    public void checkFacetRestriction(SimpleType base) throws SchemaException {
    }

    public boolean testAtomicValue(AtomicValue value) {
        try {
            return this.regex.matcher(value.getStringValue()).matches();
        }
        catch (XPathException err) {
            return false;
        }
    }
}

