/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.type.Facet;
import net.sf.saxon.type.LengthFacet;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;

public class MinLengthFacet
extends LengthFacet {
    public String getName() {
        return "minLength";
    }

    public void checkFacetRestriction(SimpleType base) throws SchemaException {
        Facet baseFacet = base.getFacet("length");
        if (baseFacet != null && (long)this.requiredLength != baseFacet.toLong()) {
            throw new SchemaException("In a type derived by restriction, the minLength facet conflicts with the length of the base type");
        }
        baseFacet = base.getFacet("minLength");
        if (baseFacet != null && (long)this.requiredLength < baseFacet.toLong()) {
            throw new SchemaException("In a type derived by restriction, the minLength facet is shorter than the minLength of the base type");
        }
        baseFacet = base.getFacet("maxLength");
        if (baseFacet != null && (long)this.requiredLength > baseFacet.toLong()) {
            throw new SchemaException("In a type derived by restriction, the minLength facet is longer than the maxLength of the base type");
        }
    }

    public boolean testLength(int actualLength) {
        return actualLength >= this.requiredLength;
    }
}

