/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.HashMap;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.CallableFunction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class FunctionInstr
extends Instruction
implements CallableFunction,
InstructionInfo {
    private Sequence body;
    private String baseURI;
    private String displayName;
    private boolean memoFunction = false;
    private int lineNumber;

    public void initialize(Sequence sequence, String string, String string2, boolean bl) {
        this.body = sequence;
        this.baseURI = string;
        this.displayName = string2;
        this.memoFunction = bl;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSystemId() {
        return null;
    }

    public Object getProperty(String string) {
        if (string.equals("name")) {
            return this.displayName;
        }
        return null;
    }

    public HashMap getProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", this.displayName);
        return hashMap;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("function");
    }

    public String getInstructionName() {
        return "xsl:function";
    }

    public String getFunctionName() {
        return this.displayName;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) {
        return null;
    }

    public Value call(Value[] valueArray, Controller controller) throws TransformerException {
        Object object;
        if (this.memoFunction && (object = this.getCachedValue(controller, valueArray)) != null) {
            return object;
        }
        if (controller.isTracing()) {
            object = controller.getTraceListener();
            object.enter(this);
        }
        object = controller.getReceiver();
        SequenceOutputter sequenceOutputter = new SequenceOutputter();
        sequenceOutputter.setSystemId(this.baseURI);
        sequenceOutputter.setNamePool(controller.getNamePool());
        controller.changeToSequenceOutputDestination(sequenceOutputter);
        Bindery bindery = controller.getBindery();
        bindery.openStackFrame(valueArray);
        this.body.process(controller.newXPathContext());
        bindery.closeStackFrame();
        controller.resetOutputDestination((SequenceReceiver)object);
        Value value = sequenceOutputter.getSequence();
        if (controller.isTracing()) {
            TraceListener traceListener = controller.getTraceListener();
            traceListener.leave(this);
        }
        if (this.memoFunction) {
            this.putCachedValue(controller, valueArray, value);
        }
        return value;
    }

    private Value getCachedValue(Controller controller, Value[] valueArray) {
        try {
            HashMap hashMap = (HashMap)controller.getUserData(this, "memo-function-cache");
            if (hashMap == null) {
                return null;
            }
            String string = FunctionInstr.getCombinedKey(valueArray);
            return (Value)hashMap.get(string);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    private void putCachedValue(Controller controller, Value[] valueArray, Value value) {
        try {
            HashMap<String, Value> hashMap = (HashMap<String, Value>)controller.getUserData(this, "memo-function-cache");
            if (hashMap == null) {
                hashMap = new HashMap<String, Value>();
                controller.setUserData(this, "memo-function-cache", hashMap);
            }
            String string = FunctionInstr.getCombinedKey(valueArray);
            hashMap.put(string, value);
        }
        catch (XPathException xPathException) {}
    }

    private static String getCombinedKey(Value[] valueArray) throws XPathException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < valueArray.length) {
            Item item;
            Value value = valueArray[n];
            SequenceIterator sequenceIterator = value.iterate(null);
            while ((item = sequenceIterator.next()) != null) {
                if (item instanceof NodeInfo) {
                    NodeInfo nodeInfo = (NodeInfo)item;
                    stringBuffer.append(nodeInfo.generateId());
                } else {
                    stringBuffer.append("" + Type.displayTypeName(item));
                    stringBuffer.append('/');
                    stringBuffer.append(item.getStringValue());
                }
                stringBuffer.append('\u0001');
            }
            stringBuffer.append('\u0002');
            ++n;
        }
        return stringBuffer.toString();
    }
}

