/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.AtomicValue;
import org.xml.sax.Locator;

public class TreeReceiver
implements SequenceReceiver {
    private Receiver baseReceiver;
    private NamePool namePool;
    private String systemId;
    private boolean previousAtomic = false;

    public TreeReceiver(Receiver receiver) {
        this.baseReceiver = receiver;
        this.previousAtomic = false;
    }

    public void setSystemId(String string) {
        if (string != this.systemId) {
            this.systemId = string;
            if (this.baseReceiver != null) {
                this.baseReceiver.setSystemId(string);
            }
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setUnderlyingReceiver(Receiver receiver) {
        if (receiver != this.baseReceiver) {
            this.baseReceiver = receiver;
            if (this.namePool != null) {
                this.baseReceiver.setNamePool(this.namePool);
            }
        }
    }

    public Receiver getUnderlyingReceiver() {
        return this.baseReceiver;
    }

    public void setNamePool(NamePool namePool) {
        if (namePool != this.namePool) {
            this.namePool = namePool;
            if (this.baseReceiver != null) {
                this.baseReceiver.setNamePool(namePool);
            }
        }
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void startDocument() throws TransformerException {
        if (this.baseReceiver == null) {
            throw new IllegalStateException("ProxyReceiver.startDocument(): no underlying emitter provided");
        }
        this.baseReceiver.startDocument();
        this.previousAtomic = false;
    }

    public void endDocument() throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.endDocument();
        }
        this.previousAtomic = false;
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.startElement(n, n2, n3);
        }
        this.previousAtomic = false;
    }

    public void namespace(int n, int n2) throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.namespace(n, n2);
        }
        this.previousAtomic = false;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3) throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.attribute(n, n2, charSequence, n3);
        }
        this.previousAtomic = false;
    }

    public void startContent() throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.startContent();
        }
        this.previousAtomic = false;
    }

    public void endElement() throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.endElement();
        }
        this.previousAtomic = false;
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.characters(charSequence, n);
        }
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.processingInstruction(string, charSequence, n);
        }
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.comment(charSequence, n);
        }
        this.previousAtomic = false;
    }

    public void setUnparsedEntity(String string, String string2, String string3) throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.setUnparsedEntity(string, string2, string3);
        }
    }

    public void setDocumentLocator(Locator locator) throws TransformerException {
        if (this.baseReceiver != null) {
            this.baseReceiver.setDocumentLocator(locator);
        }
    }

    public void append(Item item) throws TransformerException {
        if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.characters(" ", 0);
            }
            this.characters(item.getStringValue(), 0);
            this.previousAtomic = true;
        } else if (item instanceof DocumentInfo) {
            Item item2;
            AxisIterator axisIterator = ((DocumentInfo)item).iterateAxis((byte)3);
            while ((item2 = axisIterator.next()) != null) {
                this.append(item2);
            }
        } else {
            ((NodeInfo)item).copy(this, 2, true);
            this.previousAtomic = false;
        }
    }
}

