/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.hyperic.sigar.FileSystem;

public class FileSystemMap
extends HashMap {
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void init(FileSystem[] fslist) {
        super.clear();
        for (int i = 0; i < fslist.length; ++i) {
            super.put(fslist[i].getDirName(), fslist[i]);
        }
    }

    public FileSystem getFileSystem(String name) {
        return (FileSystem)this.get(name);
    }

    public boolean isMounted(String name) {
        return this.get(name) != null;
    }

    public FileSystem getMountPoint(String name) {
        FileSystem fs = this.getFileSystem(name);
        if (fs != null) {
            return fs;
        }
        File dir = new File(name);
        if (!dir.exists()) {
            return null;
        }
        try {
            dir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (!dir.isDirectory()) {
            dir = dir.getParentFile();
        }
        do {
            if ((fs = this.getFileSystem(dir.toString())) == null) continue;
            return fs;
        } while ((dir = dir.getParentFile()) != null);
        return null;
    }
}

