#include "keymap.h"
int stack_push(struct lk_ctx *ctx, struct kbdfile *fp, void *scanner);
int stack_pop(struct lk_ctx *ctx, void *scanner);

#line 6 "analyze.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yyget_lval
#define yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval yyget_lval
#endif

#ifdef yyset_lval
#define yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval yyset_lval
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* begin standard C++ headers. */

/* flex integer type definitions */

#ifndef YYFLEX_INTTYPES_DEFINED
#define YYFLEX_INTTYPES_DEFINED

/* Prefer C99 integer types if available. */
# if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
/* Include <inttypes.h> and not <stdint.h> because Solaris 2.6 has the former
 * and not the latter.
 */
#include <inttypes.h>
#  define YYFLEX_USE_STDINT
# else
#  if defined(_MSC_VER) && _MSC_VER >= 1600
/* Visual C++ 2010 does not define __STDC_VERSION__ and has <stdint.h> but not
 * <inttypes.h>.
 */
#include <stdint.h>
#   define YYFLEX_USE_STDINT
#  endif
# endif
# ifdef YYFLEX_USE_STDINT
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
# else
typedef unsigned char flex_uint8_t;
typedef short int flex_int16_t;
typedef unsigned short int flex_uint16_t;
#  ifdef __STDC__
typedef signed char flex_int8_t;
/* ISO C only requires at least 16 bits for int. */
#include <limits.h>
#   if UINT_MAX >= 4294967295
#    define YYFLEX_INT32_DEFINED
typedef int flex_int32_t;
typedef unsigned int flex_uint32_t;
#   endif
#  else
typedef char flex_int8_t;
#  endif
#  ifndef YYFLEX_INT32_DEFINED
typedef long int flex_int32_t;
typedef unsigned long int flex_uint32_t;
#  endif
# endif
#endif /* YYFLEX_INTTYPES_DEFINED */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
#else
#define yynoreturn
#define YY_ATTRIBUTE_UNUSED /* __attribute__ ((__unused__)) */
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 48
#define YY_END_OF_BUFFER 49
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[504] =
    {   0,
        0,    0,    0,    0,   45,   45,    0,    0,   49,   47,
        6,    5,   47,   40,   47,   16,   15,   14,   12,   12,
        8,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   45,   46,   48,    3,   48,    6,    0,    7,    0,
        0,   12,    0,   12,    0,   33,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   35,
        0,    0,    0,    0,    0,    0,   10,    0,    0,    0,

        4,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   10,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   45,   42,   41,   43,   44,    0,    3,
       39,    0,   39,    0,   12,   23,    0,   23,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       23,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   41,    2,
       38,   37,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,

       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   41,   37,    0,    0,
       24,    0,    0,    0,    0,   27,   28,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   20,
       21,    0,   21,    0,    0,   34,    0,    0,    0,    0,
        0,    0,    0,   21,    0,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   25,   26,    9,
        9,   11,    0,    0,    0,    0,    0,    0,    0,    9,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,    9,
        9,   13,   13,   13,   13,   13,   13,   13,    9,    0,
        0,   17,   32,   22,    0,    0,   19,   18,   31,    0,
        1,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,    1,    0,    0,    0,    0,    0,    1,   13,
       13,   13,   13,   13,    0,   29,   13,   13,    0,   13,

       30,   13,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    1,    1,    7,    1,
        1,    1,    8,    9,   10,    1,    1,   11,   12,   12,
       12,   12,   12,   12,   12,   13,   13,    1,    1,    1,
       14,    1,    1,    1,   15,   16,   17,   18,   19,   20,
       21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
       24,   31,   32,   33,   34,   24,   24,   35,   36,   24,
        1,   37,    1,    1,   38,    1,   39,   16,   40,   41,

       42,   43,   44,   45,   46,   24,   47,   48,   49,   50,
       51,   52,   24,   53,   54,   55,   56,   24,   24,   35,
       57,   24,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[58] =
    {   0,
        1,    1,    2,    1,    3,    1,    1,    1,    1,    1,
        4,    4,    4,    1,    4,    4,    4,    4,    4,    4,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    3,    5,    4,    4,
        4,    4,    4,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5
    } ;

static const flex_int16_t yy_base[517] =
    {   0,
        0,    0,   57,    0,  110,  111,  721,  720,  724,  727,
      721,  727,  719,  727,  684,  727,  727,  727,  106,  108,
      727,   96,  110,   94,  110,   96,  105,  118,  105,  122,
      717,  110,  123,  668,  668,  675,  666,  667,   82,  663,
      659,  134,    0,  157,  106,  150,  131,  141,  158,  142,
      162,  151,  156,  661,  661,  668,  659,  660,  130,  656,
      652,    0,  727,  209,  727,  195,  703,  701,  727,  696,
      211,  172,    0,  213,  154,  727,  164,  672,  686,  200,
      669,  647,  659,  180,  644,  665,  642,  658,  636,  727,
      677,  652,  667,  658,  642,  634,  727,    0,  652,  629,

      727,  177,  182,  632,  644,  184,  629,  628,  640,  622,
      639,  631,  623,  619,    0,  184,    0,  198,  644,  658,
      208,  641,  619,  631,  191,  616,  637,  614,  630,  608,
        0,  649,  624,  639,  630,  614,  606,    0,  624,  601,
      205,  209,  604,  616,  194,  601,  600,  612,  594,  611,
      603,  595,  591,    0,  727,  236,  727,  727,  201,  727,
      727,  639,  638,  238,    0,  241,  242,  244,  612,  612,
      612,  608,  614,  585,  585,  585,  581,  587,  727,  239,
      241,  611,  587,  612,  608,  587,  583,    0,  613,  588,
      245,  572,  572,  572,  568,  574,  573,   93,  574,  576,

      572,  578,  253,  247,  257,  584,  584,  584,  580,  586,
      557,  557,  557,  553,  559,    0,  244,  259,  583,  559,
      584,  580,  559,  555,  585,  560,  259,  544,  544,  544,
      540,  546,  545,  235,  546,  548,  544,  550,  261,  727,
      727,  727,  293,  247,  557,  534,  533,  553,  552,  554,
      551,  261,  262,  264,  530,  527,  276,  550,  563,  526,
      537,  524,  535,  545,  522,  538,  542,  514,  518,    0,
      541,  518,  512,  510,  509,  511,  508,  258,  504,  508,
      519,  507,  501,  505,  506,  522,  275,  499,  498,  518,
      517,  519,  516,  283,  278,  280,  495,  492,  289,  515,

      528,  491,  502,  489,  500,  510,  487,  503,  507,  479,
      483,  506,  483,  477,  475,  474,  476,  473,  269,  469,
      473,  484,  472,  466,  470,  471,  727,  727,  511,  281,
      727,  495,  497,  483,  485,  727,  727,  468,  467,  469,
      468,  455,  457,  489,  476,  464,  452,  462,  450,  727,
      293,  480,  297,  456,    0,  727,  454,  456,  443,  445,
      454,  453,  441,  277,  448,    0,  294,  469,  471,  457,
      459,    0,    0,  442,  441,  443,  442,  429,  431,  463,
      450,  438,  426,  436,  424,    0,  305,  454,  307,  430,
        0,  428,  430,  417,  419,  428,  427,  415,  289,  422,

      317,  442,  431,  444,  436,  415,  414,  404,  403,  415,
      408,  436,  422,  411,  398,  409,  396,  727,  727,  417,
      394,  727,  401,  391,  403,  396,  401,  400,  387,  386,
      319,  416,  405,  418,  410,  389,  388,  378,  377,  389,
      382,  410,  396,  385,  372,  383,  370,    0,    0,  391,
      368,  375,  365,  377,  370,  375,  374,  361,  360,  312,
      393,  727,  727,  727,  369,  368,  727,  727,  727,  364,
      396,  313,  370,    0,    0,    0,  329,  327,    0,    0,
        0,  326,  363,  322,  330,  305,  304,  303,  354,  324,
      321,  298,  297,  296,  312,  727,  313,    0,  332,  334,

      727,    0,  727,  373,  378,  383,  388,  390,  395,  400,
      405,  346,  340,  273,  134,  122
    } ;

static const flex_int16_t yy_def[517] =
    {   0,
      503,    1,  503,    3,  504,  504,  505,  505,  503,  503,
      503,  503,  506,  503,  507,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  509,  503,  503,  503,  510,  503,  506,  503,  503,
      511,  503,  512,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  513,  503,  503,

      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  509,  503,  503,  503,  503,  510,  503,
      503,  503,  503,  503,  512,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  514,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,

      503,  503,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  515,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,

      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  516,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,

      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  508,  508,  508,  508,  508,  508,  508,  508,  508,
      508,  508,  508,  503,  503,  503,  503,  503,  503,  508,
      508,  508,  508,  508,  503,  503,  508,  508,  503,  508,

      503,  508,    0,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503
    } ;

static const flex_int16_t yy_nxt[785] =
    {   0,
       10,   11,   12,   13,   14,   13,   15,   16,   17,   18,
       19,   20,   20,   21,   22,   10,   23,   10,   10,   24,
       10,   10,   10,   10,   25,   10,   10,   10,   26,   27,
       10,   28,   29,   30,   10,   10,   31,   10,   32,   33,
       10,   10,   34,   10,   10,   35,   36,   10,   10,   10,
       37,   38,   10,   39,   40,   41,   10,   10,   11,   12,
       13,   14,   13,   15,   16,   17,   18,   19,   20,   20,
       21,   42,   43,   44,   43,   43,   45,   43,   43,   43,
       43,   46,   43,   43,   43,   47,   48,   43,   49,   50,
       51,   43,   43,   31,   10,   52,   53,   43,   43,   54,

       43,   43,   55,   56,   43,   43,   43,   57,   58,   43,
       59,   60,   61,   43,   63,   63,   72,   72,   74,   74,
       74,   75,   86,   90,   78,  422,  112,   76,   88,   98,
       91,   79,  280,   97,  127,  102,  113,  355,   80,   93,
       73,  281,   81,   77,   87,   90,   64,   64,   82,   76,
       94,   89,   92,   99,   83,   97,  128,  103,  131,  116,
       84,  104,   95,   76,   85,  117,  132,  105,  129,   98,
      138,  119,   96,  106,  151,  100,  141,  107,  120,  134,
      131,  118,   72,   72,  152,  121,  166,  117,  133,  122,
      135,  130,  138,  139,  143,  123,  167,  160,  142,  160,

      144,  124,  136,  160,  117,  240,  145,  125,  167,  167,
      146,  126,  137,  155,  167,  140,  203,  163,  168,  156,
      156,  164,  164,   74,   74,   74,  171,  172,  176,  177,
      204,  167,  194,  195,  208,  209,  191,  204,  204,  213,
      214,  204,  230,  231,  242,  157,  239,  239,  243,  243,
      244,  244,  205,  244,  244,  258,  244,  260,  158,  204,
      300,  245,  244,  227,  246,  259,  244,  261,  244,  330,
      301,  327,  327,  286,  321,  302,  270,  288,  244,  244,
      262,  244,  244,  322,  287,  303,  336,  247,  273,  263,
      287,  337,  330,  338,  287,  340,  287,  367,  304,  328,

      289,  336,  314,  329,  329,  336,  337,  305,  372,  374,
      337,  376,  401,  373,  372,  339,  372,  341,  418,  373,
      367,  373,  418,  419,  418,  431,  460,  419,  460,  419,
      448,  375,  448,  377,  401,  449,  448,  449,  484,  490,
      495,  449,  497,  188,  499,  500,  501,  431,  502,  165,
      498,  498,  498,  498,  460,  489,  472,  496,  496,  496,
      484,  490,  496,  495,  489,  497,  499,  500,  494,  493,
      501,  492,  502,   62,   62,   62,   62,   62,   65,   65,
       65,   65,   65,   68,   68,   68,   68,   68,   70,  491,
       70,   70,   70,  115,  115,  154,  154,  489,  154,  154,

      159,  159,  159,  159,  159,  162,  488,  162,  162,  162,
      487,  486,  485,  481,  480,  479,  483,  476,  475,  474,
      482,  481,  481,  480,  479,  480,  479,  480,  479,  476,
      475,  474,  474,  478,  477,  476,  475,  474,  473,  469,
      468,  467,  471,  464,  463,  462,  470,  469,  469,  468,
      467,  468,  467,  468,  467,  464,  463,  462,  462,  466,
      465,  464,  463,  462,  461,  459,  458,  457,  456,  455,
      454,  453,  452,  451,  450,  447,  446,  445,  444,  443,
      442,  441,  440,  439,  438,  437,  436,  435,  434,  433,
      432,  430,  429,  428,  427,  426,  425,  424,  423,  421,

      420,  417,  416,  415,  414,  413,  412,  411,  410,  409,
      408,  407,  406,  405,  404,  403,  402,  328,  391,  400,
      399,  386,  398,  397,  396,  395,  394,  393,  392,  366,
      391,  391,  390,  389,  388,  387,  386,  386,  385,  384,
      383,  382,  381,  380,  379,  378,  371,  370,  369,  368,
      366,  366,  366,  356,  365,  364,  350,  363,  362,  361,
      360,  359,  358,  357,  331,  356,  356,  354,  353,  352,
      351,  350,  350,  349,  348,  347,  346,  345,  344,  343,
      342,  335,  334,  333,  332,  331,  331,  331,  326,  325,
      324,  323,  320,  319,  318,  317,  316,  315,  313,  312,

      311,  310,  309,  308,  307,  306,  299,  298,  297,  296,
      295,  294,  293,  292,  291,  290,  285,  284,  283,  282,
      279,  278,  277,  276,  275,  274,  272,  271,  269,  268,
      267,  266,  265,  264,  257,  256,  255,  254,  253,  252,
      251,  250,  249,  248,  241,  241,  238,  237,  236,  235,
      234,  233,  216,  232,  229,  228,  226,  225,  224,  223,
      222,  221,  220,  219,  218,  217,  216,  216,  215,  212,
      211,  210,  207,  206,  202,  201,  200,  199,  198,  197,
      179,  196,  193,  192,  190,  189,  187,  186,  185,  184,
      183,  182,  181,  180,  179,  179,  178,  175,  174,  173,

      170,  169,  161,   69,   67,  153,  138,  150,  131,  149,
      148,  147,  114,   97,  111,   90,  110,  109,  108,  101,
       71,   69,   67,  503,   66,   66,    9,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503
    } ;

static const flex_int16_t yy_chk[785] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,

        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    5,    6,   19,   19,   20,   20,
       20,   22,   24,   26,   23,  516,   39,   22,   25,   30,
       27,   23,  198,   29,   45,   32,   39,  515,   23,   28,
       19,  198,   23,   22,   24,   26,    5,    6,   23,   22,
       28,   25,   27,   30,   23,   29,   45,   32,   47,   42,
       23,   33,   28,   32,   23,   42,   48,   33,   46,   51,
       50,   44,   28,   33,   59,   30,   52,   33,   44,   49,
       47,   42,   72,   72,   59,   44,   75,   42,   48,   44,
       49,   46,   50,   51,   53,   44,   77,   66,   52,   66,

       53,   44,   49,  159,   52,  159,   53,   44,   75,  102,
       53,   44,   49,   64,  103,   51,  116,   71,   77,   64,
       64,   71,   71,   74,   74,   74,   80,   80,   84,   84,
      118,  102,  106,  106,  121,  121,  103,  141,  116,  125,
      125,  142,  145,  145,  164,   64,  156,  156,  164,  164,
      166,  167,  118,  168,  191,  180,  204,  181,   64,  141,
      217,  166,  203,  142,  168,  180,  205,  181,  227,  244,
      217,  239,  239,  203,  234,  218,  514,  205,  166,  167,
      181,  168,  191,  234,  204,  218,  252,  168,  191,  181,
      203,  252,  244,  253,  205,  254,  227,  287,  218,  243,

      205,  257,  227,  243,  243,  278,  257,  218,  294,  295,
      278,  296,  330,  294,  299,  253,  319,  254,  351,  299,
      287,  319,  353,  351,  364,  367,  401,  353,  431,  364,
      387,  295,  389,  296,  330,  387,  399,  389,  460,  472,
      484,  399,  490,  513,  495,  497,  499,  367,  500,  512,
      494,  493,  492,  491,  401,  489,  431,  488,  487,  486,
      460,  472,  485,  484,  483,  490,  495,  497,  482,  478,
      499,  477,  500,  504,  504,  504,  504,  504,  505,  505,
      505,  505,  505,  506,  506,  506,  506,  506,  507,  473,
      507,  507,  507,  508,  508,  509,  509,  471,  509,  509,

      510,  510,  510,  510,  510,  511,  470,  511,  511,  511,
      466,  465,  461,  459,  458,  457,  456,  455,  454,  453,
      452,  451,  450,  447,  446,  445,  444,  443,  442,  441,
      440,  439,  438,  437,  436,  435,  434,  433,  432,  430,
      429,  428,  427,  426,  425,  424,  423,  421,  420,  417,
      416,  415,  414,  413,  412,  411,  410,  409,  408,  407,
      406,  405,  404,  403,  402,  400,  398,  397,  396,  395,
      394,  393,  392,  390,  388,  385,  384,  383,  382,  381,
      380,  379,  378,  377,  376,  375,  374,  371,  370,  369,
      368,  365,  363,  362,  361,  360,  359,  358,  357,  354,

      352,  349,  348,  347,  346,  345,  344,  343,  342,  341,
      340,  339,  338,  335,  334,  333,  332,  329,  326,  325,
      324,  323,  322,  321,  320,  318,  317,  316,  315,  314,
      313,  312,  311,  310,  309,  308,  307,  306,  305,  304,
      303,  302,  301,  300,  298,  297,  293,  292,  291,  290,
      289,  288,  286,  285,  284,  283,  282,  281,  280,  279,
      277,  276,  275,  274,  273,  272,  271,  269,  268,  267,
      266,  265,  264,  263,  262,  261,  260,  259,  258,  256,
      255,  251,  250,  249,  248,  247,  246,  245,  238,  237,
      236,  235,  233,  232,  231,  230,  229,  228,  226,  225,

      224,  223,  222,  221,  220,  219,  215,  214,  213,  212,
      211,  210,  209,  208,  207,  206,  202,  201,  200,  199,
      197,  196,  195,  194,  193,  192,  190,  189,  187,  186,
      185,  184,  183,  182,  178,  177,  176,  175,  174,  173,
      172,  171,  170,  169,  163,  162,  153,  152,  151,  150,
      149,  148,  147,  146,  144,  143,  140,  139,  137,  136,
      135,  134,  133,  132,  130,  129,  128,  127,  126,  124,
      123,  122,  120,  119,  114,  113,  112,  111,  110,  109,
      108,  107,  105,  104,  100,   99,   96,   95,   94,   93,
       92,   91,   89,   88,   87,   86,   85,   83,   82,   81,

       79,   78,   70,   68,   67,   61,   60,   58,   57,   56,
       55,   54,   41,   40,   38,   37,   36,   35,   34,   31,
       15,   13,   11,    9,    8,    7,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  503,
      503,  503,  503,  503
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "analyze.l"
#line 2 "analyze.l"
#include "config.h"

#include <stdlib.h>
#include <unistd.h> /* readlink */

#include <kbdfile.h>

#include "libcommon.h"
#include "contextP.h"
#include "ksyms.h"
#include "paths.h"

#include "parser.h"
#line 778 "analyze.c"

#define YY_NO_INPUT 1
#line 35 "analyze.l"
int
stack_push(struct lk_ctx *ctx, struct kbdfile *fp, void *scanner)
{
	int i = 0;

	while (ctx->stack[i]) i++;

	if (i == MAX_INCLUDE_DEPTH) {
		ERR(ctx, _("includes are nested too deeply"));
		return -1;
	}

	ctx->stack[i] = fp;

	yypush_buffer_state(yy_create_buffer(kbdfile_get_file(fp), YY_BUF_SIZE, scanner), scanner);
	return 0;
}

int
stack_pop(struct lk_ctx *ctx, void *scanner)
{
	int i = 0;

	while (ctx->stack[i]) i++;
	if (!i)
		return 0;
	i--;

	/*
	 * The top of stack is input file for library. No need to close it.
	 */
	if (i) {
		kbdfile_free(ctx->stack[i]);
	}
	ctx->stack[i] = NULL;

	yypop_buffer_state(scanner);
	return 0;
}

/*
 * Where shall we look for an include file?
 * Current strategy (undocumented, may change):
 *
 * 1. Look for a user-specified LOADKEYS_INCLUDE_PATH
 * 2. Try . and ../include and ../../include
 * 3. Try D and D/../include and D/../../include
 *    where D is the directory from where we are loading the current file.
 * 4. Try KD/include and KD/#/include where KD = DATADIR/KEYMAPDIR.
 *
 * Expected layout:
 * KD has subdirectories amiga, atari, i386, mac, sun, include
 * KD/include contains architecture-independent stuff
 * like strings and iso-8859-x compose tables.
 * KD/i386 has subdirectories qwerty, ... and include;
 * this latter include dir contains stuff with keycode=...
 *
 * (Of course, if the present setup turns out to be reasonable,
 * then later also the other architectures will grow and get
 * subdirectories, and the hard-coded i386 below will go again.)
 *
 * People that dislike a dozen lookups for loadkeys
 * can easily do "loadkeys file_with_includes; dumpkeys > my_keymap"
 * and afterwards use only "loadkeys /fullpath/mykeymap", where no
 * lookups are required.
 */
static const char *const include_dirpath0[] = { "", 0 };
static const char *const include_dirpath1[] = { "", "../include/", "../../include/", 0 };
static const char *const include_dirpath3[] = {
	DATADIR "/" KEYMAPDIR "/include/",
	DATADIR "/" KEYMAPDIR "/i386/include/",
	DATADIR "/" KEYMAPDIR "/mac/include/", 0
};

static const char *const include_suffixes[] = { "", ".inc", 0 };

static int
find_incl_file_near_fn(struct lk_ctx *ctx, char *s, char *fn, struct kbdfile *fp)
{
	const char *include_dirpath2[] = { 0, 0, 0, 0 };
	char *t, *te, *t1 = NULL, *t2 = NULL;
	size_t len;
	int rc = 1;

	if (!fn)
		return 1;

	t = strdup(fn);
	if (t == NULL)
		goto nomem;

	te = strrchr(t, '/');
	if (te) {
		te[1] = 0;
		len = strlen(t);
		include_dirpath2[0] = t;
		include_dirpath2[1] = t1 = malloc(len + 12);
		include_dirpath2[2] = t2 = malloc(len + 15);

		if (t1 == NULL || t2 == NULL)
			goto nomem;

		strcpy(t1, t);
		strcat(t1, "../include/");
		strcpy(t2, t);
		strcat(t2, "../../include/");
		rc = kbdfile_find(s, include_dirpath2, include_suffixes, fp);
		free(t1);
		free(t2);
	}
	free(t);
	return rc;

nomem:	ERR(ctx, _("out of memory"));
	if (t1) free(t1);
	if (t2) free(t2);
	if (t)  free(t);
	return -1;
}

static int
find_standard_incl_file(struct lk_ctx *ctx, char *s, struct kbdfile *fp)
{
	char *pathname;
	int rc = 1;
	int i = 0;

	while (ctx->stack[i]) i++;
	if (i == 0)
		return -1;
	i--;
	pathname = kbdfile_get_pathname(ctx->stack[i]);

	if (kbdfile_find(s, include_dirpath1, include_suffixes, fp)) {
		if ((rc = find_incl_file_near_fn(ctx, s, pathname, fp)) == -1)
			return rc;
	}

	/* If filename is a symlink, also look near its target. */
	if (rc) {
		char buf[MAXPATHLEN], path[MAXPATHLEN], *ptr;
		ssize_t n;

		n = readlink(pathname, buf, sizeof(buf));
		if (n > 0 && n < (ssize_t) sizeof(buf)) {
			buf[n] = 0;
			if (buf[0] == '/') {
				rc = find_incl_file_near_fn(ctx, s, buf, fp);

			} else if (strlen(pathname) + (size_t) n < sizeof(path)) {
				strcpy(path, pathname);
				path[sizeof(path) - 1] = 0;
				ptr = strrchr(path, '/');
				if (ptr)
					ptr[1] = 0;
				strcat(path, buf);
				rc = find_incl_file_near_fn(ctx, s, path, fp);
			}
		}
	}

	if (rc)
		rc = kbdfile_find(s, include_dirpath3, include_suffixes, fp);
	return rc;
}

static int
find_incl_file(struct lk_ctx *ctx, char *s, struct kbdfile *fp)
{
	char *ev;

	if (!s || !*s)
		return 1;

	if (*s == '/')		/* no path required */
		return (kbdfile_find(s, include_dirpath0, include_suffixes, fp));

	if ((ev = getenv("LOADKEYS_INCLUDE_PATH")) != NULL) {
		/* try user-specified path */
		const char *user_dir[2] = { 0, 0 };
		while (ev) {
			int rc;
			char *t = strchr(ev, ':');
			char sv = 0;
			if (t) {
				sv = *t;
				*t = 0;
			}
			user_dir[0] = ev;
			if (*ev)
				rc = kbdfile_find(s, user_dir, include_suffixes, fp);
			else	/* empty string denotes system path */
				rc = find_standard_incl_file(ctx, s, fp);

			if (rc <= 0)
				return rc;
			if (t)
				*t++ = sv;
			ev = t;
		}
		return 1;
	}
	return find_standard_incl_file(ctx, s, fp);
}

static int
open_include(struct lk_ctx *ctx, char *s, yyscan_t scanner)
{
	int rc;
	struct kbdfile *fp;

	INFO(ctx, _("switching to %s"), s);

	fp = kbdfile_new(ctx->kbdfile_ctx);
	if (!fp) {
		ERR(ctx, _("out of memory"));
		return -1;
	}

	rc = find_incl_file(ctx, s, fp);
	if (rc > 0) {
		ERR(ctx, _("cannot open include file %s"), s);
		free(s);
		return -1;
	} else if (rc == -1) {
		free(s);
		return -1;
	}

	free(s);

	return stack_push(ctx, fp, scanner);
}

static int
parse_int(struct lk_ctx *ctx, char *text, char *value, int base, int *res)
{
	long v;

	errno = 0;
	v = strtol(value, NULL, base);

	if (errno) {
		ERR(ctx, _("unable to parse number: %s"), text);
		return -1;
	}

	if (v < 0) {
		ERR(ctx, _("value must be a positive number: %s"), text);
		return -1;
	}

	if (v > INT_MAX) {
		ERR(ctx, _("value must be less than %d: %s"), INT_MAX, text);
		return -1;
	}

	*res = (int) v;

	return 0;
}

#line 1044 "analyze.c"

#line 1046 "analyze.c"

#define INITIAL 0
#define RVALUE 1
#define STR 2
#define INCLSTR 3

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#define YY_EXTRA_TYPE struct lk_ctx *

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

    static void yy_push_state ( int _new_state , yyscan_t yyscanner);
    
    static void yy_pop_state ( yyscan_t yyscanner );
    
/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 336 "analyze.l"


#line 1326 "analyze.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 504 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 503 );
		yy_cp = yyg->yy_last_accepting_cpos;
		yy_current_state = yyg->yy_last_accepting_state;

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 338 "analyze.l"
{
				yy_push_state(INCLSTR, yyscanner);
			}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 341 "analyze.l"
{
				char *s = strndup(yytext+1, strlen(yytext)-2);
				if (s == NULL) {
					ERR(yyextra, _("out of memory"));
					return(ERROR);
				}

				if (open_include(yyextra, s, yyscanner) == -1)
					return(ERROR);

				while (((struct yyguts_t*)yyscanner)->yy_start_stack_ptr) {
					yy_pop_state(yyscanner);
				}
			}
	YY_BREAK
case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 355 "analyze.l"
{
				ERR(yyextra, _("expected filename between quotes"));
				return(ERROR);
			}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(RVALUE):
case YY_STATE_EOF(STR):
case YY_STATE_EOF(INCLSTR):
#line 359 "analyze.l"
{
				stack_pop(yyextra, yyscanner);
				if (!YY_CURRENT_BUFFER)
					yyterminate();
			}
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 364 "analyze.l"
{
				yyset_lineno(yyget_lineno(yyscanner) + 1, yyscanner);
			}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 367 "analyze.l"
{
				yyset_lineno(yyget_lineno(yyscanner) + 1, yyscanner);

				while (((struct yyguts_t*)yyscanner)->yy_start_stack_ptr) {
					yy_pop_state(yyscanner);
				}
				return(EOL);
			}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 375 "analyze.l"
; /* do nothing */
	YY_BREAK
case 7:
/* rule 7 can match eol */
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_cp - 1);
yyg->yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 376 "analyze.l"
; /* do nothing */
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 377 "analyze.l"
{
				yy_push_state(RVALUE, yyscanner);
				lk_array_empty(yyextra->key_line);
				return(EQUALS);
			}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 382 "analyze.l"
{
				yy_push_state(RVALUE, yyscanner);
				return(STRING);
			}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 386 "analyze.l"
{
				yy_push_state(RVALUE, yyscanner);
				return(TO);
			}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 390 "analyze.l"
{
				if (parse_int(yyextra, yytext, yytext + 1, 16, &(yylval->num)) < 0)
					return(ERROR);

				if (yylval->num >= 0xf000) {
					ERR(yyextra, _("unicode keysym out of range: %s"),
						yytext);
					return(ERROR);
				}

				return(UNUMBER);
			}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 402 "analyze.l"
{
				if (parse_int(yyextra, yytext, yytext, 0, &(yylval->num)) < 0)
					return(ERROR);

				return(NUMBER);
			}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 408 "analyze.l"
{	return((yylval->num = ksymtocode(yyextra, yytext, TO_AUTO)) == -1 ? ERROR : LITERAL);	}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 409 "analyze.l"
{	return(DASH);		}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 410 "analyze.l"
{	return(COMMA);		}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 411 "analyze.l"
{	return(PLUS);		}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 412 "analyze.l"
{	return(CHARSET);	}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 413 "analyze.l"
{	return(KEYMAPS);	}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 414 "analyze.l"
{	return(KEYCODE);	}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 415 "analyze.l"
{	return(PLAIN);		}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 416 "analyze.l"
{	return(SHIFT);		}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 417 "analyze.l"
{	return(CONTROL);	}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 418 "analyze.l"
{	return(ALT);		}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 419 "analyze.l"
{	return(ALTGR);		}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 420 "analyze.l"
{	return(SHIFTL);		}
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 421 "analyze.l"
{	return(SHIFTR);		}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 422 "analyze.l"
{	return(CTRLL);		}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 423 "analyze.l"
{	return(CTRLR);		}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 424 "analyze.l"
{	return(CAPSSHIFT);	}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 425 "analyze.l"
{	return(ALT_IS_META);	}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 426 "analyze.l"
{	return(STRINGS);	}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 427 "analyze.l"
{	return(COMPOSE);	}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 428 "analyze.l"
{	return(AS);		}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 429 "analyze.l"
{	return(USUAL);		}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 430 "analyze.l"
{	return(ON);		}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 431 "analyze.l"
{	return(FOR);		}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 432 "analyze.l"
{
				if (parse_int(yyextra, yytext, yytext + 2, 8, &(yylval->num)) < 0)
					return(ERROR);

				return(CCHAR);
			}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 438 "analyze.l"
{
				yylval->num = (unsigned char) yytext[2];
				return(CCHAR);
			}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 442 "analyze.l"
{
				yylval->num = (unsigned char) yytext[1];
				return(CCHAR);
			}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 446 "analyze.l"
{
				yylval->str.data[0] = '\0';
				yylval->str.len = 0;

				yy_push_state(STR, yyscanner);
			}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 452 "analyze.l"
{
				long int i;
				if (yylval->str.len == MAX_PARSER_STRING) {
					ERR(yyextra, _("string too long"));
					return(ERROR);
				}

				i = strtol(yytext + 1, NULL, 8);

				if (i == LONG_MIN || i == LONG_MAX) {
					char buf[200];

					strerror_r(errno, buf, sizeof(buf));

					ERR(yyextra, buf);
					return(ERROR);
				}

				if (i > UCHAR_MAX) {
					ERR(yyextra, _("octal number too big"));
					return(ERROR);
				}

				yylval->str.data[yylval->str.len++] = (unsigned char) i;
			}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 477 "analyze.l"
{
				if (yylval->str.len == MAX_PARSER_STRING) {
					ERR(yyextra, _("string too long"));
					return(ERROR);
				}
				yylval->str.data[yylval->str.len++] = '"';
			}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 484 "analyze.l"
{
				if (yylval->str.len == MAX_PARSER_STRING) {
					ERR(yyextra, _("string too long"));
					return(ERROR);
				}
				yylval->str.data[yylval->str.len++] = '\\';
			}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 491 "analyze.l"
{
				if (yylval->str.len == MAX_PARSER_STRING) {
					ERR(yyextra, _("string too long"));
					return(ERROR);
				}
				yylval->str.data[yylval->str.len++] = '\n';
			}
	YY_BREAK
case 45:
/* rule 45 can match eol */
YY_RULE_SETUP
#line 498 "analyze.l"
{
				size_t len = strlen(yytext);

				if (yylval->str.len + len >= MAX_PARSER_STRING) {
					ERR(yyextra, _("string too long"));
					return(ERROR);
				}

				strcpy((char *) yylval->str.data + yylval->str.len, yytext);
				yylval->str.len += len;
			}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 509 "analyze.l"
{
				yylval->str.data[yylval->str.len] = '\0';
				while (((struct yyguts_t*)yyscanner)->yy_start_stack_ptr) {
					yy_pop_state(yyscanner);
				}
				return(STRLITERAL);
			}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 516 "analyze.l"
{
				return(ERROR);
			}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 519 "analyze.l"
ECHO;
	YY_BREAK
#line 1768 "analyze.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_last_accepting_cpos;
				yy_current_state = yyg->yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 504 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	char *yy_cp = yyg->yy_c_buf_p;

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 504 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 503);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

    static void yy_push_state (int  _new_state , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( yyg->yy_start_stack_ptr >= yyg->yy_start_stack_depth )
		{
		yy_size_t new_size;

		yyg->yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = (yy_size_t) yyg->yy_start_stack_depth * sizeof( int );

		if ( ! yyg->yy_start_stack )
			yyg->yy_start_stack = (int *) yyalloc( new_size , yyscanner );

		else
			yyg->yy_start_stack = (int *) yyrealloc(
					(void *) yyg->yy_start_stack, new_size , yyscanner );

		if ( ! yyg->yy_start_stack )
			YY_FATAL_ERROR( "out of memory expanding start-condition stack" );
		}

	yyg->yy_start_stack[yyg->yy_start_stack_ptr++] = YY_START;

	BEGIN(_new_state);
}

    static void yy_pop_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( --yyg->yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yyg->yy_start_stack[yyg->yy_start_stack_ptr]);
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner YY_ATTRIBUTE_UNUSED)
{
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner YY_ATTRIBUTE_UNUSED)
{
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner YY_ATTRIBUTE_UNUSED)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size , yyscan_t yyscanner YY_ATTRIBUTE_UNUSED)
{
	return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner YY_ATTRIBUTE_UNUSED)
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr , yyscan_t yyscanner YY_ATTRIBUTE_UNUSED)
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#line 519 "analyze.l"


