// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::fmt;

/// A set of error code for [`glib::Error`][crate::glib::Error] for operations in [`FwFcp`][crate::FwFcp].
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "HinawaFwFcpError")]
pub enum FwFcpError {
    /// The transaction is canceled due to response timeout.
    #[doc(alias = "HINAWA_FW_FCP_ERROR_TIMEOUT")]
    Timeout,
    /// The size of response is larger than expected.
    #[doc(alias = "HINAWA_FW_FCP_ERROR_LARGE_RESP")]
    LargeResp,
    #[doc(alias = "HINAWA_FW_FCP_ERROR_ABORTED")]
    Aborted,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FwFcpError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FwFcpError::{}",
            match *self {
                Self::Timeout => "Timeout",
                Self::LargeResp => "LargeResp",
                Self::Aborted => "Aborted",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FwFcpError {
    type GlibType = ffi::HinawaFwFcpError;

    fn into_glib(self) -> ffi::HinawaFwFcpError {
        match self {
            Self::Timeout => ffi::HINAWA_FW_FCP_ERROR_TIMEOUT,
            Self::LargeResp => ffi::HINAWA_FW_FCP_ERROR_LARGE_RESP,
            Self::Aborted => ffi::HINAWA_FW_FCP_ERROR_ABORTED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::HinawaFwFcpError> for FwFcpError {
    unsafe fn from_glib(value: ffi::HinawaFwFcpError) -> Self {
        match value {
            ffi::HINAWA_FW_FCP_ERROR_TIMEOUT => Self::Timeout,
            ffi::HINAWA_FW_FCP_ERROR_LARGE_RESP => Self::LargeResp,
            ffi::HINAWA_FW_FCP_ERROR_ABORTED => Self::Aborted,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for FwFcpError {
    fn domain() -> Quark {
        unsafe { from_glib(ffi::hinawa_fw_fcp_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        match code {
            ffi::HINAWA_FW_FCP_ERROR_TIMEOUT => Some(Self::Timeout),
            ffi::HINAWA_FW_FCP_ERROR_LARGE_RESP => Some(Self::LargeResp),
            ffi::HINAWA_FW_FCP_ERROR_ABORTED => Some(Self::Aborted),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for FwFcpError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::hinawa_fw_fcp_error_get_type()) }
    }
}

impl glib::value::ValueType for FwFcpError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FwFcpError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FwFcpError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

/// A set of error code for [`glib::Error`][crate::glib::Error] for operations in [`FwNode`][crate::FwNode].
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "HinawaFwNodeError")]
pub enum FwNodeError {
    /// The node associated to the instance is disconnected.
    #[doc(alias = "HINAWA_FW_NODE_ERROR_DISCONNECTED")]
    Disconnected,
    /// The instance is already associated to node by opening firewire character device.
    #[doc(alias = "HINAWA_FW_NODE_ERROR_OPENED")]
    Opened,
    /// The instance is not associated to node by opening firewire character device.
    #[doc(alias = "HINAWA_FW_NODE_ERROR_NOT_OPENED")]
    NotOpened,
    /// The system call fails.
    #[doc(alias = "HINAWA_FW_NODE_ERROR_FAILED")]
    Failed,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FwNodeError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FwNodeError::{}",
            match *self {
                Self::Disconnected => "Disconnected",
                Self::Opened => "Opened",
                Self::NotOpened => "NotOpened",
                Self::Failed => "Failed",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FwNodeError {
    type GlibType = ffi::HinawaFwNodeError;

    fn into_glib(self) -> ffi::HinawaFwNodeError {
        match self {
            Self::Disconnected => ffi::HINAWA_FW_NODE_ERROR_DISCONNECTED,
            Self::Opened => ffi::HINAWA_FW_NODE_ERROR_OPENED,
            Self::NotOpened => ffi::HINAWA_FW_NODE_ERROR_NOT_OPENED,
            Self::Failed => ffi::HINAWA_FW_NODE_ERROR_FAILED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::HinawaFwNodeError> for FwNodeError {
    unsafe fn from_glib(value: ffi::HinawaFwNodeError) -> Self {
        match value {
            ffi::HINAWA_FW_NODE_ERROR_DISCONNECTED => Self::Disconnected,
            ffi::HINAWA_FW_NODE_ERROR_OPENED => Self::Opened,
            ffi::HINAWA_FW_NODE_ERROR_NOT_OPENED => Self::NotOpened,
            ffi::HINAWA_FW_NODE_ERROR_FAILED => Self::Failed,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for FwNodeError {
    fn domain() -> Quark {
        unsafe { from_glib(ffi::hinawa_fw_node_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        match code {
            ffi::HINAWA_FW_NODE_ERROR_DISCONNECTED => Some(Self::Disconnected),
            ffi::HINAWA_FW_NODE_ERROR_OPENED => Some(Self::Opened),
            ffi::HINAWA_FW_NODE_ERROR_NOT_OPENED => Some(Self::NotOpened),
            ffi::HINAWA_FW_NODE_ERROR_FAILED => Some(Self::Failed),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for FwNodeError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::hinawa_fw_node_error_get_type()) }
    }
}

impl glib::value::ValueType for FwNodeError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FwNodeError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FwNodeError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

/// A representation for rcode of asynchronous transaction on IEEE 1394 bus.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "HinawaFwRcode")]
pub enum FwRcode {
    /// For completion.
    #[doc(alias = "HINAWA_FW_RCODE_COMPLETE")]
    Complete,
    /// For error of conflicting.
    #[doc(alias = "HINAWA_FW_RCODE_CONFLICT_ERROR")]
    ConflictError,
    /// For error of data.
    #[doc(alias = "HINAWA_FW_RCODE_DATA_ERROR")]
    DataError,
    /// For error of type.
    #[doc(alias = "HINAWA_FW_RCODE_TYPE_ERROR")]
    TypeError,
    /// For error of address.
    #[doc(alias = "HINAWA_FW_RCODE_ADDRESS_ERROR")]
    AddressError,
    /// For error of sending.
    #[doc(alias = "HINAWA_FW_RCODE_SEND_ERROR")]
    SendError,
    /// For cancellation.
    #[doc(alias = "HINAWA_FW_RCODE_CANCELLED")]
    Cancelled,
    // For busyness.
    #[doc(alias = "HINAWA_FW_RCODE_BUSY")]
    Busy,
    /// For generation.
    #[doc(alias = "HINAWA_FW_RCODE_GENERATION")]
    Generation,
    /// For no acknowledge.
    #[doc(alias = "HINAWA_FW_RCODE_NO_ACK")]
    NoAck,
    /// For rcode out of specification.
    #[doc(alias = "HINAWA_FW_RCODE_INVALID")]
    Invalid,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FwRcode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FwRcode::{}",
            match *self {
                Self::Complete => "Complete",
                Self::ConflictError => "ConflictError",
                Self::DataError => "DataError",
                Self::TypeError => "TypeError",
                Self::AddressError => "AddressError",
                Self::SendError => "SendError",
                Self::Cancelled => "Cancelled",
                Self::Busy => "Busy",
                Self::Generation => "Generation",
                Self::NoAck => "NoAck",
                Self::Invalid => "Invalid",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FwRcode {
    type GlibType = ffi::HinawaFwRcode;

    fn into_glib(self) -> ffi::HinawaFwRcode {
        match self {
            Self::Complete => ffi::HINAWA_FW_RCODE_COMPLETE,
            Self::ConflictError => ffi::HINAWA_FW_RCODE_CONFLICT_ERROR,
            Self::DataError => ffi::HINAWA_FW_RCODE_DATA_ERROR,
            Self::TypeError => ffi::HINAWA_FW_RCODE_TYPE_ERROR,
            Self::AddressError => ffi::HINAWA_FW_RCODE_ADDRESS_ERROR,
            Self::SendError => ffi::HINAWA_FW_RCODE_SEND_ERROR,
            Self::Cancelled => ffi::HINAWA_FW_RCODE_CANCELLED,
            Self::Busy => ffi::HINAWA_FW_RCODE_BUSY,
            Self::Generation => ffi::HINAWA_FW_RCODE_GENERATION,
            Self::NoAck => ffi::HINAWA_FW_RCODE_NO_ACK,
            Self::Invalid => ffi::HINAWA_FW_RCODE_INVALID,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::HinawaFwRcode> for FwRcode {
    unsafe fn from_glib(value: ffi::HinawaFwRcode) -> Self {
        match value {
            ffi::HINAWA_FW_RCODE_COMPLETE => Self::Complete,
            ffi::HINAWA_FW_RCODE_CONFLICT_ERROR => Self::ConflictError,
            ffi::HINAWA_FW_RCODE_DATA_ERROR => Self::DataError,
            ffi::HINAWA_FW_RCODE_TYPE_ERROR => Self::TypeError,
            ffi::HINAWA_FW_RCODE_ADDRESS_ERROR => Self::AddressError,
            ffi::HINAWA_FW_RCODE_SEND_ERROR => Self::SendError,
            ffi::HINAWA_FW_RCODE_CANCELLED => Self::Cancelled,
            ffi::HINAWA_FW_RCODE_BUSY => Self::Busy,
            ffi::HINAWA_FW_RCODE_GENERATION => Self::Generation,
            ffi::HINAWA_FW_RCODE_NO_ACK => Self::NoAck,
            ffi::HINAWA_FW_RCODE_INVALID => Self::Invalid,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FwRcode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::hinawa_fw_rcode_get_type()) }
    }
}

impl glib::value::ValueType for FwRcode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FwRcode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FwRcode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

/// A set of error code for [`glib::Error`][crate::glib::Error] for operations in [`FwReq`][crate::FwReq].
///
/// The actual value is equivalent to [`FwRcode`][crate::FwRcode].
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "HinawaFwReqError")]
pub enum FwReqError {
    /// For error of conflicting.
    #[doc(alias = "HINAWA_FW_REQ_ERROR_CONFLICT_ERROR")]
    ConflictError,
    /// For error of data.
    #[doc(alias = "HINAWA_FW_REQ_ERROR_DATA_ERROR")]
    DataError,
    /// For error of type.
    #[doc(alias = "HINAWA_FW_REQ_ERROR_TYPE_ERROR")]
    TypeError,
    /// For error of address.
    #[doc(alias = "HINAWA_FW_REQ_ERROR_ADDRESS_ERROR")]
    AddressError,
    /// For error of sending.
    #[doc(alias = "HINAWA_FW_REQ_ERROR_SEND_ERROR")]
    SendError,
    /// For cancellation.
    #[doc(alias = "HINAWA_FW_REQ_ERROR_CANCELLED")]
    Cancelled,
    /// For busyness.
    #[doc(alias = "HINAWA_FW_REQ_ERROR_BUSY")]
    Busy,
    /// For generation.
    #[doc(alias = "HINAWA_FW_REQ_ERROR_GENERATION")]
    Generation,
    /// For no acknowledge.
    #[doc(alias = "HINAWA_FW_REQ_ERROR_NO_ACK")]
    NoAck,
    /// For rcode out of specification.
    #[doc(alias = "HINAWA_FW_REQ_ERROR_INVALID")]
    Invalid,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FwReqError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FwReqError::{}",
            match *self {
                Self::ConflictError => "ConflictError",
                Self::DataError => "DataError",
                Self::TypeError => "TypeError",
                Self::AddressError => "AddressError",
                Self::SendError => "SendError",
                Self::Cancelled => "Cancelled",
                Self::Busy => "Busy",
                Self::Generation => "Generation",
                Self::NoAck => "NoAck",
                Self::Invalid => "Invalid",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FwReqError {
    type GlibType = ffi::HinawaFwReqError;

    fn into_glib(self) -> ffi::HinawaFwReqError {
        match self {
            Self::ConflictError => ffi::HINAWA_FW_REQ_ERROR_CONFLICT_ERROR,
            Self::DataError => ffi::HINAWA_FW_REQ_ERROR_DATA_ERROR,
            Self::TypeError => ffi::HINAWA_FW_REQ_ERROR_TYPE_ERROR,
            Self::AddressError => ffi::HINAWA_FW_REQ_ERROR_ADDRESS_ERROR,
            Self::SendError => ffi::HINAWA_FW_REQ_ERROR_SEND_ERROR,
            Self::Cancelled => ffi::HINAWA_FW_REQ_ERROR_CANCELLED,
            Self::Busy => ffi::HINAWA_FW_REQ_ERROR_BUSY,
            Self::Generation => ffi::HINAWA_FW_REQ_ERROR_GENERATION,
            Self::NoAck => ffi::HINAWA_FW_REQ_ERROR_NO_ACK,
            Self::Invalid => ffi::HINAWA_FW_REQ_ERROR_INVALID,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::HinawaFwReqError> for FwReqError {
    unsafe fn from_glib(value: ffi::HinawaFwReqError) -> Self {
        match value {
            ffi::HINAWA_FW_REQ_ERROR_CONFLICT_ERROR => Self::ConflictError,
            ffi::HINAWA_FW_REQ_ERROR_DATA_ERROR => Self::DataError,
            ffi::HINAWA_FW_REQ_ERROR_TYPE_ERROR => Self::TypeError,
            ffi::HINAWA_FW_REQ_ERROR_ADDRESS_ERROR => Self::AddressError,
            ffi::HINAWA_FW_REQ_ERROR_SEND_ERROR => Self::SendError,
            ffi::HINAWA_FW_REQ_ERROR_CANCELLED => Self::Cancelled,
            ffi::HINAWA_FW_REQ_ERROR_BUSY => Self::Busy,
            ffi::HINAWA_FW_REQ_ERROR_GENERATION => Self::Generation,
            ffi::HINAWA_FW_REQ_ERROR_NO_ACK => Self::NoAck,
            ffi::HINAWA_FW_REQ_ERROR_INVALID => Self::Invalid,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for FwReqError {
    fn domain() -> Quark {
        unsafe { from_glib(ffi::hinawa_fw_req_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        match code {
            ffi::HINAWA_FW_REQ_ERROR_CONFLICT_ERROR => Some(Self::ConflictError),
            ffi::HINAWA_FW_REQ_ERROR_DATA_ERROR => Some(Self::DataError),
            ffi::HINAWA_FW_REQ_ERROR_TYPE_ERROR => Some(Self::TypeError),
            ffi::HINAWA_FW_REQ_ERROR_ADDRESS_ERROR => Some(Self::AddressError),
            ffi::HINAWA_FW_REQ_ERROR_SEND_ERROR => Some(Self::SendError),
            ffi::HINAWA_FW_REQ_ERROR_CANCELLED => Some(Self::Cancelled),
            ffi::HINAWA_FW_REQ_ERROR_BUSY => Some(Self::Busy),
            ffi::HINAWA_FW_REQ_ERROR_GENERATION => Some(Self::Generation),
            ffi::HINAWA_FW_REQ_ERROR_NO_ACK => Some(Self::NoAck),
            ffi::HINAWA_FW_REQ_ERROR_INVALID => Some(Self::Invalid),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for FwReqError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::hinawa_fw_req_error_get_type()) }
    }
}

impl glib::value::ValueType for FwReqError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FwReqError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FwReqError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

/// A set of error code for [`glib::Error`][crate::glib::Error] for operations in [`FwResp`][crate::FwResp].
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "HinawaFwRespError")]
pub enum FwRespError {
    /// The generic system call error.
    #[doc(alias = "HINAWA_FW_RESP_ERROR_FAILED")]
    Failed,
    /// The instance is already associated to reserved address range.
    #[doc(alias = "HINAWA_FW_RESP_ERROR_RESERVED")]
    Reserved,
    /// The address space is used exclusively.
    #[doc(alias = "HINAWA_FW_RESP_ERROR_ADDR_SPACE_USED")]
    AddrSpaceUsed,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FwRespError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FwRespError::{}",
            match *self {
                Self::Failed => "Failed",
                Self::Reserved => "Reserved",
                Self::AddrSpaceUsed => "AddrSpaceUsed",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FwRespError {
    type GlibType = ffi::HinawaFwRespError;

    fn into_glib(self) -> ffi::HinawaFwRespError {
        match self {
            Self::Failed => ffi::HINAWA_FW_RESP_ERROR_FAILED,
            Self::Reserved => ffi::HINAWA_FW_RESP_ERROR_RESERVED,
            Self::AddrSpaceUsed => ffi::HINAWA_FW_RESP_ERROR_ADDR_SPACE_USED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::HinawaFwRespError> for FwRespError {
    unsafe fn from_glib(value: ffi::HinawaFwRespError) -> Self {
        match value {
            ffi::HINAWA_FW_RESP_ERROR_FAILED => Self::Failed,
            ffi::HINAWA_FW_RESP_ERROR_RESERVED => Self::Reserved,
            ffi::HINAWA_FW_RESP_ERROR_ADDR_SPACE_USED => Self::AddrSpaceUsed,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for FwRespError {
    fn domain() -> Quark {
        unsafe { from_glib(ffi::hinawa_fw_resp_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        match code {
            ffi::HINAWA_FW_RESP_ERROR_FAILED => Some(Self::Failed),
            ffi::HINAWA_FW_RESP_ERROR_RESERVED => Some(Self::Reserved),
            ffi::HINAWA_FW_RESP_ERROR_ADDR_SPACE_USED => Some(Self::AddrSpaceUsed),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for FwRespError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::hinawa_fw_resp_error_get_type()) }
    }
}

impl glib::value::ValueType for FwRespError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FwRespError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FwRespError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

/// A representation for tcode of asynchronous transaction on IEEE 1394 bus.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "HinawaFwTcode")]
pub enum FwTcode {
    /// For request to write quadlet.
    #[doc(alias = "HINAWA_FW_TCODE_WRITE_QUADLET_REQUEST")]
    WriteQuadletRequest,
    /// For request to write block.
    #[doc(alias = "HINAWA_FW_TCODE_WRITE_BLOCK_REQUEST")]
    WriteBlockRequest,
    /// For response to write.
    #[doc(alias = "HINAWA_FW_TCODE_WRITE_RESPONSE")]
    WriteResponse,
    /// For response to read quadlet.
    #[doc(alias = "HINAWA_FW_TCODE_READ_QUADLET_REQUEST")]
    ReadQuadletRequest,
    /// For request to read block.
    #[doc(alias = "HINAWA_FW_TCODE_READ_BLOCK_REQUEST")]
    ReadBlockRequest,
    /// For response to quadlet read.
    #[doc(alias = "HINAWA_FW_TCODE_READ_QUADLET_RESPONSE")]
    ReadQuadletResponse,
    /// For response to block read.
    #[doc(alias = "HINAWA_FW_TCODE_READ_BLOCK_RESPONSE")]
    ReadBlockResponse,
    /// For cycle start.
    #[doc(alias = "HINAWA_FW_TCODE_CYCLE_START")]
    CycleStart,
    /// For request to lock.
    #[doc(alias = "HINAWA_FW_TCODE_LOCK_REQUEST")]
    LockRequest,
    /// For stream data.
    #[doc(alias = "HINAWA_FW_TCODE_STREAM_DATA")]
    StreamData,
    /// For response to lock.
    #[doc(alias = "HINAWA_FW_TCODE_LOCK_RESPONSE")]
    LockResponse,
    /// For lock request for mask-swap.
    #[doc(alias = "HINAWA_FW_TCODE_LOCK_MASK_SWAP")]
    LockMaskSwap,
    /// For lock request for compare-swap.
    #[doc(alias = "HINAWA_FW_TCODE_LOCK_COMPARE_SWAP")]
    LockCompareSwap,
    /// For lock request for fetch-add.
    #[doc(alias = "HINAWA_FW_TCODE_LOCK_FETCH_ADD")]
    LockFetchAdd,
    /// For lock request for little-add.
    #[doc(alias = "HINAWA_FW_TCODE_LOCK_LITTLE_ADD")]
    LockLittleAdd,
    /// For lock request for bounded-add.
    #[doc(alias = "HINAWA_FW_TCODE_LOCK_BOUNDED_ADD")]
    LockBoundedAdd,
    /// For lock request for wrap-add.
    #[doc(alias = "HINAWA_FW_TCODE_LOCK_WRAP_ADD")]
    LockWrapAdd,
    /// For lock request for vendor-dependent.
    #[doc(alias = "HINAWA_FW_TCODE_LOCK_VENDOR_DEPENDENT")]
    LockVendorDependent,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FwTcode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FwTcode::{}",
            match *self {
                Self::WriteQuadletRequest => "WriteQuadletRequest",
                Self::WriteBlockRequest => "WriteBlockRequest",
                Self::WriteResponse => "WriteResponse",
                Self::ReadQuadletRequest => "ReadQuadletRequest",
                Self::ReadBlockRequest => "ReadBlockRequest",
                Self::ReadQuadletResponse => "ReadQuadletResponse",
                Self::ReadBlockResponse => "ReadBlockResponse",
                Self::CycleStart => "CycleStart",
                Self::LockRequest => "LockRequest",
                Self::StreamData => "StreamData",
                Self::LockResponse => "LockResponse",
                Self::LockMaskSwap => "LockMaskSwap",
                Self::LockCompareSwap => "LockCompareSwap",
                Self::LockFetchAdd => "LockFetchAdd",
                Self::LockLittleAdd => "LockLittleAdd",
                Self::LockBoundedAdd => "LockBoundedAdd",
                Self::LockWrapAdd => "LockWrapAdd",
                Self::LockVendorDependent => "LockVendorDependent",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FwTcode {
    type GlibType = ffi::HinawaFwTcode;

    fn into_glib(self) -> ffi::HinawaFwTcode {
        match self {
            Self::WriteQuadletRequest => ffi::HINAWA_FW_TCODE_WRITE_QUADLET_REQUEST,
            Self::WriteBlockRequest => ffi::HINAWA_FW_TCODE_WRITE_BLOCK_REQUEST,
            Self::WriteResponse => ffi::HINAWA_FW_TCODE_WRITE_RESPONSE,
            Self::ReadQuadletRequest => ffi::HINAWA_FW_TCODE_READ_QUADLET_REQUEST,
            Self::ReadBlockRequest => ffi::HINAWA_FW_TCODE_READ_BLOCK_REQUEST,
            Self::ReadQuadletResponse => ffi::HINAWA_FW_TCODE_READ_QUADLET_RESPONSE,
            Self::ReadBlockResponse => ffi::HINAWA_FW_TCODE_READ_BLOCK_RESPONSE,
            Self::CycleStart => ffi::HINAWA_FW_TCODE_CYCLE_START,
            Self::LockRequest => ffi::HINAWA_FW_TCODE_LOCK_REQUEST,
            Self::StreamData => ffi::HINAWA_FW_TCODE_STREAM_DATA,
            Self::LockResponse => ffi::HINAWA_FW_TCODE_LOCK_RESPONSE,
            Self::LockMaskSwap => ffi::HINAWA_FW_TCODE_LOCK_MASK_SWAP,
            Self::LockCompareSwap => ffi::HINAWA_FW_TCODE_LOCK_COMPARE_SWAP,
            Self::LockFetchAdd => ffi::HINAWA_FW_TCODE_LOCK_FETCH_ADD,
            Self::LockLittleAdd => ffi::HINAWA_FW_TCODE_LOCK_LITTLE_ADD,
            Self::LockBoundedAdd => ffi::HINAWA_FW_TCODE_LOCK_BOUNDED_ADD,
            Self::LockWrapAdd => ffi::HINAWA_FW_TCODE_LOCK_WRAP_ADD,
            Self::LockVendorDependent => ffi::HINAWA_FW_TCODE_LOCK_VENDOR_DEPENDENT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::HinawaFwTcode> for FwTcode {
    unsafe fn from_glib(value: ffi::HinawaFwTcode) -> Self {
        match value {
            ffi::HINAWA_FW_TCODE_WRITE_QUADLET_REQUEST => Self::WriteQuadletRequest,
            ffi::HINAWA_FW_TCODE_WRITE_BLOCK_REQUEST => Self::WriteBlockRequest,
            ffi::HINAWA_FW_TCODE_WRITE_RESPONSE => Self::WriteResponse,
            ffi::HINAWA_FW_TCODE_READ_QUADLET_REQUEST => Self::ReadQuadletRequest,
            ffi::HINAWA_FW_TCODE_READ_BLOCK_REQUEST => Self::ReadBlockRequest,
            ffi::HINAWA_FW_TCODE_READ_QUADLET_RESPONSE => Self::ReadQuadletResponse,
            ffi::HINAWA_FW_TCODE_READ_BLOCK_RESPONSE => Self::ReadBlockResponse,
            ffi::HINAWA_FW_TCODE_CYCLE_START => Self::CycleStart,
            ffi::HINAWA_FW_TCODE_LOCK_REQUEST => Self::LockRequest,
            ffi::HINAWA_FW_TCODE_STREAM_DATA => Self::StreamData,
            ffi::HINAWA_FW_TCODE_LOCK_RESPONSE => Self::LockResponse,
            ffi::HINAWA_FW_TCODE_LOCK_MASK_SWAP => Self::LockMaskSwap,
            ffi::HINAWA_FW_TCODE_LOCK_COMPARE_SWAP => Self::LockCompareSwap,
            ffi::HINAWA_FW_TCODE_LOCK_FETCH_ADD => Self::LockFetchAdd,
            ffi::HINAWA_FW_TCODE_LOCK_LITTLE_ADD => Self::LockLittleAdd,
            ffi::HINAWA_FW_TCODE_LOCK_BOUNDED_ADD => Self::LockBoundedAdd,
            ffi::HINAWA_FW_TCODE_LOCK_WRAP_ADD => Self::LockWrapAdd,
            ffi::HINAWA_FW_TCODE_LOCK_VENDOR_DEPENDENT => Self::LockVendorDependent,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FwTcode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::hinawa_fw_tcode_get_type()) }
    }
}

impl glib::value::ValueType for FwTcode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FwTcode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FwTcode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
