/*
 * mount_smb.c
 *
 * Module for Linux automountd to mount an SMB/CIFS filesystem
 *
 * Mount point input format expected is: //server/service[/root_path...]
 */

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include <netdb.h>
#include <fcntl.h>
#include <unistd.h>
#include <syslog.h>
#include <string.h>
#include <syslog.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>

#define MODULE_MOUNT
#include "automount.h"

#define MODPREFIX "mount(smb): "
int mount_version = AUTOFS_MOUNT_VERSION; /* Required by protocol */

struct smb_mount_opt {
  char *optname;		/* mount-style option name */
  char optchar;			/* character flag for smbmount */
  int hasarg;			/* takes argument? */
};

static struct smb_mount_opt[] = {
  { "nocaps",   'C', 0 },
  { "guest",    'n', 0 },
  { "passwd",   'P', 1 },
  { "srvname",  's', 1 },
  { "clntname", 'c', 1 },
  { "login",    'U', 1 },
  { "uid",      'u', 1 },
  { "gid",      'g', 1 },
  { "filemod",  'f', 1 },
  { "dirmod",   'd', 1 },
  { "port",     'p', 1 },
  { "maxxmit",  'm', 1 },
  { NULL, 0, 0 }
};

int mount_init(void **context)
{
  return 0;
}

int mount_mount(char *root, char *name, int name_len, char *what,
		char *fstype, char *options, void *context)
{
  struct hostent *he;
  struct sockaddr_in saddr, laddr;
  int sock, len, local, err;
  char **smbopt;
  

  


    /* Not a local host - do a mount */

    fullpath = malloc(strlen(root)+name_len+2);
    if ( !fullpath ) {
      syslog(LOG_ERR, MODPREFIX "malloc: %m");
      return 1;
    }
    sprintf(fullpath, "%s/%s", root, name);
    
    *colon = ':';
    syslog(LOG_DEBUG, MODPREFIX "calling mkdir %s", name);
    if ( mkdir(name, 0555) && errno != EEXIST ) {
      syslog(LOG_NOTICE, MODPREFIX "mkdir %s failed: %m", name);
      free(fullpath);
      return 1;
    }
    
    if ( options ) {
      syslog(LOG_DEBUG, MODPREFIX "calling mount -t nfs -o %s %s %s",
	     options, what, fullpath);
      err = spawnl(_PATH_MOUNT, _PATH_MOUNT, "-t", "nfs", "-o", options,
		   what, fullpath, NULL);
    } else {
      syslog(LOG_DEBUG, MODPREFIX "calling mount -t nfs %s %s", what, fullpath);
      err = spawnl(_PATH_MOUNT, _PATH_MOUNT, "-t", "nfs", what, fullpath, NULL);
    }
    free(fullpath);
    if ( err )
      syslog(LOG_NOTICE, MODPREFIX "nfs entry %s: mount failure",
	     name);
    else
      syslog(LOG_DEBUG, MODPREFIX "mounted %s", name);
    return ( err != 0 );
  }
}

int mount_done(void *context)
{
  return 0;
}
