/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.uima.ruta.cache.PatternCacheKey;

public class RutaPatternCache {
    private static final String PROP_RUTA_PATTERN_CACHE_SIZE = "uima.ruta.pattern_cache_size";
    private static final int RUTA_PATTERN_CACHE_SIZE = Integer.parseInt(System.getProperty("uima.ruta.pattern_cache_size", "10000"));
    private static final LoadingCache<PatternCacheKey, Pattern> CACHE = Caffeine.newBuilder().maximumSize((long)RUTA_PATTERN_CACHE_SIZE).build(k -> RutaPatternCache.createPattern(k));

    public static Pattern getPattern(String patternString, boolean ignore) {
        int flags = 40;
        if (ignore) {
            flags |= 0x42;
        }
        return (Pattern)CACHE.get((Object)new PatternCacheKey(patternString, flags));
    }

    public static Pattern getPattern(String patternString, int flags) {
        return (Pattern)CACHE.get((Object)new PatternCacheKey(patternString, flags));
    }

    private static synchronized Pattern createPattern(PatternCacheKey key) {
        return Pattern.compile(key.getPatternString(), key.getFlags());
    }

    public static Map<PatternCacheKey, Pattern> getCacheMap() {
        return Collections.unmodifiableMap(CACHE.asMap());
    }

    public static void clearCache() {
        CACHE.invalidateAll();
        CACHE.cleanUp();
    }
}

