/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.fulcrum.jce.crypto.PasswordParameters;

public class PasswordFactory
implements PasswordParameters {
    private static PasswordFactory instance;
    String algo;
    int count = 1000;

    public PasswordFactory(String algo) {
        this.algo = algo;
    }

    public PasswordFactory(String algo, int count) {
        this.algo = algo;
        this.count = count;
    }

    public static synchronized PasswordFactory getInstance() {
        if (instance == null) {
            instance = new PasswordFactory("SHA1");
        }
        return instance;
    }

    public static synchronized PasswordFactory getInstance(String algo) {
        if (instance == null) {
            instance = new PasswordFactory(algo);
        }
        return instance;
    }

    public static synchronized PasswordFactory getInstance(String algo, int count) {
        if (instance == null) {
            instance = new PasswordFactory(algo, count);
        }
        return instance;
    }

    public char[] create() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return this.create(PasswordParameters.DefaultPassword(), PasswordParameters.Salt(), this.count);
    }

    public char[] create(String seed) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return this.create(seed.toCharArray());
    }

    public final char[] create(char[] seed) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return this.create(seed, PasswordParameters.Salt(), this.count);
    }

    public char[] create(char[] password, byte[] salt, int count) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int i;
        char[] result = null;
        MessageDigest sha1 = MessageDigest.getInstance(this.algo);
        byte[] passwordMask = new String(password).getBytes("UTF-8");
        byte[] temp = new byte[salt.length + passwordMask.length];
        byte[] digest = null;
        StringBuilder stringBuffer = new StringBuilder();
        System.arraycopy(passwordMask, 0, temp, 0, passwordMask.length);
        System.arraycopy(salt, 0, temp, passwordMask.length, salt.length);
        digest = temp;
        for (int i2 = 0; i2 < count; ++i2) {
            sha1.update(digest);
            digest = sha1.digest();
        }
        long long1 = PasswordFactory.createLong(digest, 0);
        long long2 = PasswordFactory.createLong(digest, 4);
        long long3 = PasswordFactory.createLong(digest, 8);
        long long4 = PasswordFactory.createLong(digest, 12);
        stringBuffer.append(Long.toHexString(long1).substring(0, 4));
        stringBuffer.append('-');
        stringBuffer.append(Long.toHexString(long2).substring(0, 4));
        stringBuffer.append('-');
        stringBuffer.append(Long.toHexString(long3).substring(0, 4));
        stringBuffer.append('-');
        stringBuffer.append(Long.toHexString(long4).substring(0, 5));
        result = new char[stringBuffer.length()];
        for (i = 0; i < stringBuffer.length(); ++i) {
            result[i] = stringBuffer.charAt(i);
        }
        for (i = 0; i < stringBuffer.length(); ++i) {
            stringBuffer.setCharAt(i, ' ');
        }
        return result;
    }

    private static long createLong(byte[] buf, int nOfs) {
        return (long)(buf[nOfs] << 24 | (buf[nOfs + 1] & 0xFF) << 16 | (buf[nOfs + 2] & 0xFF) << 8 | buf[nOfs + 3] & 0xFF) << 32 | (long)(buf[nOfs + 4] << 24 | (buf[nOfs + 5] & 0xFF) << 16 | (buf[nOfs + 6] & 0xFF) << 8 | buf[nOfs + 7] & 0xFF) & 0xFFFFFFFFL;
    }
}

