/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices.saaj;

import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SAAJMetaFactory;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.openejb.server.webservices.saaj.SaajFactoryFinder;

public class SaajMetaFactoryImpl
extends SAAJMetaFactory {
    protected MessageFactory newMessageFactory(String arg0) throws SOAPException {
        return (MessageFactory)this.callFactoryMethod("newMessageFactory", arg0);
    }

    protected SOAPFactory newSOAPFactory(String arg0) throws SOAPException {
        return (SOAPFactory)this.callFactoryMethod("newSOAPFactory", arg0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object callFactoryMethod(String methodName, String arg) throws SOAPException {
        SAAJMetaFactory factory = (SAAJMetaFactory)SaajFactoryFinder.find("jakarta.xml.soap.MetaFactory");
        try {
            Method method = factory.getClass().getDeclaredMethod(methodName, String.class);
            boolean accessibility = method.isAccessible();
            try {
                Object result;
                method.setAccessible(true);
                Object object = result = method.invoke((Object)factory, arg);
                return object;
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof SOAPException)) throw new SOAPException("Error calling factory method: " + methodName, (Throwable)e);
                throw (SOAPException)e.getTargetException();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new SOAPException("Error calling factory method: " + methodName, (Throwable)e);
            }
            finally {
                method.setAccessible(accessibility);
            }
        }
        catch (NoSuchMethodException e) {
            throw new SOAPException("Factory method not found: " + methodName, (Throwable)e);
        }
    }
}

