/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.codec.binary;

import java.util.Arrays;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.codec.binary.StringUtils;
import org.apache.tomcat.util.res.StringManager;

@Deprecated
public abstract class BaseNCodec {
    protected static final StringManager sm = StringManager.getManager(BaseNCodec.class);
    static final int EOF = -1;
    public static final int MIME_CHUNK_SIZE = 76;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 128;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    protected final byte pad;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;

    private static int createPositiveCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError(sm.getString("base64.outOfMemory", (long)minCapacity & 0xFFFFFFFFL));
        }
        return Math.max(minCapacity, 0x7FFFFFF7);
    }

    private static byte[] resizeBuffer(Context context, int minCapacity) {
        int oldCapacity = context.buffer.length;
        int newCapacity = oldCapacity * 2;
        if (Integer.compareUnsigned(newCapacity, minCapacity) < 0) {
            newCapacity = minCapacity;
        }
        if (Integer.compareUnsigned(newCapacity, 0x7FFFFFF7) > 0) {
            newCapacity = BaseNCodec.createPositiveCapacity(minCapacity);
        }
        byte[] b = Arrays.copyOf(context.buffer, newCapacity);
        context.buffer = b;
        return b;
    }

    protected BaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength) {
        this(unencodedBlockSize, encodedBlockSize, lineLength, chunkSeparatorLength, 61);
    }

    protected BaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength, byte pad) {
        this.unencodedBlockSize = unencodedBlockSize;
        this.encodedBlockSize = encodedBlockSize;
        boolean useChunking = lineLength > 0 && chunkSeparatorLength > 0;
        this.lineLength = useChunking ? lineLength / encodedBlockSize * encodedBlockSize : 0;
        this.chunkSeparatorLength = chunkSeparatorLength;
        this.pad = pad;
    }

    int available(Context context) {
        return this.hasData(context) ? context.pos - context.readPos : 0;
    }

    protected boolean containsAlphabetOrPad(byte[] arrayOctet) {
        if (arrayOctet == null) {
            return false;
        }
        for (byte element : arrayOctet) {
            if (this.pad != element && !this.isInAlphabet(element)) continue;
            return true;
        }
        return false;
    }

    public byte[] decode(byte[] pArray) {
        return this.decode(pArray, 0, pArray.length);
    }

    public byte[] decode(byte[] pArray, int off, int len) {
        if (pArray == null || len == 0) {
            return new byte[0];
        }
        Context context = new Context();
        this.decode(pArray, off, len, context);
        this.decode(pArray, off, -1, context);
        byte[] result = new byte[context.pos];
        this.readResults(result, 0, result.length, context);
        return result;
    }

    abstract void decode(byte[] var1, int var2, int var3, Context var4);

    public byte[] decode(String pArray) {
        return this.decode(StringUtils.getBytesUtf8(pArray));
    }

    public byte[] encode(byte[] pArray) {
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        return this.encode(pArray, 0, pArray.length);
    }

    public byte[] encode(byte[] pArray, int offset, int length) {
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        Context context = new Context();
        this.encode(pArray, offset, length, context);
        this.encode(pArray, offset, -1, context);
        byte[] buf = new byte[context.pos - context.readPos];
        this.readResults(buf, 0, buf.length, context);
        return buf;
    }

    abstract void encode(byte[] var1, int var2, int var3, Context var4);

    public String encodeAsString(byte[] pArray) {
        return StringUtils.newStringUtf8(this.encode(pArray));
    }

    protected byte[] ensureBufferSize(int size, Context context) {
        if (context.buffer == null) {
            context.buffer = new byte[Math.max(size, this.getDefaultBufferSize())];
            context.pos = 0;
            context.readPos = 0;
        } else if (context.pos + size - context.buffer.length > 0) {
            return BaseNCodec.resizeBuffer(context, context.pos + size);
        }
        return context.buffer;
    }

    protected int getDefaultBufferSize() {
        return 128;
    }

    public long getEncodedLength(byte[] pArray) {
        long len = (long)((pArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            len += (len + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return len;
    }

    boolean hasData(Context context) {
        return context.pos > context.readPos;
    }

    protected abstract boolean isInAlphabet(byte var1);

    int readResults(byte[] b, int bPos, int bAvail, Context context) {
        if (this.hasData(context)) {
            int len = Math.min(this.available(context), bAvail);
            System.arraycopy(context.buffer, context.readPos, b, bPos, len);
            context.readPos += len;
            if (!this.hasData(context)) {
                context.readPos = 0;
                context.pos = 0;
            }
            return len;
        }
        return context.eof ? -1 : 0;
    }

    static class Context {
        int ibitWorkArea;
        byte[] buffer;
        int pos;
        int readPos;
        boolean eof;
        int currentLinePos;
        int modulus;

        Context() {
        }

        public String toString() {
            return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), HexUtils.toHexString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.modulus, this.pos, this.readPos);
        }
    }
}

