/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.lexicalpreservation;

import com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import com.github.javaparser.printer.concretesyntaxmodel.CsmMix;
import com.github.javaparser.printer.concretesyntaxmodel.CsmToken;
import com.github.javaparser.printer.lexicalpreservation.Added;
import com.github.javaparser.printer.lexicalpreservation.Difference;
import com.github.javaparser.printer.lexicalpreservation.DifferenceElement;
import com.github.javaparser.printer.lexicalpreservation.DifferenceElementCalculator;
import com.github.javaparser.printer.lexicalpreservation.Kept;
import com.github.javaparser.printer.lexicalpreservation.NodeText;
import com.github.javaparser.printer.lexicalpreservation.PeekingIterator;
import com.github.javaparser.printer.lexicalpreservation.Removed;
import com.github.javaparser.printer.lexicalpreservation.Reshuffled;
import com.github.javaparser.printer.lexicalpreservation.TextElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ReshuffledDiffElementExtractor {
    private final NodeText nodeText;

    static ReshuffledDiffElementExtractor of(NodeText nodeText) {
        return new ReshuffledDiffElementExtractor(nodeText);
    }

    private ReshuffledDiffElementExtractor(NodeText nodeText) {
        this.nodeText = nodeText;
    }

    public void extract(List<DifferenceElement> diffElements) {
        Difference.ArrayIterator<DifferenceElement> iterator = new Difference.ArrayIterator<DifferenceElement>(diffElements);
        while (iterator.hasNext()) {
            DifferenceElement diffElement = iterator.next();
            if (!(diffElement instanceof Reshuffled)) continue;
            Reshuffled reshuffled = (Reshuffled)diffElement;
            CsmMix elementsFromPreviousOrder = reshuffled.getPreviousOrder();
            CsmMix elementsFromNextOrder = reshuffled.getNextOrder();
            Map<Integer, Integer> correspondanceBetweenNextOrderAndPreviousOrder = this.getCorrespondanceBetweenNextOrderAndPreviousOrder(elementsFromPreviousOrder, elementsFromNextOrder);
            List<Integer> nodeTextIndexOfPreviousElements = this.findIndexOfCorrespondingNodeTextElement(elementsFromPreviousOrder.getElements(), this.nodeText);
            PeekingIterator<Integer> nodeTextIndexOfPreviousElementsIterator = new PeekingIterator<Integer>(nodeTextIndexOfPreviousElements);
            HashMap<Integer, Integer> nodeTextIndexToPreviousCSMIndex = new HashMap<Integer, Integer>();
            while (nodeTextIndexOfPreviousElementsIterator.hasNext()) {
                int value = nodeTextIndexOfPreviousElementsIterator.next();
                if (value == -1) continue;
                nodeTextIndexToPreviousCSMIndex.put(value, nodeTextIndexOfPreviousElementsIterator.currentIndex());
            }
            int lastNodeTextIndex = nodeTextIndexOfPreviousElements.stream().max(Integer::compareTo).orElse(-1);
            LinkedList<CsmElement> elementsToBeAddedAtTheEnd = new LinkedList<CsmElement>();
            List<CsmElement> nextOrderElements = elementsFromNextOrder.getElements();
            HashMap elementsToAddBeforeGivenOriginalCSMElement = new HashMap();
            for (int ni = 0; ni < nextOrderElements.size(); ++ni) {
                if (correspondanceBetweenNextOrderAndPreviousOrder.containsKey(ni)) continue;
                int originalCsmIndex = -1;
                for (int nj = ni + 1; nj < nextOrderElements.size() && originalCsmIndex == -1; ++nj) {
                    if (!correspondanceBetweenNextOrderAndPreviousOrder.containsKey(nj)) continue;
                    originalCsmIndex = correspondanceBetweenNextOrderAndPreviousOrder.get(nj);
                    if (!elementsToAddBeforeGivenOriginalCSMElement.containsKey(originalCsmIndex)) {
                        elementsToAddBeforeGivenOriginalCSMElement.put(originalCsmIndex, new LinkedList());
                    }
                    ((List)elementsToAddBeforeGivenOriginalCSMElement.get(originalCsmIndex)).add(nextOrderElements.get(ni));
                }
                if (originalCsmIndex != -1) continue;
                elementsToBeAddedAtTheEnd.add(nextOrderElements.get(ni));
            }
            iterator.remove();
            if (lastNodeTextIndex != -1) {
                for (int ntIndex = 0; ntIndex <= lastNodeTextIndex; ++ntIndex) {
                    if (!nodeTextIndexToPreviousCSMIndex.containsKey(ntIndex)) continue;
                    int indexOfOriginalCSMElement = (Integer)nodeTextIndexToPreviousCSMIndex.get(ntIndex);
                    if (elementsToAddBeforeGivenOriginalCSMElement.containsKey(indexOfOriginalCSMElement)) {
                        for (CsmElement elementToAdd : (List)elementsToAddBeforeGivenOriginalCSMElement.get(indexOfOriginalCSMElement)) {
                            iterator.add(new Added(elementToAdd));
                        }
                    }
                    CsmElement originalCSMElement = elementsFromPreviousOrder.getElements().get(indexOfOriginalCSMElement);
                    boolean toBeKept = correspondanceBetweenNextOrderAndPreviousOrder.containsValue(indexOfOriginalCSMElement);
                    if (toBeKept) {
                        iterator.add(new Kept(originalCSMElement));
                        continue;
                    }
                    iterator.add(new Removed(originalCSMElement));
                }
            }
            for (CsmElement elementToAdd : elementsToBeAddedAtTheEnd) {
                iterator.add(new Added(elementToAdd));
            }
        }
    }

    private Map<Integer, Integer> getCorrespondanceBetweenNextOrderAndPreviousOrder(CsmMix elementsFromPreviousOrder, CsmMix elementsFromNextOrder) {
        HashMap<Integer, Integer> correspondanceBetweenNextOrderAndPreviousOrder = new HashMap<Integer, Integer>();
        Difference.ArrayIterator<CsmElement> previousOrderElementsIterator = new Difference.ArrayIterator<CsmElement>(elementsFromPreviousOrder.getElements());
        int syncNextIndex = 0;
        block0: while (previousOrderElementsIterator.hasNext()) {
            CsmElement pe = previousOrderElementsIterator.next();
            Difference.ArrayIterator<CsmElement> nextOrderElementsIterator = new Difference.ArrayIterator<CsmElement>(elementsFromNextOrder.getElements(), syncNextIndex);
            while (nextOrderElementsIterator.hasNext()) {
                CsmElement ne = nextOrderElementsIterator.next();
                if (correspondanceBetweenNextOrderAndPreviousOrder.values().contains(previousOrderElementsIterator.index()) || !DifferenceElementCalculator.matching(ne, pe)) continue;
                correspondanceBetweenNextOrderAndPreviousOrder.put(nextOrderElementsIterator.index(), previousOrderElementsIterator.index());
                syncNextIndex = nextOrderElementsIterator.index();
                continue block0;
            }
        }
        return correspondanceBetweenNextOrderAndPreviousOrder;
    }

    private List<Integer> findIndexOfCorrespondingNodeTextElement(List<CsmElement> elements, NodeText nodeText) {
        ArrayList<Integer> correspondingIndices = new ArrayList<Integer>();
        PeekingIterator<CsmElement> csmElementListIterator = new PeekingIterator<CsmElement>(elements);
        while (csmElementListIterator.hasNext()) {
            boolean isFirstIterationOnCsmElements = !csmElementListIterator.hasPrevious();
            int previousCsmElementIndex = csmElementListIterator.previousIndex();
            CsmElement csmElement = csmElementListIterator.next();
            EnumMap<MatchClassification, Integer> potentialMatches = new EnumMap<MatchClassification, Integer>(MatchClassification.class);
            PeekingIterator<TextElement> nodeTextListIterator = new PeekingIterator<TextElement>(nodeText.getElements());
            while (nodeTextListIterator.hasNext()) {
                boolean isFirstIterationOnNodeTextElements = !nodeTextListIterator.hasPrevious();
                TextElement textElement = nodeTextListIterator.next();
                int currentTextElementIndex = nodeTextListIterator.currentIndex();
                if (correspondingIndices.contains(currentTextElementIndex)) continue;
                boolean isCorresponding = csmElement.isCorrespondingElement(textElement);
                if (isCorresponding) {
                    boolean hasSamePreviousElement = false;
                    if (!isFirstIterationOnNodeTextElements && !isFirstIterationOnCsmElements) {
                        TextElement previousTextElement = nodeText.getTextElement(currentTextElementIndex - 1);
                        hasSamePreviousElement = elements.get(previousCsmElementIndex).isCorrespondingElement(previousTextElement);
                    }
                    boolean hasSameNextElement = false;
                    if (csmElementListIterator.hasNext()) {
                        TextElement nextTextElement = nodeTextListIterator.peek();
                        hasSameNextElement = elements.get(csmElementListIterator.nextIndex()).isCorrespondingElement(nextTextElement);
                    }
                    if (hasSamePreviousElement && hasSameNextElement) {
                        potentialMatches.putIfAbsent(MatchClassification.ALL, currentTextElementIndex);
                        continue;
                    }
                    if (hasSamePreviousElement) {
                        potentialMatches.putIfAbsent(MatchClassification.PREVIOUS_AND_SAME, currentTextElementIndex);
                        continue;
                    }
                    if (hasSameNextElement) {
                        potentialMatches.putIfAbsent(MatchClassification.NEXT_AND_SAME, currentTextElementIndex);
                        continue;
                    }
                    potentialMatches.putIfAbsent(MatchClassification.SAME_ONLY, currentTextElementIndex);
                    continue;
                }
                if (!this.isAlmostCorrespondingElement(textElement, csmElement)) continue;
                potentialMatches.putIfAbsent(MatchClassification.ALMOST, currentTextElementIndex);
            }
            Optional<MatchClassification> bestMatchKey = potentialMatches.keySet().stream().min(Comparator.comparing(MatchClassification::getPriority));
            if (bestMatchKey.isPresent()) {
                correspondingIndices.add((Integer)potentialMatches.get((Object)bestMatchKey.get()));
                continue;
            }
            correspondingIndices.add(-1);
        }
        return correspondingIndices;
    }

    private boolean isAlmostCorrespondingElement(TextElement textElement, CsmElement csmElement) {
        if (csmElement.isCorrespondingElement(textElement)) {
            return false;
        }
        return textElement.isWhiteSpace() && csmElement instanceof CsmToken && ((CsmToken)csmElement).isWhiteSpace();
    }

    private static enum MatchClassification {
        ALL(1),
        PREVIOUS_AND_SAME(2),
        NEXT_AND_SAME(3),
        SAME_ONLY(4),
        ALMOST(5);

        private final int priority;

        private MatchClassification(int priority) {
            this.priority = priority;
        }

        int getPriority() {
            return this.priority;
        }
    }
}

