/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.canal;

import com.alibaba.otter.canal.client.impl.SimpleCanalConnector;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.canal.CanalEnhanceInfo;

public class CanalInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final AbstractTag<String> BATCH_SIZE_TAG = Tags.ofKey((String)"batchSize");
    private static final AbstractTag<String> DESTINATION_TAG = Tags.ofKey((String)"destination");

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        CanalEnhanceInfo canalEnhanceInfo = (CanalEnhanceInfo)objInst.getSkyWalkingDynamicField();
        SimpleCanalConnector connector = (SimpleCanalConnector)objInst;
        String url = canalEnhanceInfo.getUrl();
        if (Objects.equals(url, "") || url == null) {
            InetSocketAddress address = (InetSocketAddress)connector.getNextAddress();
            String runningAddress = address.getAddress().toString() + ":" + address.getPort();
            url = runningAddress = runningAddress.replace('/', ' ');
            List socketAddressList = (List)ContextManager.getRuntimeContext().get((Object)"currentAddress");
            if (socketAddressList != null && socketAddressList.size() > 0) {
                for (InetSocketAddress socketAddress : socketAddressList) {
                    String currentAddress = socketAddress.getAddress().toString() + ":" + socketAddress.getPort();
                    if ((currentAddress = currentAddress.replace('/', ' ')).equals(runningAddress)) continue;
                    url = url + "," + currentAddress;
                }
            }
        }
        String batchSize = allArguments[0].toString();
        String destination = canalEnhanceInfo.getDestination();
        AbstractSpan activeSpan = ContextManager.createExitSpan((String)("Canal/" + destination), (String)url).start(System.currentTimeMillis());
        activeSpan.setComponent((Component)ComponentsDefine.CANAL);
        activeSpan.tag(BATCH_SIZE_TAG, batchSize);
        activeSpan.tag(DESTINATION_TAG, destination);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

