/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

final class DimensionAppender
implements GridCoverageResource {
    private final GridCoverageProcessor processor;
    private final GridCoverageResource source;
    private final GridGeometry dimToAdd;
    private volatile GridGeometry gridGeometry;

    private DimensionAppender(GridCoverageProcessor processor, GridCoverageResource source, GridGeometry dimToAdd) {
        this.processor = processor;
        this.source = source;
        this.dimToAdd = dimToAdd;
    }

    static GridCoverageResource create(GridCoverageProcessor processor, GridCoverageResource source, GridGeometry dimToAdd) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        GridExtent extent = dimToAdd.getExtent();
        int i = extent.getDimension();
        if (i == 0) {
            return source;
        }
        do {
            long size;
            if ((size = extent.getSize(--i)) == 1L) continue;
            Integer name = extent.getAxisType(i).orElse(null);
            if (name == null) {
                name = i;
            }
            throw new IllegalGridGeometryException(Resources.format((short)52, name, size));
        } while (i != 0);
        if (source instanceof DimensionAppender) {
            try {
                DimensionAppender a = (DimensionAppender)source;
                dimToAdd = new GridGeometry(a.dimToAdd, dimToAdd);
                source = a.source;
            }
            catch (FactoryException e) {
                throw new IllegalGridGeometryException(e.getMessage(), (Throwable)e);
            }
        }
        return new DimensionAppender(processor, source, dimToAdd);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return this.source.getIdentifier();
    }

    @Override
    public Metadata getMetadata() throws DataStoreException {
        return this.source.getMetadata();
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.source.getSampleDimensions();
    }

    @Override
    public GridGeometry getGridGeometry() throws DataStoreException {
        GridGeometry gg = this.gridGeometry;
        if (gg == null) {
            try {
                this.gridGeometry = gg = new GridGeometry(this.source.getGridGeometry(), this.dimToAdd);
            }
            catch (RuntimeException | FactoryException e) {
                throw new DataStoreReferencingException(e.getMessage(), e);
            }
        }
        return gg;
    }

    @Override
    public GridCoverageResource subset(Query query) throws DataStoreException {
        GridCoverageResource subset = this.source.subset(query);
        if (subset == this.source) {
            return this;
        }
        return new DimensionAppender(this.processor, subset, this.dimToAdd);
    }

    @Override
    public GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        return this.processor.appendDimensions(this.source.read(domain, ranges), this.dimToAdd);
    }

    @Override
    public RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return this.source.getLoadingStrategy();
    }

    @Override
    public boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        return this.source.setLoadingStrategy(strategy);
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        this.source.addListener(eventType, listener);
    }

    @Override
    public <T extends StoreEvent> void removeListener(Class<T> eventType, StoreListener<? super T> listener) {
        this.source.removeListener(eventType, listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        sb.append(this.source).append(" + dimensions[");
        GridExtent extent = this.dimToAdd.getExtent();
        double[] coordinates = new double[extent.getDimension()];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = extent.getLow(i);
        }
        try {
            this.dimToAdd.getGridToCRS(PixelInCell.CELL_CORNER).transform(coordinates, 0, coordinates, 0, 1);
        }
        catch (RuntimeException | TransformException e) {
            Logging.unexpectedException((Logger)StoreUtilities.LOGGER, DimensionAppender.class, (String)"toString", (Throwable)e);
            Arrays.fill(coordinates, Double.NaN);
        }
        for (int i = 0; i < coordinates.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            extent.getAxisType(i).ifPresent(type -> sb.append(type.name()).append('='));
            sb.append(coordinates[i]);
        }
        return sb.append(']').toString();
    }
}

