/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy.bytebuddy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.dubbo.rpc.proxy.bytebuddy.ByteBuddyInterceptor;

public class ByteBuddyProxy {
    private static final Map<ClassLoader, Map<CacheKey, ByteBuddyProxy>> PROXY_CACHE_MAP = new WeakHashMap<ClassLoader, Map<CacheKey, ByteBuddyProxy>>();
    private final Class<?> proxyClass;
    private final InvocationHandler handler;

    private ByteBuddyProxy(Class<?> proxyClass, InvocationHandler handler) {
        this.proxyClass = proxyClass;
        this.handler = handler;
    }

    public static Object newInstance(ClassLoader cl, Class<?>[] interfaces, InvocationHandler handler) {
        return ByteBuddyProxy.getProxy(cl, interfaces, handler).newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuddyProxy getProxy(ClassLoader cl, Class<?>[] interfaces, InvocationHandler handler) {
        Map cache;
        if (interfaces.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        interfaces = (Class[])interfaces.clone();
        Arrays.sort(interfaces, Comparator.comparing(Class::getName));
        CacheKey key = new CacheKey(interfaces);
        Map<ClassLoader, Map<CacheKey, ByteBuddyProxy>> map = PROXY_CACHE_MAP;
        synchronized (map) {
            cache = PROXY_CACHE_MAP.computeIfAbsent(cl, k -> new ConcurrentHashMap());
        }
        ByteBuddyProxy proxy = (ByteBuddyProxy)cache.get(key);
        if (proxy == null) {
            Class<?> clazz = interfaces[0];
            synchronized (clazz) {
                proxy = (ByteBuddyProxy)cache.get(key);
                if (proxy == null) {
                    proxy = new ByteBuddyProxy(ByteBuddyProxy.buildProxyClass(cl, interfaces, handler), handler);
                    cache.put(key, proxy);
                }
            }
        }
        return proxy;
    }

    private Object newInstance() {
        try {
            Constructor<?> constructor = this.proxyClass.getDeclaredConstructor(InvocationHandler.class);
            return constructor.newInstance(this.handler);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> buildProxyClass(ClassLoader cl, Class<?>[] ics, InvocationHandler handler) {
        ElementMatcher.Junction methodMatcher = Arrays.stream(ics).map(ElementMatchers::isDeclaredBy).reduce(ElementMatcher.Junction::or).orElse(ElementMatchers.none()).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class)));
        return new ByteBuddy().subclass(Proxy.class).implement((Type[])ics).method((ElementMatcher)methodMatcher).intercept((Implementation)MethodDelegation.to((Object)new ByteBuddyInterceptor(handler))).make().load(cl).getLoaded();
    }

    private static class CacheKey {
        private final Class<?>[] classes;

        private CacheKey(Class<?>[] classes) {
            this.classes = classes;
        }

        public Class<?>[] getClasses() {
            return this.classes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return Arrays.equals(this.classes, that.classes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.classes);
        }
    }
}

