/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters;

import com.netflix.discovery.EurekaClientConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
public class KeyFormatter {
    public static final String DEFAULT_REPLACEMENT = "__";
    private static final KeyFormatter DEFAULT_KEY_FORMATTER = new KeyFormatter("__");
    private final String replacement;

    public KeyFormatter(String replacement) {
        this.replacement = replacement;
    }

    @Inject
    public KeyFormatter(EurekaClientConfig eurekaClientConfig) {
        this.replacement = eurekaClientConfig == null ? DEFAULT_REPLACEMENT : eurekaClientConfig.getEscapeCharReplacement();
    }

    public String formatKey(String keyTemplate) {
        StringBuilder sb = new StringBuilder(keyTemplate.length() + 1);
        for (char c : keyTemplate.toCharArray()) {
            if (c == '_') {
                sb.append(this.replacement);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static KeyFormatter defaultKeyFormatter() {
        return DEFAULT_KEY_FORMATTER;
    }
}

