/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.ServerConnectionType;
import com.microsoft.azure.management.sql.implementation.ServerConnectionPolicyInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServerConnectionPoliciesInner {
    private ServerConnectionPoliciesService service;
    private SqlManagementClientImpl client;

    public ServerConnectionPoliciesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ServerConnectionPoliciesService)retrofit.create(ServerConnectionPoliciesService.class);
        this.client = client;
    }

    public ServerConnectionPolicyInner createOrUpdate(String resourceGroupName, String serverName, ServerConnectionType connectionType) {
        return (ServerConnectionPolicyInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, connectionType).toBlocking().single()).body();
    }

    public ServiceFuture<ServerConnectionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerConnectionType connectionType, ServiceCallback<ServerConnectionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, connectionType), serviceCallback);
    }

    public Observable<ServerConnectionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerConnectionType connectionType) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, connectionType).map((Func1)new Func1<ServiceResponse<ServerConnectionPolicyInner>, ServerConnectionPolicyInner>(){

            public ServerConnectionPolicyInner call(ServiceResponse<ServerConnectionPolicyInner> response) {
                return (ServerConnectionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServerConnectionPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, ServerConnectionType connectionType) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (connectionType == null) {
            throw new IllegalArgumentException("Parameter connectionType is required and cannot be null.");
        }
        String connectionPolicyName = "default";
        String apiVersion = "2014-04-01";
        ServerConnectionPolicyInner parameters = new ServerConnectionPolicyInner();
        parameters.withConnectionType(connectionType);
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, "default", "2014-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerConnectionPolicyInner>>>(){

            public Observable<ServiceResponse<ServerConnectionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerConnectionPoliciesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerConnectionPolicyInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerConnectionPolicyInner>(){}.getType()).register(201, new TypeToken<ServerConnectionPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerConnectionPolicyInner get(String resourceGroupName, String serverName) {
        return (ServerConnectionPolicyInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<ServerConnectionPolicyInner> getAsync(String resourceGroupName, String serverName, ServiceCallback<ServerConnectionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<ServerConnectionPolicyInner> getAsync(String resourceGroupName, String serverName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<ServerConnectionPolicyInner>, ServerConnectionPolicyInner>(){

            public ServerConnectionPolicyInner call(ServiceResponse<ServerConnectionPolicyInner> response) {
                return (ServerConnectionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServerConnectionPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String connectionPolicyName = "default";
        String apiVersion = "2014-04-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, "default", "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerConnectionPolicyInner>>>(){

            public Observable<ServiceResponse<ServerConnectionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerConnectionPoliciesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerConnectionPolicyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerConnectionPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServerConnectionPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerConnectionPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/connectionPolicies/{connectionPolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="connectionPolicyName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ServerConnectionPolicyInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerConnectionPolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/connectionPolicies/{connectionPolicyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="connectionPolicyName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

