/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.CpuMethods;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class Cpu {
    static final Cpu INSTANCE = new Cpu();
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        return INSTANCE.registerObservers(openTelemetry, ManagementFactory.getOperatingSystemMXBean(), Runtime.getRuntime()::availableProcessors, CpuMethods.processCpuTime(), CpuMethods.systemCpuUtilization(), CpuMethods.processCpuUtilization());
    }

    List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, OperatingSystemMXBean osBean, IntSupplier availableProcessors, @Nullable Supplier<Long> processCpuTime, @Nullable Supplier<Double> systemCpuUtilization, @Nullable Supplier<Double> processCpuUtilization) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        if (SemconvStability.emitOldJvmSemconv()) {
            observables.add((AutoCloseable)meter.gaugeBuilder("process.runtime.jvm.system.cpu.load_1m").setDescription("Average CPU load of the whole system for the last minute").setUnit("{run_queue_item}").buildWithCallback(observableMeasurement -> {
                double loadAverage = osBean.getSystemLoadAverage();
                if (loadAverage >= 0.0) {
                    observableMeasurement.record(loadAverage);
                }
            }));
            if (systemCpuUtilization != null) {
                observables.add((AutoCloseable)meter.gaugeBuilder("process.runtime.jvm.system.cpu.utilization").setDescription("Recent cpu utilization for the whole system").setUnit("1").buildWithCallback(observableMeasurement -> {
                    Double cpuUsage = (Double)systemCpuUtilization.get();
                    if (cpuUsage != null && cpuUsage >= 0.0) {
                        observableMeasurement.record(cpuUsage.doubleValue());
                    }
                }));
            }
            if (processCpuUtilization != null) {
                observables.add((AutoCloseable)meter.gaugeBuilder("process.runtime.jvm.cpu.utilization").setDescription("Recent cpu utilization for the process").setUnit("1").buildWithCallback(observableMeasurement -> {
                    Double cpuUsage = (Double)processCpuUtilization.get();
                    if (cpuUsage != null && cpuUsage >= 0.0) {
                        observableMeasurement.record(cpuUsage.doubleValue());
                    }
                }));
            }
        }
        if (SemconvStability.emitStableJvmSemconv()) {
            if (processCpuTime != null) {
                observables.add((AutoCloseable)meter.counterBuilder("jvm.cpu.time").ofDoubles().setDescription("CPU time used by the process as reported by the JVM.").setUnit("s").buildWithCallback(observableMeasurement -> {
                    Long cpuTimeNanos = (Long)processCpuTime.get();
                    if (cpuTimeNanos != null && cpuTimeNanos >= 0L) {
                        observableMeasurement.record((double)cpuTimeNanos.longValue() / NANOS_PER_S);
                    }
                }));
            }
            observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.cpu.count").setDescription("Number of processors available to the Java virtual machine.").setUnit("{cpu}").buildWithCallback(observableMeasurement -> observableMeasurement.record((long)availableProcessors.getAsInt())));
            if (processCpuUtilization != null) {
                observables.add((AutoCloseable)meter.gaugeBuilder("jvm.cpu.recent_utilization").setDescription("Recent CPU utilization for the process as reported by the JVM.").setUnit("1").buildWithCallback(observableMeasurement -> {
                    Double cpuUsage = (Double)processCpuUtilization.get();
                    if (cpuUsage != null && cpuUsage >= 0.0) {
                        observableMeasurement.record(cpuUsage.doubleValue());
                    }
                }));
            }
        }
        return observables;
    }

    private Cpu() {
    }
}

