/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NPDUControl is the corresponding interface of NPDUControl
type NPDUControl interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetMessageTypeFieldPresent returns MessageTypeFieldPresent (property field)
	GetMessageTypeFieldPresent() bool
	// GetDestinationSpecified returns DestinationSpecified (property field)
	GetDestinationSpecified() bool
	// GetSourceSpecified returns SourceSpecified (property field)
	GetSourceSpecified() bool
	// GetExpectingReply returns ExpectingReply (property field)
	GetExpectingReply() bool
	// GetNetworkPriority returns NetworkPriority (property field)
	GetNetworkPriority() NPDUNetworkPriority
	// IsNPDUControl is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNPDUControl()
	// CreateBuilder creates a NPDUControlBuilder
	CreateNPDUControlBuilder() NPDUControlBuilder
}

// _NPDUControl is the data-structure of this message
type _NPDUControl struct {
	MessageTypeFieldPresent bool
	DestinationSpecified    bool
	SourceSpecified         bool
	ExpectingReply          bool
	NetworkPriority         NPDUNetworkPriority
	// Reserved Fields
	reservedField0 *uint8
	reservedField1 *uint8
}

var _ NPDUControl = (*_NPDUControl)(nil)

// NewNPDUControl factory function for _NPDUControl
func NewNPDUControl(messageTypeFieldPresent bool, destinationSpecified bool, sourceSpecified bool, expectingReply bool, networkPriority NPDUNetworkPriority) *_NPDUControl {
	return &_NPDUControl{MessageTypeFieldPresent: messageTypeFieldPresent, DestinationSpecified: destinationSpecified, SourceSpecified: sourceSpecified, ExpectingReply: expectingReply, NetworkPriority: networkPriority}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NPDUControlBuilder is a builder for NPDUControl
type NPDUControlBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(messageTypeFieldPresent bool, destinationSpecified bool, sourceSpecified bool, expectingReply bool, networkPriority NPDUNetworkPriority) NPDUControlBuilder
	// WithMessageTypeFieldPresent adds MessageTypeFieldPresent (property field)
	WithMessageTypeFieldPresent(bool) NPDUControlBuilder
	// WithDestinationSpecified adds DestinationSpecified (property field)
	WithDestinationSpecified(bool) NPDUControlBuilder
	// WithSourceSpecified adds SourceSpecified (property field)
	WithSourceSpecified(bool) NPDUControlBuilder
	// WithExpectingReply adds ExpectingReply (property field)
	WithExpectingReply(bool) NPDUControlBuilder
	// WithNetworkPriority adds NetworkPriority (property field)
	WithNetworkPriority(NPDUNetworkPriority) NPDUControlBuilder
	// Build builds the NPDUControl or returns an error if something is wrong
	Build() (NPDUControl, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NPDUControl
}

// NewNPDUControlBuilder() creates a NPDUControlBuilder
func NewNPDUControlBuilder() NPDUControlBuilder {
	return &_NPDUControlBuilder{_NPDUControl: new(_NPDUControl)}
}

type _NPDUControlBuilder struct {
	*_NPDUControl

	collectedErr []error
}

var _ (NPDUControlBuilder) = (*_NPDUControlBuilder)(nil)

func (b *_NPDUControlBuilder) WithMandatoryFields(messageTypeFieldPresent bool, destinationSpecified bool, sourceSpecified bool, expectingReply bool, networkPriority NPDUNetworkPriority) NPDUControlBuilder {
	return b.WithMessageTypeFieldPresent(messageTypeFieldPresent).WithDestinationSpecified(destinationSpecified).WithSourceSpecified(sourceSpecified).WithExpectingReply(expectingReply).WithNetworkPriority(networkPriority)
}

func (b *_NPDUControlBuilder) WithMessageTypeFieldPresent(messageTypeFieldPresent bool) NPDUControlBuilder {
	b.MessageTypeFieldPresent = messageTypeFieldPresent
	return b
}

func (b *_NPDUControlBuilder) WithDestinationSpecified(destinationSpecified bool) NPDUControlBuilder {
	b.DestinationSpecified = destinationSpecified
	return b
}

func (b *_NPDUControlBuilder) WithSourceSpecified(sourceSpecified bool) NPDUControlBuilder {
	b.SourceSpecified = sourceSpecified
	return b
}

func (b *_NPDUControlBuilder) WithExpectingReply(expectingReply bool) NPDUControlBuilder {
	b.ExpectingReply = expectingReply
	return b
}

func (b *_NPDUControlBuilder) WithNetworkPriority(networkPriority NPDUNetworkPriority) NPDUControlBuilder {
	b.NetworkPriority = networkPriority
	return b
}

func (b *_NPDUControlBuilder) Build() (NPDUControl, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._NPDUControl.deepCopy(), nil
}

func (b *_NPDUControlBuilder) MustBuild() NPDUControl {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NPDUControlBuilder) DeepCopy() any {
	_copy := b.CreateNPDUControlBuilder().(*_NPDUControlBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateNPDUControlBuilder creates a NPDUControlBuilder
func (b *_NPDUControl) CreateNPDUControlBuilder() NPDUControlBuilder {
	if b == nil {
		return NewNPDUControlBuilder()
	}
	return &_NPDUControlBuilder{_NPDUControl: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NPDUControl) GetMessageTypeFieldPresent() bool {
	return m.MessageTypeFieldPresent
}

func (m *_NPDUControl) GetDestinationSpecified() bool {
	return m.DestinationSpecified
}

func (m *_NPDUControl) GetSourceSpecified() bool {
	return m.SourceSpecified
}

func (m *_NPDUControl) GetExpectingReply() bool {
	return m.ExpectingReply
}

func (m *_NPDUControl) GetNetworkPriority() NPDUNetworkPriority {
	return m.NetworkPriority
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNPDUControl(structType any) NPDUControl {
	if casted, ok := structType.(NPDUControl); ok {
		return casted
	}
	if casted, ok := structType.(*NPDUControl); ok {
		return *casted
	}
	return nil
}

func (m *_NPDUControl) GetTypeName() string {
	return "NPDUControl"
}

func (m *_NPDUControl) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (messageTypeFieldPresent)
	lengthInBits += 1

	// Reserved Field (reserved)
	lengthInBits += 1

	// Simple field (destinationSpecified)
	lengthInBits += 1

	// Reserved Field (reserved)
	lengthInBits += 1

	// Simple field (sourceSpecified)
	lengthInBits += 1

	// Simple field (expectingReply)
	lengthInBits += 1

	// Simple field (networkPriority)
	lengthInBits += 2

	return lengthInBits
}

func (m *_NPDUControl) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func NPDUControlParse(ctx context.Context, theBytes []byte) (NPDUControl, error) {
	return NPDUControlParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func NPDUControlParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (NPDUControl, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (NPDUControl, error) {
		return NPDUControlParseWithBuffer(ctx, readBuffer)
	}
}

func NPDUControlParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (NPDUControl, error) {
	v, err := (&_NPDUControl{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_NPDUControl) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__nPDUControl NPDUControl, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NPDUControl"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NPDUControl")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	messageTypeFieldPresent, err := ReadSimpleField(ctx, "messageTypeFieldPresent", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageTypeFieldPresent' field"))
	}
	m.MessageTypeFieldPresent = messageTypeFieldPresent

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(1)), uint8(0))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	destinationSpecified, err := ReadSimpleField(ctx, "destinationSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'destinationSpecified' field"))
	}
	m.DestinationSpecified = destinationSpecified

	reservedField1, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(1)), uint8(0))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField1 = reservedField1

	sourceSpecified, err := ReadSimpleField(ctx, "sourceSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sourceSpecified' field"))
	}
	m.SourceSpecified = sourceSpecified

	expectingReply, err := ReadSimpleField(ctx, "expectingReply", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'expectingReply' field"))
	}
	m.ExpectingReply = expectingReply

	networkPriority, err := ReadEnumField[NPDUNetworkPriority](ctx, "networkPriority", "NPDUNetworkPriority", ReadEnum(NPDUNetworkPriorityByValue, ReadUnsignedByte(readBuffer, uint8(2))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'networkPriority' field"))
	}
	m.NetworkPriority = networkPriority

	if closeErr := readBuffer.CloseContext("NPDUControl"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NPDUControl")
	}

	return m, nil
}

func (m *_NPDUControl) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NPDUControl) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("NPDUControl"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for NPDUControl")
	}

	if err := WriteSimpleField[bool](ctx, "messageTypeFieldPresent", m.GetMessageTypeFieldPresent(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'messageTypeFieldPresent' field")
	}

	if err := WriteReservedField[uint8](ctx, "reserved", uint8(0), WriteUnsignedByte(writeBuffer, 1)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 1")
	}

	if err := WriteSimpleField[bool](ctx, "destinationSpecified", m.GetDestinationSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'destinationSpecified' field")
	}

	if err := WriteReservedField[uint8](ctx, "reserved", uint8(0), WriteUnsignedByte(writeBuffer, 1)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 2")
	}

	if err := WriteSimpleField[bool](ctx, "sourceSpecified", m.GetSourceSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'sourceSpecified' field")
	}

	if err := WriteSimpleField[bool](ctx, "expectingReply", m.GetExpectingReply(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'expectingReply' field")
	}

	if err := WriteSimpleEnumField[NPDUNetworkPriority](ctx, "networkPriority", "NPDUNetworkPriority", m.GetNetworkPriority(), WriteEnum[NPDUNetworkPriority, uint8](NPDUNetworkPriority.GetValue, NPDUNetworkPriority.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 2))); err != nil {
		return errors.Wrap(err, "Error serializing 'networkPriority' field")
	}

	if popErr := writeBuffer.PopContext("NPDUControl"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for NPDUControl")
	}
	return nil
}

func (m *_NPDUControl) IsNPDUControl() {}

func (m *_NPDUControl) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NPDUControl) deepCopy() *_NPDUControl {
	if m == nil {
		return nil
	}
	_NPDUControlCopy := &_NPDUControl{
		m.MessageTypeFieldPresent,
		m.DestinationSpecified,
		m.SourceSpecified,
		m.ExpectingReply,
		m.NetworkPriority,
		m.reservedField0,
		m.reservedField1,
	}
	return _NPDUControlCopy
}

func (m *_NPDUControl) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
