/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataActiveAuthenticationPolicy is the corresponding interface of BACnetConstructedDataActiveAuthenticationPolicy
type BACnetConstructedDataActiveAuthenticationPolicy interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetActiveAuthenticationPolicy returns ActiveAuthenticationPolicy (property field)
	GetActiveAuthenticationPolicy() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataActiveAuthenticationPolicy is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataActiveAuthenticationPolicy()
	// CreateBuilder creates a BACnetConstructedDataActiveAuthenticationPolicyBuilder
	CreateBACnetConstructedDataActiveAuthenticationPolicyBuilder() BACnetConstructedDataActiveAuthenticationPolicyBuilder
}

// _BACnetConstructedDataActiveAuthenticationPolicy is the data-structure of this message
type _BACnetConstructedDataActiveAuthenticationPolicy struct {
	BACnetConstructedDataContract
	ActiveAuthenticationPolicy BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataActiveAuthenticationPolicy = (*_BACnetConstructedDataActiveAuthenticationPolicy)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataActiveAuthenticationPolicy)(nil)

// NewBACnetConstructedDataActiveAuthenticationPolicy factory function for _BACnetConstructedDataActiveAuthenticationPolicy
func NewBACnetConstructedDataActiveAuthenticationPolicy(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, activeAuthenticationPolicy BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataActiveAuthenticationPolicy {
	if activeAuthenticationPolicy == nil {
		panic("activeAuthenticationPolicy of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataActiveAuthenticationPolicy must not be nil")
	}
	_result := &_BACnetConstructedDataActiveAuthenticationPolicy{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ActiveAuthenticationPolicy:    activeAuthenticationPolicy,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataActiveAuthenticationPolicyBuilder is a builder for BACnetConstructedDataActiveAuthenticationPolicy
type BACnetConstructedDataActiveAuthenticationPolicyBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(activeAuthenticationPolicy BACnetApplicationTagUnsignedInteger) BACnetConstructedDataActiveAuthenticationPolicyBuilder
	// WithActiveAuthenticationPolicy adds ActiveAuthenticationPolicy (property field)
	WithActiveAuthenticationPolicy(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataActiveAuthenticationPolicyBuilder
	// WithActiveAuthenticationPolicyBuilder adds ActiveAuthenticationPolicy (property field) which is build by the builder
	WithActiveAuthenticationPolicyBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataActiveAuthenticationPolicyBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataActiveAuthenticationPolicy or returns an error if something is wrong
	Build() (BACnetConstructedDataActiveAuthenticationPolicy, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataActiveAuthenticationPolicy
}

// NewBACnetConstructedDataActiveAuthenticationPolicyBuilder() creates a BACnetConstructedDataActiveAuthenticationPolicyBuilder
func NewBACnetConstructedDataActiveAuthenticationPolicyBuilder() BACnetConstructedDataActiveAuthenticationPolicyBuilder {
	return &_BACnetConstructedDataActiveAuthenticationPolicyBuilder{_BACnetConstructedDataActiveAuthenticationPolicy: new(_BACnetConstructedDataActiveAuthenticationPolicy)}
}

type _BACnetConstructedDataActiveAuthenticationPolicyBuilder struct {
	*_BACnetConstructedDataActiveAuthenticationPolicy

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataActiveAuthenticationPolicyBuilder) = (*_BACnetConstructedDataActiveAuthenticationPolicyBuilder)(nil)

func (b *_BACnetConstructedDataActiveAuthenticationPolicyBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataActiveAuthenticationPolicy
}

func (b *_BACnetConstructedDataActiveAuthenticationPolicyBuilder) WithMandatoryFields(activeAuthenticationPolicy BACnetApplicationTagUnsignedInteger) BACnetConstructedDataActiveAuthenticationPolicyBuilder {
	return b.WithActiveAuthenticationPolicy(activeAuthenticationPolicy)
}

func (b *_BACnetConstructedDataActiveAuthenticationPolicyBuilder) WithActiveAuthenticationPolicy(activeAuthenticationPolicy BACnetApplicationTagUnsignedInteger) BACnetConstructedDataActiveAuthenticationPolicyBuilder {
	b.ActiveAuthenticationPolicy = activeAuthenticationPolicy
	return b
}

func (b *_BACnetConstructedDataActiveAuthenticationPolicyBuilder) WithActiveAuthenticationPolicyBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataActiveAuthenticationPolicyBuilder {
	builder := builderSupplier(b.ActiveAuthenticationPolicy.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.ActiveAuthenticationPolicy, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataActiveAuthenticationPolicyBuilder) Build() (BACnetConstructedDataActiveAuthenticationPolicy, error) {
	if b.ActiveAuthenticationPolicy == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'activeAuthenticationPolicy' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataActiveAuthenticationPolicy.deepCopy(), nil
}

func (b *_BACnetConstructedDataActiveAuthenticationPolicyBuilder) MustBuild() BACnetConstructedDataActiveAuthenticationPolicy {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataActiveAuthenticationPolicyBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataActiveAuthenticationPolicyBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataActiveAuthenticationPolicyBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataActiveAuthenticationPolicyBuilder().(*_BACnetConstructedDataActiveAuthenticationPolicyBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataActiveAuthenticationPolicyBuilder creates a BACnetConstructedDataActiveAuthenticationPolicyBuilder
func (b *_BACnetConstructedDataActiveAuthenticationPolicy) CreateBACnetConstructedDataActiveAuthenticationPolicyBuilder() BACnetConstructedDataActiveAuthenticationPolicyBuilder {
	if b == nil {
		return NewBACnetConstructedDataActiveAuthenticationPolicyBuilder()
	}
	return &_BACnetConstructedDataActiveAuthenticationPolicyBuilder{_BACnetConstructedDataActiveAuthenticationPolicy: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACTIVE_AUTHENTICATION_POLICY
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) GetActiveAuthenticationPolicy() BACnetApplicationTagUnsignedInteger {
	return m.ActiveAuthenticationPolicy
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetActiveAuthenticationPolicy())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataActiveAuthenticationPolicy(structType any) BACnetConstructedDataActiveAuthenticationPolicy {
	if casted, ok := structType.(BACnetConstructedDataActiveAuthenticationPolicy); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataActiveAuthenticationPolicy); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) GetTypeName() string {
	return "BACnetConstructedDataActiveAuthenticationPolicy"
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (activeAuthenticationPolicy)
	lengthInBits += m.ActiveAuthenticationPolicy.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataActiveAuthenticationPolicy BACnetConstructedDataActiveAuthenticationPolicy, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataActiveAuthenticationPolicy"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataActiveAuthenticationPolicy")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	activeAuthenticationPolicy, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "activeAuthenticationPolicy", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'activeAuthenticationPolicy' field"))
	}
	m.ActiveAuthenticationPolicy = activeAuthenticationPolicy

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), activeAuthenticationPolicy)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataActiveAuthenticationPolicy"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataActiveAuthenticationPolicy")
	}

	return m, nil
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataActiveAuthenticationPolicy"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataActiveAuthenticationPolicy")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "activeAuthenticationPolicy", m.GetActiveAuthenticationPolicy(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'activeAuthenticationPolicy' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataActiveAuthenticationPolicy"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataActiveAuthenticationPolicy")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) IsBACnetConstructedDataActiveAuthenticationPolicy() {
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) deepCopy() *_BACnetConstructedDataActiveAuthenticationPolicy {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataActiveAuthenticationPolicyCopy := &_BACnetConstructedDataActiveAuthenticationPolicy{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.ActiveAuthenticationPolicy),
	}
	_BACnetConstructedDataActiveAuthenticationPolicyCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataActiveAuthenticationPolicyCopy
}

func (m *_BACnetConstructedDataActiveAuthenticationPolicy) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
