/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.internal.serialization.impl.portable.ClassDefinitionImpl;
import com.hazelcast.internal.serialization.impl.portable.FieldDefinitionImpl;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.PortableId;
import com.hazelcast.spi.annotation.PrivateApi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@Deprecated(since="5.4", forRemoval=true)
public final class ClassDefinitionBuilder {
    private final PortableId portableId;
    private final List<FieldDefinitionImpl> fieldDefinitions = new ArrayList<FieldDefinitionImpl>();
    private final Set<String> addedFieldNames = new HashSet<String>();
    private int index;
    private boolean done;

    public ClassDefinitionBuilder(int factoryId, int classId) {
        this(factoryId, classId, 0);
    }

    public ClassDefinitionBuilder(int factoryId, int classId, int version) {
        this(new PortableId(factoryId, classId, version));
    }

    public ClassDefinitionBuilder(PortableId portableId) {
        this.portableId = portableId;
    }

    @Nonnull
    public ClassDefinitionBuilder addIntField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.INT);
    }

    @Nonnull
    public ClassDefinitionBuilder addLongField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.LONG);
    }

    @Nonnull
    @Deprecated
    public ClassDefinitionBuilder addUTFField(@Nonnull String fieldName) {
        return this.addStringField(fieldName);
    }

    @Nonnull
    public ClassDefinitionBuilder addStringField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.UTF);
    }

    @Nonnull
    public ClassDefinitionBuilder addBooleanField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.BOOLEAN);
    }

    @Nonnull
    public ClassDefinitionBuilder addByteField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.BYTE);
    }

    @Nonnull
    public ClassDefinitionBuilder addBooleanArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.BOOLEAN_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addCharField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.CHAR);
    }

    @Nonnull
    public ClassDefinitionBuilder addDoubleField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.DOUBLE);
    }

    @Nonnull
    public ClassDefinitionBuilder addFloatField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.FLOAT);
    }

    @Nonnull
    public ClassDefinitionBuilder addShortField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.SHORT);
    }

    @Nonnull
    public ClassDefinitionBuilder addDecimalField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.DECIMAL);
    }

    @Nonnull
    public ClassDefinitionBuilder addTimeField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.TIME);
    }

    @Nonnull
    public ClassDefinitionBuilder addDateField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.DATE);
    }

    @Nonnull
    public ClassDefinitionBuilder addTimestampField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.TIMESTAMP);
    }

    @Nonnull
    public ClassDefinitionBuilder addTimestampWithTimezoneField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE);
    }

    @Nonnull
    public ClassDefinitionBuilder addByteArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.BYTE_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addCharArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.CHAR_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addIntArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.INT_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addLongArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.LONG_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addDoubleArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.DOUBLE_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addFloatArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.FLOAT_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addShortArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.SHORT_ARRAY);
    }

    @Nonnull
    @Deprecated
    public ClassDefinitionBuilder addUTFArrayField(@Nonnull String fieldName) {
        return this.addStringArrayField(fieldName);
    }

    @Nonnull
    public ClassDefinitionBuilder addStringArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.UTF_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addPortableField(@Nonnull String fieldName, ClassDefinition classDefinition) {
        if (classDefinition.getClassId() == 0) {
            throw new IllegalArgumentException("Portable class ID cannot be zero!");
        }
        this.check(fieldName);
        this.fieldDefinitions.add(new FieldDefinitionImpl(this.index++, fieldName, FieldType.PORTABLE, classDefinition.getPortableId()));
        return this;
    }

    @Nonnull
    public ClassDefinitionBuilder addPortableArrayField(@Nonnull String fieldName, ClassDefinition classDefinition) {
        if (classDefinition.getClassId() == 0) {
            throw new IllegalArgumentException("Portable class ID cannot be zero!");
        }
        this.check(fieldName);
        this.fieldDefinitions.add(new FieldDefinitionImpl(this.index++, fieldName, FieldType.PORTABLE_ARRAY, classDefinition.getPortableId()));
        return this;
    }

    @Nonnull
    public ClassDefinitionBuilder addDecimalArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.DECIMAL_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addTimeArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.TIME_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addDateArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.DATE_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addTimestampArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.TIMESTAMP_ARRAY);
    }

    @Nonnull
    public ClassDefinitionBuilder addTimestampWithTimezoneArrayField(@Nonnull String fieldName) {
        return this.addField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY);
    }

    private ClassDefinitionBuilder addField(@Nonnull String fieldName, FieldType fieldType) {
        this.check(fieldName);
        this.fieldDefinitions.add(new FieldDefinitionImpl(this.index++, fieldName, fieldType, this.portableId.getVersion()));
        return this;
    }

    @PrivateApi
    public void addField(FieldDefinitionImpl fieldDefinition) {
        if (this.index != fieldDefinition.getIndex()) {
            throw new IllegalArgumentException("Invalid field index");
        }
        this.check(fieldDefinition.getName());
        ++this.index;
        this.fieldDefinitions.add(fieldDefinition);
    }

    @Nonnull
    public ClassDefinition build() {
        this.done = true;
        ClassDefinitionImpl cd = new ClassDefinitionImpl(this.portableId);
        for (FieldDefinitionImpl fd : this.fieldDefinitions) {
            cd.addFieldDef(fd);
        }
        return cd;
    }

    private void check(@Nonnull String fieldName) {
        if (!this.addedFieldNames.add(fieldName)) {
            throw new HazelcastSerializationException("Field with field name : " + fieldName + " already exists");
        }
        if (this.done) {
            throw new HazelcastSerializationException("ClassDefinition is already built for " + this.portableId.getClassId());
        }
    }

    public int getFactoryId() {
        return this.portableId.getFactoryId();
    }

    public int getClassId() {
        return this.portableId.getClassId();
    }

    public int getVersion() {
        return this.portableId.getVersion();
    }

    public PortableId getPortableId() {
        return this.portableId;
    }
}

