/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.odata2.api.exception.ODataException;

public abstract class MessageReference {
    protected final String key;
    protected List<Object> content = null;

    private MessageReference(String key) {
        this(key, null);
    }

    private MessageReference(String key, List<Object> content) {
        this.key = key;
        this.content = content;
    }

    public static MessageReference create(Class<? extends ODataException> clazz, String key) {
        return new SimpleMessageReference(clazz.getName() + "." + key);
    }

    public MessageReference create() {
        return new SingleMessageReference(this.key);
    }

    public String getKey() {
        return this.key;
    }

    public MessageReference addContent(Object ... content) {
        if (this.content == null) {
            return new SimpleMessageReference(this.key, content);
        }
        ArrayList<Object> mergedContent = new ArrayList<Object>(this.content.size() + content.length);
        mergedContent.addAll(this.content);
        mergedContent.addAll(Arrays.asList(content));
        return new SimpleMessageReference(this.key, mergedContent);
    }

    public List<?> getContent() {
        if (this.content == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.content);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageReference other = (MessageReference)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public MessageReference updateContent(List<?> oldContent, Object ... newContent) {
        ArrayList<Object> mergedContent = new ArrayList<Object>();
        if (oldContent != null && !oldContent.isEmpty()) {
            mergedContent.addAll(oldContent);
        }
        mergedContent.addAll(Arrays.asList(newContent));
        return new SimpleMessageReference(this.key, mergedContent);
    }

    private static class SingleMessageReference
    extends MessageReference {
        public SingleMessageReference(String implKey) {
            super(implKey);
        }

        public SingleMessageReference(String implKey, List<Object> content) {
            super(implKey, content);
        }

        public SingleMessageReference(String implKey, Object ... content) {
            super(implKey, Arrays.asList(content));
        }

        @Override
        public MessageReference addContent(Object ... content) {
            if (this.content == null) {
                this.content = new ArrayList();
            }
            this.content.addAll(Arrays.asList(content));
            return this;
        }
    }

    private static class SimpleMessageReference
    extends MessageReference {
        public SimpleMessageReference(String implKey) {
            super(implKey);
        }

        public SimpleMessageReference(String implKey, List<Object> content) {
            super(implKey, content);
        }

        public SimpleMessageReference(String implKey, Object ... content) {
            super(implKey, Arrays.asList(content));
        }
    }
}

