/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http;

import java.util.Locale;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.http.ConditionalOnPreferredJsonMapper;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnPreferredJsonMapperCondition
extends SpringBootCondition {
    private static final String PREFERRED_MAPPER_PROPERTY = "spring.http.converters.preferred-json-mapper";
    @Deprecated(since="3.5.0", forRemoval=true)
    private static final String DEPRECATED_PREFERRED_MAPPER_PROPERTY = "spring.mvc.converters.preferred-json-mapper";

    OnPreferredJsonMapperCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionalOnPreferredJsonMapper.JsonMapper conditionMapper = (ConditionalOnPreferredJsonMapper.JsonMapper)metadata.getAnnotations().get(ConditionalOnPreferredJsonMapper.class).getEnum("value", ConditionalOnPreferredJsonMapper.JsonMapper.class);
        ConditionOutcome outcome = this.getMatchOutcome(context.getEnvironment(), PREFERRED_MAPPER_PROPERTY, conditionMapper);
        if (outcome != null) {
            return outcome;
        }
        outcome = this.getMatchOutcome(context.getEnvironment(), DEPRECATED_PREFERRED_MAPPER_PROPERTY, conditionMapper);
        if (outcome != null) {
            return outcome;
        }
        ConditionMessage message = ConditionMessage.forCondition(ConditionalOnPreferredJsonMapper.class, conditionMapper.name()).because("no property was configured and Jackson is the default");
        return conditionMapper == ConditionalOnPreferredJsonMapper.JsonMapper.JACKSON ? ConditionOutcome.match(message) : ConditionOutcome.noMatch(message);
    }

    private ConditionOutcome getMatchOutcome(Environment environment, String key, ConditionalOnPreferredJsonMapper.JsonMapper conditionMapper) {
        String property = environment.getProperty(key);
        if (property == null) {
            return null;
        }
        ConditionalOnPreferredJsonMapper.JsonMapper configuredMapper = ConditionalOnPreferredJsonMapper.JsonMapper.valueOf(property.toUpperCase(Locale.ROOT));
        ConditionMessage message = ConditionMessage.forCondition(ConditionalOnPreferredJsonMapper.class, configuredMapper.name()).because("property '%s' had the value '%s'".formatted(key, property));
        return configuredMapper == conditionMapper ? ConditionOutcome.match(message) : ConditionOutcome.noMatch(message);
    }
}

