/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import org.apache.myfaces.tobago.internal.util.StringUtils;

public class BoundedRangeModelConverter
implements Converter<BoundedRangeModel> {
    public BoundedRangeModel getAsObject(FacesContext facesContext, UIComponent component, String string) throws ConverterException {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        try {
            BoundedRangeModel model = (BoundedRangeModel)((ValueHolder)component).getValue();
            return new DefaultBoundedRangeModel(Integer.parseInt(string), model.getExtent(), model.getMinimum(), model.getMaximum());
        }
        catch (Exception e) {
            throw new ConverterException("string='" + string + "'", (Throwable)e);
        }
    }

    public String getAsString(FacesContext facesContext, UIComponent component, BoundedRangeModel boundedRangeModel) throws ConverterException {
        if (boundedRangeModel == null) {
            return null;
        }
        try {
            return Integer.toString(boundedRangeModel.getValue());
        }
        catch (ClassCastException e) {
            throw new ConverterException("object='" + String.valueOf(boundedRangeModel) + "'", (Throwable)e);
        }
    }
}

