/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.it;

import java.io.File;

import org.junit.jupiter.api.Test;

/**
 * This is a test set for <a href="https://issues.apache.org/jira/browse/MNG-1491">MNG-1491</a>.
 *
 *
 */
public class MavenITmng1491ReactorArtifactIdCollisionTest extends AbstractMavenIntegrationTestCase {

    public MavenITmng1491ReactorArtifactIdCollisionTest() {
        super(ALL_MAVEN_VERSIONS);
    }

    @Test
    public void testitMNG1491() throws Exception {
        File testDir = extractResources("/mng-1491");

        Verifier verifier = newVerifier(testDir.getAbsolutePath());
        verifier.setAutoclean(false);

        try {
            verifier.addCliArgument("initialize");
            verifier.execute();

            verifier.verifyErrorFreeLog();

            fail("Build should fail due to duplicate artifactId's in the reactor.");
        } catch (VerificationException e) {
            // expected.
        }
    }
}
