/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.engine.constraint.CardinalityConstraint;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.vocabulary.SHACL;

public class MinCount
extends CardinalityConstraint {
    public MinCount(int minCardinality) {
        super(minCardinality, -1);
    }

    public int getMinCount() {
        return this.minCount;
    }

    @Override
    public Node getComponent() {
        return SHACL.MinCountConstraintComponent;
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        throw new InternalErrorException("Call to MinCount/compact syntax");
    }

    public String toString() {
        return String.format("minCount[%s]", MinCount.strInt(this.minCount));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

