/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.parser;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Hex;

class ShexParserLib {
    ShexParserLib() {
    }

    static String unescapeShexRegex(String s, char escape, boolean pointCodeOnly) {
        int i = s.indexOf(escape);
        if (i == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.substring(0, i));
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch != escape) {
                sb.append(ch);
            } else {
                if (i >= s.length() - 1) {
                    throw new AtlasException("Illegal escape at end of string");
                }
                char ch2 = s.charAt(i + 1);
                ++i;
                if (ch2 == 'u') {
                    if (i + 4 >= s.length()) {
                        throw new AtlasException("\\u escape too short");
                    }
                    int x4 = Hex.hexStringToInt((String)s, (int)(i + 1), (int)4);
                    sb.append((char)x4);
                    i += 4;
                } else if (ch2 == 'U') {
                    if (i + 8 >= s.length()) {
                        throw new AtlasException("\\U escape too short");
                    }
                    int ch8 = Hex.hexStringToInt((String)s, (int)(i + 1), (int)8);
                    if (Character.charCount(ch8) == 1) {
                        sb.append((char)ch8);
                    } else {
                        if (!Character.isDefined(ch8) && !Character.isSupplementaryCodePoint(ch8)) {
                            throw new AtlasException(String.format("Illegal codepoint: 0x%04X", ch8));
                        }
                        if (ch8 > 0x10FFFF) {
                            throw new AtlasException(String.format("Illegal code point in \\U sequence value: 0x%08X", ch8));
                        }
                        char[] chars = Character.toChars(ch8);
                        sb.append(chars);
                    }
                    i += 8;
                } else if (pointCodeOnly) {
                    sb.append('\\');
                    sb.append(ch2);
                    ++i;
                } else {
                    char ch3 = '\u0000';
                    switch (ch2) {
                        case 'n': {
                            ch3 = '\n';
                            break;
                        }
                        case 't': {
                            ch3 = '\t';
                            break;
                        }
                        case 'r': {
                            ch3 = '\r';
                            break;
                        }
                        case 'b': {
                            ch3 = '\b';
                            break;
                        }
                        case 'f': {
                            ch3 = '\f';
                            break;
                        }
                        case '\'': {
                            ch3 = '\'';
                            break;
                        }
                        case '\"': {
                            ch3 = '\"';
                            break;
                        }
                        case '-': 
                        case '/': {
                            ch3 = ch2;
                            break;
                        }
                        case '$': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '.': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            sb.append('\\');
                            ch3 = ch2;
                            break;
                        }
                        default: {
                            throw new AtlasException("Unknown escape: \\" + ch2);
                        }
                    }
                    sb.append(ch3);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

